/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.pdf;

import clover.com.lowagie.text.Cell;
import clover.com.lowagie.text.Rectangle;
import clover.com.lowagie.text.Row;
import clover.com.lowagie.text.Table;
import clover.com.lowagie.text.pdf.PdfCell;
import java.util.ArrayList;
import java.util.Iterator;

class PdfTable
extends Rectangle {
    private int columns;
    private ArrayList headercells;
    private ArrayList cells;
    private float cellpadding;
    private float cellspacing;

    PdfTable(Table table, float f, float f2, float f3) {
        super(f, f3, f2, f3);
        PdfCell pdfCell;
        int n;
        this.setBorder(table.border());
        this.setBorderWidth(table.borderWidth());
        this.setBorderColor(table.borderColor());
        this.setBackgroundColor(table.backgroundColor());
        this.setGrayFill(table.grayFill());
        this.columns = table.columns();
        this.cellpadding = table.cellpadding();
        this.cellspacing = table.cellspacing();
        float[] fArray = table.getWidths(f, f2 - f);
        this.setLeft(fArray[0]);
        this.setRight(fArray[fArray.length - 1]);
        int n2 = 0;
        int n3 = 0;
        int n4 = table.firstDataRow();
        this.headercells = new ArrayList();
        this.cells = new ArrayList();
        int n5 = table.size() + 1;
        float[] fArray2 = new float[n5];
        int n6 = 0;
        while (n6 < n5) {
            fArray2[n6] = f3;
            ++n6;
        }
        Iterator iterator = table.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            Row row = (Row)iterator.next();
            if (row.isEmpty()) {
                if (n2 < n5 - 1 && fArray2[n2 + 1] > fArray2[n2]) {
                    fArray2[n2 + 1] = fArray2[n2];
                }
            } else {
                n = 0;
                while (n < row.columns()) {
                    Cell cell = (Cell)row.getCell(n);
                    if (cell != null) {
                        block14: {
                            pdfCell = new PdfCell(cell, n2, fArray[n], fArray[n + cell.colspan()], fArray2[n2], this.cellspacing, this.cellpadding);
                            try {
                                if (fArray2[n2] - pdfCell.height() - this.cellpadding < fArray2[n2 + pdfCell.rowspan()]) {
                                    fArray2[n2 + pdfCell.rowspan()] = fArray2[n2] - pdfCell.height() - this.cellpadding;
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                if (!(fArray2[n2] - pdfCell.height() < fArray2[n5 - 1])) break block14;
                                fArray2[n5 - 1] = fArray2[n2] - pdfCell.height();
                            }
                        }
                        if (n2 < n4) {
                            pdfCell.setHeader();
                            this.headercells.add(pdfCell);
                        }
                        pdfCell.setGroupNumber(n3);
                        bl |= cell.getGroupChange();
                        this.cells.add(pdfCell);
                    }
                    ++n;
                }
            }
            ++n2;
            if (!bl) continue;
            ++n3;
        }
        n = this.cells.size();
        int n7 = 0;
        while (n7 < n) {
            pdfCell = (PdfCell)this.cells.get(n7);
            try {
                pdfCell.setBottom(fArray2[pdfCell.rownumber() + pdfCell.rowspan()]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                pdfCell.setBottom(fArray2[n5 - 1]);
            }
            ++n7;
        }
        this.setBottom(fArray2[n5 - 1]);
    }

    ArrayList getHeaderCells() {
        return this.headercells;
    }

    boolean hasHeader() {
        return this.headercells.size() > 0;
    }

    ArrayList getCells() {
        return this.cells;
    }

    int columns() {
        return this.columns;
    }

    float cellpadding() {
        return this.cellpadding;
    }

    float cellspacing() {
        return this.cellspacing;
    }
}

