/*
 * Decompiled with CFR 0.152.
 */
package jm.util;

import java.util.Vector;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.util.Attribute;
import jm.util.ConversionException;
import jm.util.Element;
import jm.util.StandardXMLStyle;
import jm.util.XMLStyle;
import jm.util.XMLStyles;

class XMLParser {
    private static final XMLStyle DEFAULT_XML_STYLE = new StandardXMLStyle();

    private XMLParser() {
    }

    public static String scoreToXMLString(Score score) {
        return DEFAULT_XML_STYLE.initialXMLDeclaration() + XMLParser.scoreToXMLString(score, DEFAULT_XML_STYLE);
    }

    private static String scoreToXMLString(Score score, XMLStyle xMLStyle) {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(xMLStyle.getLeftAngleBracket() + xMLStyle.getScoreTagName());
        if (!score.getTitle().equals("Untitled Score")) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getTitleAttributeName() + "=" + xMLStyle.getDoubleQuote());
            String string = score.getTitle();
            for (n2 = 0; n2 < string.length(); ++n2) {
                char c = string.charAt(n2);
                if (c == ' ') {
                    stringBuffer.append(xMLStyle.getSpace());
                    continue;
                }
                if (c == '/') {
                    stringBuffer.append(xMLStyle.getSlash());
                    continue;
                }
                if (c == '&') {
                    stringBuffer.append(xMLStyle.getAmpersandInString());
                    continue;
                }
                if (c == '<') {
                    stringBuffer.append(xMLStyle.getLeftAngleBracketInString());
                    continue;
                }
                if (c == '>') {
                    stringBuffer.append(xMLStyle.getRightAngleBracketInString());
                    continue;
                }
                if (c == '\"') {
                    stringBuffer.append(xMLStyle.getDoubleQuoteInString());
                    continue;
                }
                if (c == '#') {
                    stringBuffer.append(xMLStyle.getHash());
                    continue;
                }
                if (c == '/') {
                    stringBuffer.append(xMLStyle.getSlash());
                    continue;
                }
                if (c == '?') {
                    stringBuffer.append(xMLStyle.getQuestionMark());
                    continue;
                }
                if (c == ';') {
                    stringBuffer.append(xMLStyle.getSemicolon());
                    continue;
                }
                stringBuffer.append(c);
            }
            stringBuffer.append(xMLStyle.getDoubleQuote());
        }
        if (score.getTempo() != 60.0) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getTempoAttributeName() + "=" + xMLStyle.getDoubleQuote() + (xMLStyle.limitDecimalPlaces() ? XMLParser.limitDecimalPlaces(score.getTempo(), 2) : Double.toString(score.getTempo())) + xMLStyle.getDoubleQuote());
        }
        if (score.getKeySignature() != 0) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getKeySignatureAttributeName() + "=" + xMLStyle.getDoubleQuote() + Integer.toString(score.getKeySignature()) + xMLStyle.getDoubleQuote());
        }
        if (score.getKeyQuality() != 0) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getKeyQualityAttributeName() + "=" + xMLStyle.getDoubleQuote() + Integer.toString(score.getKeyQuality()) + xMLStyle.getDoubleQuote());
        }
        if (score.getNumerator() != 4) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getNumeratorAttributeName() + "=" + xMLStyle.getDoubleQuote() + Integer.toString(score.getNumerator()) + xMLStyle.getDoubleQuote());
        }
        if (score.getDenominator() != 4) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getDenominatorAttributeName() + "=" + xMLStyle.getDoubleQuote() + Integer.toString(score.getDenominator()) + xMLStyle.getDoubleQuote());
        }
        if ((n = score.size()) == 0) {
            stringBuffer.append(xMLStyle.getSlash() + xMLStyle.getRightAngleBracket());
        } else {
            stringBuffer.append(xMLStyle.getRightAngleBracket());
            for (n2 = 0; n2 < score.size(); ++n2) {
                stringBuffer.append(XMLParser.partToXMLString(score.getPart(n2), xMLStyle));
            }
            stringBuffer.append(xMLStyle.getLeftAngleBracket() + xMLStyle.getSlash() + xMLStyle.getScoreTagName() + xMLStyle.getRightAngleBracket());
        }
        return stringBuffer.toString();
    }

    public static String partToXMLString(Part part) {
        return DEFAULT_XML_STYLE.initialXMLDeclaration() + XMLParser.partToXMLString(part, DEFAULT_XML_STYLE);
    }

    private static String partToXMLString(Part part, XMLStyle xMLStyle) {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(xMLStyle.getLeftAngleBracket() + xMLStyle.getPartTagName());
        if (!part.getTitle().equals("Untitled Part")) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getTitleAttributeName() + "=" + xMLStyle.getDoubleQuote());
            String string = part.getTitle();
            for (n2 = 0; n2 < string.length(); ++n2) {
                char c = string.charAt(n2);
                if (c == ' ') {
                    stringBuffer.append(xMLStyle.getSpace());
                    continue;
                }
                if (c == '/') {
                    stringBuffer.append(xMLStyle.getSlash());
                    continue;
                }
                if (c == '&') {
                    stringBuffer.append(xMLStyle.getAmpersandInString());
                    continue;
                }
                if (c == '<') {
                    stringBuffer.append(xMLStyle.getLeftAngleBracketInString());
                    continue;
                }
                if (c == '>') {
                    stringBuffer.append(xMLStyle.getRightAngleBracketInString());
                    continue;
                }
                if (c == '\"') {
                    stringBuffer.append(xMLStyle.getDoubleQuoteInString());
                    continue;
                }
                if (c == '#') {
                    stringBuffer.append(xMLStyle.getHash());
                    continue;
                }
                if (c == '?') {
                    stringBuffer.append(xMLStyle.getQuestionMark());
                    continue;
                }
                if (c == ';') {
                    stringBuffer.append(xMLStyle.getSemicolon());
                    continue;
                }
                stringBuffer.append(c);
            }
            stringBuffer.append(xMLStyle.getDoubleQuote());
        }
        if (part.getChannel() != 0) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getChannelAttributeName() + "=" + xMLStyle.getDoubleQuote() + Integer.toString(part.getChannel()) + xMLStyle.getDoubleQuote());
        }
        if (part.getInstrument() != 0) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getInstrumentAttributeName() + "=" + xMLStyle.getDoubleQuote() + Integer.toString(part.getInstrument()) + xMLStyle.getDoubleQuote());
        }
        if (part.getTempo() != -1.0) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getTempoAttributeName() + "=" + xMLStyle.getDoubleQuote() + (xMLStyle.limitDecimalPlaces() ? XMLParser.limitDecimalPlaces(part.getTempo(), 2) : Double.toString(part.getTempo())) + xMLStyle.getDoubleQuote());
        }
        if (part.getKeySignature() != Integer.MIN_VALUE) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getKeySignatureAttributeName() + "=" + xMLStyle.getDoubleQuote() + Integer.toString(part.getKeySignature()) + xMLStyle.getDoubleQuote());
        }
        if (part.getKeyQuality() != Integer.MIN_VALUE) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getKeyQualityAttributeName() + "=" + xMLStyle.getDoubleQuote() + Integer.toString(part.getKeyQuality()) + xMLStyle.getDoubleQuote());
        }
        if (part.getNumerator() != Integer.MIN_VALUE) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getNumeratorAttributeName() + "=" + xMLStyle.getDoubleQuote() + Integer.toString(part.getNumerator()) + xMLStyle.getDoubleQuote());
        }
        if (part.getDenominator() != Integer.MIN_VALUE) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getDenominatorAttributeName() + "=" + xMLStyle.getDoubleQuote() + Integer.toString(part.getDenominator()) + xMLStyle.getDoubleQuote());
        }
        if (part.getPan() != 0.5) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getPanAttributeName() + "=" + xMLStyle.getDoubleQuote() + (xMLStyle.limitDecimalPlaces() ? XMLParser.limitDecimalPlaces(part.getPan(), 2) : Double.toString(part.getPan())) + xMLStyle.getDoubleQuote());
        }
        if ((n = part.size()) == 0) {
            stringBuffer.append(xMLStyle.getSlash() + xMLStyle.getRightAngleBracket());
        } else {
            stringBuffer.append(xMLStyle.getRightAngleBracket());
            for (n2 = 0; n2 < part.size(); ++n2) {
                stringBuffer.append(XMLParser.phraseToXMLString(part.getPhrase(n2), xMLStyle));
            }
            stringBuffer.append(xMLStyle.getLeftAngleBracket() + xMLStyle.getSlash() + xMLStyle.getPartTagName() + xMLStyle.getRightAngleBracket());
        }
        return stringBuffer.toString();
    }

    public static String phraseToXMLString(Phrase phrase) {
        return DEFAULT_XML_STYLE.initialXMLDeclaration() + XMLParser.phraseToXMLString(phrase, DEFAULT_XML_STYLE);
    }

    private static String phraseToXMLString(Phrase phrase, XMLStyle xMLStyle) {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(xMLStyle.getLeftAngleBracket() + xMLStyle.getPhraseTagName());
        if (!phrase.getTitle().equals("Untitled Phrase")) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getTitleAttributeName() + "=" + xMLStyle.getDoubleQuote());
            String string = phrase.getTitle();
            for (n2 = 0; n2 < string.length(); ++n2) {
                char c = string.charAt(n2);
                if (c == ' ') {
                    stringBuffer.append(xMLStyle.getSpace());
                    continue;
                }
                if (c == '/') {
                    stringBuffer.append(xMLStyle.getSlash());
                    continue;
                }
                if (c == '&') {
                    stringBuffer.append(xMLStyle.getAmpersandInString());
                    continue;
                }
                if (c == '<') {
                    stringBuffer.append(xMLStyle.getLeftAngleBracketInString());
                    continue;
                }
                if (c == '>') {
                    stringBuffer.append(xMLStyle.getRightAngleBracketInString());
                    continue;
                }
                if (c == '\"') {
                    stringBuffer.append(xMLStyle.getDoubleQuoteInString());
                    continue;
                }
                if (c == '#') {
                    stringBuffer.append(xMLStyle.getHash());
                    continue;
                }
                if (c == '?') {
                    stringBuffer.append(xMLStyle.getQuestionMark());
                    continue;
                }
                if (c == ';') {
                    stringBuffer.append(xMLStyle.getSemicolon());
                    continue;
                }
                stringBuffer.append(c);
            }
            stringBuffer.append(xMLStyle.getDoubleQuote());
        }
        if (phrase.getStartTime() != 0.0) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getStartTimeAttributeName() + "=" + xMLStyle.getDoubleQuote() + (xMLStyle.limitDecimalPlaces() ? XMLParser.limitDecimalPlaces(phrase.getStartTime(), 2) : Double.toString(phrase.getStartTime())) + xMLStyle.getDoubleQuote());
        }
        if (phrase.getInstrument() != -1) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getInstrumentAttributeName() + "=" + xMLStyle.getDoubleQuote() + Integer.toString(phrase.getInstrument()) + xMLStyle.getDoubleQuote());
        }
        if (phrase.getPan() != -1.0) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getTempoAttributeName() + "=" + xMLStyle.getDoubleQuote() + (xMLStyle.limitDecimalPlaces() ? XMLParser.limitDecimalPlaces(phrase.getTempo(), 2) : Double.toString(phrase.getTempo())) + xMLStyle.getDoubleQuote());
        }
        if (phrase.getAppend()) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getAppendAttributeName() + "=" + xMLStyle.getDoubleQuote() + (phrase.getAppend() ? Boolean.TRUE.toString() : Boolean.FALSE.toString()) + xMLStyle.getDoubleQuote());
        }
        if (phrase.getPan() != 0.5) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getPanAttributeName() + "=" + xMLStyle.getDoubleQuote() + (xMLStyle.limitDecimalPlaces() ? XMLParser.limitDecimalPlaces(phrase.getPan(), 2) : Double.toString(phrase.getPan())) + xMLStyle.getDoubleQuote());
        }
        if ((n = phrase.size()) == 0) {
            stringBuffer.append(xMLStyle.getSlash() + xMLStyle.getRightAngleBracket());
        } else {
            stringBuffer.append(xMLStyle.getRightAngleBracket());
            for (n2 = 0; n2 < n; ++n2) {
                stringBuffer.append(XMLParser.noteToXMLString(phrase.getNote(n2), xMLStyle));
            }
            stringBuffer.append(xMLStyle.getLeftAngleBracket() + xMLStyle.getSlash() + xMLStyle.getPhraseTagName() + xMLStyle.getRightAngleBracket());
        }
        return stringBuffer.toString();
    }

    public static String noteToXMLString(Note note) {
        return DEFAULT_XML_STYLE.initialXMLDeclaration() + XMLParser.noteToXMLString(note, DEFAULT_XML_STYLE);
    }

    private static String noteToXMLString(Note note, XMLStyle xMLStyle) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(xMLStyle.getLeftAngleBracket() + xMLStyle.getNoteTagName());
        if (!note.getPitchType()) {
            if (note.getPitch() != 60) {
                stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getPitchAttributeName() + "=" + xMLStyle.getDoubleQuote() + Integer.toString(note.getPitch()) + xMLStyle.getDoubleQuote());
            }
        } else {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getFrequencyAttributeName() + "=" + xMLStyle.getDoubleQuote() + Double.toString(note.getFrequency()) + xMLStyle.getDoubleQuote());
        }
        if (note.getDynamic() != 85) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getDynamicAttributeName() + "=" + xMLStyle.getDoubleQuote() + Integer.toString(note.getDynamic()) + xMLStyle.getDoubleQuote());
        }
        if (note.getRhythmValue() != 1.0) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getRhythmValueAttributeName() + "=" + xMLStyle.getDoubleQuote() + (xMLStyle.limitDecimalPlaces() ? XMLParser.limitDecimalPlaces(note.getRhythmValue(), 2) : Double.toString(note.getRhythmValue())) + xMLStyle.getDoubleQuote());
        }
        if (note.getPan() != 0.5) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getPanAttributeName() + "=" + xMLStyle.getDoubleQuote() + (xMLStyle.limitDecimalPlaces() ? XMLParser.limitDecimalPlaces(note.getPan(), 2) : Double.toString(note.getPan())) + xMLStyle.getDoubleQuote());
        }
        if (note.getDuration() != 0.9) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getDurationAttributeName() + "=" + xMLStyle.getDoubleQuote() + (xMLStyle.limitDecimalPlaces() ? XMLParser.limitDecimalPlaces(note.getDuration(), 2) : Double.toString(note.getDuration())) + xMLStyle.getDoubleQuote());
        }
        if (note.getOffset() != 0.0) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getOffsetAttributeName() + "=" + xMLStyle.getDoubleQuote() + (xMLStyle.limitDecimalPlaces() ? XMLParser.limitDecimalPlaces(note.getOffset(), 2) : Double.toString(note.getOffset())) + xMLStyle.getDoubleQuote());
        }
        if (note.getSampleStartTime() != 0.0) {
            stringBuffer.append(xMLStyle.getSpace() + xMLStyle.getSampleStartTimeAttributeName() + "=" + xMLStyle.getDoubleQuote() + (xMLStyle.limitDecimalPlaces() ? XMLParser.limitDecimalPlaces(note.getSampleStartTime(), 2) : Double.toString(note.getSampleStartTime())) + xMLStyle.getDoubleQuote());
        }
        stringBuffer.append(xMLStyle.getSlash() + xMLStyle.getRightAngleBracket());
        return stringBuffer.toString();
    }

    private static String limitDecimalPlaces(double d, int n) {
        String string = Double.toString(d);
        int n2 = string.lastIndexOf(".") + n + 1;
        if (n2 > string.length()) {
            n2 = string.length();
        }
        return string.substring(0, n2);
    }

    public static Score xmlStringToScore(String string) throws ConversionException {
        String string2 = XMLParser.preprocessString(string);
        Element[] elementArray = XMLParser.xmlStringToElements(string2);
        if (elementArray.length != 1) {
            throw new ConversionException("There can be only one root element.  This string invalidly has " + elementArray.length + " root elements.");
        }
        Element element = elementArray[0];
        if (XMLStyles.isValidScoreTag(elementArray[0].getName())) {
            return XMLParser.elementToScore(elementArray[0]);
        }
        if (XMLStyles.isValidPartTag(elementArray[0].getName())) {
            return new Score(XMLParser.elementToPart(elementArray[0]));
        }
        if (XMLStyles.isValidPhraseTag(elementArray[0].getName())) {
            return new Score(new Part(XMLParser.elementToPhrase(elementArray[0])));
        }
        if (XMLStyles.isValidNoteTag(elementArray[0].getName())) {
            return new Score(new Part(new Phrase(XMLParser.elementToNote(elementArray[0]))));
        }
        throw new ConversionException("Unrecognised root element: " + elementArray[0].getName());
    }

    public static Part xmlStringToPart(String string) throws ConversionException {
        String string2 = XMLParser.preprocessString(string);
        Element[] elementArray = XMLParser.xmlStringToElements(string2);
        if (elementArray.length != 1) {
            throw new ConversionException("There can be only one root element.  This string invalidly has " + elementArray.length + " root elements.");
        }
        Element element = elementArray[0];
        if (XMLStyles.isValidScoreTag(elementArray[0].getName())) {
            throw new ConversionException("This XML string represents a Score, use the xmlStringToScore(String) method instead.");
        }
        if (XMLStyles.isValidPartTag(elementArray[0].getName())) {
            return XMLParser.elementToPart(elementArray[0]);
        }
        if (XMLStyles.isValidPhraseTag(elementArray[0].getName())) {
            return new Part(XMLParser.elementToPhrase(elementArray[0]));
        }
        if (XMLStyles.isValidNoteTag(elementArray[0].getName())) {
            return new Part(new Phrase(XMLParser.elementToNote(elementArray[0])));
        }
        throw new ConversionException("Unrecognised root element: " + elementArray[0].getName());
    }

    public static Phrase xmlStringToPhrase(String string) throws ConversionException {
        String string2 = XMLParser.preprocessString(string);
        Element[] elementArray = XMLParser.xmlStringToElements(string2);
        if (elementArray.length != 1) {
            throw new ConversionException("There can be only one root element.  This string invalidly has " + elementArray.length + " root elements.");
        }
        Element element = elementArray[0];
        if (XMLStyles.isValidScoreTag(elementArray[0].getName())) {
            throw new ConversionException("This XML string represents a Score, use the xmlStringToScore(String) method instead.");
        }
        if (XMLStyles.isValidPartTag(elementArray[0].getName())) {
            throw new ConversionException("This XML string represents a Part, use the xmlStringToPart(String) method instead.");
        }
        if (XMLStyles.isValidPhraseTag(elementArray[0].getName())) {
            return XMLParser.elementToPhrase(elementArray[0]);
        }
        if (XMLStyles.isValidNoteTag(elementArray[0].getName())) {
            return new Phrase(XMLParser.elementToNote(elementArray[0]));
        }
        throw new ConversionException("Unrecognised root element: " + elementArray[0].getName());
    }

    public static Note xmlStringToNote(String string) throws ConversionException {
        String string2 = XMLParser.preprocessString(string);
        Element[] elementArray = XMLParser.xmlStringToElements(string2);
        if (elementArray.length != 1) {
            throw new ConversionException("There can be only one root element.  This string invalidly has " + elementArray.length + " root elements.");
        }
        Element element = elementArray[0];
        if (XMLStyles.isValidScoreTag(elementArray[0].getName())) {
            throw new ConversionException("This XML string represents a Score, use the xmlStringToScore(String) method instead.");
        }
        if (XMLStyles.isValidPartTag(elementArray[0].getName())) {
            throw new ConversionException("This XML string represents a Part, use the xmlStringToPart(String) method instead.");
        }
        if (XMLStyles.isValidPhraseTag(elementArray[0].getName())) {
            throw new ConversionException("This XML string represents a Phrase, use the xmlStringToPhrase(String) method instead.");
        }
        if (XMLStyles.isValidNoteTag(elementArray[0].getName())) {
            return XMLParser.elementToNote(elementArray[0]);
        }
        throw new ConversionException("Unrecognised root element: " + elementArray[0].getName());
    }

    private static String preprocessString(String string) throws ConversionException {
        CharSequence charSequence;
        String string2 = string;
        for (int i = 0; i < XMLStyles.styles.length; ++i) {
            charSequence = XMLStyles.styles[i].initialXMLDeclaration();
            if (!string.startsWith((String)charSequence)) continue;
            string2 = string2.substring(((String)charSequence).length());
            break;
        }
        char[] cArray = string2.toCharArray();
        charSequence = null;
        StandardXMLStyle standardXMLStyle = new StandardXMLStyle();
        char[][] cArray2 = ((XMLStyle)standardXMLStyle).getEncodingsOfReferenceChars();
        char[] cArray3 = ((XMLStyle)standardXMLStyle).getReferenceChars();
        for (int i = 0; i < cArray2.length; ++i) {
            charSequence = new StringBuffer();
            String string3 = new String(cArray2[i]);
            int n = 0;
            int n2 = string2.indexOf(string3);
            while (n2 != -1) {
                while (n < n2) {
                    ((StringBuffer)charSequence).append(cArray[n]);
                    ++n;
                }
                ((StringBuffer)charSequence).append(cArray3[i]);
                n2 = string2.indexOf(string3, n += 3);
            }
            n2 = string2.length();
            while (n < n2) {
                ((StringBuffer)charSequence).append(cArray[n]);
                ++n;
            }
            string2 = ((StringBuffer)charSequence).toString();
            cArray = string2.toCharArray();
        }
        return string2;
    }

    private static Score elementToScore(Element element) throws ConversionException {
        StandardXMLStyle standardXMLStyle = new StandardXMLStyle();
        if (!XMLStyles.isValidScoreTag(element.getName())) {
            throw new ConversionException("The root element must have the name '" + standardXMLStyle.getScoreTagName() + "'.  The invalid name used " + "was '" + element.getName() + "'.");
        }
        Score score = new Score();
        String string = XMLStyles.getTitleAttributeValue(element);
        if (!string.equals("")) {
            score.setTitle(string);
        }
        if (!(string = XMLStyles.getTempoAttributeValue(element)).equals("")) {
            try {
                score.setTempo(Double.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getTempoAttributeName() + "' of element '" + standardXMLStyle.getScoreTagName() + "' must represent a Java double.");
            }
        }
        if (!(string = XMLStyles.getKeySignatureAttributeValue(element)).equals("")) {
            try {
                score.setKeySignature(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getKeySignatureAttributeName() + "' of element '" + standardXMLStyle.getScoreTagName() + "' must represent a Java integer.");
            }
        }
        if (!(string = XMLStyles.getKeyQualityAttributeValue(element)).equals("")) {
            try {
                score.setKeyQuality(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getKeyQualityAttributeName() + "' of element '" + standardXMLStyle.getScoreTagName() + "' must represent a Java integer.");
            }
        }
        if (!(string = XMLStyles.getNumeratorAttributeValue(element)).equals("")) {
            try {
                score.setNumerator(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getNumeratorAttributeName() + "' of element '" + standardXMLStyle.getScoreTagName() + "' must represent a Java integer.");
            }
        }
        if (!(string = XMLStyles.getDenominatorAttributeValue(element)).equals("")) {
            try {
                score.setDenominator(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getDenominatorAttributeName() + "' of element '" + standardXMLStyle.getScoreTagName() + "' must represent a Java integer.");
            }
        }
        Element[] elementArray = element.getChildren();
        for (int i = 0; i < elementArray.length; ++i) {
            if (!XMLStyles.isValidPartTag(elementArray[i].getName())) continue;
            score.addPart(XMLParser.elementToPart(elementArray[i]));
        }
        return score;
    }

    private static Part elementToPart(Element element) throws ConversionException {
        StandardXMLStyle standardXMLStyle = new StandardXMLStyle();
        if (!XMLStyles.isValidPartTag(element.getName())) {
            throw new ConversionException("Invalid element: " + element.getName() + ".  The only " + "accepted tag name is '" + standardXMLStyle.getPartTagName() + "'.");
        }
        Part part = new Part();
        String string = XMLStyles.getTitleAttributeValue(element);
        if (!string.equals("")) {
            part.setTitle(string);
        }
        if (!(string = XMLStyles.getChannelAttributeValue(element)).equals("")) {
            try {
                part.setChannel(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getChannelAttributeName() + "' of element '" + standardXMLStyle.getPartTagName() + "' must represent a Java integer.");
            }
        }
        if (!(string = XMLStyles.getInstrumentAttributeValue(element)).equals("")) {
            try {
                part.setInstrument(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getInstrumentAttributeName() + "' of element '" + standardXMLStyle.getPartTagName() + "' must represent a Java integer.");
            }
        }
        if (!(string = XMLStyles.getTempoAttributeValue(element)).equals("")) {
            try {
                part.setTempo(Double.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getTempoAttributeName() + "' of element '" + standardXMLStyle.getPartTagName() + "' must represent a Java double.");
            }
        }
        if (!(string = XMLStyles.getKeySignatureAttributeValue(element)).equals("")) {
            try {
                part.setKeySignature(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getKeySignatureAttributeName() + "' of element '" + standardXMLStyle.getPartTagName() + "' must represent a Java integer.");
            }
        }
        if (!(string = XMLStyles.getKeyQualityAttributeValue(element)).equals("")) {
            try {
                part.setKeyQuality(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getKeyQualityAttributeName() + "' of element '" + standardXMLStyle.getScoreTagName() + "' must represent a Java integer.");
            }
        }
        if (!(string = XMLStyles.getNumeratorAttributeValue(element)).equals("")) {
            try {
                part.setNumerator(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getNumeratorAttributeName() + "' of element '" + standardXMLStyle.getPartTagName() + "' must represent a Java integer.");
            }
        }
        if (!(string = XMLStyles.getDenominatorAttributeValue(element)).equals("")) {
            try {
                part.setDenominator(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getDenominatorAttributeName() + "' of element '" + standardXMLStyle.getPartTagName() + "' must represent a Java integer.");
            }
        }
        if (!(string = XMLStyles.getPanAttributeValue(element)).equals("")) {
            try {
                part.setPan(Double.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getPanAttributeName() + "' of element '" + standardXMLStyle.getPartTagName() + "' must represent a Java double.");
            }
        }
        Element[] elementArray = element.getChildren();
        for (int i = 0; i < elementArray.length; ++i) {
            if (!XMLStyles.isValidPhraseTag(elementArray[i].getName())) continue;
            part.addPhrase(XMLParser.elementToPhrase(elementArray[i]));
        }
        return part;
    }

    private static Phrase elementToPhrase(Element element) throws ConversionException {
        StandardXMLStyle standardXMLStyle = new StandardXMLStyle();
        if (!XMLStyles.isValidPhraseTag(element.getName())) {
            throw new ConversionException("Invalid element: " + element.getName() + ".  The only " + "accepted tag name is '" + standardXMLStyle.getPhraseTagName() + "'.");
        }
        Phrase phrase = new Phrase();
        String string = XMLStyles.getTitleAttributeValue(element);
        if (!string.equals("")) {
            try {
                phrase.setTitle(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getTitleAttributeName() + "' of element '" + standardXMLStyle.getPhraseTagName() + "' must represent a Java integer.");
            }
        }
        if (!(string = XMLStyles.getStartTimeAttributeValue(element)).equals("")) {
            try {
                phrase.setStartTime(Double.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getStartTimeAttributeName() + "' of element '" + standardXMLStyle.getPhraseTagName() + "' must represent a Java double.");
            }
        }
        if (!(string = XMLStyles.getInstrumentAttributeValue(element)).equals("")) {
            try {
                phrase.setInstrument(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getInstrumentAttributeName() + "' of element '" + standardXMLStyle.getPhraseTagName() + "' must represent a Java integer.");
            }
        }
        if (!(string = XMLStyles.getTempoAttributeValue(element)).equals("")) {
            try {
                phrase.setTempo(Double.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getTempoAttributeName() + "' of element '" + standardXMLStyle.getPhraseTagName() + "' must represent a Java double.");
            }
        }
        if (!(string = XMLStyles.getAppendAttributeValue(element)).equals("")) {
            phrase.setAppend(new Boolean(string));
        }
        if (!(string = XMLStyles.getPanAttributeValue(element)).equals("")) {
            try {
                phrase.setPan(Double.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getPanAttributeName() + "' of element '" + standardXMLStyle.getPhraseTagName() + "' must represent a Java double.");
            }
        }
        Element[] elementArray = element.getChildren();
        for (int i = 0; i < elementArray.length; ++i) {
            if (!XMLStyles.isValidNoteTag(elementArray[i].getName())) continue;
            phrase.addNote(XMLParser.elementToNote(elementArray[i]));
        }
        return phrase;
    }

    private static Note elementToNote(Element element) throws ConversionException {
        StandardXMLStyle standardXMLStyle = new StandardXMLStyle();
        if (!XMLStyles.isValidNoteTag(element.getName())) {
            throw new ConversionException("Invalid element: " + element.getName() + ".  The only " + "accepted tag name is '" + standardXMLStyle.getNoteTagName() + "'.");
        }
        Note note = new Note();
        String string = XMLStyles.getPitchAttributeValue(element);
        if (!string.equals("")) {
            try {
                note.setPitch(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getPitchAttributeName() + "' of element '" + standardXMLStyle.getNoteTagName() + "' must represent a Java integer.");
            }
        }
        if (!(string = XMLStyles.getFrequencyAttributeValue(element)).equals("")) {
            try {
                double d = Double.valueOf(string);
                note.setFrequency(d);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getFrequencyAttributeName() + "' of element '" + standardXMLStyle.getNoteTagName() + "' must represent a Java double.");
            }
        }
        if (!(string = XMLStyles.getDynamicAttributeValue(element)).equals("")) {
            try {
                note.setDynamic(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getDynamicAttributeName() + "' of element '" + standardXMLStyle.getNoteTagName() + "' must represent a Java integer.");
            }
        }
        if (!(string = XMLStyles.getRhythmValueAttributeValue(element)).equals("")) {
            try {
                note.setRhythmValue(Double.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getRhythmValueAttributeName() + "' of element '" + standardXMLStyle.getNoteTagName() + "' must represent a Java double.");
            }
        }
        if (!(string = XMLStyles.getPanAttributeValue(element)).equals("")) {
            try {
                note.setPan(Double.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getPanAttributeName() + "' of element '" + standardXMLStyle.getNoteTagName() + "' must represent a Java double.");
            }
        }
        if (!(string = XMLStyles.getDurationAttributeValue(element)).equals("")) {
            try {
                note.setDuration(Double.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getDurationAttributeName() + "' of element '" + standardXMLStyle.getNoteTagName() + "' must represent a Java double.");
            }
        }
        if (!(string = XMLStyles.getOffsetAttributeValue(element)).equals("")) {
            try {
                note.setOffset(Double.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getOffsetAttributeName() + "' of element '" + standardXMLStyle.getNoteTagName() + "' must represent a Java double.");
            }
        }
        if (!(string = XMLStyles.getSampleStartTimeAttributeValue(element)).equals("")) {
            try {
                note.setSampleStartTime(Double.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConversionException("Invalid attribute value: " + string + ".  The " + "attribute '" + standardXMLStyle.getSampleStartTimeAttributeName() + "' of " + "element '" + standardXMLStyle.getNoteTagName() + "' must represent a " + "Java double.");
            }
        }
        return note;
    }

    private static Element[] xmlStringToElements(String string) throws ConversionException {
        Vector<Element> vector = new Vector<Element>();
        StandardXMLStyle standardXMLStyle = new StandardXMLStyle();
        char[][] cArray = ((XMLStyle)standardXMLStyle).getEncodingsOfValueReferenceChars();
        char[] cArray2 = ((XMLStyle)standardXMLStyle).getValueReferenceChars();
        try {
            int n = 0;
            if (string.charAt(n++) != '<') {
                throw new ConversionException("XML String does not begin with '<'");
            }
            StringBuffer stringBuffer = new StringBuffer();
            char c = string.charAt(n++);
            while (c != ' ' && c != '/' && c != '>') {
                stringBuffer.append(c);
                c = string.charAt(n++);
            }
            Element element = new Element(stringBuffer.toString());
            while (c == ' ') {
                StringBuffer stringBuffer2 = new StringBuffer();
                c = string.charAt(n++);
                while (c != '=') {
                    if (c == '/') {
                        throw new ConversionException("Illegal character '/' in attribute name of the '" + element.getName() + "' element.");
                    }
                    if (c == '>') {
                        throw new ConversionException("Illegal character '>' in attribute name of the '" + element.getName() + "' element.");
                    }
                    stringBuffer2.append(c);
                    c = string.charAt(n++);
                }
                Attribute attribute = new Attribute(stringBuffer2.toString());
                if ((c = string.charAt(n++)) != '\"') {
                    throw new ConversionException("The value of the '" + attribute.getName() + "' attribute in the '" + element.getName() + "' element does not begin with a double-quote " + "(\").");
                }
                StringBuffer stringBuffer3 = new StringBuffer();
                c = string.charAt(n++);
                while (c != '\"') {
                    block8: for (int i = 0; i < cArray.length; ++i) {
                        for (int j = 0; j < cArray[i].length; ++j) {
                            try {
                                if (cArray[i][j] != string.charAt(n + j - 1)) {
                                    if (i != cArray.length - 1) continue block8;
                                    stringBuffer3.append(c);
                                    continue block8;
                                }
                                if (j != cArray[i].length - 1) continue;
                                n += cArray[i].length - 1;
                                stringBuffer3.append(cArray2[i]);
                                break block8;
                            }
                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                if (i != cArray.length - 1) continue block8;
                                stringBuffer3.append(c);
                                continue block8;
                            }
                        }
                    }
                    c = string.charAt(n++);
                }
                attribute.setValue(stringBuffer3.toString());
                element.addAttribute(attribute);
                c = string.charAt(n++);
            }
            if (c == '>') {
                int n2 = string.indexOf("</" + element.getName() + ">");
                if (n2 == -1) {
                    throw new ConversionException("No closing tag found: </" + element.getName() + ">");
                }
                element.appendChildren(XMLParser.xmlStringToElements(string.substring(n, n2)));
                n = n2 + element.getName().length() + 3;
            } else if (c == '/') {
                if ((c = string.charAt(n++)) != '>') {
                    throw new ConversionException("Character '>' is expected to terminate the '" + element.getName() + "' element but was not " + "found.");
                }
            } else {
                throw new ConversionException("Either '>' or '/>' is expected to terminate the '" + element.getName() + "' element but neither was " + "found.");
            }
            vector.addElement(element);
            if (n < string.length()) {
                Element[] elementArray = XMLParser.xmlStringToElements(string.substring(n));
                for (int i = 0; i < elementArray.length; ++i) {
                    vector.addElement(elementArray[i]);
                }
            }
            Object[] objectArray = new Element[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ConversionException("Xml string ended prematurely.  Further characters were excepted.");
        }
    }
}

