/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools.ga;

import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import jm.music.data.Phrase;
import jm.music.tools.NoteListException;
import jm.music.tools.PhraseAnalysis;
import jm.music.tools.QuantisationException;
import jm.music.tools.ga.FitnessEvaluater;

public class NormalDistributionFE
extends FitnessEvaluater {
    protected static String label = "Normal Distribution Fitness Evaluater";
    protected Panel panel;
    private double[] weighting = new double[]{1.0, 1.0, 1.0, 0.1, 1.0, 1.0, 0.5, 0.5, 0.5, 1.0, 0.5, 0.5, 1.0, 0.5, 1.0, 0.1, 1.0, 1.0, 1.0, 0.5, 0.1, 0.1, 0.1};
    protected Label F1Label;
    protected Label F2Label;
    protected Label F3Label;
    protected Label F4Label;
    protected Label F5Label;
    protected Label F6Label;
    protected Label F7Label;
    protected Label F8Label;
    protected Label F9Label;
    protected Label F10Label;
    protected Label F11Label;
    protected Label F12Label;
    protected Label F13Label;
    protected Label F14Label;
    protected Label F15Label;
    protected Label F16Label;
    protected Label F17Label;
    protected Label F18Label;
    protected Label F19Label;
    protected Label F20Label;
    protected Label F21Label;
    protected Label F22Label;
    protected Label F23Label;
    private double[] mean = new double[]{0.307, 0.308, 0.021, 0.669, 0.021, 0.079, 0.652, 0.545, 0.383, 0.13, 0.562, 0.411, 0.495, 0.601, 0.013, 0.252, 0.066, 0.183, 0.112, 0.538, 0.439, 0.523, 0.346};
    private double[] standardDeviation = new double[]{0.115, 0.129, 0.038, 0.318, 0.044, 0.137, 0.148, 0.166, 0.211, 0.13, 0.21, 0.139, 0.059, 0.218, 0.047, 0.399, 0.105, 0.146, 0.125, 0.227, 0.246, 0.261, 0.275};
    public static final double duration = 0.25;
    public static final int tonic = 60;
    public static final int[] scale = PhraseAnalysis.MAJOR_SCALE;

    public NormalDistributionFE() {
        this.panel = new Panel();
        this.panel.setLayout(new GridLayout(23, 3));
        this.F1Label = new Label(Integer.toString((int)(this.weighting[0] * 100.0)));
        this.panel.add(new Label("Note Density", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[0] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[0] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F1Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F1Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F1Label);
        this.F2Label = new Label(Integer.toString((int)(this.weighting[1] * 100.0)));
        this.panel.add(new Label("Pitch Variety", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[1] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[1] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F2Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F2Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F2Label);
        this.F3Label = new Label(Integer.toString((int)(this.weighting[1] * 100.0)));
        this.panel.add(new Label("Rhythmic Variety", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[2] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[2] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F3Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F3Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F3Label);
        this.F4Label = new Label(Integer.toString((int)(this.weighting[3] * 100.0)));
        this.panel.add(new Label("Climax Strength", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[3] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[3] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F4Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F4Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F4Label);
        this.F5Label = new Label(Integer.toString((int)(this.weighting[4] * 100.0)));
        this.panel.add(new Label("Rest Density", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[4] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[4] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F5Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F5Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F5Label);
        this.F6Label = new Label(Integer.toString((int)(this.weighting[5] * 100.0)));
        this.panel.add(new Label("Tonal Deviation", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[5] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[5] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F6Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F6Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F6Label);
        this.F7Label = new Label(Integer.toString((int)(this.weighting[6] * 100.0)));
        this.panel.add(new Label("Key Centeredness", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[6] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[6] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F7Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F7Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F7Label);
        this.F8Label = new Label(Integer.toString((int)(this.weighting[7] * 100.0)));
        this.panel.add(new Label("Pitch Range", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[7] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[7] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F8Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F8Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F8Label);
        this.F9Label = new Label(Integer.toString((int)(this.weighting[8] * 100.0)));
        this.panel.add(new Label("Rhythm Range", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[8] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[8] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F9Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F9Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F9Label);
        this.F10Label = new Label(Integer.toString((int)(this.weighting[9] * 100.0)));
        this.panel.add(new Label("Repeated Pitch Density", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[9] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[9] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F10Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F10Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F10Label);
        this.F11Label = new Label(Integer.toString((int)(this.weighting[10] * 100.0)));
        this.panel.add(new Label("Repeated Rhythm Density", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[10] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[10] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F11Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F11Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F11Label);
        this.F12Label = new Label(Integer.toString((int)(this.weighting[11] * 100.0)));
        this.panel.add(new Label("Melodic Direction Stability", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[11] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[11] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F12Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F12Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F12Label);
        this.F13Label = new Label(Integer.toString((int)(this.weighting[12] * 100.0)));
        this.panel.add(new Label("Overall Pitch Direction", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[12] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[12] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F13Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F13Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F13Label);
        this.F14Label = new Label(Integer.toString((int)(this.weighting[13] * 100.0)));
        this.panel.add(new Label("Pitch Movement", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[13] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[13] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F14Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F14Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F14Label);
        this.F15Label = new Label(Integer.toString((int)(this.weighting[14] * 100.0)));
        this.panel.add(new Label("Dissonance", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[14] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[14] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F15Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F15Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F15Label);
        this.F16Label = new Label(Integer.toString((int)(this.weighting[15] * 100.0)));
        this.panel.add(new Label("Leap Compensation", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[15] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[15] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F16Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F16Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F16Label);
        this.F17Label = new Label(Integer.toString((int)(this.weighting[16] * 100.0)));
        this.panel.add(new Label("Syncopation", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[16] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[16] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F17Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F17Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F17Label);
        this.F18Label = new Label(Integer.toString((int)(this.weighting[17] * 100.0)));
        this.panel.add(new Label("Repeated Pitch Patterns of 3", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[17] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[17] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F18Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F18Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F18Label);
        this.F19Label = new Label(Integer.toString((int)(this.weighting[18] * 100.0)));
        this.panel.add(new Label("Repeated Pitch Patterns of 4", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[18] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[18] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F19Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F19Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F19Label);
        this.F20Label = new Label(Integer.toString((int)(this.weighting[19] * 100.0)));
        this.panel.add(new Label("Repeated Rhythm Patterns of 3", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[19] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[19] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F20Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F20Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F20Label);
        this.F21Label = new Label(Integer.toString((int)(this.weighting[20] * 100.0)));
        this.panel.add(new Label("Repeated Rhythm Patterns of 4", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[20] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[20] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F21Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F21Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F21Label);
        this.F22Label = new Label(Integer.toString((int)(this.weighting[21] * 100.0)));
        this.panel.add(new Label("Climax Position", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[21] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[21] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F22Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F22Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F22Label);
        this.F23Label = new Label(Integer.toString((int)(this.weighting[22] * 100.0)));
        this.panel.add(new Label("Climax Tonality", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[22] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ((NormalDistributionFE)NormalDistributionFE.this).weighting[22] = (double)this.getValue() / 100.0;
                        NormalDistributionFE.this.F23Label.setText(Integer.toString(this.getValue()));
                        NormalDistributionFE.this.F23Label.repaint();
                    }
                });
            }
        });
        this.panel.add(this.F23Label);
    }

    @Override
    public double[] evaluate(Phrase[] phraseArray) {
        double[] dArray = new double[phraseArray.length];
        for (int i = 0; i < phraseArray.length; ++i) {
            double d = 0.0;
            for (int j = 0; j < this.mean.length; ++j) {
                d += this.calculateFitness(this.getValue2(j, phraseArray[i]), this.mean[j], this.standardDeviation[j], this.weighting[j]);
            }
            dArray[i] = 1.0 / (d / (double)(this.weighting.length - 1) + 1.0);
        }
        return dArray;
    }

    private double calculateFitness(double d, double d2, double d3, double d4) {
        return Math.abs((d - d2) / d3) * d4;
    }

    private double getValue2(int n, Phrase phrase) {
        try {
            switch (n) {
                default: {
                    return PhraseAnalysis.noteDensity(phrase, 0.25);
                }
                case 1: {
                    return PhraseAnalysis.pitchVariety(phrase);
                }
                case 2: {
                    return PhraseAnalysis.rhythmicVariety(phrase);
                }
                case 3: {
                    return PhraseAnalysis.climaxStrength(phrase);
                }
                case 4: {
                    return PhraseAnalysis.restDensity(phrase, 0.25);
                }
                case 5: {
                    return PhraseAnalysis.tonalDeviation(phrase, 0.25, 60, scale);
                }
                case 6: {
                    return PhraseAnalysis.keyCenteredness(phrase, 0.25, 60);
                }
                case 7: {
                    return PhraseAnalysis.pitchRangePerSpan(phrase);
                }
                case 8: {
                    return PhraseAnalysis.rhythmRangePerSpan(phrase);
                }
                case 9: {
                    return PhraseAnalysis.repeatedPitchDensity(phrase);
                }
                case 10: {
                    return PhraseAnalysis.repeatedRhythmicValueDensity(phrase);
                }
                case 11: {
                    return PhraseAnalysis.melodicDirectionStability(phrase);
                }
                case 12: {
                    return PhraseAnalysis.overallPitchDirection(phrase);
                }
                case 13: {
                    return PhraseAnalysis.movementByStep(phrase, 60, scale);
                }
                case 14: {
                    return PhraseAnalysis.dissonance(phrase);
                }
                case 15: {
                    return PhraseAnalysis.leapCompensation(phrase);
                }
                case 16: {
                    return PhraseAnalysis.syncopation(phrase);
                }
                case 17: {
                    return PhraseAnalysis.repeatedPitchPatterns(phrase, 3);
                }
                case 18: {
                    return PhraseAnalysis.repeatedPitchPatterns(phrase, 4);
                }
                case 19: {
                    return PhraseAnalysis.repeatedRhythmPatterns(phrase, 3);
                }
                case 20: {
                    return PhraseAnalysis.repeatedRhythmPatterns(phrase, 4);
                }
                case 21: {
                    return PhraseAnalysis.climaxPosition(phrase);
                }
                case 22: 
            }
            return PhraseAnalysis.climaxTonality(phrase, 60, scale);
        }
        catch (NoteListException noteListException) {
            noteListException.printStackTrace();
            System.err.println(noteListException);
            System.exit(-1);
        }
        catch (QuantisationException quantisationException) {
            quantisationException.printStackTrace();
            System.err.println(quantisationException);
            System.exit(-1);
        }
        return 0.0;
    }

    @Override
    public Panel getPanel() {
        return this.panel;
    }

    @Override
    public String getLabel() {
        return label;
    }
}

