/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools.ga;

import java.awt.Choice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import jm.music.data.Note;
import jm.music.data.Phrase;
import jm.music.tools.PhraseAnalysis;
import jm.music.tools.ga.Mutater;

public class ComplexMutater
extends Mutater {
    private int[] MUTATE_PERCENTAGE = new int[]{0, 40, 1, 40, 60};
    private static final int SEMITONES_PER_OCTAVE = 12;
    private static final int TONIC = 60;
    protected static String label = "Mutater";
    protected Panel panel = new Panel();
    protected Choice choice;
    protected Scrollbar scrollbar;
    protected Label mutateLabel;
    protected boolean modifyAll = false;

    public ComplexMutater() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panel.setLayout(gridBagLayout);
        this.mutateLabel = new Label(Integer.toString(this.MUTATE_PERCENTAGE[0]));
        this.scrollbar = new Scrollbar(0, this.MUTATE_PERCENTAGE[0], 1, 0, 100);
        this.choice = new Choice();
        this.choice.add("Random pitch change");
        this.choice.add("Bar sequence mutations");
        this.choice.add("Split and merge");
        this.choice.add("Step interpolation");
        this.choice.add("Tonal Pauses");
        this.choice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ComplexMutater.this.mutateLabel.setText(Integer.toString(ComplexMutater.this.MUTATE_PERCENTAGE[ComplexMutater.this.choice.getSelectedIndex()]));
                ComplexMutater.this.scrollbar.setValue(ComplexMutater.this.MUTATE_PERCENTAGE[ComplexMutater.this.choice.getSelectedIndex()]);
            }
        });
        this.scrollbar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                ((ComplexMutater)ComplexMutater.this).MUTATE_PERCENTAGE[ComplexMutater.this.choice.getSelectedIndex()] = ComplexMutater.this.scrollbar.getValue();
                ComplexMutater.this.mutateLabel.setText(Integer.toString(ComplexMutater.this.scrollbar.getValue()));
                ComplexMutater.this.mutateLabel.repaint();
            }
        });
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.choice, gridBagConstraints);
        this.panel.add(this.choice);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.scrollbar, gridBagConstraints);
        this.panel.add(this.scrollbar);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.mutateLabel, gridBagConstraints);
        this.panel.add(this.mutateLabel);
    }

    @Override
    public Phrase[] mutate(Phrase[] phraseArray, double d, int n, int n2) {
        int n3;
        double[] dArray = new double[phraseArray.length];
        for (n3 = 0; n3 < phraseArray.length; ++n3) {
            dArray[n3] = phraseArray[n3].getEndTime();
        }
        for (n3 = 0; n3 < phraseArray.length; ++n3) {
            int n4;
            int n5;
            int n6;
            Object object;
            int n7;
            Object object2;
            Object object3;
            int n8;
            int n9;
            Phrase phrase = phraseArray[n3];
            if (this.modifyAll) {
                n = 0;
                d = 0.0;
            }
            int n10 = phrase.size() - n;
            double d2 = (double)(n10 * this.MUTATE_PERCENTAGE[0]) / 100.0;
            int n11 = 0;
            n11 = d2 < 1.0 ? (Math.random() < d2 ? 1 : 0) : (int)Math.floor(d2);
            for (n9 = 0; n9 < n11; ++n9) {
                int n12 = (int)(Math.random() * (double)n10);
                this.mutate(phrase.getNote(n + n12));
            }
            if (Math.random() < (double)this.MUTATE_PERCENTAGE[1] / 100.0) {
                n9 = 0;
                double d3 = 0.0;
                for (n8 = 0; n8 < phrase.size(); ++n8) {
                    d3 += phrase.getNote(n8).getRhythmValue();
                }
                int[] nArray = new int[(int)d3];
                object3 = new int[(int)d3];
                object2 = 0;
                d3 = 0.0;
                for (n7 = 0; n7 < phrase.size(); ++n7) {
                    if (d3 / (double)n2 == Math.floor(d3 / (double)n2)) {
                        nArray[object2] = n7;
                        object3[object2++] = (int)(d3 * (double)n2);
                    }
                    d3 += phrase.getNote(n7).getRhythmValue();
                }
                n7 = 0;
                object = new int[object2];
                if (object2 > 0) {
                    for (n6 = 1; n6 < object2; ++n6) {
                        if (object3[n6] != object3[n6 - 1] + 1) continue;
                        object[n7++] = nArray[n6 - 1];
                    }
                }
                if (n7 > 0) {
                    n6 = 0;
                    while (n6 < (int)(d / (double)n2) - 1) {
                        n6 = (int)(Math.random() * (double)n7);
                    }
                    int n13 = (int)(Math.random() * 2.0 + 1.0);
                    switch (n13) {
                        case 1: {
                            int n14 = 0;
                            n14 = Math.random() < 0.5 ? 2 : -2;
                            object2 = object[n6];
                            for (d3 = 0.0; d3 < (double)n2; d3 += phrase.getNote((int)object2++).getRhythmValue()) {
                                this.shiftPitch(phrase.getNote((int)object2), n14);
                            }
                            break;
                        }
                        default: {
                            object2 = object[n6];
                            for (d3 = 0.0; d3 < (double)n2; d3 += phrase.getNote((int)object2++).getRhythmValue()) {
                            }
                            n5 = object2 - object[n6];
                            object2 = object[n6];
                            if (n5 <= 0) break;
                            int[] nArray2 = new int[n5];
                            double[] dArray2 = new double[n5];
                            for (n4 = 0; n4 < n5; ++n4) {
                                nArray2[n4] = phrase.getNote(n4 + object2).getPitch();
                                dArray2[n4] = phrase.getNote(n4 + object2).getRhythmValue();
                            }
                            for (n4 = 0; n4 < n5; ++n4) {
                                phrase.getNote(n4 + object2).setPitch(nArray2[n5 - n4 - 1]);
                                phrase.getNote(n4 + object2).setRhythmValue(dArray2[n5 - n4 - 1]);
                            }
                        }
                    }
                }
            }
            n9 = phrase.size() - n;
            double d4 = (double)(n9 * this.MUTATE_PERCENTAGE[2]) / 100.0;
            n8 = 0;
            n8 = d4 < 1.0 ? (Math.random() < d4 ? 1 : 0) : (int)Math.floor(d4);
            object3 = (Vector)phrase.getNoteList().clone();
            for (object2 = 0; object2 < n8; ++object2) {
                n7 = (int)(Math.random() * (double)(n9 - 1));
                object = (Note)((Vector)object3).elementAt(n + n7);
                n6 = ((Note)object).getPitch();
                double d5 = ((Note)object).getRhythmValue();
                if (d5 >= 1.0 && d5 % 1.0 == 0.0 && d5 * 2.0 == Math.ceil(d5 * 2.0)) {
                    ((Vector)object3).removeElementAt(n + n7);
                    ((Vector)object3).insertElementAt(new Note(n6, d5 / 2.0), n + n7);
                    ((Vector)object3).insertElementAt(new Note(n6, d5 / 2.0), n + n7);
                    ++n9;
                    continue;
                }
                double d6 = d5 + ((Note)((Vector)object3).elementAt(n + n7 + 1)).getRhythmValue();
                if (!(d6 <= 2.0)) continue;
                ((Vector)object3).removeElementAt(n + n7);
                ((Vector)object3).removeElementAt(n + n7);
                ((Vector)object3).insertElementAt(new Note(n6, d6), n + n7);
                --n9;
            }
            phrase.addNoteList((Vector)object3, false);
            object3 = (Vector)phrase.getNoteList().clone();
            n6 = Integer.MIN_VALUE;
            double d7 = 0.0;
            for (n5 = n; n5 < ((Vector)object3).size() && n6 == Integer.MIN_VALUE; ++n5) {
                n6 = ((Note)((Vector)object3).elementAt(n5)).getPitch();
                d7 = ((Note)((Vector)object3).elementAt(n5)).getRhythmValue();
            }
            for (int i = n5; i < ((Vector)object3).size(); ++i) {
                object2 = ((Note)((Vector)object3).elementAt(i)).getPitch();
                double d8 = ((Note)((Vector)object3).elementAt(i)).getRhythmValue();
                if (object2 == Integer.MIN_VALUE) continue;
                int n15 = object2 - n6;
                if ((Math.abs(n15) == 4 || Math.abs(n15) == 3) && Math.random() < (double)this.MUTATE_PERCENTAGE[3] / 100.0) {
                    n4 = 0;
                    if (n15 > 0) {
                        n4 = object2 - 1;
                        if (!this.isScale(n4)) {
                            --n4;
                        }
                    } else {
                        n4 = object2 + 1;
                        if (!this.isScale(n4)) {
                            ++n4;
                        }
                    }
                    if (d8 > d7) {
                        if (d8 >= 0.5 && (int)Math.ceil(d8 * 2.0) == (int)(d8 * 2.0)) {
                            ((Vector)object3).removeElementAt(i);
                            ((Vector)object3).insertElementAt(new Note((int)object2, d8 / 2.0), i);
                            ((Vector)object3).insertElementAt(new Note(n4, d8 / 2.0), i);
                            ++i;
                        }
                    } else if (d7 >= 0.5 && (int)Math.ceil(d7 * 2.0) == (int)(d7 * 2.0)) {
                        ((Vector)object3).removeElementAt(i - 1);
                        ((Vector)object3).insertElementAt(new Note(n4, d7 / 2.0), i - 1);
                        ((Vector)object3).insertElementAt(new Note(n6, d7 / 2.0), i - 1);
                        ++i;
                    }
                }
                n6 = object2;
                d7 = d8;
            }
            phrase.addNoteList((Vector)object3, false);
            phrase.addNoteList(this.applyTonalPausesMutation(phrase, d, n, n2), false);
            double d9 = 0.0;
            for (int i = n; i < phrase.size(); ++i) {
                int n16 = phrase.getNote(i).getPitch();
                double d10 = phrase.getNote(i).getRhythmValue();
                if (n16 != Integer.MIN_VALUE && !this.isScale(n16)) {
                    if ((int)Math.ceil(d9 / 2.0) == (int)(d9 / 2.0)) {
                        if (Math.random() < d10) {
                            if (Math.random() < 0.5) {
                                phrase.getNote(i).setPitch(n16 + 1);
                            } else {
                                phrase.getNote(i).setPitch(n16 - 1);
                            }
                        }
                    } else if (Math.random() < d10 / 2.0) {
                        if (Math.random() < 0.5) {
                            phrase.getNote(i).setPitch(n16 + 1);
                        } else {
                            phrase.getNote(i).setPitch(n16 - 1);
                        }
                    }
                }
                d9 += d10;
            }
        }
        return phraseArray;
    }

    private void mutate(Note note) {
        int n = (int)(10.0 / (Math.random() * 6.0 + 2.0));
        if (Math.random() < 0.5) {
            this.shiftPitch(note, n);
        } else {
            this.shiftPitch(note, 0 - n);
        }
    }

    private Vector applyTonalPausesMutation(Phrase phrase, double d, int n, int n2) {
        Vector vector = (Vector)phrase.getNoteList().clone();
        double d2 = d;
        int n3 = 0;
        for (int i = n; i < phrase.size() - 1; ++i) {
            int n4 = phrase.getNote(i).getPitch();
            int n5 = ComplexMutater.pitchToDegree(n4, 60);
            double d3 = phrase.getNote(i).getRhythmValue() + phrase.getNote(i + 1).getRhythmValue();
            if (d2 / (double)n2 == Math.ceil(d2 / (double)n2) && (n5 == 0 || n5 == 7) && Math.random() < 2.0 / d3 * ((double)this.MUTATE_PERCENTAGE[4] / 100.0)) {
                vector.removeElementAt(i - n3);
                vector.removeElementAt(i - n3);
                vector.insertElementAt(new Note(n4, d3), i - n3);
                d2 += phrase.getNote(i).getRhythmValue();
                ++i;
                ++n3;
            }
            d2 += phrase.getNote(i).getRhythmValue();
        }
        return vector;
    }

    private void shiftPitch(Note note, int n) {
        note.setPitch(note.getPitch() + n);
    }

    private boolean isScale(int n) {
        for (int i = 0; i < PhraseAnalysis.MAJOR_SCALE.length; ++i) {
            if (n % 12 != PhraseAnalysis.MAJOR_SCALE[i]) continue;
            return true;
        }
        return false;
    }

    private static int pitchToDegree(int n, int n2) {
        if ((n -= n2) < 0) {
            n += (-n / 12 + 1) * 12;
        }
        return n % 12;
    }

    @Override
    public Panel getPanel() {
        return this.panel;
    }

    @Override
    public String getLabel() {
        return label;
    }

    public void setModifyAll(boolean bl) {
        this.modifyAll = bl;
    }
}

