/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools.ca;

public class CellularAutomata {
    int xSize;
    int ySize;
    boolean wrapAround;
    boolean[][] cellStates;
    int[][] cellSurrounds;

    public CellularAutomata(int n, int n2) {
        this(n, n2, 25, false);
    }

    public CellularAutomata(int n, int n2, int n3) {
        this(n, n2, n3, false);
    }

    public CellularAutomata(int n, int n2, int n3, boolean bl) {
        this.xSize = n;
        this.ySize = n2;
        this.wrapAround = bl;
        this.cellStates = new boolean[n][n2];
        this.cellSurrounds = new int[n][n2];
        this.setGrid(n3);
    }

    public void evolve() {
        boolean[][] blArray = new boolean[this.xSize][this.ySize];
        for (int i = 0; i < this.xSize; ++i) {
            for (int j = 0; j < this.ySize; ++j) {
                if (this.getState(i, j)) {
                    if (this.getSurrounding(i, j) == 2) {
                        blArray[i][j] = true;
                        continue;
                    }
                    blArray[i][j] = false;
                    continue;
                }
                if (this.getState(i, j) || this.getSurrounding(i, j) != 2 && this.getSurrounding(i, j) != 3) continue;
                blArray[i][j] = true;
            }
        }
        this.cellStates = blArray;
    }

    public boolean getState(int n, int n2) {
        return this.cellStates[n][n2];
    }

    public boolean[][] getAllStates() {
        return this.cellStates;
    }

    public int getSurrounding(int n, int n2) {
        int n3;
        block47: {
            block46: {
                block45: {
                    block44: {
                        block43: {
                            block42: {
                                block41: {
                                    block40: {
                                        n3 = 0;
                                        try {
                                            if (this.cellStates[n - 1][n2 - 1]) {
                                                ++n3;
                                            }
                                        }
                                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                            if (!this.wrapAround) break block40;
                                            if (n - 1 < 0 && n2 - 1 < 0) {
                                                if (this.cellStates[this.xSize - 1][this.ySize - 1]) {
                                                    ++n3;
                                                }
                                            }
                                            if (n - 1 < 0) {
                                                if (this.cellStates[this.xSize - 1][n2 - 1]) {
                                                    ++n3;
                                                }
                                            }
                                            if (n2 - 1 >= 0 || !this.cellStates[n - 1][this.ySize - 1]) break block40;
                                            ++n3;
                                        }
                                    }
                                    try {
                                        if (this.cellStates[n][n2 - 1]) {
                                            ++n3;
                                        }
                                    }
                                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                        if (!this.wrapAround || !this.cellStates[n][this.ySize - 1]) break block41;
                                        ++n3;
                                    }
                                }
                                try {
                                    if (this.cellStates[n + 1][n2 - 1]) {
                                        ++n3;
                                    }
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    if (!this.wrapAround) break block42;
                                    if (n + 1 >= this.xSize && n2 - 1 < 0) {
                                        if (this.cellStates[0][this.ySize - 1]) {
                                            ++n3;
                                        }
                                    }
                                    if (n + 1 >= this.xSize) {
                                        if (this.cellStates[0][n2 - 1]) {
                                            ++n3;
                                        }
                                    }
                                    if (n2 - 1 >= 0 || !this.cellStates[n + 1][this.ySize - 1]) break block42;
                                    ++n3;
                                }
                            }
                            try {
                                if (this.cellStates[n - 1][n2]) {
                                    ++n3;
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                if (!this.wrapAround || !this.cellStates[this.xSize - 1][n2]) break block43;
                                ++n3;
                            }
                        }
                        try {
                            if (this.cellStates[n + 1][n2]) {
                                ++n3;
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            if (!this.wrapAround || !this.cellStates[0][n2]) break block44;
                            ++n3;
                        }
                    }
                    try {
                        if (this.cellStates[n - 1][n2 + 1]) {
                            ++n3;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        if (!this.wrapAround) break block45;
                        if (n - 1 < 0 && n2 + 1 >= this.ySize) {
                            if (this.cellStates[this.xSize - 1][0]) {
                                ++n3;
                            }
                        }
                        if (n - 1 < 0) {
                            if (this.cellStates[this.xSize - 1][n2 + 1]) {
                                ++n3;
                            }
                        }
                        if (n2 + 1 < this.ySize || !this.cellStates[n - 1][0]) break block45;
                        ++n3;
                    }
                }
                try {
                    if (this.cellStates[n][n2 + 1]) {
                        ++n3;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (!this.wrapAround || !this.cellStates[n][0]) break block46;
                    ++n3;
                }
            }
            try {
                if (this.cellStates[n + 1][n2 + 1]) {
                    ++n3;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (!this.wrapAround) break block47;
                if (n + 1 >= this.xSize && n2 + 1 >= this.ySize) {
                    if (this.cellStates[0][0]) {
                        ++n3;
                    }
                }
                if (n + 1 >= this.xSize) {
                    if (this.cellStates[0][n2 + 1]) {
                        ++n3;
                    }
                }
                if (n2 + 1 < this.ySize || !this.cellStates[n + 1][0]) break block47;
                ++n3;
            }
        }
        return n3;
    }

    public void print() {
        for (int i = 0; i < this.xSize; ++i) {
            for (int j = 0; j < this.ySize; ++j) {
                if (this.getState(i, j)) {
                    System.out.print("1");
                    continue;
                }
                System.out.print("0");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    public void setGrid(int n) {
        for (int i = 0; i < this.xSize; ++i) {
            for (int j = 0; j < this.ySize; ++j) {
                this.cellStates[i][j] = this.trueFalse(n);
            }
        }
    }

    private boolean trueFalse(int n) {
        int n2 = (int)(Math.random() * 100.0);
        boolean bl = n2 < n;
        return bl;
    }
}

