/*
 * Decompiled with CFR 0.152.
 */
package jm.midi.event;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jm.midi.event.Event;
import jm.midi.event.VoiceEvt;

public final class PWheel
implements VoiceEvt,
Cloneable {
    private final short id = (short)6;
    private int value;
    private short midiChannel;
    private int time;

    public PWheel() {
        this.value = 0;
        this.midiChannel = 0;
        this.time = 0;
    }

    public PWheel(int n, short s, int n2) {
        this.value = n;
        this.midiChannel = s;
        this.time = n2;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
    }

    @Override
    public short getMidiChannel() {
        return this.midiChannel;
    }

    @Override
    public void setMidiChannel(short s) {
        this.midiChannel = s;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public void setTime(int n) {
        this.time = n;
    }

    @Override
    public short getID() {
        return 6;
    }

    @Override
    public int write(DataOutputStream dataOutputStream) throws IOException {
        return 0;
    }

    @Override
    public int read(DataInputStream dataInputStream) throws IOException {
        this.value = dataInputStream.readUnsignedByte();
        this.value += dataInputStream.readUnsignedByte() * 128;
        return 1;
    }

    @Override
    public Event copy() throws CloneNotSupportedException {
        PWheel pWheel;
        try {
            pWheel = (PWheel)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println(cloneNotSupportedException);
            pWheel = new PWheel();
        }
        return pWheel;
    }

    @Override
    public void print() {
        System.out.println("Pitch Wheel(006):\t\t\t\t  [time = " + this.time + "][midiChannel = " + this.midiChannel + "][value = " + this.value + "]");
    }
}

