/*
 * Decompiled with CFR 0.152.
 */
package jm.midi;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import jm.JMC;
import jm.midi.event.ATouch;
import jm.midi.event.CChange;
import jm.midi.event.CPres;
import jm.midi.event.EndTrack;
import jm.midi.event.Event;
import jm.midi.event.KeySig;
import jm.midi.event.NoteOff;
import jm.midi.event.NoteOn;
import jm.midi.event.PChange;
import jm.midi.event.PWheel;
import jm.midi.event.TempoEvent;
import jm.midi.event.TimeSig;

public final class MidiUtil
implements JMC {
    private static final boolean VERBOSE = false;

    public static int readVarLength(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2 = n = (int)dataInputStream.readUnsignedByte();
        if ((n & 0x80) != 0) {
            n2 &= 0x7F;
            do {
                n = (short)dataInputStream.readUnsignedByte();
                n2 = (n2 << 7) + (n & 0x7F);
            } while ((n & 0x80) != 0);
        }
        return n2;
    }

    public static int writeVarLength(int n, DataOutputStream dataOutputStream) throws IOException {
        int n2 = 0;
        long l = n & 0x7F;
        while ((n >>= 7) > 0) {
            l <<= 8;
            l |= (long)(n & 0x7F | 0x80);
        }
        while (true) {
            dataOutputStream.writeByte((byte)l);
            ++n2;
            if ((l & 0x80L) == 0L) break;
            l >>= 8;
        }
        return n2;
    }

    public static int varLengthBytes(int n) {
        int n2 = 0;
        long l = n & 0x7F;
        while ((n >>= 7) > 0) {
            l <<= 8;
            l |= (long)(n & 0x7F | 0x80);
        }
        while (true) {
            ++n2;
            if ((l & 0x80L) == 0L) break;
            l >>= 8;
        }
        return n2;
    }

    public static double getEndEvt(short s, Vector vector, int n) {
        double d = 0.0;
        ++n;
        while (n < vector.size()) {
            Event event = (Event)vector.elementAt(n);
            d += (double)event.getTime();
            switch (event.getID()) {
                case 5: {
                    NoteOn noteOn = (NoteOn)event;
                    if (noteOn.getPitch() != s || noteOn.getVelocity() != 0 || !(d > 0.0)) break;
                    noteOn.setPitch((short)255);
                    return d;
                }
                case 4: {
                    NoteOff noteOff = (NoteOff)event;
                    if (noteOff.getPitch() != s || !(d > 0.0)) break;
                    noteOff.setPitch((short)255);
                    return d;
                }
            }
            ++n;
        }
        System.out.println("Error reading file - sorry!");
        System.out.println("Try to continue reading anyway");
        return 0.0;
    }

    public static Event createVoiceEvent(int n) throws IOException {
        switch (n) {
            case 8: {
                return new NoteOff();
            }
            case 9: {
                return new NoteOn();
            }
            case 10: {
                return new ATouch();
            }
            case 11: {
                return new CChange();
            }
            case 12: {
                return new PChange();
            }
            case 13: {
                return new CPres();
            }
            case 14: {
                return new PWheel();
            }
        }
        return null;
    }

    public static Event createMetaEvent(int n) throws IOException {
        switch (n) {
            case 81: {
                return new TempoEvent();
            }
            case 47: {
                return new EndTrack();
            }
            case 88: {
                return new TimeSig();
            }
            case 89: {
                return new KeySig();
            }
        }
        return null;
    }

    public static Event createSysExEvent(int n) throws IOException {
        switch (n) {
            default: 
        }
        return null;
    }
}

