/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import java.util.Random;
import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;

public class Noise
extends AudioObject {
    private int noiseType = 0;
    private int noiseDensity = 10;
    private float amp = 1.0f;
    private static float sum;
    private static float[] rg;
    private static int k;
    private static int kg;
    private static int ng;
    private static int threshold;
    private static int np;
    private static int nbits;
    private static int numbPoints;
    private static float nr;
    private static float result;
    private static int counter;
    private double standardDeviation = 0.25;
    private double mean = 0.0;
    private float walkLastValue = 0.0f;
    private float walkStepSize = 0.3f;
    private float walkMax = 1.0f;
    private float walkMin = -1.0f;
    private int walkNoiseDensity = 500;
    private long walkDensityCounter = 0L;
    private boolean walkVaryDensity = true;
    private int walkNoiseDensityMin = 1;
    private int walkNoiseDensityMax = 1500;
    private int walkNoiseDensityStepSize = 100;
    private Random RandomGenerator = new Random();
    private int gendynAmpGranularity = 128;
    private double gendynPrevTime = 50.0;
    private int gendynTimeMirror = 80;
    private int gendynAmpMirror = 80;
    private int tempAmpMirror;
    private boolean ampMirrorUpdate = false;
    private int gendynPointSize = 4;
    private boolean pointSizeReset = false;
    private int newPointSize;
    private double[] gendynAmpArray = new double[this.gendynPointSize];
    private double[] gendynTimeArray = new double[this.gendynPointSize];
    private double gendynAmp0 = 0.0;
    private int[] gendynIntArray;
    private double gendynIntArrayLength;
    private int gendynIntArrayCounter = 0;
    private double gendynTimeStepSize = 10.0;
    private double maxGendynTimeStepSize = 100.0;
    private double gendynAmpStepSize = 10.0;
    private double maxGendynAmpStepSize = 100.0;
    private int mirrorMax = 100;
    private boolean gendynGaussian = false;
    private double gendynPrimaryTimeStepSize = 10.0;
    private double gendynPrimaryAmpStepSize = 10.0;
    private int gendynPrimaryTimeMirror = 100;
    private int gendynPrimaryAmpMirror = 100;
    private int gendynInterpolation = 1;
    private boolean gendynGranularityUpdate = false;
    private int tempGendynGranularity;
    public static final int WHITE_NOISE = 0;
    public static final int STEP_NOISE = 1;
    public static final int SMOOTH_NOISE = 2;
    public static final int BROWN_NOISE = 3;
    public static final int FRACTAL_NOISE = 4;
    public static final int GAUSSIAN_NOISE = 5;
    public static final int WALK_NOISE = 6;
    public static final int GENDYN_NOISE = 7;
    private float gnSampleVal;
    private int gnj;
    private int mgaCounter;
    private double mgaInc;
    private int index;
    private int jindex;
    private double rwNewVal;

    public Noise(Instrument instrument) {
        this(instrument, 0);
    }

    public Noise(Instrument instrument, int n) {
        this(instrument, n, 44100);
    }

    public Noise(Instrument instrument, int n, int n2) {
        this(instrument, n, n2, 1);
    }

    public Noise(Instrument instrument, int n, int n2, int n3) {
        super(instrument, n2, "[WaveTable]");
        this.noiseType = n;
        this.channels = n3;
        if (n == 4) {
            this.setUpFractalMath();
        }
        if (n == 7) {
            this.makeGendynArray();
        }
        for (int i = 0; i < this.gendynPointSize; ++i) {
            this.gendynAmpArray[i] = 50.0;
        }
    }

    public void setAmp(float f) {
        this.amp = f;
    }

    public float getAmp() {
        return this.amp;
    }

    private void setUpFractalMath() {
        nr /= 2.0f;
        while (nr > 1.0f) {
            ++nbits;
            np = 2 * np;
            nr /= 2.0f;
        }
        for (kg = 0; kg < nbits; ++kg) {
            Noise.rg[Noise.kg] = (float)Math.random();
        }
    }

    @Override
    public int work(float[] fArray) throws AOException {
        int n = 0;
        switch (this.noiseType) {
            case 0: {
                while (n < fArray.length) {
                    for (int i = 0; i < this.channels; ++i) {
                        fArray[n++] = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                    }
                }
                break;
            }
            case 3: {
                float f = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                while (n < fArray.length) {
                    for (int i = 0; i < this.channels; ++i) {
                        float f4 = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                        float f5 = (f + f2 + f3 + f4) / 4.0f;
                        fArray[n++] = f5;
                        f = f2;
                        f2 = f3;
                        f3 = f4;
                    }
                }
                break;
            }
            case 1: {
                int n2 = this.noiseDensity;
                float f = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                while (n < fArray.length) {
                    for (int i = 0; i < this.channels; ++i) {
                        if (n % n2 == 0) {
                            f = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                        }
                        fArray[n++] = f;
                    }
                }
                break;
            }
            case 2: {
                int n3 = this.noiseDensity;
                float f = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                float f6 = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                while (n < fArray.length) {
                    for (int i = 0; i < this.channels; ++i) {
                        if ((n + 1) % n3 == 0) {
                            fArray[n++] = f6;
                            f = f6;
                            f6 = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                            continue;
                        }
                        fArray[n++] = f + (f6 - f) / (float)n3 * (float)(n % n3);
                    }
                }
                break;
            }
            case 4: {
                while (n < fArray.length) {
                    for (int i = 0; i < this.channels; ++i) {
                        if (counter % this.noiseDensity == 0) {
                            threshold = np;
                            ng = nbits;
                            while (k % threshold != 0) {
                                --ng;
                                threshold /= 2;
                            }
                            sum = 0.0f;
                            for (kg = 0; kg < nbits; ++kg) {
                                if (kg < ng) {
                                    Noise.rg[Noise.kg] = (float)Math.random();
                                }
                                sum += rg[kg];
                            }
                            result = (float)(((double)(sum / (float)nbits) - 0.17) * 2.85 - 1.0);
                            if ((double)result > 1.0) {
                                result = 1.0f;
                            } else if ((double)result < -1.0) {
                                result = -1.0f;
                            }
                        }
                        ++counter;
                        fArray[n++] = result * this.amp;
                    }
                    if (counter <= 67000) continue;
                    counter = 0;
                }
                break;
            }
            case 5: {
                Random random = new Random();
                while (n < fArray.length) {
                    for (int i = 0; i < this.channels; ++i) {
                        float f = (float)(random.nextGaussian() * this.standardDeviation + this.mean);
                        if (f < -1.0f) {
                            f = -1.0f;
                        } else if (f > 1.0f) {
                            f = 1.0f;
                        }
                        fArray[n++] = f * this.amp;
                    }
                }
                break;
            }
            case 6: {
                while (n < fArray.length) {
                    for (int i = 0; i < this.channels; ++i) {
                        fArray[n++] = this.walkLastValue;
                        ++this.walkDensityCounter;
                        if ((int)this.walkDensityCounter % this.walkNoiseDensity != 0) continue;
                        this.walkLastValue += (float)Math.random() * this.walkStepSize * 2.0f - this.walkStepSize;
                        while (this.walkLastValue > this.walkMax || this.walkLastValue < this.walkMin) {
                            if (this.walkLastValue > this.walkMax) {
                                this.walkLastValue -= (this.walkLastValue - this.walkMax) * 2.0f;
                            }
                            if (!(this.walkLastValue < this.walkMin)) continue;
                            this.walkLastValue += (this.walkMin - this.walkLastValue) * 2.0f;
                        }
                        if (!this.walkVaryDensity) continue;
                        this.walkNoiseDensity += (int)(Math.random() * (double)this.walkNoiseDensityStepSize * 2.0 - (double)this.walkNoiseDensityStepSize);
                        if (this.walkNoiseDensity < this.walkNoiseDensityMin) {
                            this.walkNoiseDensity = this.walkNoiseDensityMin;
                            continue;
                        }
                        if (this.walkNoiseDensity <= this.walkNoiseDensityMax) continue;
                        this.walkNoiseDensity = this.walkNoiseDensityMax;
                    }
                }
                break;
            }
            case 7: {
                this.gnSampleVal = 0.0f;
                while (n < fArray.length) {
                    this.gnSampleVal = ((float)this.gendynIntArray[this.gendynIntArrayCounter] / (float)this.gendynAmpGranularity - 0.5f) * 2.0f;
                    if ((double)this.gnSampleVal > 1.0) {
                        this.gnSampleVal = 1.0f;
                    } else if ((double)this.gnSampleVal < -1.0) {
                        this.gnSampleVal = -1.0f;
                    }
                    this.gnj = 0;
                    while (this.gnj < this.channels) {
                        fArray[n++] = this.gnSampleVal;
                        ++this.gnj;
                    }
                    ++this.gendynIntArrayCounter;
                    if (this.gendynIntArrayCounter < (int)this.gendynIntArrayLength) continue;
                    this.makeGendynArray();
                }
                break;
            }
            default: {
                System.err.println(this.name + "jMusic error: Noise type " + this.noiseType + " not supported yet.");
                System.exit(1);
            }
        }
        return n;
    }

    private void makeGendynArray() {
        double d;
        this.gendynTimeStepSize = this.randWalk(this.gendynTimeStepSize, this.gendynPrimaryTimeStepSize, this.gendynPrimaryTimeMirror, true);
        if (Math.abs(this.gendynTimeStepSize) > this.maxGendynTimeStepSize) {
            this.gendynTimeStepSize = this.maxGendynTimeStepSize;
        }
        this.gendynAmpStepSize = this.randWalk(this.gendynAmpStepSize, this.gendynPrimaryAmpStepSize, this.gendynPrimaryAmpMirror, false);
        if (Math.abs(this.gendynAmpStepSize) > this.maxGendynAmpStepSize) {
            this.gendynAmpStepSize = this.maxGendynAmpStepSize;
        }
        this.index = 0;
        while (this.index < this.gendynPointSize) {
            this.gendynTimeArray[this.index] = Math.abs(this.randWalk(this.gendynTimeArray[this.index], this.gendynTimeStepSize, this.gendynTimeMirror, true));
            if (this.gendynTimeArray[this.index] < 1.0) {
                this.gendynTimeArray[this.index] = 1.0;
            }
            this.gendynAmpArray[this.index] = this.randWalk(this.gendynAmpArray[this.index], this.gendynAmpStepSize, this.gendynAmpMirror / 2 + 51, false);
            ++this.index;
        }
        this.gendynIntArrayLength = 0.0;
        this.index = 0;
        while (this.index < this.gendynPointSize) {
            this.gendynIntArrayLength += this.gendynTimeArray[this.index];
            ++this.index;
        }
        this.gendynIntArray = new int[(int)this.gendynIntArrayLength];
        this.mgaCounter = 0;
        this.mgaInc = (this.gendynAmpArray[0] - this.gendynAmp0) / this.gendynTimeArray[0];
        this.jindex = 0;
        while (this.jindex < (int)this.gendynTimeArray[0]) {
            switch (this.gendynInterpolation) {
                case 2: {
                    d = (1.0 - (Math.cos((double)this.jindex / this.gendynTimeArray[0] * 3.14) / 2.0 + 0.5)) * (this.gendynAmpArray[0] - this.gendynAmp0);
                    this.gendynIntArray[this.mgaCounter++] = (int)((this.gendynAmp0 + d) / 100.0 * (double)this.gendynAmpGranularity);
                    break;
                }
                case 1: {
                    this.gendynIntArray[this.mgaCounter++] = (int)((this.gendynAmp0 + this.mgaInc * (double)this.jindex) / 100.0 * (double)this.gendynAmpGranularity);
                    break;
                }
                case 3: {
                    this.gendynIntArray[this.mgaCounter++] = (int)(this.gendynAmp0 / 100.0 * (double)this.gendynAmpGranularity);
                }
            }
            ++this.jindex;
        }
        this.index = 1;
        while (this.index < this.gendynPointSize - 1) {
            this.mgaInc = (this.gendynAmpArray[this.index] - this.gendynAmpArray[this.index - 1]) / this.gendynTimeArray[this.index];
            this.jindex = 0;
            while (this.jindex < (int)this.gendynTimeArray[this.index]) {
                switch (this.gendynInterpolation) {
                    case 2: {
                        d = (1.0 - (Math.cos((double)this.jindex / this.gendynTimeArray[this.index] * 3.14) / 2.0 + 0.5)) * (this.gendynAmpArray[this.index] - this.gendynAmpArray[this.index - 1]);
                        this.gendynIntArray[this.mgaCounter++] = (int)((this.gendynAmpArray[this.index - 1] + d) / 100.0 * (double)this.gendynAmpGranularity);
                        break;
                    }
                    case 1: {
                        this.gendynIntArray[this.mgaCounter++] = (int)((this.gendynAmpArray[this.index - 1] + this.mgaInc * (double)this.jindex) / 100.0 * (double)this.gendynAmpGranularity);
                        break;
                    }
                    case 3: {
                        this.gendynIntArray[this.mgaCounter++] = (int)(this.gendynAmpArray[this.index - 1] / 100.0 * (double)this.gendynAmpGranularity);
                    }
                }
                ++this.jindex;
            }
            ++this.index;
        }
        this.gendynAmp0 = this.gendynAmpArray[this.gendynPointSize - 1];
        this.gendynIntArrayCounter = 0;
        if (this.pointSizeReset) {
            this.resetPointSize();
        }
        if (this.gendynGranularityUpdate) {
            this.updateGranularity();
        }
    }

    private double randWalk(double d, double d2, int n, boolean bl) {
        this.rwNewVal = 0.0;
        this.rwNewVal = this.gendynGaussian ? d + this.RandomGenerator.nextGaussian() * d2 : d + (this.RandomGenerator.nextDouble() * d2 * 2.0 - d2);
        if (bl) {
            if (d2 == 0.0) {
                this.rwNewVal = d;
            } else {
                while (this.rwNewVal > (double)n || this.rwNewVal < 0.0) {
                    if (this.rwNewVal > (double)n) {
                        this.rwNewVal = (double)n - (this.rwNewVal - (double)n);
                    }
                    if (!(this.rwNewVal < 0.0)) continue;
                    this.rwNewVal = this.rwNewVal / 2.0 * -1.0;
                }
            }
            if (this.rwNewVal < 0.0) {
                this.rwNewVal = 0.0;
            }
        } else {
            int n2 = this.mirrorMax - n;
            while (this.rwNewVal > (double)n || this.rwNewVal < (double)n2) {
                if (this.rwNewVal > (double)n) {
                    this.rwNewVal = (double)n - (this.rwNewVal - (double)n);
                }
                if (!(this.rwNewVal < (double)n2)) continue;
                this.rwNewVal = (double)n2 + ((double)n2 - this.rwNewVal);
            }
            if (this.rwNewVal < 0.0) {
                this.rwNewVal = 0.0;
            }
        }
        return this.rwNewVal;
    }

    public void setNoiseDensity(int n) {
        this.noiseDensity = n;
    }

    public void setStandardDeviation(double d) {
        this.standardDeviation = d;
    }

    public void setMean(double d) {
        this.mean = d;
    }

    public void setWalkStepSize(double d) {
        if (d > 0.0) {
            this.walkStepSize = (float)d;
        } else {
            System.err.println("Walk step size must be greater than zero.");
        }
    }

    public void setWalkMax(double d) {
        if (d > 0.0) {
            this.walkMax = (float)d;
        } else {
            System.err.println("Walk maximum value must be greater than zero.");
        }
    }

    public void setWalkMin(double d) {
        if (d < 0.0) {
            this.walkMin = (float)d;
        } else {
            System.err.println("Walk minimum value must be less than zero.");
        }
    }

    public void setWalkNoiseDensity(int n) {
        if (n > 0) {
            this.walkNoiseDensity = n;
        } else {
            System.err.println("walkNoiseDensity must be greater than zero.");
        }
    }

    public void setWalkVaryDensity(boolean bl) {
        this.walkVaryDensity = bl;
    }

    public void setWalkNoiseDensityMin(int n) {
        if (n > 0) {
            this.walkNoiseDensityMin = n;
        } else {
            System.err.println("walkNoiseDensityMin must be greater than zero.");
        }
    }

    public void setWalkNoiseDensityMax(int n) {
        if (n > 0) {
            this.walkNoiseDensityMax = n;
        } else {
            System.err.println("walkNoiseDensityMax must be greater than zero.");
        }
    }

    public void setWalkNoiseDensityStepSize(int n) {
        if (n > 0) {
            this.walkNoiseDensityStepSize = n;
        } else {
            System.err.println("walkNoiseDensityMax must be greater than zero.");
        }
    }

    public void setGendynTimeMirror(double d) {
        if (d > 1.0 && d <= 100.0) {
            this.gendynTimeMirror = (int)d;
        } else {
            System.err.println("GendynTimeMirror must be between 3 and 100, not " + d);
        }
    }

    public void setGendynAmpMirror(double d) {
        if (d > 0.0 && d <= 100.0) {
            this.gendynAmpMirror = (int)d;
        } else {
            System.err.println("GendynAmpMirror must be between 1 and 100, not " + d);
        }
    }

    public double getGendynAmp0() {
        return this.gendynAmp0;
    }

    public int getGendynPointSize() {
        return this.gendynPointSize;
    }

    public void setGendynPointSize(int n) {
        this.pointSizeReset = true;
        this.newPointSize = n;
    }

    private void resetPointSize() {
        this.gendynPointSize = this.newPointSize;
        this.gendynAmpArray = new double[this.gendynPointSize];
        this.gendynTimeArray = new double[this.gendynPointSize];
        for (int i = 0; i < this.gendynPointSize; ++i) {
            this.gendynAmpArray[i] = 50.0;
            this.gendynTimeArray[i] = 30.0;
        }
        if (this.getGendynAmpStepSize() < 3.0) {
            this.setGendynAmpStepSize(3);
        }
        this.pointSizeReset = false;
    }

    public double getGendynAmpArray(int n) {
        return this.gendynAmpArray[n];
    }

    public double getGendynTimeArray(int n) {
        return this.gendynTimeArray[n];
    }

    public double getGendynAmpStepSize() {
        return this.gendynAmpStepSize;
    }

    public double getGendynTimeStepSize() {
        return this.gendynTimeStepSize;
    }

    public void setGendynAmpStepSize(int n) {
        if (n >= 0) {
            this.gendynAmpStepSize = n;
        }
    }

    public void setMaxGendynAmpStepSize(int n) {
        if (n >= 0) {
            this.maxGendynAmpStepSize = n;
        }
    }

    public void setGendynTimeStepSize(double d) {
        if (d >= 0.0) {
            this.gendynTimeStepSize = d;
        }
    }

    public void setMaxGendynTimeStepSize(int n) {
        if (n >= 0) {
            this.maxGendynTimeStepSize = n;
        }
    }

    public void setGendynPrimaryAmpStepSize(int n) {
        if (n >= 0) {
            this.gendynPrimaryAmpStepSize = n;
        }
    }

    public void setGendynPrimaryTimeStepSize(int n) {
        if (n >= 0) {
            this.gendynPrimaryTimeStepSize = n;
        }
    }

    public void setGendynAmpGranularity(int n) {
        this.gendynGranularityUpdate = true;
        this.tempGendynGranularity = n;
    }

    private void updateGranularity() {
        if (this.tempGendynGranularity > 0) {
            this.gendynAmpGranularity = this.tempGendynGranularity;
        }
    }

    public void setGendynPrimaryTimeMirror(int n) {
        if (n >= 0) {
            this.gendynPrimaryTimeMirror = n;
        }
    }

    public void setGendynPrimaryAmpMirror(int n) {
        if (n >= 0) {
            this.gendynPrimaryAmpMirror = n;
        }
    }

    public void setGendynInterpolation(int n) {
        this.gendynInterpolation = n;
    }

    public int getGendynInterpolation() {
        return this.gendynInterpolation;
    }

    public void setGendynGaussian(boolean bl) {
        this.gendynGaussian = bl;
    }

    static {
        rg = new float[16];
        np = 1;
        nbits = 1;
        numbPoints = 48000;
        nr = numbPoints;
        counter = 0;
    }
}

