/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

public class MassObject {
    private double massSize = 1.0;
    private double friction = 3.0E-6;
    private double inertia = 0.0;
    private double deltaTime = 1.0;
    private double yPosition;

    public MassObject() {
        this(1.0);
    }

    public MassObject(double d) {
        this(d, 1.0);
    }

    public MassObject(double d, double d2) {
        this.massSize = d2;
        this.friction = d;
    }

    public void setYPosition(double d) {
        this.yPosition = d;
    }

    public double getYPosition() {
        return this.yPosition;
    }

    public double getDisplacement(double d) {
        d += this.inertia;
        if (this.inertia < 0.0 && this.friction > 0.0 || this.inertia > 0.0 && this.friction < 0.0) {
            this.friction *= -1.0;
        }
        this.inertia = Math.abs(this.friction) > Math.abs(d) ? 0.0 : d - this.friction;
        double d2 = d / this.massSize;
        double d3 = d2 / (this.deltaTime * this.deltaTime);
        return d3;
    }
}

