/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class Filter
extends AudioObject {
    public static final int LOW_PASS = 0;
    public static final int HIGH_PASS = 1;
    private int type = 0;
    private double cutoff_frequency;
    private double initialCutoff;
    private double cutoff_frq_percent;
    private double ripple = 0.5;
    private double poles = 2.0;
    private double[] a = new double[22];
    private double[] ta = new double[22];
    private double[] b = new double[22];
    private double[] tb = new double[22];
    private double[][] xbuf;
    private double[][] ybuf;

    public Filter(AudioObject audioObject, double d) {
        this(audioObject, d, 0, 0.5, 2.0);
    }

    public Filter(AudioObject audioObject, double d, int n) {
        this(audioObject, d, n, 0.5, 2.0);
    }

    public Filter(AudioObject audioObject, double d, int n, double d2, double d3) {
        super(audioObject, "[Filter]");
        this.type = n;
        this.cutoff_frequency = d;
        this.ripple = d2;
        this.poles = d3;
        if (this.poles > 20.0) {
            System.err.println("More than 20 poles are not allowed (Sorry)");
            System.exit(1);
        }
    }

    public Filter(AudioObject[] audioObjectArray, double d, int n) {
        this(audioObjectArray, d, n, 0.5, 2.0);
    }

    public Filter(AudioObject[] audioObjectArray, double d, int n, double d2, double d3) {
        super(audioObjectArray, "[Filter]");
        this.type = n;
        this.cutoff_frequency = d;
        this.initialCutoff = d;
        this.ripple = d2;
        this.poles = d3;
        if (this.poles > 20.0) {
            System.err.println("More than 20 poles are not allowed (Sorry)");
            System.exit(1);
        }
    }

    @Override
    public void build() {
        this.ybuf = new double[this.channels][22];
        this.xbuf = new double[this.channels][22];
        this.setCutOff(this.cutoff_frequency);
    }

    public void printCoefficients() {
        for (int i = 0; i < 22; ++i) {
            System.out.println("a[" + i + "] " + this.a[i] + "    b[" + i + "] " + this.b[i]);
        }
    }

    public void setCutOff(double d) {
        this.cutoff_frequency = d;
        if (d <= 0.0) {
            System.err.println("Filter error: You tried to use a cuttoff frequency of " + d + " - woops! Frequency must be greater than zero. ");
            System.err.println("Exiting from Filter");
            System.exit(1);
        }
        if (d > 0.5 * (double)this.sampleRate) {
            System.err.println("Cutoff frequencies above the Nyquist limit are BAD ;) SampleRate = " + this.sampleRate + " Frequency = " + d);
            System.err.println("Exiting from Filter");
            System.exit(1);
        }
        this.cutoff_frq_percent = 1.0 / (double)this.sampleRate * d;
        this.coefficientCalc();
    }

    public void setPoles(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 20) {
            n = 20;
        }
        this.poles = n;
        this.setCutOff(this.cutoff_frequency);
    }

    @Override
    public int work(float[] fArray) throws AOException {
        int n;
        int n2 = this.previous[0].nextWork(fArray);
        float[] fArray2 = null;
        if (this.previous.length > 1) {
            fArray2 = new float[n2];
            this.previous[1].nextWork(fArray2);
        }
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            int n4;
            if (n % 100 == 0 && this.previous.length > 1) {
                this.setCutOff((double)fArray2[n] + this.initialCutoff);
            }
            for (n4 = (int)this.poles; n4 > 0; --n4) {
                this.xbuf[n3][n4] = this.xbuf[n3][n4 - 1];
            }
            this.xbuf[n3][0] = fArray[n];
            for (n4 = (int)this.poles; n4 > 0; --n4) {
                this.ybuf[n3][n4] = this.ybuf[n3][n4 - 1];
            }
            this.ybuf[n3][0] = 0.0;
            n4 = 0;
            while ((double)n4 < this.poles + 1.0) {
                double[] dArray = this.ybuf[n3];
                dArray[0] = dArray[0] + this.a[n4] * this.xbuf[n3][n4];
                if (n4 > 0) {
                    double[] dArray2 = this.ybuf[n3];
                    dArray2[0] = dArray2[0] + this.b[n4] * this.ybuf[n3][n4];
                }
                ++n4;
            }
            fArray[n] = (float)(this.ybuf[n3][0] * 1.0);
            if (this.channels != ++n3) continue;
            n3 = 0;
        }
        return n;
    }

    public void coefficientCalc() {
        int n;
        for (n = 0; n < 22; ++n) {
            this.a[n] = 0.0;
            this.b[n] = 0.0;
        }
        this.a[2] = 1.0;
        this.b[2] = 1.0;
        n = 1;
        while ((double)n <= this.poles * 0.5) {
            int n2;
            double[] dArray = this.coefficientCalcSupport(n);
            for (n2 = 0; n2 < 22; ++n2) {
                this.ta[n2] = this.a[n2];
                this.tb[n2] = this.b[n2];
            }
            for (n2 = 2; n2 < 22; ++n2) {
                this.a[n2] = dArray[0] * this.ta[n2] + dArray[1] * this.ta[n2 - 1] + dArray[2] * this.ta[n2 - 2];
                this.b[n2] = this.tb[n2] - dArray[3] * this.tb[n2 - 1] - dArray[4] * this.tb[n2 - 2];
            }
            ++n;
        }
        this.b[2] = 0.0;
        for (n = 0; n < 20; ++n) {
            this.a[n] = this.a[n + 2];
            this.b[n] = -this.b[n + 2];
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < 20; ++i) {
            if (this.type == 0) {
                d += this.a[i];
            }
            if (this.type == 0) {
                d2 += this.b[i];
            }
            if (this.type == 1) {
                d += this.a[i] * Math.pow(-1.0, i);
            }
            if (this.type != 1) continue;
            d2 += this.b[i] * Math.pow(-1.0, i);
        }
        double d3 = d / (1.0 - d2);
        for (int i = 0; i < 20; ++i) {
            this.a[i] = this.a[i] / d3;
        }
    }

    private double[] coefficientCalcSupport(int n) {
        double d;
        double d2;
        double d3;
        double[] dArray = new double[5];
        double d4 = -Math.cos(Math.PI / (this.poles * 2.0) + (double)(n - 1) * Math.PI / this.poles);
        double d5 = Math.sin(Math.PI / (this.poles * 2.0) + (double)(n - 1) * Math.PI / this.poles);
        if (this.ripple != 0.0) {
            d3 = Math.sqrt(Math.pow(100.0 / (100.0 - this.ripple), 2.0) - 1.0);
            d2 = 1.0 / this.poles * Math.log(1.0 / d3 + Math.sqrt(1.0 / (d3 * d3) + 1.0));
            d = 1.0 / this.poles * Math.log(1.0 / d3 + Math.sqrt(1.0 / (d3 * d3) - 1.0));
            d = (Math.exp(d) + Math.exp(-d)) * 0.5;
            d4 = d4 * ((Math.exp(d2) - Math.exp(-d2)) * 0.5) / d;
            d5 = d5 * ((Math.exp(d2) + Math.exp(-d2)) * 0.5) / d;
        }
        d3 = 2.0 * Math.tan(0.5);
        d2 = Math.PI * 2 * this.cutoff_frq_percent;
        d = d4 * d4 + d5 * d5;
        double d6 = 4.0 - 4.0 * d4 * d3 + d * (d3 * d3);
        double d7 = d3 * d3 / d6;
        double d8 = 2.0 * d7;
        double d9 = d7;
        double d10 = (8.0 - 2.0 * d * (d3 * d3)) / d6;
        double d11 = (-4.0 - 4.0 * d4 * d3 - d * (d3 * d3)) / d6;
        double d12 = 0.0;
        if (this.type == 1) {
            d12 = -Math.cos(d2 * 0.5 + 0.5) / Math.cos(d2 * 0.5 - 0.5);
        }
        if (this.type == 0) {
            d12 = Math.sin(0.5 - d2 * 0.5) / Math.sin(0.5 + d2 * 0.5);
        }
        d6 = 1.0 + d10 * d12 - d11 * (d12 * d12);
        dArray[0] = (d7 - d8 * d12 + d9 * (d12 * d12)) / d6;
        dArray[1] = (-2.0 * d7 * d12 + d8 + d8 * (d12 * d12) - 2.0 * d9 * d12) / d6;
        dArray[2] = (d7 * (d12 * d12) - d8 * d12 + d9) / d6;
        dArray[3] = (2.0 * d12 + d10 + d10 * (d12 * d12) - 2.0 * d11 * d12) / d6;
        dArray[4] = (-(d12 * d12) - d10 * d12 + d11) / d6;
        if (this.type == 1) {
            dArray[1] = -dArray[1];
        }
        if (this.type == 1) {
            dArray[3] = -dArray[3];
        }
        return dArray;
    }
}

