/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.math;

public abstract class RealFloatFFT {
    int n;

    public RealFloatFFT(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The transform length must be >=0 : " + n);
        }
        this.n = n;
    }

    protected void checkData(float[] fArray, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("The offset must be >=0 : " + n);
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("The stride must be >=1 : " + n2);
        }
        if (n + n2 * (this.n - 1) + 1 > fArray.length) {
            throw new IllegalArgumentException("The data array is too small for " + this.n + ":" + "i0=" + n + " stride=" + n2 + " data.length=" + fArray.length);
        }
    }

    public void transform(float[] fArray) {
        this.transform(fArray, 0, 1);
    }

    public abstract void transform(float[] var1, int var2, int var3);

    public float[] toWraparoundOrder(float[] fArray) {
        return this.toWraparoundOrder(fArray, 0, 1);
    }

    public abstract float[] toWraparoundOrder(float[] var1, int var2, int var3);

    public void backtransform(float[] fArray) {
        this.backtransform(fArray, 0, 1);
    }

    public abstract void backtransform(float[] var1, int var2, int var3);

    public float normalization() {
        return 1.0f / (float)this.n;
    }

    public void inverse(float[] fArray) {
        this.inverse(fArray, 0, 1);
    }

    public void inverse(float[] fArray, int n, int n2) {
        this.backtransform(fArray, n, n2);
        float f = this.normalization();
        for (int i = 0; i < this.n; ++i) {
            int n3 = n + n2 * i;
            fArray[n3] = fArray[n3] * f;
        }
    }
}

