/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import jm.JMC;
import jm.audio.AOException;
import jm.audio.AudioObject;

public final class SampleOut
extends AudioObject
implements JMC {
    private boolean sync;
    public static float max = 0.0f;
    public static int numofchan;
    public static int samprate;
    private RandomAccessFile raf;
    private int position = 0;
    private int count;
    private ByteArrayOutputStream bos = new ByteArrayOutputStream();
    private DataOutputStream dos = new DataOutputStream(this.bos);
    private boolean DEBUG_AU = false;
    private String fileName;
    private int size = 0;

    public SampleOut(AudioObject audioObject) {
        super(audioObject, "[SampleOut]");
        this.sync = true;
        this.fileName = "jmusic.tmp";
        try {
            this.raf = new RandomAccessFile(this.fileName, "rw");
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public SampleOut(AudioObject audioObject, String string) {
        super(audioObject, "[SampleOut]");
        this.sync = true;
        this.fileName = string;
        try {
            this.raf = new RandomAccessFile(this.fileName, "rw");
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public SampleOut(AudioObject audioObject, String string, boolean bl) {
        super(audioObject, "[SampleOut]");
        this.sync = bl;
        this.fileName = string;
        try {
            this.raf = new RandomAccessFile(this.fileName, "rw");
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public SampleOut(AudioObject audioObject, String string, int n, boolean bl) {
        super(audioObject, "[SampleOut]");
        this.sync = bl;
        this.position = n;
        this.fileName = string;
        try {
            this.raf = new RandomAccessFile(this.fileName, "rw");
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public void finalize() {
    }

    @Override
    public void build() {
        if (this.sync) {
            try {
                this.raf.getFD().sync();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.position = (int)(this.currentNoteStartTime * (double)this.sampleRate) * 4 * this.channels;
        if (this.position < 0) {
            this.position = 0;
        }
        samprate = this.sampleRate;
        numofchan = this.channels;
        this.finished = false;
    }

    @Override
    public int work(float[] fArray) throws AOException {
        if (this.inst.iterations < 0) {
            this.finished = true;
        }
        int n = this.previous[0].nextWork(fArray);
        for (int i = 0; i < n; ++i) {
            float f = fArray[i];
            if (max < Math.abs(f)) {
                max = Math.abs(f);
            }
            try {
                this.dos.writeFloat(f);
                continue;
            }
            catch (IOException iOException) {
                throw new AOException(this.name, iOException.toString());
            }
        }
        this.write(n);
        return n;
    }

    private void write(int n) {
        int n2 = n;
        ByteArrayInputStream byteArrayInputStream = null;
        DataInputStream dataInputStream = null;
        ByteArrayInputStream byteArrayInputStream2 = null;
        DataInputStream dataInputStream2 = null;
        int n3 = n2 * 4;
        try {
            this.raf.seek(this.position);
            float f = this.raf.readFloat();
            this.raf.seek(this.position);
            byte[] byArray = new byte[n3];
            int n4 = this.raf.read(byArray);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            dataInputStream = new DataInputStream(byteArrayInputStream);
            byteArrayInputStream2 = new ByteArrayInputStream(this.bos.toByteArray());
            dataInputStream2 = new DataInputStream(byteArrayInputStream2);
            this.bos.reset();
            float[] fArray = new float[n2];
            for (int i = 0; i < n2; ++i) {
                fArray[i] = dataInputStream.readFloat() + dataInputStream2.readFloat();
                if (max < Math.abs(fArray[i])) {
                    max = Math.abs(fArray[i]);
                }
                this.dos.writeFloat(fArray[i]);
            }
            this.dos.flush();
            this.raf.seek(this.position);
            this.raf.write(this.bos.toByteArray());
            this.bos.reset();
            this.position += n3;
            dataInputStream.close();
            byteArrayInputStream.close();
            dataInputStream2.close();
            byteArrayInputStream2.close();
        }
        catch (EOFException eOFException) {
            try {
                this.raf.seek(this.position);
                this.raf.write(this.bos.toByteArray());
                this.bos.reset();
                this.position += n3;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

