/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import jm.JMC;
import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;

public class SampleIn
extends AudioObject
implements JMC {
    private File file;
    private AudioFileFormat fileFormat;
    private AudioFormat format;
    private int sampleSize;
    private String fileType;
    private boolean cache;
    private long duration;
    private InputStream is;
    private boolean wholeFile = false;
    private int loop;
    private int loopCount;
    private int loopStart;
    private int loopEnd;
    private int streamPosition;
    private boolean bigEndian;

    public SampleIn(Instrument instrument, String string) {
        this(instrument, string, false);
    }

    public SampleIn(Instrument instrument, String string, boolean bl) {
        this(instrument, string, bl, false);
    }

    public SampleIn(Instrument instrument, String string, boolean bl, boolean bl2) {
        this(instrument, string, bl, bl2, 0);
    }

    public SampleIn(Instrument instrument, String string, boolean bl, boolean bl2, int n) {
        this(instrument, string, bl, bl2, 0, 0, 0);
    }

    public SampleIn(Instrument instrument, String string, boolean bl, boolean bl2, int n, int n2, int n3) {
        super(instrument, 0, "[SampleIn]");
        try {
            this.file = new File(string);
            this.cache = bl;
            this.wholeFile = bl2;
            this.loop = n;
            this.loopStart = n2;
            this.loopEnd = n3;
            if (this.loop == -1) {
                this.loop = Integer.MAX_VALUE;
            }
            this.fileFormat = AudioSystem.getAudioFileFormat(this.file);
            this.format = this.fileFormat.getFormat();
            this.bigEndian = this.format.isBigEndian();
            this.channels = this.format.getChannels();
            this.sampleRate = (int)this.format.getSampleRate();
            this.duration = (long)this.fileFormat.getFrameLength() * (long)this.channels;
            this.sampleSize = this.format.getSampleSizeInBits() / 8;
            this.fileType = this.fileFormat.toString();
            this.is = AudioSystem.getAudioInputStream(this.file);
            if (this.cache) {
                byte[] byArray = new byte[(int)this.duration * this.sampleSize];
                this.is.read(byArray);
                this.is.close();
                this.is = new ByteArrayInputStream(byArray);
            }
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void finalize() {
        try {
            this.is.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void build() {
        if (!this.wholeFile) {
            this.duration = (long)(this.currentNote.getDuration() * (double)this.sampleRate * (double)this.channels);
        }
        this.loopCount = this.loop;
        this.reset(0);
    }

    public void reset(int n) {
        this.streamPosition = 0;
        try {
            if (this.cache) {
                this.is.reset();
            } else {
                this.is = AudioSystem.getAudioInputStream(this.file);
                if (n > 0) {
                    this.is.read(new byte[n * this.sampleSize * this.channels]);
                }
            }
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            System.out.println("jMusic SampleIn error: This file format is not supported.");
            System.exit(0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public int work(float[] fArray) throws AOException {
        this.finished = false;
        byte[] byArray = new byte[this.sampleSize * this.channels];
        byte[] byArray2 = new byte[this.sampleSize];
        for (int i = 0; i < fArray.length - this.channels; i += this.channels) {
            try {
                if (this.is.read(byArray) == -1) {
                    this.finished = true;
                    continue;
                }
                for (int j = 0; j < this.channels; ++j) {
                    for (int k = 0; k < this.sampleSize; ++k) {
                        byArray2[k] = byArray[k + j * this.sampleSize];
                    }
                    fArray[i + j] = this.getFloat(byArray2);
                    if (++this.streamPosition == this.loopStart && this.loop > 0) {
                        this.is.mark(this.loopStart);
                    } else if (this.streamPosition == this.loopEnd && this.loop > 0 && --this.loopCount >= 1) {
                        this.reset(this.loopStart);
                        this.streamPosition = this.loopStart;
                    }
                    if ((long)this.streamPosition < this.duration) continue;
                    this.finished = true;
                }
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return fArray.length;
    }

    public void setWholeFile(boolean bl) {
        this.wholeFile = bl;
    }

    public int getWaveSize() {
        return (int)(this.duration / (long)this.channels);
    }

    public int getNumOfBytes() {
        return (int)(this.duration * (long)this.sampleSize);
    }

    public int getBits() {
        return this.sampleSize;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public int getBitResolution() {
        int n = -1;
        switch (this.sampleSize) {
            case 1: {
                n = 8;
                break;
            }
            case 2: {
                n = 16;
                break;
            }
            case 3: {
                n = 24;
                break;
            }
            case 4: {
                n = 32;
            }
        }
        return n;
    }

    private float getFloat(byte[] byArray) {
        float f = 0.0f;
        int n = 0;
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < byArray.length) {
            n |= (byArray[n3] & 0xFF) << (this.bigEndian ? n2 : n3 + 1) * 8 - 8;
            ++n3;
            --n2;
        }
        switch (this.sampleSize) {
            case 1: {
                if (n > 127) {
                    n ^= 0xFFFFFFFF;
                    n &= 0x7F;
                    n = ~n + 1;
                }
                f = (float)n / 127.0f;
                break;
            }
            case 2: {
                if (n > Short.MAX_VALUE) {
                    n ^= 0xFFFFFFFF;
                    n &= Short.MAX_VALUE;
                    n = ~n + 1;
                }
                f = (float)n / 32767.0f;
                break;
            }
            case 3: {
                if (n > 0x7FFFFF) {
                    n ^= 0xFFFFFFFF;
                    n &= 0x7FFFFF;
                    n = ~n + 1;
                }
                f = (float)n / 8388608.0f;
                break;
            }
            case 4: {
                f = (float)((double)n / 2.147483647E9);
                break;
            }
            default: {
                System.err.println("Format not accepted");
            }
        }
        return f;
    }

    public void setLoopStart(int n) {
        this.loopStart = n;
    }

    public void setLoopEnd(int n) {
        this.loopEnd = n;
    }

    public void setLoop(int n) {
        this.loop = n;
    }
}

