/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.io;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;

public final class RTIn
extends AudioObject {
    public boolean finished = false;
    private int bufsize;
    private TargetDataLine dline;
    private boolean started = false;

    public RTIn(Instrument instrument, int n, int n2, int n3) {
        super(instrument, n, "[RTIn]");
        this.sampleRate = n;
        this.channels = n2;
        this.bufsize = n3;
        this.init();
    }

    @Override
    public int work(float[] fArray) throws AOException {
        int n;
        if (!this.started) {
            this.dline.start();
            this.started = true;
        }
        int n2 = 0;
        int n3 = fArray.length * 2;
        byte[] byArray = new byte[n3];
        this.dline.read(byArray, 0, n3);
        for (n = 0; n < fArray.length; ++n) {
            short s = (short)((byArray[n2++] << 8) + byArray[n2++]);
            fArray[n] = (float)s / 32767.0f;
        }
        return n;
    }

    public void init() {
        AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.sampleRate, 16, this.channels, this.channels * 2, this.sampleRate, true);
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
        System.out.println("Setting for audio line: " + info);
        if (!AudioSystem.isLineSupported(info)) {
            System.out.println(info);
            System.err.println("JMF Line not supported ... exiting .. sothere");
            System.exit(1);
        }
        try {
            this.dline = (TargetDataLine)AudioSystem.getLine(info);
            this.dline.open(audioFormat, this.bufsize * 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

