/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets.plaf;

import com.explodingpixels.widgets.ImageUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;

public class ArtworkUtils {
    private ArtworkUtils() {
    }

    public static ImageSet getImageSet(URL imageLocation) {
        Image image = new ImageIcon(imageLocation).getImage();
        ArtworkUtils.checkImageDivisibleByThree(image);
        int subImageWidth = image.getWidth(null) / 3;
        int imageHeight = image.getHeight(null);
        BufferedImage inactiveImage = ImageUtils.getSubImage(image, 0, 0, subImageWidth, imageHeight);
        BufferedImage activeImage = ImageUtils.getSubImage(image, subImageWidth, 0, subImageWidth, imageHeight);
        BufferedImage pressedImage = ImageUtils.getSubImage(image, subImageWidth * 2, 0, subImageWidth, imageHeight);
        return new ImageSet(inactiveImage, activeImage, pressedImage);
    }

    private static void checkImageDivisibleByThree(Image image) {
        if (image.getWidth(null) % 3 != 0) {
            throw new IllegalArgumentException("The given image should contain three sub-images all of the same size.");
        }
    }

    public static class ImageSet {
        private final ImageIcon fInactiveImage;
        private final ImageIcon fActiveImage;
        private final ImageIcon fPressedImage;

        private ImageSet(Image inactiveImage, Image activeImage, Image pressedImage) {
            this.fInactiveImage = new ImageIcon(inactiveImage);
            this.fActiveImage = new ImageIcon(activeImage);
            this.fPressedImage = new ImageIcon(pressedImage);
        }

        public ImageIcon getInactiveImage() {
            return this.fInactiveImage;
        }

        public ImageIcon getActiveImage() {
            return this.fActiveImage;
        }

        public ImageIcon getPressedImage() {
            return this.fPressedImage;
        }
    }
}

