/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.stunclient;

import junit.framework.TestCase;
import org.ice4j.StunException;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.message.MessageFactory;
import org.ice4j.message.Response;
import org.ice4j.stack.StunStack;
import org.ice4j.stunclient.NetworkConfigurationDiscoveryProcess;
import org.ice4j.stunclient.ResponseSequenceServer;
import org.ice4j.stunclient.StunDiscoveryReport;

public class StunAddressDiscovererTest
extends TestCase {
    private NetworkConfigurationDiscoveryProcess stunAddressDiscoverer = null;
    private TransportAddress discovererAddress = new TransportAddress("127.0.0.1", 15555, Transport.UDP);
    private ResponseSequenceServer responseServer = null;
    private TransportAddress responseServerAddress = new TransportAddress("127.0.0.1", 19999, Transport.UDP);
    private TransportAddress mappedClientAddress = new TransportAddress("212.56.4.10", 15612, Transport.UDP);
    private TransportAddress mappedClientAddressPort2 = new TransportAddress("212.56.4.10", 15611, Transport.UDP);

    public StunAddressDiscovererTest(String name) throws StunException {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        System.setProperty("org.ice4j.MAX_CTRAN_RETRANS_TIMER", "100");
        System.setProperty("org.ice4j.MAX_RETRANSMISSIONS", "2");
        StunStack stunStack = new StunStack();
        this.responseServer = new ResponseSequenceServer(stunStack, this.responseServerAddress);
        this.stunAddressDiscoverer = new NetworkConfigurationDiscoveryProcess(stunStack, this.discovererAddress, this.responseServerAddress);
        this.stunAddressDiscoverer.start();
        this.responseServer.start();
    }

    protected void tearDown() throws Exception {
        System.clearProperty("org.ice4j.MAX_CTRAN_RETRANS_TIMER");
        System.clearProperty("org.ice4j.MAX_RETRANSMISSIONS");
        this.responseServer.shutDown();
        this.stunAddressDiscoverer.shutDown();
        this.stunAddressDiscoverer = null;
        super.tearDown();
    }

    public void testRecognizeBlockedUDP() throws Exception {
        StunDiscoveryReport expectedReturn = new StunDiscoveryReport();
        expectedReturn.setNatType("UDP Blocking Firewall");
        expectedReturn.setPublicAddress(null);
        StunDiscoveryReport actualReturn = this.stunAddressDiscoverer.determineAddress();
        StunAddressDiscovererTest.assertEquals((String)"The StunAddressDiscoverer failed for a no-udp environment.", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testRecognizeSymmetricNat() throws Exception {
        Response testIResponse1 = MessageFactory.create3489BindingResponse(this.mappedClientAddress, this.responseServerAddress, this.responseServerAddress);
        Response testIResponse2 = null;
        Response testIResponse3 = MessageFactory.create3489BindingResponse(this.mappedClientAddressPort2, this.responseServerAddress, this.responseServerAddress);
        this.responseServer.addMessage(testIResponse1);
        this.responseServer.addMessage(testIResponse2);
        this.responseServer.addMessage(testIResponse3);
        StunDiscoveryReport expectedReturn = new StunDiscoveryReport();
        expectedReturn.setNatType("Symmetric NAT");
        expectedReturn.setPublicAddress(this.mappedClientAddress);
        StunDiscoveryReport actualReturn = this.stunAddressDiscoverer.determineAddress();
        StunAddressDiscovererTest.assertEquals((String)"The StunAddressDiscoverer failed for a no-udp environment.", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testRecognizePortRestrictedCone() throws Exception {
        Response testIResponse1 = MessageFactory.create3489BindingResponse(this.mappedClientAddress, this.responseServerAddress, this.responseServerAddress);
        Response testIResponse2 = null;
        Response testIResponse3 = MessageFactory.create3489BindingResponse(this.mappedClientAddress, this.responseServerAddress, this.responseServerAddress);
        Response testIResponse4 = null;
        this.responseServer.addMessage(testIResponse1);
        this.responseServer.addMessage(testIResponse2);
        this.responseServer.addMessage(testIResponse3);
        this.responseServer.addMessage(testIResponse4);
        StunDiscoveryReport expectedReturn = new StunDiscoveryReport();
        expectedReturn.setNatType("Port Restricted Cone NAT");
        expectedReturn.setPublicAddress(this.mappedClientAddress);
        StunDiscoveryReport actualReturn = this.stunAddressDiscoverer.determineAddress();
        StunAddressDiscovererTest.assertEquals((String)"The StunAddressDiscoverer failed for a no-udp environment.", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testRecognizeRestrictedCone() throws Exception {
        Response testIResponse1 = MessageFactory.create3489BindingResponse(this.mappedClientAddress, this.responseServerAddress, this.responseServerAddress);
        Response testIResponse2 = null;
        Response testIResponse3 = MessageFactory.create3489BindingResponse(this.mappedClientAddress, this.responseServerAddress, this.responseServerAddress);
        Response testIResponse4 = MessageFactory.create3489BindingResponse(this.mappedClientAddress, this.responseServerAddress, this.responseServerAddress);
        this.responseServer.addMessage(testIResponse1);
        this.responseServer.addMessage(testIResponse2);
        this.responseServer.addMessage(testIResponse3);
        this.responseServer.addMessage(testIResponse4);
        StunDiscoveryReport expectedReturn = new StunDiscoveryReport();
        expectedReturn.setNatType("Restricted Cone NAT");
        expectedReturn.setPublicAddress(this.mappedClientAddress);
        StunDiscoveryReport actualReturn = this.stunAddressDiscoverer.determineAddress();
        StunAddressDiscovererTest.assertEquals((String)"The StunAddressDiscoverer failed for a no-udp environment.", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testRecognizeFullCone() throws Exception {
        Response testIResponse1 = MessageFactory.create3489BindingResponse(this.mappedClientAddress, this.responseServerAddress, this.responseServerAddress);
        Response testIResponse2 = MessageFactory.create3489BindingResponse(this.mappedClientAddress, this.responseServerAddress, this.responseServerAddress);
        this.responseServer.addMessage(testIResponse1);
        this.responseServer.addMessage(testIResponse2);
        StunDiscoveryReport expectedReturn = new StunDiscoveryReport();
        expectedReturn.setNatType("Full Cone NAT");
        expectedReturn.setPublicAddress(this.mappedClientAddress);
        StunDiscoveryReport actualReturn = this.stunAddressDiscoverer.determineAddress();
        StunAddressDiscovererTest.assertEquals((String)"The StunAddressDiscoverer failed for a no-udp environment.", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testRecognizeUdpSymmetricFirewall() throws Exception {
        Response testIResponse1 = MessageFactory.create3489BindingResponse(this.discovererAddress, this.responseServerAddress, this.responseServerAddress);
        Response testIResponse2 = null;
        this.responseServer.addMessage(testIResponse1);
        this.responseServer.addMessage(testIResponse2);
        StunDiscoveryReport expectedReturn = new StunDiscoveryReport();
        expectedReturn.setNatType("Symmetric UDP Firewall");
        expectedReturn.setPublicAddress(this.discovererAddress);
        StunDiscoveryReport actualReturn = this.stunAddressDiscoverer.determineAddress();
        StunAddressDiscovererTest.assertEquals((String)"The StunAddressDiscoverer failed for a no-udp environment.", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testRecognizeOpenInternet() throws Exception {
        Response testIResponse1 = MessageFactory.create3489BindingResponse(this.discovererAddress, this.responseServerAddress, this.responseServerAddress);
        Response testIResponse2 = MessageFactory.create3489BindingResponse(this.discovererAddress, this.responseServerAddress, this.responseServerAddress);
        this.responseServer.addMessage(testIResponse1);
        this.responseServer.addMessage(testIResponse2);
        StunDiscoveryReport expectedReturn = new StunDiscoveryReport();
        expectedReturn.setNatType("Open Internet Configuration");
        expectedReturn.setPublicAddress(this.discovererAddress);
        StunDiscoveryReport actualReturn = this.stunAddressDiscoverer.determineAddress();
        StunAddressDiscovererTest.assertEquals((String)"The StunAddressDiscoverer failed for a no-udp environment.", (Object)expectedReturn, (Object)actualReturn);
    }
}

