/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.socket.DatagramPacketFilter;
import org.ice4j.socket.MultiplexedDatagramSocket;
import org.ice4j.socket.SafeCloseDatagramSocket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplexingDatagramSocket
extends SafeCloseDatagramSocket {
    private static final Logger logger = Logger.getLogger(MultiplexingDatagramSocket.class.getName());
    private static final MultiplexedDatagramSocket[] NO_SOCKETS = new MultiplexedDatagramSocket[0];
    private boolean inReceive = false;
    private final List<DatagramPacket> received = new LinkedList<DatagramPacket>();
    private final Object receiveSyncRoot = new Object();
    private MultiplexedDatagramSocket[] sockets = NO_SOCKETS;
    private final Object socketsSyncRoot = new Object();

    public MultiplexingDatagramSocket() throws SocketException {
    }

    public MultiplexingDatagramSocket(DatagramSocket delegate) throws SocketException {
        super(delegate);
    }

    public MultiplexingDatagramSocket(int port) throws SocketException {
        super(port);
    }

    public MultiplexingDatagramSocket(int port, InetAddress laddr) throws SocketException {
        super(port, laddr);
    }

    public MultiplexingDatagramSocket(SocketAddress bindaddr) throws SocketException {
        super(bindaddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatagramPacket clone(DatagramPacket p) {
        DatagramPacket datagramPacket = p;
        synchronized (datagramPacket) {
            byte[] pData = p.getData();
            byte[] cData = pData == null ? null : (byte[])pData.clone();
            return new DatagramPacket(cData, p.getOffset(), p.getLength(), p.getAddress(), p.getPort());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(MultiplexedDatagramSocket multiplexed) {
        Object object = this.socketsSyncRoot;
        synchronized (object) {
            int socketCount = this.sockets.length;
            for (int i = 0; i < socketCount; ++i) {
                if (!this.sockets[i].equals(multiplexed)) continue;
                if (socketCount == 1) {
                    this.sockets = NO_SOCKETS;
                    break;
                }
                MultiplexedDatagramSocket[] newSockets = new MultiplexedDatagramSocket[socketCount - 1];
                System.arraycopy(this.sockets, 0, newSockets, 0, i);
                System.arraycopy(this.sockets, i + 1, newSockets, i, newSockets.length - i);
                this.sockets = newSockets;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(DatagramPacket src, DatagramPacket dest) {
        DatagramPacket datagramPacket = dest;
        synchronized (datagramPacket) {
            dest.setAddress(src.getAddress());
            dest.setPort(src.getPort());
            byte[] srcData = src.getData();
            if (srcData == null) {
                dest.setLength(0);
            } else {
                byte[] destData = dest.getData();
                if (destData == null) {
                    dest.setLength(0);
                } else {
                    int srcLength;
                    int destOffset = dest.getOffset();
                    int destLength = destData.length - destOffset;
                    if (destLength >= (srcLength = src.getLength())) {
                        destLength = srcLength;
                    } else if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "Truncating received DatagramPacket data!");
                    }
                    System.arraycopy(srcData, src.getOffset(), destData, destOffset, destLength);
                    dest.setLength(destLength);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiplexedDatagramSocket getSocket(DatagramPacketFilter filter) throws SocketException {
        if (filter == null) {
            throw new NullPointerException("filter");
        }
        Object object = this.socketsSyncRoot;
        synchronized (object) {
            for (MultiplexedDatagramSocket socket : this.sockets) {
                if (!filter.equals(socket.getFilter())) continue;
                return socket;
            }
            MultiplexedDatagramSocket socket = new MultiplexedDatagramSocket(this, filter);
            int socketCount = this.sockets.length;
            if (socketCount == 0) {
                this.sockets = new MultiplexedDatagramSocket[]{socket};
            } else {
                MultiplexedDatagramSocket[] newSockets = new MultiplexedDatagramSocket[socketCount + 1];
                System.arraycopy(this.sockets, 0, newSockets, 0, socketCount);
                newSockets[socketCount] = socket;
                this.sockets = newSockets;
            }
            return socket;
        }
    }

    @Override
    public void receive(DatagramPacket p) throws IOException {
        this.receive(this.received, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receive(List<DatagramPacket> received, DatagramPacket p) throws IOException {
        DatagramPacket r = null;
        do {
            boolean doReceive;
            Object object = this.receiveSyncRoot;
            synchronized (object) {
                block26: {
                    if (received.isEmpty()) {
                        if (this.inReceive) {
                            doReceive = false;
                            try {
                                this.receiveSyncRoot.wait();
                                break block26;
                            }
                            catch (InterruptedException iex) {
                                continue;
                            }
                        }
                        doReceive = true;
                        this.inReceive = true;
                    } else {
                        doReceive = false;
                        r = received.remove(0);
                    }
                }
            }
            if (!doReceive) continue;
            try {
                super.receive(p);
                object = this.receiveSyncRoot;
                synchronized (object) {
                    Object object2 = this.socketsSyncRoot;
                    synchronized (object2) {
                        boolean accepted = false;
                        for (MultiplexedDatagramSocket socket : this.sockets) {
                            if (!socket.getFilter().accept(p)) continue;
                            socket.received.add(MultiplexingDatagramSocket.clone(p));
                            accepted = true;
                        }
                        if (!accepted) {
                            this.received.add(MultiplexingDatagramSocket.clone(p));
                        }
                    }
                }
            }
            finally {
                object = this.receiveSyncRoot;
                synchronized (object) {
                    this.inReceive = false;
                    this.receiveSyncRoot.notify();
                }
            }
        } while (r == null);
        MultiplexingDatagramSocket.copy(r, p);
    }

    void receive(MultiplexedDatagramSocket multiplexed, DatagramPacket p) throws IOException {
        this.receive(multiplexed.received, p);
    }
}

