/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.pseudotcp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.pseudotcp.PseudoTCPBase;
import org.ice4j.pseudotcp.PseudoTcpTestBase;
import org.junit.Assert;

public class PseudoTcpTestTransfer
extends PseudoTcpTestBase {
    private static final Logger logger = Logger.getLogger(PseudoTCPBase.class.getName());
    private byte[] sendData;
    private int sendStreamSize;
    private int totalSent;
    private ByteArrayOutputStream recvStream;

    public void doTestTransfer(int size) {
        Thread.setDefaultUncaughtExceptionHandler(this);
        this.sendData = PseudoTcpTestTransfer.createDummyData(size);
        this.sendStreamSize = size;
        this.recvStream = new ByteArrayOutputStream(size);
        long start = PseudoTCPBase.now();
        this.startClocks();
        try {
            this.connect();
        }
        catch (IOException ex) {
            PseudoTcpTestTransfer.fail((String)ex.getMessage());
        }
        this.assert_Connected_wait(5000);
        long transferTout = this.maxTransferTime(this.sendData.length, 1000L);
        boolean transfferInTime = this.assert_Disconnected_wait(transferTout);
        long elapsed = PseudoTCPBase.now() - start;
        this.stopClocks();
        int received = this.recvStream.size();
        PseudoTcpTestTransfer.assertEquals((String)("Transfer timeout, transferred: " + received + " required: " + this.sendData.length + " elapsed: " + elapsed + " limit: " + transferTout), (boolean)true, (boolean)transfferInTime);
        PseudoTcpTestTransfer.assertEquals((int)size, (int)received);
        byte[] recvdArray = this.recvStream.toByteArray();
        Assert.assertArrayEquals((byte[])this.sendData, (byte[])recvdArray);
        logger.log(Level.INFO, "Transferred " + received + " bytes in " + elapsed + " ms (" + (long)(size * 8) / elapsed + " Kbps");
    }

    void readData() throws IOException {
        int rcvd;
        byte[] block = new byte[4096];
        do {
            rcvd = this.remoteRecv(block, block.length);
            this.updateRemoteClock();
            if (rcvd == -1) continue;
            this.recvStream.write(block, 0, rcvd);
        } while (rcvd > 0);
    }

    boolean writeData() throws IOException {
        int tosend;
        int sent;
        byte[] block = new byte[4096];
        do {
            tosend = Math.min(this.sendStreamSize - this.totalSent, block.length);
            System.arraycopy(this.sendData, this.totalSent, block, 0, tosend);
            if (tosend > 0) {
                sent = this.localSend(block, tosend);
                this.updateLocalClock();
                if (sent != -1) {
                    this.totalSent += sent;
                    continue;
                }
                logger.log(Level.FINE, "Flow Controlled");
                continue;
            }
            tosend = 0;
            sent = 0;
        } while (sent > 0);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Sent: " + this.totalSent + " remaining: " + (this.sendStreamSize - this.totalSent));
        }
        return tosend == 0;
    }

    public void onTcpReadable(PseudoTCPBase tcp) {
        if (tcp == this.getRemoteTcp()) {
            try {
                this.readData();
                int received = this.recvStream.size();
                int required = this.sendStreamSize;
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Receivied: " + received + " required: " + required);
                }
                if (received == required) {
                    this.onTcpClosed(this.getRemoteTcp(), null);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void onTcpWriteable(PseudoTCPBase tcp) {
        if (tcp == this.getLocalTcp()) {
            logger.log(Level.FINER, "Flow Control Lifted");
            try {
                if (this.writeData()) {
                    this.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                PseudoTcpTestTransfer.fail((String)ex.getMessage());
            }
        }
    }

    public void testSend() {
        PseudoTcpTestTransfer test = new PseudoTcpTestTransfer();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.doTestTransfer(1000000);
    }

    public void testSendWithDelay() {
        PseudoTcpTestTransfer test = new PseudoTcpTestTransfer();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.setDelay(50);
        test.doTestTransfer(1000000);
    }

    public void testSendWithLoss() {
        PseudoTcpTestTransfer test = new PseudoTcpTestTransfer();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.setLoss(10);
        test.doTestTransfer(100000);
    }

    public void testSendWithDelayAndLoss() {
        PseudoTcpTestTransfer test = new PseudoTcpTestTransfer();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.setDelay(50);
        test.setLoss(10);
        test.doTestTransfer(100000);
    }

    public void testSendWithLossAndOptNaglingOff() {
        PseudoTcpTestTransfer test = new PseudoTcpTestTransfer();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.setLoss(10);
        test.setOptNagling(false);
        test.doTestTransfer(100000);
    }

    public void testSendWithLossAndOptAckDelayOff() {
        PseudoTcpTestTransfer test = new PseudoTcpTestTransfer();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.setLoss(10);
        test.setOptAckDelay(0);
        test.doTestTransfer(100000);
    }

    public void testSendWithDelayAndOptNaglingOff() {
        PseudoTcpTestTransfer test = new PseudoTcpTestTransfer();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.setDelay(50);
        test.setOptNagling(false);
        test.doTestTransfer(100000);
    }

    public void testSendWithDelayAndOptAckDelayOff() {
        PseudoTcpTestTransfer test = new PseudoTcpTestTransfer();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.setDelay(50);
        test.setOptAckDelay(0);
        test.doTestTransfer(100000);
    }

    public void testSendRemoteNoWindowScale() {
        PseudoTcpTestTransfer test = new PseudoTcpTestTransfer();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.setLocalOptRcvBuf(100000);
        test.disableRemoteWindowScale();
        test.doTestTransfer(1000000);
    }

    public void testSendLocalNoWindowScale() {
        PseudoTcpTestTransfer test = new PseudoTcpTestTransfer();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.setRemoteOptRcvBuf(100000);
        test.disableLocalWindowScale();
        test.doTestTransfer(1000000);
    }

    public void testSendBothUseWindowScale() {
        PseudoTcpTestTransfer test = new PseudoTcpTestTransfer();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.setRemoteOptRcvBuf(100000);
        test.setLocalOptRcvBuf(100000);
        test.doTestTransfer(1000000);
    }

    public void testSendLargeInFlight() {
        PseudoTcpTestTransfer test = new PseudoTcpTestTransfer();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.setRemoteOptRcvBuf(100000);
        test.setLocalOptRcvBuf(100000);
        test.setOptSndBuf(150000);
        test.doTestTransfer(1000000);
    }

    public void testSendBothUseLargeWindowScale() {
        PseudoTcpTestTransfer test = new PseudoTcpTestTransfer();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.setRemoteOptRcvBuf(1000000);
        test.setLocalOptRcvBuf(1000000);
        test.doTestTransfer(10000000);
    }

    public void testSendSmallReceiveBuffer() {
        PseudoTcpTestTransfer test = new PseudoTcpTestTransfer();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.setRemoteOptRcvBuf(10000);
        test.setLocalOptRcvBuf(10000);
        test.doTestTransfer(1000000);
    }

    public void testSendVerySmallReceiveBuffer() {
        PseudoTcpTestTransfer test = new PseudoTcpTestTransfer();
        test.setLocalMtu(1500);
        test.setRemoteMtu(1500);
        test.setRemoteOptRcvBuf(100);
        test.setLocalOptRcvBuf(100);
        test.doTestTransfer(100000);
    }
}

