/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import java.util.Arrays;
import junit.framework.TestCase;
import org.ice4j.MsgFixture;
import org.ice4j.StunException;
import org.ice4j.attribute.ChangeRequestAttribute;

public class ChangeRequestAttributeTest
extends TestCase {
    private ChangeRequestAttribute changeRequestAttribute = null;
    private MsgFixture binMessagesFixture;

    public ChangeRequestAttributeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.changeRequestAttribute = new ChangeRequestAttribute();
        this.binMessagesFixture = new MsgFixture();
        this.binMessagesFixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.changeRequestAttribute = null;
        this.binMessagesFixture.tearDown();
        this.binMessagesFixture = null;
        super.tearDown();
    }

    public void testChangeRequestAttribute() {
        this.changeRequestAttribute = new ChangeRequestAttribute();
        ChangeRequestAttributeTest.assertEquals((String)"ChangeRequestAttribute did not construct an attribute with the correct type.", (char)this.changeRequestAttribute.getAttributeType(), (char)'\u0003');
    }

    public void testDecodeAttributeBody() throws StunException {
        byte[] attributeValue = this.binMessagesFixture.chngReqTestValue1;
        char offset = '\u0004';
        char length = (char)(attributeValue.length - offset);
        this.changeRequestAttribute.decodeAttributeBody(attributeValue, offset, length);
        ChangeRequestAttributeTest.assertEquals((String)"decodeAttributeBody() did not properly decode the changeIpFlag", (boolean)false, (boolean)this.changeRequestAttribute.getChangeIpFlag());
        ChangeRequestAttributeTest.assertEquals((String)"decodeAttributeBody() did not properly decode the changePortFlag", (boolean)false, (boolean)this.changeRequestAttribute.getChangePortFlag());
        attributeValue = this.binMessagesFixture.chngReqTestValue2;
        this.changeRequestAttribute.decodeAttributeBody(attributeValue, offset, length);
        ChangeRequestAttributeTest.assertEquals((String)"decodeAttributeBody() did not properly decode the changeIpFlag", (boolean)true, (boolean)this.changeRequestAttribute.getChangeIpFlag());
        ChangeRequestAttributeTest.assertEquals((String)"decodeAttributeBody() did not properly decode the changePortFlag", (boolean)true, (boolean)this.changeRequestAttribute.getChangePortFlag());
        this.changeRequestAttribute.getChangePortFlag();
    }

    public void testEncode() {
        byte[] expectedReturn = this.binMessagesFixture.chngReqTestValue1;
        this.changeRequestAttribute = new ChangeRequestAttribute();
        this.changeRequestAttribute.setChangeIpFlag(false);
        this.changeRequestAttribute.setChangePortFlag(false);
        byte[] actualReturn = this.changeRequestAttribute.encode();
        ChangeRequestAttributeTest.assertTrue((String)"Object did not encode properly.", (boolean)Arrays.equals(expectedReturn, actualReturn));
        expectedReturn = this.binMessagesFixture.chngReqTestValue2;
        this.changeRequestAttribute = new ChangeRequestAttribute();
        this.changeRequestAttribute.setChangeIpFlag(true);
        this.changeRequestAttribute.setChangePortFlag(true);
        actualReturn = this.changeRequestAttribute.encode();
        ChangeRequestAttributeTest.assertTrue((String)"Object did not encode properly.", (boolean)Arrays.equals(expectedReturn, actualReturn));
    }

    public void testEquals() {
        ChangeRequestAttribute target = null;
        boolean expectedReturn = false;
        boolean actualReturn = this.changeRequestAttribute.equals(target);
        ChangeRequestAttributeTest.assertEquals((String)"Null value test failed", (boolean)expectedReturn, (boolean)actualReturn);
        target = new ChangeRequestAttribute();
        this.changeRequestAttribute.setChangeIpFlag(true);
        this.changeRequestAttribute.setChangePortFlag(false);
        target.setChangeIpFlag(false);
        target.setChangePortFlag(true);
        actualReturn = this.changeRequestAttribute.equals(target);
        ChangeRequestAttributeTest.assertEquals((String)"Test against a different value failed", (boolean)expectedReturn, (boolean)actualReturn);
        target = new ChangeRequestAttribute();
        this.changeRequestAttribute.setChangeIpFlag(true);
        this.changeRequestAttribute.setChangePortFlag(false);
        target.setChangeIpFlag(true);
        target.setChangePortFlag(false);
        expectedReturn = true;
        actualReturn = this.changeRequestAttribute.equals(target);
        ChangeRequestAttributeTest.assertEquals((String)"Test against an equals value failed", (boolean)expectedReturn, (boolean)actualReturn);
    }

    public void testGetDataLength() {
        char expectedReturn = '\u0004';
        char actualReturn = this.changeRequestAttribute.getDataLength();
        ChangeRequestAttributeTest.assertEquals((String)"data length returned an invalid value", (char)expectedReturn, (char)actualReturn);
    }

    public void testGetName() {
        String expectedReturn = "CHANGE-REQUEST";
        String actualReturn = this.changeRequestAttribute.getName();
        ChangeRequestAttributeTest.assertEquals((String)"Invalid name", (String)expectedReturn, (String)actualReturn);
    }
}

