/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.zrtp;

import gnu.java.bigintcrypto.BigIntegerCrypto;
import gnu.java.zrtp.ZrtpCallback;
import gnu.java.zrtp.ZrtpCodes;
import gnu.java.zrtp.ZrtpConfigure;
import gnu.java.zrtp.ZrtpConstants;
import gnu.java.zrtp.ZrtpSrtpSecrets;
import gnu.java.zrtp.ZrtpStateClass;
import gnu.java.zrtp.packets.ZrtpPacketBase;
import gnu.java.zrtp.packets.ZrtpPacketCommit;
import gnu.java.zrtp.packets.ZrtpPacketConf2Ack;
import gnu.java.zrtp.packets.ZrtpPacketConfirm;
import gnu.java.zrtp.packets.ZrtpPacketDHPart;
import gnu.java.zrtp.packets.ZrtpPacketError;
import gnu.java.zrtp.packets.ZrtpPacketErrorAck;
import gnu.java.zrtp.packets.ZrtpPacketHello;
import gnu.java.zrtp.packets.ZrtpPacketHelloAck;
import gnu.java.zrtp.packets.ZrtpPacketPing;
import gnu.java.zrtp.packets.ZrtpPacketPingAck;
import gnu.java.zrtp.packets.ZrtpPacketRelayAck;
import gnu.java.zrtp.packets.ZrtpPacketSASRelay;
import gnu.java.zrtp.utils.Base32;
import gnu.java.zrtp.utils.ZrtpFortuna;
import gnu.java.zrtp.utils.ZrtpUtils;
import gnu.java.zrtp.zidfile.ZidFile;
import gnu.java.zrtp.zidfile.ZidRecord;
import java.util.Arrays;
import java.util.EnumSet;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.cryptozrtp.AsymmetricCipherKeyPair;
import org.bouncycastle.cryptozrtp.params.DHPublicKeyParameters;
import org.bouncycastle.cryptozrtp.params.ECPublicKeyParameters;
import org.bouncycastle.mathzrtp.ec.ECPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZRtp {
    static final int MAX_ZRTP_VERSIONS = 2;
    static final int SUPPORTED_ZRTP_VERSIONS = 1;
    private final ZrtpStateClass stateEngine;
    private final byte[] zid = new byte[12];
    private byte[] peerZid;
    private ZrtpCallback callback = null;
    private AsymmetricCipherKeyPair dhKeyPair = null;
    private AsymmetricCipherKeyPair ecKeyPair = null;
    private ZrtpFortuna secRand;
    private byte[] DHss = null;
    private byte[] pubKeyBytes = null;
    private ZrtpCallback.Role myRole;
    private String SAS;
    private byte[] sasHash = null;
    private byte[] rs1IDr = null;
    private byte[] rs2IDr = null;
    private byte[] auxSecretIDr = null;
    private byte[] pbxSecretIDr = null;
    private byte[] rs1IDi = null;
    private byte[] rs2IDi = null;
    private byte[] auxSecretIDi = null;
    private byte[] pbxSecretIDi = null;
    private boolean rs1Valid = false;
    private boolean rs2Valid = false;
    private byte[] hvi = new byte[64];
    private byte[] peerHvi = null;
    private int hashLength;
    private Digest hashFunction;
    private Digest hashCtxFunction;
    private HMac hmacFunction;
    private int hashLengthImpl = 32;
    private Digest hashFunctionImpl = new SHA256Digest();
    private HMac hmacFunctionImpl = new HMac((Digest)new SHA256Digest());
    private ZrtpConstants.SupportedHashes hash;
    private ZrtpConstants.SupportedSymCiphers cipher;
    private ZrtpConstants.SupportedPubKeys pubKey;
    private ZrtpConstants.SupportedSASTypes sasType;
    private ZrtpConstants.SupportedAuthLengths authLength;
    private byte[] H0 = new byte[64];
    private byte[] H1 = new byte[64];
    private byte[] H2 = new byte[64];
    private byte[] H3 = new byte[64];
    private byte[] peerHelloHash = new byte[64];
    private byte[] peerHelloVersion = null;
    private byte[] peerH2 = new byte[64];
    private byte[] peerH3 = new byte[64];
    private byte[] messageHash = new byte[64];
    private byte[] s0 = new byte[64];
    private byte[] newRs1 = null;
    private byte[] hmacKeyI = null;
    private byte[] hmacKeyR = null;
    private byte[] srtpKeyI = null;
    private byte[] srtpSaltI = null;
    private byte[] srtpKeyR = null;
    private byte[] srtpSaltR = null;
    private byte[] zrtpKeyI = null;
    private byte[] zrtpKeyR = null;
    private byte[] zrtpSession = null;
    private boolean multiStream = false;
    private boolean multiStreamAvailable = false;
    private boolean enableMitmEnrollment = false;
    private boolean peerIsEnrolled;
    private boolean mitmSeen = false;
    private boolean signSasSeen = false;
    private byte[] pbxSecretTmp = null;
    private boolean enrollmentMode = false;
    private ZrtpPacketHello zrtpHello_11 = new ZrtpPacketHello();
    private ZrtpPacketHello zrtpHello_12 = new ZrtpPacketHello();
    private ZrtpPacketHelloAck zrtpHelloAck = new ZrtpPacketHelloAck();
    private ZrtpPacketConf2Ack zrtpConf2Ack = new ZrtpPacketConf2Ack();
    private ZrtpPacketError zrtpError = new ZrtpPacketError();
    private ZrtpPacketErrorAck zrtpErrorAck = new ZrtpPacketErrorAck();
    private ZrtpPacketDHPart zrtpDH1 = new ZrtpPacketDHPart();
    private ZrtpPacketDHPart zrtpDH2 = new ZrtpPacketDHPart();
    private ZrtpPacketCommit zrtpCommit = new ZrtpPacketCommit();
    private ZrtpPacketConfirm zrtpConfirm1 = new ZrtpPacketConfirm();
    private ZrtpPacketConfirm zrtpConfirm2 = new ZrtpPacketConfirm();
    private ZrtpPacketPingAck zrtpPingAck = new ZrtpPacketPingAck();
    private ZrtpPacketSASRelay zrtpSasRelay = new ZrtpPacketSASRelay();
    private ZrtpPacketRelayAck zrtpRelayAck = new ZrtpPacketRelayAck();
    HelloPacketVersion[] helloPackets = new HelloPacketVersion[2];
    int highestZrtpVersion;
    ZrtpPacketHello currentHelloPacket;
    private byte[] randomIV = new byte[16];
    private byte[] tempMsgBuffer = new byte[1024];
    private int lengthOfMsgData;
    private byte[] signatureData = null;
    private int signatureLength = 0;
    private int peerSSRC = 0;
    private boolean paranoidMode = false;
    private ZrtpConfigure configureAlgos;

    public ZRtp(byte[] myZid, ZrtpCallback cb, String id, ZrtpConfigure config) {
        this(myZid, cb, id, config, false, false);
    }

    public ZRtp(byte[] myZid, ZrtpCallback cb, String id, ZrtpConfigure config, boolean mitmMode) {
        this(myZid, cb, id, config, mitmMode, false);
    }

    public ZRtp(byte[] myZid, ZrtpCallback cb, String id, ZrtpConfigure config, boolean mitmMode, boolean sasSignSupport) {
        this.secRand = ZrtpFortuna.getInstance();
        this.configureAlgos = config;
        this.enableMitmEnrollment = config.isTrustedMitM();
        this.paranoidMode = config.isParanoidMode();
        System.arraycopy(myZid, 0, this.zid, 0, 12);
        this.callback = cb;
        this.secRand.nextBytes(this.randomIV);
        this.secRand.nextBytes(this.H0);
        this.hashFunctionImpl.update(this.H0, 0, 32);
        this.hashFunctionImpl.doFinal(this.H1, 0);
        this.hashFunctionImpl.update(this.H1, 0, 32);
        this.hashFunctionImpl.doFinal(this.H2, 0);
        this.hashFunctionImpl.update(this.H2, 0, 32);
        this.hashFunctionImpl.doFinal(this.H3, 0);
        this.zrtpHello_11.configureHello(config);
        this.zrtpHello_11.setH3(this.H3);
        this.zrtpHello_11.setZid(this.zid);
        this.zrtpHello_11.setVersion(ZrtpConstants.zrtpVersion_11);
        this.zrtpHello_12.configureHello(config);
        this.zrtpHello_12.setH3(this.H3);
        this.zrtpHello_12.setZid(this.zid);
        this.zrtpHello_12.setVersion(ZrtpConstants.zrtpVersion_12);
        if (mitmMode) {
            this.zrtpHello_11.setMitmMode();
            this.zrtpHello_12.setMitmMode();
        }
        if (sasSignSupport) {
            this.zrtpHello_11.setSasSign();
            this.zrtpHello_12.setSasSign();
        }
        this.helloPackets[0] = new HelloPacketVersion();
        this.helloPackets[0].helloHash = new byte[64];
        this.helloPackets[0].packet = this.zrtpHello_11;
        this.helloPackets[0].version = this.zrtpHello_11.getVersionInt();
        this.setClientId(id, this.helloPackets[0]);
        this.helloPackets[1] = new HelloPacketVersion();
        this.helloPackets[1].helloHash = new byte[64];
        this.helloPackets[1].packet = this.zrtpHello_12;
        this.helloPackets[1].version = this.zrtpHello_12.getVersionInt();
        this.setClientId(id, this.helloPackets[1]);
        this.currentHelloPacket = this.helloPackets[0].packet;
        this.stateEngine = new ZrtpStateClass(this);
    }

    public void startZrtpEngine() {
        if (this.stateEngine != null && this.stateEngine.isInState(ZrtpStateClass.ZrtpStates.Initial)) {
            ZrtpStateClass zrtpStateClass = this.stateEngine;
            zrtpStateClass.getClass();
            ZrtpStateClass.Event ev = new ZrtpStateClass.Event(zrtpStateClass, ZrtpStateClass.EventDataType.ZrtpInitial, null);
            this.stateEngine.processEvent(ev);
        }
    }

    public void stopZrtp() {
        if (this.stateEngine != null) {
            ZrtpStateClass zrtpStateClass = this.stateEngine;
            zrtpStateClass.getClass();
            ZrtpStateClass.Event ev = new ZrtpStateClass.Event(zrtpStateClass, ZrtpStateClass.EventDataType.ZrtpClose, null);
            this.stateEngine.processEvent(ev);
        }
    }

    public void processZrtpMessage(byte[] extHeader, int ssrc) {
        this.peerSSRC = ssrc;
        if (this.stateEngine != null) {
            ZrtpStateClass zrtpStateClass = this.stateEngine;
            zrtpStateClass.getClass();
            ZrtpStateClass.Event ev = new ZrtpStateClass.Event(zrtpStateClass, ZrtpStateClass.EventDataType.ZrtpPacket, extHeader);
            this.stateEngine.processEvent(ev);
        }
    }

    public void processTimeout() {
        if (this.stateEngine != null) {
            ZrtpStateClass zrtpStateClass = this.stateEngine;
            zrtpStateClass.getClass();
            ZrtpStateClass.Event ev = new ZrtpStateClass.Event(zrtpStateClass, ZrtpStateClass.EventDataType.Timer, null);
            this.stateEngine.processEvent(ev);
        }
    }

    public void setAuxSecret(byte[] data) {
    }

    public boolean isEnrollmentMode() {
        return this.enrollmentMode;
    }

    public void setEnrollmentMode(boolean enrollmentMode) {
        this.enrollmentMode = enrollmentMode;
    }

    public boolean isPeerEnrolled() {
        return this.peerIsEnrolled;
    }

    public boolean sendSASRelayPacket(byte[] sh, ZrtpConstants.SupportedSASTypes render) {
        byte[] ekey;
        byte[] hkey;
        if (this.myRole == ZrtpCallback.Role.Responder) {
            hkey = this.hmacKeyR;
            ekey = this.zrtpKeyR;
        } else {
            hkey = this.hmacKeyI;
            ekey = this.zrtpKeyI;
        }
        this.secRand.nextBytes(this.randomIV);
        this.zrtpSasRelay.setIv(this.randomIV);
        this.zrtpSasRelay.setTrustedSas(sh);
        this.zrtpSasRelay.setSasType(render.name);
        byte[] dataToSecure = this.zrtpSasRelay.getDataToSecure();
        try {
            this.cipher.cipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(ekey, 0, this.cipher.keyLength), this.randomIV));
            int done = this.cipher.cipher.processBytes(dataToSecure, 0, dataToSecure.length, dataToSecure, 0);
            this.cipher.cipher.doFinal(dataToSecure, done);
        }
        catch (Exception e) {
            this.sendInfo(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereSecurityException));
            return false;
        }
        byte[] confMac = this.computeHmac(hkey, this.hashLength, dataToSecure, dataToSecure.length);
        this.zrtpSasRelay.setDataToSecure(dataToSecure);
        this.zrtpSasRelay.setHmac(confMac);
        this.stateEngine.sendSASRelay(this.zrtpSasRelay);
        return true;
    }

    public ZrtpConstants.SupportedSASTypes getSasType() {
        return this.sasType;
    }

    public byte[] getSasHash() {
        return this.sasHash;
    }

    public boolean inState(ZrtpStateClass.ZrtpStates state) {
        if (this.stateEngine != null) {
            return this.stateEngine.isInState(state);
        }
        return false;
    }

    public void SASVerified() {
        if (this.paranoidMode) {
            return;
        }
        ZidFile zidf = ZidFile.getInstance();
        ZidRecord zidRec = zidf.getRecord(this.peerZid);
        zidRec.setSasVerified();
        zidf.saveRecord(zidRec);
    }

    public void resetSASVerified() {
        ZidFile zidf = ZidFile.getInstance();
        ZidRecord zidRec = zidf.getRecord(this.peerZid);
        zidRec.resetSasVerified();
        zidf.saveRecord(zidRec);
    }

    public String getHelloHash(int index) {
        String pv = new String(this.helloPackets[index].packet.getVersion());
        String hs = new String(ZrtpUtils.bytesToHexString(this.helloPackets[index].helloHash, this.hashLengthImpl));
        return pv + " " + hs;
    }

    public String[] getHelloHashSep(int index) {
        String[] ret = new String[]{new String(this.helloPackets[index].packet.getVersion()), new String(ZrtpUtils.bytesToHexString(this.helloPackets[index].helloHash, this.hashLengthImpl))};
        return ret;
    }

    public String getPeerHelloHash() {
        if (this.peerHelloVersion == null) {
            return null;
        }
        String pv = new String(this.peerHelloVersion);
        String hs = new String(ZrtpUtils.bytesToHexString(this.peerHelloHash, this.hashLengthImpl));
        return pv + " " + hs;
    }

    public String[] getPeerHelloHashSep() {
        String[] ret = new String[2];
        if (this.peerHelloVersion == null) {
            return null;
        }
        ret[0] = new String(this.peerHelloVersion);
        ret[1] = new String(ZrtpUtils.bytesToHexString(this.peerHelloHash, this.hashLengthImpl));
        return ret;
    }

    public byte[] getMultiStrParams() {
        byte[] tmp = null;
        if (this.inState(ZrtpStateClass.ZrtpStates.SecureState) && !this.multiStream) {
            tmp = new byte[this.hashLength + 1 + 1 + 1];
            tmp[0] = (byte)this.hash.ordinal();
            tmp[1] = (byte)this.authLength.ordinal();
            tmp[2] = (byte)this.cipher.ordinal();
            System.arraycopy(this.zrtpSession, 0, tmp, 3, this.hashLength);
        }
        return tmp;
    }

    public void setMultiStrParams(byte[] parameters) {
        for (ZrtpConstants.SupportedHashes supportedHashes : ZrtpConstants.SupportedHashes.values()) {
            if (supportedHashes.ordinal() != (parameters[0] & 0xFF)) continue;
            this.hash = supportedHashes;
            break;
        }
        this.setNegotiatedHash(this.hash);
        this.zrtpSession = new byte[this.hashLength];
        for (Enum enum_ : ZrtpConstants.SupportedAuthLengths.values()) {
            if (enum_.ordinal() != (parameters[1] & 0xFF)) continue;
            this.authLength = enum_;
            break;
        }
        for (Enum enum_ : ZrtpConstants.SupportedSymCiphers.values()) {
            if (enum_.ordinal() != (parameters[2] & 0xFF)) continue;
            this.cipher = enum_;
            break;
        }
        System.arraycopy(parameters, 3, this.zrtpSession, 0, this.hashLength);
        this.multiStream = true;
        this.stateEngine.setMultiStream(true);
    }

    public boolean isMultiStream() {
        return this.multiStream;
    }

    public boolean isMultiStreamAvailable() {
        return this.multiStreamAvailable;
    }

    public void acceptEnrollment(boolean accepted) {
        if (!accepted) {
            this.callback.zrtpInformEnrollment(ZrtpCodes.InfoEnrollment.EnrollmentCanceled);
            return;
        }
        ZidFile zidf = ZidFile.getInstance();
        ZidRecord zidRec = zidf.getRecord(this.peerZid);
        if (this.pbxSecretTmp == null) {
            this.callback.zrtpInformEnrollment(ZrtpCodes.InfoEnrollment.EnrollmentFailed);
            return;
        }
        zidRec.setMiTMData(this.pbxSecretTmp);
        this.callback.zrtpInformEnrollment(ZrtpCodes.InfoEnrollment.EnrollmentOk);
        zidf.saveRecord(zidRec);
    }

    public boolean setSignatureData(byte[] data) {
        if (data.length % 4 != 0) {
            return false;
        }
        ZrtpPacketConfirm conf = this.myRole == ZrtpCallback.Role.Responder ? this.zrtpConfirm1 : this.zrtpConfirm2;
        conf.setSignatureLength(data.length / 4);
        return conf.setSignatureData(data);
    }

    public byte[] getSignatureData() {
        return this.signatureData;
    }

    public int getSignatureLength() {
        return this.signatureLength * 4;
    }

    public void conf2AckSecure() {
        if (this.stateEngine != null) {
            ZrtpStateClass zrtpStateClass = this.stateEngine;
            zrtpStateClass.getClass();
            ZrtpStateClass.Event ev = new ZrtpStateClass.Event(zrtpStateClass, ZrtpStateClass.EventDataType.ZrtpPacket, this.zrtpConf2Ack.getHeaderBase());
            this.stateEngine.processEvent(ev);
        }
    }

    public byte[] getPeerZid() {
        byte[] ret = new byte[12];
        System.arraycopy(this.peerZid, 0, ret, 0, 12);
        return ret;
    }

    public long getTimeoutValue() {
        if (this.stateEngine != null) {
            return this.stateEngine.getTimeoutValue();
        }
        return -1L;
    }

    public int getNumberSupportedVersions() {
        return 1;
    }

    public int getCurrentProtocolVersion() {
        return this.currentHelloPacket.getVersionInt();
    }

    protected boolean sendPacketZRTP(ZrtpPacketBase packet) {
        return packet == null ? false : this.callback.sendDataZRTP(packet.getHeaderBase());
    }

    protected int activateTimer(int tm) {
        return this.callback.activateTimer(tm);
    }

    protected int cancelTimer() {
        return this.callback.cancelTimer();
    }

    protected ZrtpPacketHello prepareHello() {
        return this.currentHelloPacket;
    }

    protected ZrtpPacketHelloAck prepareHelloAck() {
        return this.zrtpHelloAck;
    }

    protected ZrtpPacketCommit prepareCommit(ZrtpPacketHello hello, ZrtpCodes.ZrtpErrorCodes[] errMsg) {
        this.peerZid = hello.getZid();
        if (ZrtpUtils.byteArrayCompare(this.peerZid, this.zid, 12) == 0) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.EqualZIDHello;
            return null;
        }
        System.arraycopy(hello.getH3(), 0, this.peerH3, 0, 32);
        int helloLen = hello.getLength() * 4;
        this.hashFunctionImpl.update(hello.getHeaderBase(), 0, helloLen);
        this.hashFunctionImpl.doFinal(this.peerHelloHash, 0);
        this.peerHelloVersion = hello.getVersion();
        this.sendInfo(ZrtpCodes.MessageSeverity.Info, EnumSet.of(ZrtpCodes.InfoCodes.InfoHelloReceived));
        this.sasType = hello.findBestSASType(this.configureAlgos);
        if (!this.multiStream) {
            this.pubKey = hello.findBestPubkey(this.configureAlgos);
            this.hash = hello.getSelectedHash();
            if (this.hash == null) {
                errMsg[0] = ZrtpCodes.ZrtpErrorCodes.UnsuppHashType;
                return null;
            }
            this.cipher = hello.getSelectedCipher();
            if (this.cipher == null) {
                this.cipher = hello.findBestCipher(this.configureAlgos, this.pubKey);
            }
        } else {
            if (hello.checkMultiStream()) {
                return this.prepareCommitMultiStream(hello);
            }
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.UnsuppPKExchange;
            return null;
        }
        this.authLength = hello.findBestAuthLen(this.configureAlgos);
        this.multiStreamAvailable = hello.checkMultiStream();
        this.setNegotiatedHash(this.hash);
        if (!this.fillPubKey()) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.CriticalSWError;
            return null;
        }
        this.sendInfo(ZrtpCodes.MessageSeverity.Info, EnumSet.of(ZrtpCodes.InfoCodes.InfoCommitDHGenerated));
        ZidFile zidFile = ZidFile.getInstance();
        ZidRecord zidRec = zidFile.getRecord(this.peerZid);
        this.computeSharedSecretSet(zidRec);
        if (hello.isMitmMode()) {
            this.mitmSeen = true;
        }
        this.peerIsEnrolled = zidRec.isMITMKeyAvailable();
        this.signSasSeen = hello.isSasSign();
        this.zrtpDH2.setPubKeyType(this.pubKey);
        this.zrtpDH2.setMessageType(ZrtpConstants.DHPart2Msg);
        this.zrtpDH2.setRs1Id(this.rs1IDi);
        this.zrtpDH2.setRs2Id(this.rs2IDi);
        this.zrtpDH2.setAuxSecretId(this.auxSecretIDi);
        this.zrtpDH2.setPbxSecretId(this.pbxSecretIDi);
        this.zrtpDH2.setPv(this.pubKeyBytes);
        this.zrtpDH2.setH1(this.H1);
        int len = this.zrtpDH2.getLength() * 4;
        byte[] hmac = this.computeMsgHmac(this.H0, this.zrtpDH2);
        this.zrtpDH2.setHMAC(hmac);
        this.computeHvi(this.zrtpDH2, hello);
        this.zrtpCommit.setZid(this.zid);
        this.zrtpCommit.setHashType(this.hash.name);
        this.zrtpCommit.setCipherType(this.cipher.name);
        this.zrtpCommit.setAuthLen(this.authLength.name);
        this.zrtpCommit.setPubKeyType(this.pubKey.name);
        this.zrtpCommit.setSasType(this.sasType.name);
        this.zrtpCommit.setHvi(this.hvi);
        this.zrtpCommit.setH2(this.H2);
        hmac = this.computeMsgHmac(this.H1, this.zrtpCommit);
        this.zrtpCommit.setHMAC(hmac);
        this.hashCtxFunction.update(hello.getHeaderBase(), 0, hello.getLength() * 4);
        len = this.zrtpCommit.getLength() * 4;
        this.hashCtxFunction.update(this.zrtpCommit.getHeaderBase(), 0, len);
        this.storeMsgTemp(hello);
        return this.zrtpCommit;
    }

    private boolean fillPubKey() {
        if (this.pubKey == ZrtpConstants.SupportedPubKeys.DH2K || this.pubKey == ZrtpConstants.SupportedPubKeys.DH3K) {
            this.dhKeyPair = this.pubKey.dhKeyPairGen.generateKeyPair();
            this.pubKeyBytes = ((DHPublicKeyParameters)this.dhKeyPair.getPublic()).getY().toByteArray();
            if (this.pubKeyBytes.length != this.pubKey.pubKeySize && (this.pubKeyBytes = this.adjustBigBytes(this.pubKeyBytes, this.pubKey.pubKeySize)) == null) {
                return false;
            }
        } else if (this.pubKey == ZrtpConstants.SupportedPubKeys.EC25 || this.pubKey == ZrtpConstants.SupportedPubKeys.EC38) {
            this.ecKeyPair = this.pubKey.ecKeyPairGen.generateKeyPair();
            byte[] encoded = ((ECPublicKeyParameters)this.ecKeyPair.getPublic()).getQ().getEncoded();
            this.pubKeyBytes = new byte[this.pubKey.pubKeySize];
            System.arraycopy(encoded, 1, this.pubKeyBytes, 0, this.pubKey.pubKeySize);
        } else {
            return false;
        }
        return true;
    }

    protected ZrtpPacketCommit prepareCommitMultiStream(ZrtpPacketHello hello) {
        this.hvi = new byte[16];
        this.secRand.nextBytes(this.hvi);
        this.zrtpCommit.setZid(this.zid);
        this.zrtpCommit.setHashType(this.hash.name);
        this.zrtpCommit.setCipherType(this.cipher.name);
        this.zrtpCommit.setAuthLen(this.authLength.name);
        this.zrtpCommit.setPubKeyType(ZrtpConstants.SupportedPubKeys.MULT.name);
        this.zrtpCommit.setSasType(this.sasType.name);
        this.zrtpCommit.setNonce(this.hvi);
        this.zrtpCommit.setH2(this.H2);
        int len = this.zrtpCommit.getLength() * 4;
        byte[] hmac = this.computeMsgHmac(this.H1, this.zrtpCommit);
        this.zrtpCommit.setHMACMulti(hmac);
        this.hashCtxFunction.update(hello.getHeaderBase(), 0, hello.getLength() * 4);
        this.hashCtxFunction.update(this.zrtpCommit.getHeaderBase(), 0, len);
        this.storeMsgTemp(hello);
        int helloLen = hello.getLength() * 4;
        this.hashFunctionImpl.update(hello.getHeaderBase(), 0, helloLen);
        this.hashFunctionImpl.doFinal(this.peerHelloHash, 0);
        this.peerHelloVersion = hello.getVersion();
        return this.zrtpCommit;
    }

    protected ZrtpPacketDHPart prepareDHPart1(ZrtpPacketCommit commit, ZrtpCodes.ZrtpErrorCodes[] errMsg) {
        ZrtpConstants.SupportedPubKeys commitPubKey;
        this.sendInfo(ZrtpCodes.MessageSeverity.Info, EnumSet.of(ZrtpCodes.InfoCodes.InfoRespCommitReceived));
        System.arraycopy(commit.getH2(), 0, this.peerH2, 0, 32);
        byte[] tmpH3 = new byte[64];
        this.hashFunctionImpl.update(this.peerH2, 0, 32);
        this.hashFunctionImpl.doFinal(tmpH3, 0);
        if (ZrtpUtils.byteArrayCompare(tmpH3, this.peerH3, 32) != 0) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.IgnorePacket;
            return null;
        }
        if (!this.checkMsgHmac(this.peerH2)) {
            this.sendInfo(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereHelloHMACFailed));
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.CriticalSWError;
            return null;
        }
        this.cipher = commit.getCipher();
        if (this.cipher == null) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.UnsuppCiphertype;
            return null;
        }
        this.authLength = commit.getAuthlen();
        if (this.authLength == null) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.UnsuppSRTPAuthTag;
            return null;
        }
        ZrtpConstants.SupportedHashes newHash = commit.getHash();
        if (newHash == null) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.UnsuppHashType;
            return null;
        }
        if (newHash != this.hash) {
            this.hash = newHash;
            this.setNegotiatedHash(this.hash);
            ZidFile zidFile = ZidFile.getInstance();
            ZidRecord zidRec = zidFile.getRecord(this.peerZid);
            this.computeSharedSecretSet(zidRec);
        }
        if ((commitPubKey = commit.getPubKey()) == null) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.UnsuppPKExchange;
            return null;
        }
        if (commitPubKey != this.pubKey) {
            this.pubKey = commitPubKey;
            if (!this.fillPubKey()) {
                errMsg[0] = ZrtpCodes.ZrtpErrorCodes.CriticalSWError;
                return null;
            }
        }
        if (this.pubKey == ZrtpConstants.SupportedPubKeys.EC38 && this.hash != ZrtpConstants.SupportedHashes.S384) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.UnsuppHashType;
            return null;
        }
        this.sasType = commit.getSas();
        if (this.sasType == null) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.UnsuppSASScheme;
            return null;
        }
        this.sendInfo(ZrtpCodes.MessageSeverity.Info, EnumSet.of(ZrtpCodes.InfoCodes.InfoDH1DHGenerated));
        this.zrtpDH1.setPubKeyType(this.pubKey);
        this.zrtpDH1.setMessageType(ZrtpConstants.DHPart1Msg);
        this.zrtpDH1.setRs1Id(this.rs1IDr);
        this.zrtpDH1.setRs2Id(this.rs2IDr);
        this.zrtpDH1.setAuxSecretId(this.auxSecretIDr);
        this.zrtpDH1.setPbxSecretId(this.pbxSecretIDr);
        this.zrtpDH1.setPv(this.pubKeyBytes);
        this.zrtpDH1.setH1(this.H1);
        byte[] hmac = this.computeMsgHmac(this.H0, this.zrtpDH1);
        this.zrtpDH1.setHMAC(hmac);
        this.myRole = ZrtpCallback.Role.Responder;
        this.peerHvi = commit.getHvi();
        this.hashCtxFunction.reset();
        this.hashCtxFunction.update(this.currentHelloPacket.getHeaderBase(), 0, this.currentHelloPacket.getLength() * 4);
        this.hashCtxFunction.update(commit.getHeaderBase(), 0, commit.getLength() * 4);
        this.hashCtxFunction.update(this.zrtpDH1.getHeaderBase(), 0, this.zrtpDH1.getLength() * 4);
        this.storeMsgTemp(commit);
        return this.zrtpDH1;
    }

    protected ZrtpPacketDHPart prepareDHPart2(ZrtpPacketDHPart dhPart1, ZrtpCodes.ZrtpErrorCodes[] errMsg) {
        this.sendInfo(ZrtpCodes.MessageSeverity.Info, EnumSet.of(ZrtpCodes.InfoCodes.InfoInitDH1Received));
        this.hashFunctionImpl.update(dhPart1.getH1(), 0, 32);
        this.hashFunctionImpl.doFinal(this.peerH2, 0);
        byte[] tmpHash = new byte[64];
        this.hashFunctionImpl.update(this.peerH2, 0, 32);
        this.hashFunctionImpl.doFinal(tmpHash, 0);
        if (ZrtpUtils.byteArrayCompare(tmpHash, this.peerH3, 32) != 0) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.IgnorePacket;
            return null;
        }
        if (!this.checkMsgHmac(this.peerH2)) {
            this.sendInfo(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereHelloHMACFailed));
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.CriticalSWError;
            return null;
        }
        byte[] pvrBytes = dhPart1.getPv();
        int dhSize = 0;
        if (this.pubKey == ZrtpConstants.SupportedPubKeys.DH2K || this.pubKey == ZrtpConstants.SupportedPubKeys.DH3K) {
            BigIntegerCrypto pvrBigInt = new BigIntegerCrypto(1, pvrBytes);
            if (!this.checkPubKey(pvrBigInt, this.pubKey)) {
                errMsg[0] = ZrtpCodes.ZrtpErrorCodes.DHErrorWrongPV;
                return null;
            }
            this.pubKey.dhContext.init(this.dhKeyPair.getPrivate());
            DHPublicKeyParameters pvr = new DHPublicKeyParameters(pvrBigInt, this.pubKey.specDh);
            dhSize = this.pubKey.pubKeySize;
            BigIntegerCrypto bi = this.pubKey.dhContext.calculateAgreement(pvr);
            this.DHss = bi.toByteArray();
            this.pubKey.dhContext.clear();
            bi.zeroize();
        } else if (this.pubKey == ZrtpConstants.SupportedPubKeys.EC25 || this.pubKey == ZrtpConstants.SupportedPubKeys.EC38) {
            byte[] encoded = new byte[pvrBytes.length + 1];
            encoded[0] = 4;
            System.arraycopy(pvrBytes, 0, encoded, 1, pvrBytes.length);
            ECPoint point = this.pubKey.curve.decodePoint(encoded);
            dhSize = this.pubKey.pubKeySize / 2;
            this.pubKey.ecdhContext.init(this.ecKeyPair.getPrivate());
            BigIntegerCrypto bi = this.pubKey.ecdhContext.calculateAgreement(new ECPublicKeyParameters(point, null));
            this.DHss = bi.toByteArray();
            this.pubKey.ecdhContext.clear();
            bi.zeroize();
        } else {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.CriticalSWError;
            return null;
        }
        if (this.DHss.length != dhSize && (this.DHss = this.adjustBigBytes(this.DHss, dhSize)) == null) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.CriticalSWError;
            return null;
        }
        this.myRole = ZrtpCallback.Role.Initiator;
        this.hashCtxFunction.update(dhPart1.getHeaderBase(), 0, dhPart1.getLength() * 4);
        this.hashCtxFunction.update(this.zrtpDH2.getHeaderBase(), 0, this.zrtpDH2.getLength() * 4);
        this.hashCtxFunction.doFinal(this.messageHash, 0);
        this.hashCtxFunction = null;
        ZidFile zidf = ZidFile.getInstance();
        ZidRecord zidRec = zidf.getRecord(this.peerZid);
        this.generateKeysInitiator(dhPart1, zidRec);
        zidf.saveRecord(zidRec);
        this.storeMsgTemp(dhPart1);
        return this.zrtpDH2;
    }

    protected ZrtpPacketConfirm prepareConfirm1(ZrtpPacketDHPart dhPart2, ZrtpCodes.ZrtpErrorCodes[] errMsg) {
        BigIntegerCrypto bi;
        this.sendInfo(ZrtpCodes.MessageSeverity.Info, EnumSet.of(ZrtpCodes.InfoCodes.InfoRespDH2Received));
        byte[] tmpHash = new byte[64];
        this.hashFunctionImpl.update(dhPart2.getH1(), 0, 32);
        this.hashFunctionImpl.doFinal(tmpHash, 0);
        if (ZrtpUtils.byteArrayCompare(tmpHash, this.peerH2, 32) != 0) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.IgnorePacket;
            return null;
        }
        this.computeHvi(dhPart2, this.currentHelloPacket);
        if (ZrtpUtils.byteArrayCompare(this.hvi, this.peerHvi, 32) != 0) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.DHErrorWrongHVI;
            return null;
        }
        if (!this.checkMsgHmac(dhPart2.getH1())) {
            this.sendInfo(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereCommitHMACFailed));
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.CriticalSWError;
            return null;
        }
        byte[] pviBytes = dhPart2.getPv();
        int dhSize = 0;
        if (this.pubKey == ZrtpConstants.SupportedPubKeys.DH2K || this.pubKey == ZrtpConstants.SupportedPubKeys.DH3K) {
            BigIntegerCrypto pviBigInt = new BigIntegerCrypto(1, pviBytes);
            if (!this.checkPubKey(pviBigInt, this.pubKey)) {
                errMsg[0] = ZrtpCodes.ZrtpErrorCodes.DHErrorWrongPV;
                return null;
            }
            this.pubKey.dhContext.init(this.dhKeyPair.getPrivate());
            DHPublicKeyParameters pvi = new DHPublicKeyParameters(pviBigInt, this.pubKey.specDh);
            dhSize = this.pubKey.pubKeySize;
            bi = this.pubKey.dhContext.calculateAgreement(pvi);
            this.DHss = bi.toByteArray();
            this.pubKey.dhContext.clear();
            bi.zeroize();
        } else if (this.pubKey == ZrtpConstants.SupportedPubKeys.EC25 || this.pubKey == ZrtpConstants.SupportedPubKeys.EC38) {
            byte[] encoded = new byte[pviBytes.length + 1];
            encoded[0] = 4;
            System.arraycopy(pviBytes, 0, encoded, 1, pviBytes.length);
            ECPoint pubPoint = this.pubKey.curve.decodePoint(encoded);
            dhSize = this.pubKey.pubKeySize / 2;
            this.pubKey.ecdhContext.init(this.ecKeyPair.getPrivate());
            bi = this.pubKey.ecdhContext.calculateAgreement(new ECPublicKeyParameters(pubPoint, null));
            this.DHss = bi.toByteArray();
            this.pubKey.ecdhContext.clear();
            bi.zeroize();
        } else {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.CriticalSWError;
            return null;
        }
        if (this.DHss.length != dhSize && (this.DHss = this.adjustBigBytes(this.DHss, dhSize)) == null) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.CriticalSWError;
            return null;
        }
        this.hashCtxFunction.update(dhPart2.getHeaderBase(), 0, dhPart2.getLength() * 4);
        this.hashCtxFunction.doFinal(this.messageHash, 0);
        this.hashCtxFunction = null;
        ZidFile zidf = ZidFile.getInstance();
        ZidRecord zidRec = zidf.getRecord(this.peerZid);
        this.generateKeysResponder(dhPart2, zidRec);
        zidf.saveRecord(zidRec);
        this.zrtpConfirm1.setMessageType(ZrtpConstants.Confirm1Msg);
        if (zidRec.isSasVerified() && !this.paranoidMode) {
            this.zrtpConfirm1.setSASFlag();
        }
        this.zrtpConfirm1.setExpTime(-1);
        this.zrtpConfirm1.setIv(this.randomIV);
        this.zrtpConfirm1.setHashH0(this.H0);
        if (this.enrollmentMode) {
            this.computePBXSecret();
            this.zrtpConfirm1.setPBXEnrollment();
            this.writeEnrollmentPBX();
        }
        byte[] dataToSecure = this.zrtpConfirm1.getDataToSecure();
        try {
            this.cipher.cipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.zrtpKeyR, 0, this.cipher.keyLength), this.randomIV));
            int done = this.cipher.cipher.processBytes(dataToSecure, 0, dataToSecure.length, dataToSecure, 0);
            this.cipher.cipher.doFinal(dataToSecure, done);
        }
        catch (Exception e) {
            this.sendInfo(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereSecurityException));
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.CriticalSWError;
            return null;
        }
        byte[] confMac = this.computeHmac(this.hmacKeyR, this.hashLength, dataToSecure, dataToSecure.length);
        this.zrtpConfirm1.setDataToSecure(dataToSecure);
        this.zrtpConfirm1.setHmac(confMac);
        this.storeMsgTemp(dhPart2);
        return this.zrtpConfirm1;
    }

    private byte[] adjustBigBytes(byte[] in, int size) {
        byte[] tmp = null;
        if (in.length > size && in[0] == 0) {
            tmp = new byte[in.length - 1];
            System.arraycopy(in, 1, tmp, 0, tmp.length);
            return tmp;
        }
        if (in.length < size) {
            int fill = size - in.length;
            tmp = new byte[size];
            System.arraycopy(in, 0, tmp, fill, size - fill);
            return tmp;
        }
        return null;
    }

    protected ZrtpPacketConfirm prepareConfirm1MultiStream(ZrtpPacketCommit commit, ZrtpCodes.ZrtpErrorCodes[] errMsg) {
        this.sendInfo(ZrtpCodes.MessageSeverity.Info, EnumSet.of(ZrtpCodes.InfoCodes.InfoRespCommitReceived));
        System.arraycopy(commit.getH2(), 0, this.peerH2, 0, 32);
        byte[] tmpH3 = new byte[64];
        this.hashFunctionImpl.update(this.peerH2, 0, 32);
        this.hashFunctionImpl.doFinal(tmpH3, 0);
        if (ZrtpUtils.byteArrayCompare(tmpH3, this.peerH3, 32) != 0) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.IgnorePacket;
            return null;
        }
        if (!this.checkMsgHmac(this.peerH2)) {
            this.sendInfo(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereCommitHMACFailed));
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.CriticalSWError;
            return null;
        }
        if (commit.getPubKey() != ZrtpConstants.SupportedPubKeys.MULT) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.UnsuppPKExchange;
            return null;
        }
        this.cipher = commit.getCipher();
        if (this.cipher == null) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.UnsuppCiphertype;
            return null;
        }
        this.authLength = commit.getAuthlen();
        if (this.authLength == null) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.UnsuppSRTPAuthTag;
            return null;
        }
        ZrtpConstants.SupportedHashes newHash = commit.getHash();
        if (newHash == null) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.UnsuppHashType;
            return null;
        }
        if (newHash != this.hash) {
            this.hash = newHash;
            this.setNegotiatedHash(this.hash);
        }
        this.myRole = ZrtpCallback.Role.Responder;
        this.hashCtxFunction.reset();
        this.hashCtxFunction.update(this.currentHelloPacket.getHeaderBase(), 0, this.currentHelloPacket.getLength() * 4);
        this.hashCtxFunction.update(commit.getHeaderBase(), 0, commit.getLength() * 4);
        this.hashCtxFunction.doFinal(this.messageHash, 0);
        this.hashCtxFunction = null;
        this.generateKeysMultiStream();
        this.zrtpConfirm1.setMessageType(ZrtpConstants.Confirm1Msg);
        this.zrtpConfirm1.setExpTime(-1);
        this.zrtpConfirm1.setIv(this.randomIV);
        this.zrtpConfirm1.setHashH0(this.H0);
        byte[] dataToSecure = this.zrtpConfirm1.getDataToSecure();
        try {
            this.cipher.cipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.zrtpKeyR, 0, this.cipher.keyLength), this.randomIV));
            int done = this.cipher.cipher.processBytes(dataToSecure, 0, dataToSecure.length, dataToSecure, 0);
            this.cipher.cipher.doFinal(dataToSecure, done);
        }
        catch (Exception e) {
            this.sendInfo(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereSecurityException));
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.CriticalSWError;
            return null;
        }
        byte[] confMac = this.computeHmac(this.hmacKeyR, this.hashLength, dataToSecure, dataToSecure.length);
        this.zrtpConfirm1.setDataToSecure(dataToSecure);
        this.zrtpConfirm1.setHmac(confMac);
        this.storeMsgTemp(commit);
        return this.zrtpConfirm1;
    }

    protected ZrtpPacketConfirm prepareConfirm2(ZrtpPacketConfirm confirm1, ZrtpCodes.ZrtpErrorCodes[] errMsg) {
        this.sendInfo(ZrtpCodes.MessageSeverity.Info, EnumSet.of(ZrtpCodes.InfoCodes.InfoInitConf1Received));
        byte[] dataToSecure = confirm1.getDataToSecure();
        byte[] confMac = this.computeHmac(this.hmacKeyR, this.hashLength, dataToSecure, dataToSecure.length);
        if (ZrtpUtils.byteArrayCompare(confMac, confirm1.getHmac(), 8) != 0) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.ConfirmHMACWrong;
            return null;
        }
        try {
            this.cipher.cipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.zrtpKeyR, 0, this.cipher.keyLength), confirm1.getIv()));
            int done = this.cipher.cipher.processBytes(dataToSecure, 0, dataToSecure.length, dataToSecure, 0);
            this.cipher.cipher.doFinal(dataToSecure, done);
        }
        catch (Exception e) {
            this.sendInfo(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereSecurityException));
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.CriticalSWError;
            return null;
        }
        confirm1.setDataToSecure(dataToSecure);
        if (!this.checkMsgHmac(confirm1.getHashH0())) {
            this.sendInfo(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereDH1HMACFailed));
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.CriticalSWError;
            return null;
        }
        this.signatureLength = confirm1.getSignatureLength();
        if (this.signSasSeen && this.signatureLength > 0) {
            this.signatureData = confirm1.getSignatureData();
            this.callback.checkSASSignature(this.sasHash);
        }
        boolean sasFlag = confirm1.isSASFlag();
        ZidFile zidf = ZidFile.getInstance();
        ZidRecord zidRec = zidf.getRecord(this.peerZid);
        if (!sasFlag || this.paranoidMode) {
            zidRec.resetSasVerified();
        }
        sasFlag = zidRec.isSasVerified();
        zidRec.setNewRs1(this.newRs1, -1);
        zidf.saveRecord(zidRec);
        this.zrtpConfirm2.setMessageType(ZrtpConstants.Confirm2Msg);
        this.zrtpConfirm2.setHashH0(this.H0);
        if (sasFlag) {
            this.zrtpConfirm2.setSASFlag();
        }
        this.zrtpConfirm2.setExpTime(-1);
        this.zrtpConfirm2.setIv(this.randomIV);
        if (this.enrollmentMode || this.enableMitmEnrollment && confirm1.isPBXEnrollment()) {
            this.computePBXSecret();
            if (this.enrollmentMode) {
                this.zrtpConfirm2.setPBXEnrollment();
                this.writeEnrollmentPBX();
            }
        }
        dataToSecure = this.zrtpConfirm2.getDataToSecure();
        try {
            this.cipher.cipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.zrtpKeyI, 0, this.cipher.keyLength), this.randomIV));
            int done = this.cipher.cipher.processBytes(dataToSecure, 0, dataToSecure.length, dataToSecure, 0);
            this.cipher.cipher.doFinal(dataToSecure, done);
        }
        catch (Exception e) {
            this.sendInfo(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereSecurityException));
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.CriticalSWError;
            return null;
        }
        confMac = this.computeHmac(this.hmacKeyI, this.hashLength, dataToSecure, dataToSecure.length);
        this.zrtpConfirm2.setDataToSecure(dataToSecure);
        this.zrtpConfirm2.setHmac(confMac);
        this.callback.srtpSecretsOn(this.cipher.readable + "/" + (Object)((Object)this.pubKey), this.SAS, sasFlag);
        if (this.enableMitmEnrollment && confirm1.isPBXEnrollment()) {
            this.callback.zrtpAskEnrollment(ZrtpCodes.InfoEnrollment.EnrollmentRequest);
        }
        return this.zrtpConfirm2;
    }

    private void writeEnrollmentPBX() {
        ZidFile zidf = ZidFile.getInstance();
        ZidRecord zidRec = zidf.getRecord(this.peerZid);
        if (this.pbxSecretTmp != null) {
            zidRec.setMiTMData(this.pbxSecretTmp);
        }
        zidf.saveRecord(zidRec);
    }

    protected ZrtpPacketConfirm prepareConfirm2MultiStream(ZrtpPacketConfirm confirm1, ZrtpCodes.ZrtpErrorCodes[] errMsg) {
        this.sendInfo(ZrtpCodes.MessageSeverity.Info, EnumSet.of(ZrtpCodes.InfoCodes.InfoInitConf1Received));
        this.hashCtxFunction.doFinal(this.messageHash, 0);
        this.hashCtxFunction = null;
        this.myRole = ZrtpCallback.Role.Initiator;
        this.generateKeysMultiStream();
        byte[] dataToSecure = confirm1.getDataToSecure();
        byte[] confMac = this.computeHmac(this.hmacKeyR, this.hashLength, dataToSecure, dataToSecure.length);
        if (ZrtpUtils.byteArrayCompare(confMac, confirm1.getHmac(), 8) != 0) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.ConfirmHMACWrong;
            return null;
        }
        try {
            this.cipher.cipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.zrtpKeyR, 0, this.cipher.keyLength), confirm1.getIv()));
            int done = this.cipher.cipher.processBytes(dataToSecure, 0, dataToSecure.length, dataToSecure, 0);
            this.cipher.cipher.doFinal(dataToSecure, done);
        }
        catch (Exception e) {
            this.sendInfo(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereSecurityException));
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.CriticalSWError;
            return null;
        }
        confirm1.setDataToSecure(dataToSecure);
        byte[] tmpHash = new byte[64];
        this.hashFunctionImpl.update(confirm1.getHashH0(), 0, 32);
        this.hashFunctionImpl.doFinal(tmpHash, 0);
        this.hashFunctionImpl.update(tmpHash, 0, 32);
        this.hashFunctionImpl.doFinal(this.peerH2, 0);
        if (!this.checkMsgHmac(this.peerH2)) {
            this.sendInfo(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereHelloHMACFailed));
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.CriticalSWError;
            return null;
        }
        this.zrtpConfirm2.setMessageType(ZrtpConstants.Confirm2Msg);
        this.zrtpConfirm2.setHashH0(this.H0);
        this.zrtpConfirm2.setExpTime(-1);
        this.zrtpConfirm2.setIv(this.randomIV);
        dataToSecure = this.zrtpConfirm2.getDataToSecure();
        try {
            this.cipher.cipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.zrtpKeyI, 0, this.cipher.keyLength), this.randomIV));
            int done = this.cipher.cipher.processBytes(dataToSecure, 0, dataToSecure.length, dataToSecure, 0);
            this.cipher.cipher.doFinal(dataToSecure, done);
        }
        catch (Exception e) {
            this.sendInfo(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereSecurityException));
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.CriticalSWError;
            return null;
        }
        confMac = this.computeHmac(this.hmacKeyI, this.hashLength, dataToSecure, dataToSecure.length);
        this.zrtpConfirm2.setDataToSecure(dataToSecure);
        this.zrtpConfirm2.setHmac(confMac);
        this.callback.srtpSecretsOn(this.cipher.readable, null, true);
        return this.zrtpConfirm2;
    }

    protected ZrtpPacketConf2Ack prepareConf2Ack(ZrtpPacketConfirm confirm2, ZrtpCodes.ZrtpErrorCodes[] errMsg) {
        this.sendInfo(ZrtpCodes.MessageSeverity.Info, EnumSet.of(ZrtpCodes.InfoCodes.InfoRespConf2Received));
        byte[] dataToSecure = confirm2.getDataToSecure();
        byte[] confMac = this.computeHmac(this.hmacKeyI, this.hashLength, dataToSecure, dataToSecure.length);
        if (ZrtpUtils.byteArrayCompare(confMac, confirm2.getHmac(), 8) != 0) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.ConfirmHMACWrong;
            return null;
        }
        try {
            this.cipher.cipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.zrtpKeyI, 0, this.cipher.keyLength), confirm2.getIv()));
            int done = this.cipher.cipher.processBytes(dataToSecure, 0, dataToSecure.length, dataToSecure, 0);
            this.cipher.cipher.doFinal(dataToSecure, done);
        }
        catch (Exception e) {
            this.sendInfo(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereSecurityException));
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.CriticalSWError;
            return null;
        }
        confirm2.setDataToSecure(dataToSecure);
        if (!this.multiStream) {
            if (!this.checkMsgHmac(confirm2.getHashH0())) {
                this.sendInfo(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereDH2HMACFailed));
                errMsg[0] = ZrtpCodes.ZrtpErrorCodes.CriticalSWError;
                return null;
            }
            this.signatureLength = confirm2.getSignatureLength();
            if (this.signSasSeen && this.signatureLength > 0) {
                this.signatureData = confirm2.getSignatureData();
                this.callback.checkSASSignature(this.sasHash);
            }
            boolean sasFlag = confirm2.isSASFlag();
            ZidFile zidf = ZidFile.getInstance();
            ZidRecord zidRec = zidf.getRecord(this.peerZid);
            if (!sasFlag || this.paranoidMode) {
                zidRec.resetSasVerified();
            }
            sasFlag = zidRec.isSasVerified();
            zidRec.setNewRs1(this.newRs1, -1);
            zidf.saveRecord(zidRec);
            if (this.enableMitmEnrollment && confirm2.isPBXEnrollment()) {
                this.computePBXSecret();
                this.callback.zrtpAskEnrollment(ZrtpCodes.InfoEnrollment.EnrollmentRequest);
            }
            this.callback.srtpSecretsOn(this.cipher.readable + "/" + (Object)((Object)this.pubKey), this.SAS, sasFlag);
        } else {
            byte[] tmpHash = new byte[64];
            this.hashFunctionImpl.update(confirm2.getHashH0(), 0, 32);
            this.hashFunctionImpl.doFinal(tmpHash, 0);
            if (!this.checkMsgHmac(tmpHash)) {
                this.sendInfo(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereCommitHMACFailed));
                errMsg[0] = ZrtpCodes.ZrtpErrorCodes.CriticalSWError;
                return null;
            }
            this.callback.srtpSecretsOn(this.cipher.readable, null, true);
        }
        return this.zrtpConf2Ack;
    }

    protected ZrtpPacketErrorAck prepareErrorAck(ZrtpPacketError epkt) {
        int code = epkt.getErrorCode();
        for (ZrtpCodes.ZrtpErrorCodes zc : ZrtpCodes.ZrtpErrorCodes.values()) {
            if (zc.value != code) continue;
            this.sendInfo(ZrtpCodes.MessageSeverity.ZrtpError, EnumSet.of(zc));
            break;
        }
        return this.zrtpErrorAck;
    }

    protected ZrtpPacketError prepareError(ZrtpCodes.ZrtpErrorCodes errMsg) {
        this.zrtpError.setErrorCode(errMsg.value);
        return this.zrtpError;
    }

    protected ZrtpPacketPingAck preparePingAck(ZrtpPacketPing ppkt) {
        this.zrtpPingAck.setLocalEpHash(this.zid);
        this.zrtpPingAck.setRemoteEpHash(ppkt.getEpHash());
        this.zrtpPingAck.setPeerSSRC(this.peerSSRC);
        return this.zrtpPingAck;
    }

    protected ZrtpPacketRelayAck prepareRelayAck(ZrtpPacketSASRelay srly, ZrtpCodes.ZrtpErrorCodes[] errMsg) {
        byte[] ekey;
        byte[] hkey;
        if (!this.mitmSeen || this.paranoidMode) {
            return this.zrtpRelayAck;
        }
        if (this.myRole == ZrtpCallback.Role.Responder) {
            hkey = this.hmacKeyI;
            ekey = this.zrtpKeyI;
        } else {
            hkey = this.hmacKeyR;
            ekey = this.zrtpKeyR;
        }
        byte[] dataToSecure = srly.getDataToSecure();
        byte[] relayMac = this.computeHmac(hkey, this.hashLength, dataToSecure, dataToSecure.length);
        if (ZrtpUtils.byteArrayCompare(relayMac, srly.getHmac(), 8) != 0) {
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.ConfirmHMACWrong;
            return null;
        }
        try {
            this.cipher.cipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(ekey, 0, this.cipher.keyLength), srly.getIv()));
            int done = this.cipher.cipher.processBytes(dataToSecure, 0, dataToSecure.length, dataToSecure, 0);
            this.cipher.cipher.doFinal(dataToSecure, done);
        }
        catch (Exception e) {
            this.sendInfo(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereSecurityException));
            errMsg[0] = ZrtpCodes.ZrtpErrorCodes.CriticalSWError;
            return null;
        }
        srly.setDataToSecure(dataToSecure);
        ZrtpConstants.SupportedSASTypes render = srly.getSas();
        byte[] newSasHash = srly.getTrustedSas();
        boolean sasHashNull = true;
        for (int i = 0; i < newSasHash.length; ++i) {
            if (newSasHash[i] == 0) continue;
            sasHashNull = false;
            break;
        }
        String mitm = "/SASviaMitM";
        if (sasHashNull || !this.peerIsEnrolled) {
            newSasHash = this.sasHash;
            mitm = "/MitM";
        }
        if (render == ZrtpConstants.SupportedSASTypes.B32) {
            byte[] sasBytes = new byte[]{newSasHash[0], newSasHash[1], (byte)(newSasHash[2] & 0xF0), 0};
            this.SAS = Base32.binary2ascii(sasBytes, 20);
        } else {
            this.SAS = ZrtpConstants.sas256WordsEven[newSasHash[0]] + ":" + ZrtpConstants.sas256WordsOdd[newSasHash[1]];
        }
        this.callback.srtpSecretsOn(this.cipher.readable + "/" + (Object)((Object)this.pubKey) + mitm, this.SAS, false);
        return this.zrtpRelayAck;
    }

    protected int compareCommit(ZrtpPacketCommit commit) {
        if (this.multiStream) {
            return ZrtpUtils.byteArrayCompare(this.hvi, commit.getNonce(), 16);
        }
        return ZrtpUtils.byteArrayCompare(this.hvi, commit.getHvi(), 32);
    }

    protected boolean verifyH2(ZrtpPacketCommit commit) {
        byte[] tmpH3 = new byte[64];
        this.hashFunctionImpl.update(commit.getH2(), 0, 32);
        this.hashFunctionImpl.doFinal(tmpH3, 0);
        return ZrtpUtils.byteArrayCompare(tmpH3, this.peerH3, 32) == 0;
    }

    protected void sendInfo(ZrtpCodes.MessageSeverity severity, EnumSet<?> subCode) {
        if (severity == ZrtpCodes.MessageSeverity.Info && subCode == EnumSet.of(ZrtpCodes.InfoCodes.InfoSecureStateOn)) {
            Arrays.fill(this.srtpKeyI, (byte)0);
            Arrays.fill(this.srtpSaltI, (byte)0);
            Arrays.fill(this.srtpKeyR, (byte)0);
            Arrays.fill(this.srtpSaltR, (byte)0);
        }
        this.callback.sendInfo(severity, subCode);
    }

    protected void zrtpNegotiationFailed(ZrtpCodes.MessageSeverity severity, EnumSet<?> subCode) {
        this.callback.zrtpNegotiationFailed(severity, subCode);
    }

    protected void zrtpNotSuppOther() {
        this.callback.zrtpNotSuppOther();
    }

    protected boolean srtpSecretsReady(ZrtpCallback.EnableSecurity part) {
        ZrtpSrtpSecrets sec = new ZrtpSrtpSecrets();
        sec.symEncAlgorithm = this.cipher.algo;
        sec.keyInitiator = this.srtpKeyI;
        sec.initKeyLen = this.cipher.keyLength * 8;
        sec.saltInitiator = this.srtpSaltI;
        sec.initSaltLen = 112;
        sec.keyResponder = this.srtpKeyR;
        sec.respKeyLen = this.cipher.keyLength * 8;
        sec.saltResponder = this.srtpSaltR;
        sec.respSaltLen = 112;
        sec.authAlgorithm = this.authLength.algo;
        sec.srtpAuthTagLen = this.authLength.length;
        sec.setRole(this.myRole);
        return this.callback.srtpSecretsReady(sec, part);
    }

    protected void srtpSecretsOff(ZrtpCallback.EnableSecurity part) {
        this.callback.srtpSecretsOff(part);
    }

    private void storeMsgTemp(ZrtpPacketBase pkt) {
        int length = pkt.getLength() * 4;
        Arrays.fill(this.tempMsgBuffer, (byte)0);
        System.arraycopy(pkt.getHeaderBase(), 0, this.tempMsgBuffer, 0, length);
        this.lengthOfMsgData = length;
    }

    private boolean checkMsgHmac(byte[] keyIn) {
        int len = this.lengthOfMsgData - 8;
        KeyParameter key = new KeyParameter(keyIn, 0, 32);
        this.hmacFunctionImpl.init((CipherParameters)key);
        this.hmacFunctionImpl.update(this.tempMsgBuffer, 0, len);
        byte[] data = new byte[this.hashLengthImpl];
        this.hmacFunctionImpl.doFinal(data, 0);
        byte[] storedMac = ZrtpUtils.readRegion(this.tempMsgBuffer, len, 8);
        return ZrtpUtils.byteArrayCompare(data, storedMac, 8) == 0;
    }

    private void setNegotiatedHash(ZrtpConstants.SupportedHashes hash) {
        if (hash == ZrtpConstants.SupportedHashes.S256) {
            this.hashFunction = new SHA256Digest();
            this.hmacFunction = new HMac((Digest)new SHA256Digest());
            this.hashCtxFunction = new SHA256Digest();
        } else if (hash == ZrtpConstants.SupportedHashes.S384) {
            this.hashFunction = new SHA384Digest();
            this.hmacFunction = new HMac((Digest)new SHA384Digest());
            this.hashCtxFunction = new SHA384Digest();
        }
        this.hashLength = this.hashFunction.getDigestSize();
    }

    private void setClientId(String id, HelloPacketVersion hpv) {
        String tmp = "                ";
        if (id.length() < 16) {
            hpv.packet.setClientId(tmp);
        }
        hpv.packet.setClientId(id);
        int len = hpv.packet.getLength() * 4;
        byte[] data = this.computeHmacImpl(this.H2, this.hashLengthImpl, hpv.packet.getHeaderBase(), len - 8);
        hpv.packet.setHMAC(data);
        this.hashFunctionImpl.update(hpv.packet.getHeaderBase(), 0, len);
        this.hashFunctionImpl.doFinal(hpv.helloHash, 0);
    }

    private byte[] computeMsgHmac(byte[] keyIn, ZrtpPacketBase pkt) {
        int len = (pkt.getLength() - 2) * 4;
        return this.computeHmacImpl(keyIn, this.hashLengthImpl, pkt.getHeaderBase(), len);
    }

    private final byte[] computeHmac(byte[] keyIn, int keyLen, byte[] toSign, int len) {
        KeyParameter key = new KeyParameter(keyIn, 0, keyLen);
        this.hmacFunction.init((CipherParameters)key);
        this.hmacFunction.update(toSign, 0, len);
        byte[] retval = new byte[this.hashLength];
        this.hmacFunction.doFinal(retval, 0);
        return retval;
    }

    private final byte[] computeHmacImpl(byte[] keyIn, int keyLen, byte[] toSign, int len) {
        KeyParameter key = new KeyParameter(keyIn, 0, keyLen);
        this.hmacFunctionImpl.init((CipherParameters)key);
        this.hmacFunctionImpl.update(toSign, 0, len);
        byte[] retval = new byte[this.hashLengthImpl];
        this.hmacFunctionImpl.doFinal(retval, 0);
        return retval;
    }

    private final void computeHvi(ZrtpPacketDHPart dh, ZrtpPacketHello hello) {
        this.hashFunction.update(dh.getHeaderBase(), 0, dh.getLength() * 4);
        this.hashFunction.update(hello.getHeaderBase(), 0, hello.getLength() * 4);
        this.hashFunction.doFinal(this.hvi, 0);
    }

    private void computeSharedSecretSet(ZidRecord zidRec) {
        byte[] randBuf = new byte[32];
        if (!zidRec.isRs1Valid()) {
            this.secRand.nextBytes(randBuf);
            this.rs1IDi = this.computeHmac(randBuf, 32, ZrtpConstants.initiator, ZrtpConstants.initiator.length);
            this.rs1IDr = this.computeHmac(randBuf, 32, ZrtpConstants.responder, ZrtpConstants.responder.length);
        } else {
            this.rs1Valid = true;
            this.rs1IDi = this.computeHmac(zidRec.getRs1(), 32, ZrtpConstants.initiator, ZrtpConstants.initiator.length);
            this.rs1IDr = this.computeHmac(zidRec.getRs1(), 32, ZrtpConstants.responder, ZrtpConstants.responder.length);
        }
        if (!zidRec.isRs2Valid()) {
            this.secRand.nextBytes(randBuf);
            this.rs2IDi = this.computeHmac(randBuf, 32, ZrtpConstants.initiator, ZrtpConstants.initiator.length);
            this.rs2IDr = this.computeHmac(randBuf, 32, ZrtpConstants.responder, ZrtpConstants.responder.length);
        } else {
            this.rs2Valid = true;
            this.rs2IDi = this.computeHmac(zidRec.getRs2(), 32, ZrtpConstants.initiator, ZrtpConstants.initiator.length);
            this.rs2IDr = this.computeHmac(zidRec.getRs2(), 32, ZrtpConstants.responder, ZrtpConstants.responder.length);
        }
        this.secRand.nextBytes(randBuf);
        this.auxSecretIDi = this.computeHmac(randBuf, 32, ZrtpConstants.initiator, ZrtpConstants.initiator.length);
        this.auxSecretIDr = this.computeHmac(randBuf, 32, ZrtpConstants.responder, ZrtpConstants.responder.length);
        if (!zidRec.isMITMKeyAvailable()) {
            this.secRand.nextBytes(randBuf);
            this.pbxSecretIDi = this.computeHmac(randBuf, 32, ZrtpConstants.initiator, ZrtpConstants.initiator.length);
            this.pbxSecretIDr = this.computeHmac(randBuf, 32, ZrtpConstants.responder, ZrtpConstants.responder.length);
        } else {
            this.pbxSecretIDi = this.computeHmac(zidRec.getMiTMData(), 32, ZrtpConstants.initiator, ZrtpConstants.initiator.length);
            this.pbxSecretIDr = this.computeHmac(zidRec.getMiTMData(), 32, ZrtpConstants.responder, ZrtpConstants.responder.length);
        }
    }

    private void generateKeysMultiStream() {
        byte[] KDFcontext = new byte[this.zid.length + this.peerZid.length + this.hashLength];
        if (this.myRole == ZrtpCallback.Role.Responder) {
            System.arraycopy(this.peerZid, 0, KDFcontext, 0, this.peerZid.length);
            System.arraycopy(this.zid, 0, KDFcontext, this.peerZid.length, this.zid.length);
        } else {
            System.arraycopy(this.zid, 0, KDFcontext, 0, this.zid.length);
            System.arraycopy(this.peerZid, 0, KDFcontext, this.zid.length, this.peerZid.length);
        }
        System.arraycopy(this.messageHash, 0, KDFcontext, this.zid.length + this.peerZid.length, this.hashLength);
        this.s0 = this.KDF(this.zrtpSession, ZrtpConstants.zrtpMsk, KDFcontext, this.hashLength * 8);
        this.computeSRTPKeys();
        Arrays.fill(this.s0, (byte)0);
    }

    private byte[] KDF(byte[] ki, byte[] label, byte[] context, int L) {
        KeyParameter key = new KeyParameter(ki, 0, this.hashLength);
        this.hmacFunction.init((CipherParameters)key);
        byte[] counter = ZrtpUtils.int32ToArray(1);
        this.hmacFunction.update(counter, 0, 4);
        this.hmacFunction.update(label, 0, label.length);
        this.hmacFunction.update(context, 0, context.length);
        byte[] length = ZrtpUtils.int32ToArray(L);
        this.hmacFunction.update(length, 0, 4);
        byte[] retval = new byte[this.hashLength];
        this.hmacFunction.doFinal(retval, 0);
        return retval;
    }

    private void computeSRTPKeys() {
        byte[] KDFcontext = new byte[this.zid.length + this.peerZid.length + this.hashLength];
        if (this.myRole == ZrtpCallback.Role.Responder) {
            System.arraycopy(this.peerZid, 0, KDFcontext, 0, this.peerZid.length);
            System.arraycopy(this.zid, 0, KDFcontext, this.peerZid.length, this.zid.length);
        } else {
            System.arraycopy(this.zid, 0, KDFcontext, 0, this.zid.length);
            System.arraycopy(this.peerZid, 0, KDFcontext, this.zid.length, this.peerZid.length);
        }
        System.arraycopy(this.messageHash, 0, KDFcontext, this.zid.length + this.peerZid.length, this.hashLength);
        int keyLen = this.cipher.keyLength * 8;
        this.srtpKeyI = this.KDF(this.s0, ZrtpConstants.iniMasterKey, KDFcontext, keyLen);
        this.srtpSaltI = this.KDF(this.s0, ZrtpConstants.iniMasterSalt, KDFcontext, 112);
        this.srtpKeyR = this.KDF(this.s0, ZrtpConstants.respMasterKey, KDFcontext, keyLen);
        this.srtpSaltR = this.KDF(this.s0, ZrtpConstants.respMasterSalt, KDFcontext, 112);
        this.hmacKeyI = this.KDF(this.s0, ZrtpConstants.iniHmacKey, KDFcontext, this.hashLength * 8);
        this.hmacKeyR = this.KDF(this.s0, ZrtpConstants.respHmacKey, KDFcontext, this.hashLength * 8);
        this.zrtpKeyI = this.KDF(this.s0, ZrtpConstants.iniZrtpKey, KDFcontext, keyLen);
        this.zrtpKeyR = this.KDF(this.s0, ZrtpConstants.respZrtpKey, KDFcontext, keyLen);
        if (!this.multiStream) {
            this.newRs1 = this.KDF(this.s0, ZrtpConstants.retainedSec, KDFcontext, 256);
            this.zrtpSession = this.KDF(this.s0, ZrtpConstants.zrtpSessionKey, KDFcontext, this.hashLength * 8);
            this.sasHash = this.KDF(this.s0, ZrtpConstants.sasString, KDFcontext, 256);
            if (this.sasType == ZrtpConstants.SupportedSASTypes.B32) {
                byte[] sasBytes = new byte[]{this.sasHash[0], this.sasHash[1], (byte)(this.sasHash[2] & 0xF0), 0};
                this.SAS = Base32.binary2ascii(sasBytes, 20);
            } else {
                this.SAS = ZrtpConstants.sas256WordsEven[this.sasHash[0] & 0xFF] + ":" + ZrtpConstants.sas256WordsOdd[this.sasHash[1] & 0xFF];
            }
            if (this.signSasSeen) {
                this.callback.signSAS(this.sasHash);
            }
        }
    }

    private void computePBXSecret() {
        byte[] KDFcontext = new byte[this.zid.length + this.peerZid.length];
        if (this.myRole == ZrtpCallback.Role.Responder) {
            System.arraycopy(this.peerZid, 0, KDFcontext, 0, this.peerZid.length);
            System.arraycopy(this.zid, 0, KDFcontext, this.peerZid.length, this.zid.length);
        } else {
            System.arraycopy(this.zid, 0, KDFcontext, 0, this.zid.length);
            System.arraycopy(this.peerZid, 0, KDFcontext, this.zid.length, this.peerZid.length);
        }
        this.pbxSecretTmp = this.KDF(this.zrtpSession, ZrtpConstants.zrtpTrustedMitm, KDFcontext, 256);
    }

    private void generateKeysInitiator(ZrtpPacketDHPart dhPart, ZidRecord zidRec) {
        byte[][] setD = new byte[3][];
        int rsFound = 0;
        setD[2] = null;
        setD[1] = null;
        setD[0] = null;
        if (ZrtpUtils.byteArrayCompare(this.rs1IDr, dhPart.getRs1Id(), 8) == 0) {
            setD[0] = zidRec.getRs1();
            rsFound = 1;
        } else if (ZrtpUtils.byteArrayCompare(this.rs1IDr, dhPart.getRs2Id(), 8) == 0) {
            setD[0] = zidRec.getRs1();
            rsFound = 2;
        } else if (ZrtpUtils.byteArrayCompare(this.rs2IDr, dhPart.getRs1Id(), 8) == 0) {
            setD[0] = zidRec.getRs2();
            rsFound = 4;
        } else if (ZrtpUtils.byteArrayCompare(this.rs2IDr, dhPart.getRs2Id(), 8) == 0) {
            setD[0] = zidRec.getRs2();
            rsFound = 8;
        }
        if (ZrtpUtils.byteArrayCompare(this.pbxSecretIDr, dhPart.getPbxSecretId(), 8) == 0) {
            setD[2] = zidRec.getMiTMData();
        }
        if (rsFound == 0) {
            if (this.rs1Valid || this.rs2Valid) {
                this.sendInfo(ZrtpCodes.MessageSeverity.Warning, EnumSet.of(ZrtpCodes.WarningCodes.WarningNoExpectedRSMatch));
                zidRec.resetSasVerified();
            } else {
                this.sendInfo(ZrtpCodes.MessageSeverity.Warning, EnumSet.of(ZrtpCodes.WarningCodes.WarningNoRSMatch));
            }
        } else {
            this.sendInfo(ZrtpCodes.MessageSeverity.Info, EnumSet.of(ZrtpCodes.InfoCodes.InfoRSMatchFound));
        }
        byte[] counter = ZrtpUtils.int32ToArray(1);
        this.hashFunction.update(counter, 0, 4);
        this.hashFunction.update(this.DHss, 0, this.DHss.length);
        this.hashFunction.update(ZrtpConstants.KDFString, 0, ZrtpConstants.KDFString.length);
        this.hashFunction.update(this.zid, 0, this.zid.length);
        this.hashFunction.update(this.peerZid, 0, this.peerZid.length);
        this.hashFunction.update(this.messageHash, 0, this.hashLength);
        byte[] secretHashLen = ZrtpUtils.int32ToArray(32);
        byte[] nullinger = new byte[4];
        Arrays.fill(nullinger, (byte)0);
        for (int i = 0; i < 3; ++i) {
            if (setD[i] != null) {
                this.hashFunction.update(secretHashLen, 0, secretHashLen.length);
                this.hashFunction.update(setD[i], 0, setD[i].length);
                continue;
            }
            this.hashFunction.update(nullinger, 0, nullinger.length);
        }
        this.s0 = new byte[64];
        this.hashFunction.doFinal(this.s0, 0);
        Arrays.fill(this.DHss, (byte)0);
        this.DHss = null;
        this.computeSRTPKeys();
        Arrays.fill(this.s0, (byte)0);
    }

    private void generateKeysResponder(ZrtpPacketDHPart dhPart, ZidRecord zidRec) {
        byte[][] setD = new byte[3][];
        int rsFound = 0;
        setD[2] = null;
        setD[1] = null;
        setD[0] = null;
        if (ZrtpUtils.byteArrayCompare(this.rs1IDi, dhPart.getRs1Id(), 8) == 0) {
            setD[0] = zidRec.getRs1();
            rsFound = 1;
        } else if (ZrtpUtils.byteArrayCompare(this.rs1IDi, dhPart.getRs2Id(), 8) == 0) {
            setD[0] = zidRec.getRs1();
            rsFound = 2;
        } else if (ZrtpUtils.byteArrayCompare(this.rs2IDi, dhPart.getRs1Id(), 8) == 0) {
            setD[0] = zidRec.getRs2();
            rsFound = 4;
        } else if (ZrtpUtils.byteArrayCompare(this.rs2IDi, dhPart.getRs2Id(), 8) == 0) {
            setD[0] = zidRec.getRs2();
            rsFound = 8;
        }
        if (ZrtpUtils.byteArrayCompare(this.pbxSecretIDi, dhPart.getPbxSecretId(), 8) == 0) {
            setD[2] = zidRec.getMiTMData();
        }
        if (rsFound == 0) {
            if (this.rs1Valid || this.rs2Valid) {
                this.sendInfo(ZrtpCodes.MessageSeverity.Warning, EnumSet.of(ZrtpCodes.WarningCodes.WarningNoExpectedRSMatch));
                zidRec.resetSasVerified();
            } else {
                this.sendInfo(ZrtpCodes.MessageSeverity.Warning, EnumSet.of(ZrtpCodes.WarningCodes.WarningNoRSMatch));
            }
        } else {
            this.sendInfo(ZrtpCodes.MessageSeverity.Info, EnumSet.of(ZrtpCodes.InfoCodes.InfoRSMatchFound));
        }
        byte[] counter = ZrtpUtils.int32ToArray(1);
        this.hashFunction.update(counter, 0, 4);
        this.hashFunction.update(this.DHss, 0, this.DHss.length);
        this.hashFunction.update(ZrtpConstants.KDFString, 0, ZrtpConstants.KDFString.length);
        this.hashFunction.update(this.peerZid, 0, this.peerZid.length);
        this.hashFunction.update(this.zid, 0, this.zid.length);
        this.hashFunction.update(this.messageHash, 0, this.hashLength);
        byte[] secretHashLen = ZrtpUtils.int32ToArray(32);
        byte[] nullinger = new byte[4];
        Arrays.fill(nullinger, (byte)0);
        for (int i = 0; i < 3; ++i) {
            if (setD[i] != null) {
                this.hashFunction.update(secretHashLen, 0, secretHashLen.length);
                this.hashFunction.update(setD[i], 0, setD[i].length);
                continue;
            }
            this.hashFunction.update(nullinger, 0, nullinger.length);
        }
        this.s0 = new byte[64];
        this.hashFunction.doFinal(this.s0, 0);
        Arrays.fill(this.DHss, (byte)0);
        this.DHss = null;
        this.computeSRTPKeys();
        Arrays.fill(this.s0, (byte)0);
    }

    private boolean checkPubKey(BigIntegerCrypto pvr, ZrtpConstants.SupportedPubKeys dhtype) {
        if (pvr.equals(BigIntegerCrypto.ONE)) {
            return false;
        }
        if (dhtype == ZrtpConstants.SupportedPubKeys.DH2K) {
            return !pvr.equals(ZrtpConstants.P2048MinusOne);
        }
        if (dhtype == ZrtpConstants.SupportedPubKeys.DH3K) {
            return !pvr.equals(ZrtpConstants.P3072MinusOne);
        }
        return false;
    }

    static class HelloPacketVersion {
        int version;
        ZrtpPacketHello packet;
        byte[] helloHash;

        HelloPacketVersion() {
        }
    }
}

