/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.notify;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jitsi.impl.neomedia.NeomediaServiceUtils;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.impl.neomedia.device.DeviceConfiguration;
import org.jitsi.impl.neomedia.notify.AudioSystemClipImpl;
import org.jitsi.impl.neomedia.notify.JavaSoundClipImpl;
import org.jitsi.service.audionotifier.AudioNotifierService;
import org.jitsi.service.audionotifier.SCAudioClip;

public class AudioNotifierServiceImpl
implements AudioNotifierService,
PropertyChangeListener {
    private Map<AudioKey, SCAudioClip> audios;
    private final Object audiosSyncRoot = new Object();
    private final DeviceConfiguration deviceConfiguration = NeomediaServiceUtils.getMediaServiceImpl().getDeviceConfiguration();
    private boolean mute;

    public AudioNotifierServiceImpl() {
        this.deviceConfiguration.addPropertyChangeListener(this);
    }

    public boolean audioOutAndNotificationsShareSameDevice() {
        AudioSystem audioSystem = this.getDeviceConfiguration().getAudioSystem();
        CaptureDeviceInfo2 notify = audioSystem.getSelectedDevice(AudioSystem.DataFlow.NOTIFY);
        CaptureDeviceInfo2 playback = audioSystem.getSelectedDevice(AudioSystem.DataFlow.PLAYBACK);
        return notify == null ? playback == null : notify.getLocator().equals((Object)playback.getLocator());
    }

    public SCAudioClip createAudio(String uri) {
        return this.createAudio(uri, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SCAudioClip createAudio(String uri, boolean playback) {
        Object audio;
        Object object = this.audiosSyncRoot;
        synchronized (object) {
            final AudioKey key = new AudioKey(uri, playback);
            SCAudioClip sCAudioClip = audio = this.audios == null ? null : this.audios.remove(key);
            if (audio == null) {
                try {
                    AudioSystem audioSystem = this.getDeviceConfiguration().getAudioSystem();
                    audio = audioSystem == null ? new JavaSoundClipImpl(uri, this) : ("none".equalsIgnoreCase(audioSystem.getLocatorProtocol()) ? null : new AudioSystemClipImpl(uri, this, audioSystem, playback));
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    return null;
                }
            }
            if (audio != null) {
                if (this.audios == null) {
                    this.audios = new HashMap<AudioKey, SCAudioClip>();
                }
                final Map<AudioKey, SCAudioClip> finalAudios = this.audios;
                final SCAudioClip finalAudio = audio;
                audio = new SCAudioClip(){

                    private Boolean evaluateLoopCondition(Callable<Boolean> loopCondition) throws Exception {
                        return loopCondition == null ? Boolean.FALSE : loopCondition.call();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void finalize() throws Throwable {
                        try {
                            Map map = AudioNotifierServiceImpl.this.audios;
                            synchronized (map) {
                                finalAudios.put(key, finalAudio);
                            }
                            Object var4_3 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            super.finalize();
                            throw throwable;
                        }
                        super.finalize();
                    }

                    @Override
                    public void play() {
                        this.play(-1, null);
                    }

                    @Override
                    public void play(int loopInterval, final Callable<Boolean> finalLoopCondition) {
                        Callable<Boolean> loopCondition = new Callable<Boolean>(){

                            @Override
                            public Boolean call() throws Exception {
                                return this.evaluateLoopCondition(finalLoopCondition);
                            }
                        };
                        finalAudio.play(loopInterval, loopCondition);
                    }

                    @Override
                    public void stop() {
                        finalAudio.stop();
                    }

                    @Override
                    public boolean isStarted() {
                        return finalAudio.isStarted();
                    }
                };
            }
        }
        return audio;
    }

    public DeviceConfiguration getDeviceConfiguration() {
        return this.deviceConfiguration;
    }

    public boolean isMute() {
        return this.mute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent ev) {
        String propertyName = ev.getPropertyName();
        if ("notifyDevice".equals(propertyName) || "playbackDevice".equals(propertyName)) {
            Object object = this.audiosSyncRoot;
            synchronized (object) {
                this.audios = null;
            }
        }
    }

    public void setMute(boolean mute) {
        this.mute = mute;
    }

    private static class AudioKey {
        private final boolean playback;
        final String uri;

        private AudioKey(String uri, boolean playback) {
            this.uri = uri;
            this.playback = playback;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            AudioKey that = (AudioKey)o;
            return this.playback == that.playback && (this.uri == null ? that.uri == null : this.uri.equals(that.uri));
        }

        public int hashCode() {
            return (this.uri == null ? 0 : this.uri.hashCode()) + (this.playback ? 1 : 0);
        }
    }
}

