/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.renderer.audio;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import net.sf.fmj.media.util.MediaThread;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.impl.neomedia.jmfext.media.renderer.AbstractRenderer;
import org.jitsi.util.event.PropertyChangeNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAudioRenderer<T extends AudioSystem>
extends AbstractRenderer<AudioFormat> {
    protected final T audioSystem;
    protected final AudioSystem.DataFlow dataFlow;
    private MediaLocator locator;
    private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent ev) {
            AbstractAudioRenderer.this.propertyChange(ev);
        }
    };

    protected AbstractAudioRenderer(T audioSystem) {
        this(audioSystem, AudioSystem.DataFlow.PLAYBACK);
    }

    protected AbstractAudioRenderer(T audioSystem, AudioSystem.DataFlow dataFlow) {
        if (dataFlow != AudioSystem.DataFlow.NOTIFY && dataFlow != AudioSystem.DataFlow.PLAYBACK) {
            throw new IllegalArgumentException("dataFlow");
        }
        this.audioSystem = audioSystem;
        this.dataFlow = dataFlow;
    }

    protected AbstractAudioRenderer(String locatorProtocol) {
        this(AudioSystem.getAudioSystem(locatorProtocol));
    }

    public void close() {
        if (this.audioSystem != null) {
            ((PropertyChangeNotifier)this.audioSystem).removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public MediaLocator getLocator() {
        CaptureDeviceInfo2 device;
        MediaLocator locator = this.locator;
        if (locator == null && this.audioSystem != null && (device = ((AudioSystem)this.audioSystem).getSelectedDevice(this.dataFlow)) != null) {
            locator = device.getLocator();
        }
        return locator;
    }

    public Format[] getSupportedInputFormats() {
        return ((AudioSystem)this.audioSystem).getDevice(this.dataFlow, this.getLocator()).getFormats();
    }

    public void open() throws ResourceUnavailableException {
        MediaLocator locator;
        if (this.locator == null && this.audioSystem != null && (locator = this.getLocator()) != null) {
            ((PropertyChangeNotifier)this.audioSystem).addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void playbackDevicePropertyChange(PropertyChangeEvent ev) {
    }

    private void propertyChange(PropertyChangeEvent ev) {
        String propertyName;
        switch (this.dataFlow) {
            case NOTIFY: {
                propertyName = "notifyDevice";
                break;
            }
            case PLAYBACK: {
                propertyName = "playbackDevice";
                break;
            }
            default: {
                return;
            }
        }
        if (propertyName.equals(ev.getPropertyName())) {
            this.playbackDevicePropertyChange(ev);
        }
    }

    public void setLocator(MediaLocator locator) {
        if (this.locator == null ? locator == null : this.locator.equals((Object)locator)) {
            return;
        }
        this.locator = locator;
    }

    public static void useAudioThreadPriority() {
        AbstractAudioRenderer.useThreadPriority(MediaThread.getAudioPriority());
    }
}

