/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.directshow;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.FormatControl;
import javax.media.control.FrameRateControl;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.PushBufferStream;
import net.java.sip.communicator.impl.neomedia.directshow.DSCaptureDevice;
import org.jitsi.impl.neomedia.codec.video.AVFrame;
import org.jitsi.impl.neomedia.codec.video.AVFrameFormat;
import org.jitsi.impl.neomedia.codec.video.ByteBuffer;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPushBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.ByteBufferPool;
import org.jitsi.impl.neomedia.jmfext.media.protocol.directshow.DataSource;

public class DirectShowStream
extends AbstractPushBufferStream {
    private boolean automaticallyDropsLateVideoFrames = false;
    private final ByteBufferPool byteBufferPool = new ByteBufferPool();
    private ByteBuffer data;
    private final Object dataSyncRoot = new Object();
    private long dataTimeStamp;
    private final Format format;
    final DSCaptureDevice.GrabberDelegate grabber = new DSCaptureDevice.GrabberDelegate(){

        public void frameReceived(long ptr, int length) {
            DirectShowStream.this.processFrame(ptr, length);
        }
    };
    private ByteBuffer nextData;
    private long nextDataTimeStamp;
    private Thread transferDataThread;

    DirectShowStream(DataSource dataSource, FormatControl formatControl) {
        super(dataSource, formatControl);
        this.format = (VideoFormat)formatControl.getFormat();
    }

    protected Format doGetFormat() {
        return this.format == null ? super.doGetFormat() : this.format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFrame(long ptr, int length) {
        BufferTransferHandler transferHandler;
        boolean transferData = false;
        Object object = this.dataSyncRoot;
        synchronized (object) {
            if (!this.automaticallyDropsLateVideoFrames && this.data != null) {
                if (this.nextData != null) {
                    this.nextData.free();
                    this.nextData = null;
                }
                this.nextData = this.byteBufferPool.getBuffer(length);
                if (this.nextData != null) {
                    this.nextData.setLength(DSCaptureDevice.getBytes(ptr, this.nextData.getPtr(), this.nextData.getCapacity()));
                    this.nextDataTimeStamp = System.nanoTime();
                }
                return;
            }
            if (this.data != null) {
                this.data.free();
                this.data = null;
            }
            this.data = this.byteBufferPool.getBuffer(length);
            if (this.data != null) {
                this.data.setLength(DSCaptureDevice.getBytes(ptr, this.data.getPtr(), this.data.getCapacity()));
                this.dataTimeStamp = System.nanoTime();
            }
            if (this.nextData != null) {
                this.nextData.free();
                this.nextData = null;
            }
            if (this.automaticallyDropsLateVideoFrames) {
                transferData = this.data != null;
            } else {
                transferData = false;
                this.dataSyncRoot.notifyAll();
            }
        }
        if (transferData && (transferHandler = this.transferHandler) != null) {
            transferHandler.transferData((PushBufferStream)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Buffer buffer) throws IOException {
        Object object = this.dataSyncRoot;
        synchronized (object) {
            if (this.data == null) {
                buffer.setLength(0);
                return;
            }
            Format bufferFormat = buffer.getFormat();
            if (bufferFormat == null && (bufferFormat = this.getFormat()) != null) {
                buffer.setFormat(bufferFormat);
            }
            if (bufferFormat instanceof AVFrameFormat) {
                if (AVFrame.read(buffer, bufferFormat, this.data) < 0) {
                    this.data.free();
                }
                this.data = null;
            } else {
                byte[] bytes;
                Object o = buffer.getData();
                int length = this.data.getLength();
                if (o instanceof byte[]) {
                    bytes = (byte[])o;
                    if (bytes.length < length) {
                        bytes = null;
                    }
                } else {
                    bytes = null;
                }
                if (bytes == null) {
                    bytes = new byte[length];
                    buffer.setData((Object)bytes);
                }
                this.data.free();
                this.data = null;
                buffer.setLength(length);
                buffer.setOffset(0);
            }
            buffer.setFlags(32896);
            buffer.setTimeStamp(this.dataTimeStamp);
            if (!this.automaticallyDropsLateVideoFrames) {
                this.dataSyncRoot.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInTransferDataThread() {
        boolean transferData = false;
        FrameRateControl frameRateControl = (FrameRateControl)this.dataSource.getControl(FrameRateControl.class.getName());
        long transferDataTimeStamp = -1L;
        while (Thread.currentThread().equals(this.transferDataThread)) {
            if (transferData) {
                BufferTransferHandler transferHandler = this.transferHandler;
                if (transferHandler != null) {
                    if (frameRateControl != null) {
                        long newTransferDataTimeStamp = System.currentTimeMillis();
                        if (transferDataTimeStamp != -1L) {
                            long t;
                            long minimumVideoFrameInterval;
                            float f;
                            float frameRate = frameRateControl.getFrameRate();
                            if (f > 0.0f && (minimumVideoFrameInterval = (long)(1000.0f / frameRate)) > 0L && (t = newTransferDataTimeStamp - transferDataTimeStamp) > 0L && t < minimumVideoFrameInterval) {
                                boolean interrupted = false;
                                try {
                                    Thread.sleep(minimumVideoFrameInterval - t);
                                }
                                catch (InterruptedException ie) {
                                    interrupted = true;
                                }
                                if (!interrupted) continue;
                                Thread.currentThread().interrupt();
                                continue;
                            }
                        }
                        transferDataTimeStamp = newTransferDataTimeStamp;
                    }
                    transferHandler.transferData((PushBufferStream)this);
                }
                Object frameRate = this.dataSyncRoot;
                synchronized (frameRate) {
                    if (this.data != null) {
                        this.data.free();
                    }
                    this.data = this.nextData;
                    this.dataTimeStamp = this.nextDataTimeStamp;
                    this.nextData = null;
                }
            }
            Object object = this.dataSyncRoot;
            synchronized (object) {
                if (this.data == null) {
                    this.data = this.nextData;
                    this.dataTimeStamp = this.nextDataTimeStamp;
                    this.nextData = null;
                }
                if (this.data == null) {
                    boolean interrupted = false;
                    try {
                        this.dataSyncRoot.wait();
                    }
                    catch (InterruptedException iex) {
                        interrupted = true;
                    }
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    transferData = this.data != null;
                } else {
                    transferData = true;
                }
            }
        }
    }

    public void start() throws IOException {
        super.start();
        if (!this.automaticallyDropsLateVideoFrames) {
            this.transferDataThread = new Thread(this.getClass().getSimpleName()){

                public void run() {
                    DirectShowStream.this.runInTransferDataThread();
                }
            };
            this.transferDataThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        try {
            this.transferDataThread = null;
            Object object = this.dataSyncRoot;
            synchronized (object) {
                if (this.data != null) {
                    this.data.free();
                    this.data = null;
                }
                if (this.nextData != null) {
                    this.nextData.free();
                    this.nextData = null;
                }
                if (!this.automaticallyDropsLateVideoFrames) {
                    this.dataSyncRoot.notifyAll();
                }
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            super.stop();
            this.byteBufferPool.drain();
            throw throwable;
        }
        super.stop();
        this.byteBufferPool.drain();
    }
}

