/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.directshow;

import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.control.FormatControl;
import javax.media.control.FrameRateControl;
import javax.media.format.VideoFormat;
import net.java.sip.communicator.impl.neomedia.directshow.DSCaptureDevice;
import net.java.sip.communicator.impl.neomedia.directshow.DSFormat;
import net.java.sip.communicator.impl.neomedia.directshow.DSManager;
import org.jitsi.impl.neomedia.codec.FFmpeg;
import org.jitsi.impl.neomedia.codec.video.AVFrameFormat;
import org.jitsi.impl.neomedia.control.FrameRateControlAdapter;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPushBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractVideoPushBufferCaptureDevice;
import org.jitsi.impl.neomedia.jmfext.media.protocol.directshow.DirectShowStream;
import org.jitsi.util.Logger;

public class DataSource
extends AbstractVideoPushBufferCaptureDevice {
    private static final long[] DS_TO_FFMPEG_PIX_FMTS = new long[]{DSFormat.RGB24, FFmpeg.PIX_FMT_RGB24, DSFormat.RGB32, FFmpeg.PIX_FMT_RGB32, DSFormat.ARGB32, 27L, DSFormat.YUY2, 1L, DSFormat.UYVY, 17L, DSFormat.Y411, 18L, DSFormat.Y41P, 7L, DSFormat.NV12, 25L, DSFormat.I420, 0L};
    private static final Logger logger = Logger.getLogger(DataSource.class);
    private DSCaptureDevice device = null;
    private DSCaptureDevice.GrabberDelegate grabber = null;
    private DSManager manager = DSManager.getInstance();
    private DSFormat nativeFormat = null;

    public static long getDSPixFmt(int ffmpegPixFmt) {
        for (int i = 0; i < DS_TO_FFMPEG_PIX_FMTS.length; i += 2) {
            if (DS_TO_FFMPEG_PIX_FMTS[i + 1] != (long)ffmpegPixFmt) continue;
            return DS_TO_FFMPEG_PIX_FMTS[i];
        }
        return -1L;
    }

    public static long getFFmpegPixFmt(long dsPixFmt) {
        for (int i = 0; i < DS_TO_FFMPEG_PIX_FMTS.length; i += 2) {
            if (DS_TO_FFMPEG_PIX_FMTS[i] != dsPixFmt) continue;
            return DS_TO_FFMPEG_PIX_FMTS[i + 1];
        }
        return -1L;
    }

    public DataSource() {
    }

    public DataSource(MediaLocator locator) {
        super(locator);
    }

    protected FrameRateControl createFrameRateControl() {
        return new FrameRateControlAdapter(){
            private float frameRate = -1.0f;

            public float getFrameRate() {
                return this.frameRate;
            }

            public float setFrameRate(float frameRate) {
                this.frameRate = frameRate;
                return this.frameRate;
            }
        };
    }

    protected AbstractPushBufferStream createStream(int streamIndex, FormatControl formatControl) {
        DirectShowStream stream = new DirectShowStream(this, formatControl);
        if (logger.isTraceEnabled()) {
            DSFormat[] deviceFmts;
            for (DSFormat deviceFmt : deviceFmts = this.device.getSupportedFormats()) {
                logger.trace("width= " + deviceFmt.getWidth() + ", height= " + deviceFmt.getHeight() + ", pixelFormat= " + deviceFmt.getPixelFormat());
            }
        }
        this.grabber = stream.grabber;
        return stream;
    }

    protected void doConnect() throws IOException {
        if (logger.isInfoEnabled()) {
            logger.info("doConnect");
        }
        if (this.manager == null) {
            this.manager = DSManager.getInstance();
        }
        this.setLocator(this.getLocator());
        super.doConnect();
    }

    protected void doDisconnect() {
        if (logger.isInfoEnabled()) {
            logger.info("doDisconnect");
        }
        super.doDisconnect();
        if (this.manager != null) {
            this.device.setDelegate(null);
            this.device = null;
            DSManager.dispose();
            this.manager = null;
        }
    }

    protected void doStart() throws IOException {
        if (logger.isInfoEnabled()) {
            logger.info("start");
        }
        this.device.open();
        if (this.nativeFormat != null) {
            this.device.setFormat(this.nativeFormat);
        }
        this.device.setDelegate(this.grabber);
        super.doStart();
    }

    protected void doStop() throws IOException {
        if (logger.isInfoEnabled()) {
            logger.info("stop");
        }
        super.doStop();
        this.device.close();
    }

    protected Format[] getSupportedFormats(int streamIndex) {
        if (this.device == null) {
            return new Format[0];
        }
        DSFormat[] deviceFmts = this.device.getSupportedFormats();
        ArrayList<AVFrameFormat> fmts = new ArrayList<AVFrameFormat>(deviceFmts.length);
        for (DSFormat deviceFmt : deviceFmts) {
            Dimension size = new Dimension(deviceFmt.getWidth(), deviceFmt.getHeight());
            long devicePixFmt = deviceFmt.getPixelFormat();
            int pixFmt = (int)DataSource.getFFmpegPixFmt(devicePixFmt);
            fmts.add(new AVFrameFormat(size, -1.0f, pixFmt, (int)devicePixFmt));
        }
        return fmts.toArray(new Format[fmts.size()]);
    }

    private void setDevice(DSCaptureDevice device) {
        this.device = device;
    }

    protected Format setFormat(int streamIndex, Format oldValue, Format newValue) {
        if (newValue instanceof VideoFormat) {
            AVFrameFormat avFrameFormat;
            long pixFmt;
            if (newValue instanceof AVFrameFormat && (pixFmt = (long)(avFrameFormat = (AVFrameFormat)newValue).getDeviceSystemPixFmt()) != -1L) {
                Dimension size = avFrameFormat.getSize();
                this.nativeFormat = new DSFormat(size.width, size.height, pixFmt);
            }
            return newValue;
        }
        return super.setFormat(streamIndex, oldValue, newValue);
    }

    public void setLocator(MediaLocator locator) {
        DSCaptureDevice device = null;
        logger.info("set locator to " + locator);
        if (this.getLocator() == null) {
            super.setLocator(locator);
        }
        locator = this.getLocator();
        logger.info("getLocator() returns " + locator);
        if (locator != null && "directshow".equalsIgnoreCase(locator.getProtocol())) {
            DSCaptureDevice[] devices = this.manager.getCaptureDevices();
            logger.info("Search directshow device...");
            for (int i = 0; i < devices.length; ++i) {
                if (!devices[i].getName().equals(locator.getRemainder())) continue;
                device = devices[i];
                logger.info("Set directshow device: " + device);
                break;
            }
            if (device == null) {
                logger.info("No devices matches locator's remainder: " + locator.getRemainder());
            }
        } else {
            logger.info("MediaLocator either null or does not have right protocol");
            device = null;
        }
        this.setDevice(device);
    }
}

