/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.Renderer;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.MediaUtils;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.PulseAudioRenderer;
import org.jitsi.impl.neomedia.pulseaudio.PA;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PulseAudioSystem
extends AudioSystem {
    private static final String LOCATOR_PROTOCOL = "pulseaudio";
    public static final String MEDIA_ROLE_EVENT = "event";
    public static final String MEDIA_ROLE_PHONE = "phone";
    private static final String NULL_DEV_CAPTURE_DEVICE_INFO_NAME = "Default";
    private boolean createContext;
    private long context;
    private long mainloop;

    public static void corkStream(long stream, boolean b) throws IOException {
        if (stream == 0L) {
            throw new IOException("stream");
        }
        long o = PA.stream_cork(stream, b, null);
        if (o == 0L) {
            throw new IOException("pa_stream_cork");
        }
        PA.operation_unref(o);
    }

    public static PulseAudioSystem getPulseAudioSystem() {
        AudioSystem audioSystem = AudioSystem.getAudioSystem(LOCATOR_PROTOCOL);
        return audioSystem instanceof PulseAudioSystem ? (PulseAudioSystem)audioSystem : null;
    }

    public PulseAudioSystem() throws Exception {
        super(LOCATOR_PROTOCOL, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createContext() {
        if (this.context != 0L) {
            throw new IllegalStateException("context");
        }
        this.startMainloop();
        try {
            block17: {
                long proplist = PA.proplist_new();
                if (proplist == 0L) {
                    throw new RuntimeException("pa_proplist_new");
                }
                try {
                    block16: {
                        this.populateContextProplist(proplist);
                        long context = PA.context_new_with_proplist(PA.threaded_mainloop_get_api(this.mainloop), null, proplist);
                        if (context == 0L) {
                            throw new RuntimeException("pa_context_new_with_proplist");
                        }
                        try {
                            if (proplist != 0L) {
                                PA.proplist_free(proplist);
                                proplist = 0L;
                            }
                            Runnable stateCallback = new Runnable(){

                                public void run() {
                                    PulseAudioSystem.this.signalMainloop(false);
                                }
                            };
                            this.lockMainloop();
                            try {
                                block15: {
                                    PA.context_set_state_callback(context, stateCallback);
                                    PA.context_connect(context, null, 0, 0L);
                                    try {
                                        int state = this.waitForContextState(context, 4);
                                        if (state != 4) {
                                            throw new IllegalStateException("context.state");
                                        }
                                        this.context = context;
                                        Object var8_5 = null;
                                        if (this.context != 0L) break block15;
                                    }
                                    catch (Throwable throwable) {
                                        Object var8_6 = null;
                                        if (this.context != 0L) throw throwable;
                                        PA.context_disconnect(context);
                                        throw throwable;
                                    }
                                    PA.context_disconnect(context);
                                }
                                Object var10_8 = null;
                                this.unlockMainloop();
                            }
                            catch (Throwable throwable) {
                                Object var10_9 = null;
                                this.unlockMainloop();
                                throw throwable;
                            }
                            Object var12_11 = null;
                            if (this.context != 0L) break block16;
                        }
                        catch (Throwable throwable) {
                            Object var12_12 = null;
                            if (this.context != 0L) throw throwable;
                            PA.context_unref(context);
                            throw throwable;
                        }
                        PA.context_unref(context);
                    }
                    Object var14_14 = null;
                    if (proplist == 0L) break block17;
                }
                catch (Throwable throwable) {
                    Object var14_15 = null;
                    if (proplist == 0L) throw throwable;
                    PA.proplist_free(proplist);
                    throw throwable;
                }
                PA.proplist_free(proplist);
            }
            Object var16_17 = null;
            if (this.context != 0L) return;
            this.stopMainloop();
            return;
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            if (this.context != 0L) throw throwable;
            this.stopMainloop();
            throw throwable;
        }
    }

    @Override
    public Renderer createRenderer(boolean playback) {
        MediaLocator locator;
        if (playback) {
            locator = null;
        } else {
            CaptureDeviceInfo2 device = this.getSelectedDevice(AudioSystem.DataFlow.NOTIFY);
            if (device == null) {
                return null;
            }
            locator = device.getLocator();
        }
        PulseAudioRenderer renderer = new PulseAudioRenderer(playback ? MEDIA_ROLE_PHONE : MEDIA_ROLE_EVENT);
        if (renderer != null && locator != null) {
            renderer.setLocator(locator);
        }
        return renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long createStream(int sampleRate, int channels, String mediaName, String mediaRole) throws IllegalStateException, RuntimeException {
        long context = this.getContext();
        if (context == 0L) {
            throw new IllegalStateException("context");
        }
        long sampleSpec = PA.sample_spec_new(3, sampleRate, channels);
        if (sampleSpec == 0L) {
            throw new RuntimeException("pa_sample_spec_new");
        }
        long ret = 0L;
        try {
            block11: {
                long proplist = PA.proplist_new();
                if (proplist == 0L) {
                    throw new RuntimeException("pa_proplist_new");
                }
                try {
                    block10: {
                        PA.proplist_sets(proplist, "media.name", mediaRole);
                        PA.proplist_sets(proplist, "media.role", mediaRole);
                        long stream = PA.stream_new_with_proplist(context, null, sampleSpec, 0L, proplist);
                        if (stream == 0L) {
                            throw new RuntimeException("pa_stream_new_with_proplist");
                        }
                        try {
                            ret = stream;
                            Object var16_10 = null;
                            if (ret != 0L) break block10;
                        }
                        catch (Throwable throwable) {
                            Object var16_11 = null;
                            if (ret != 0L) throw throwable;
                            PA.stream_unref(stream);
                            throw throwable;
                        }
                        PA.stream_unref(stream);
                    }
                    Object var18_13 = null;
                    if (proplist == 0L) break block11;
                }
                catch (Throwable throwable) {
                    Object var18_14 = null;
                    if (proplist == 0L) throw throwable;
                    PA.proplist_free(proplist);
                    throw throwable;
                }
                PA.proplist_free(proplist);
            }
            Object var20_16 = null;
            if (sampleSpec == 0L) return ret;
        }
        catch (Throwable throwable) {
            Object var20_17 = null;
            if (sampleSpec == 0L) throw throwable;
            PA.sample_spec_free(sampleSpec);
            throw throwable;
        }
        PA.sample_spec_free(sampleSpec);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void doInitialize() throws Exception {
        long context = this.getContext();
        final LinkedList<CaptureDeviceInfo2> captureDevices = new LinkedList<CaptureDeviceInfo2>();
        final LinkedList captureDeviceFormats = new LinkedList();
        PA.source_info_cb_t sourceInfoListCallback = new PA.source_info_cb_t(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void callback(long c, long i, int eol) {
                try {
                    if (eol == 0 && i != 0L) {
                        PulseAudioSystem.this.sourceInfoListCallback(c, i, captureDevices, captureDeviceFormats);
                    }
                    Object var7_4 = null;
                    PulseAudioSystem.this.signalMainloop(false);
                }
                catch (Throwable throwable) {
                    Object var7_5 = null;
                    PulseAudioSystem.this.signalMainloop(false);
                    throw throwable;
                }
            }
        };
        final LinkedList<CaptureDeviceInfo2> playbackDevices = new LinkedList<CaptureDeviceInfo2>();
        final LinkedList playbackDeviceFormats = new LinkedList();
        PA.sink_info_cb_t sinkInfoListCallback = new PA.sink_info_cb_t(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void callback(long c, long i, int eol) {
                try {
                    if (eol == 0 && i != 0L) {
                        PulseAudioSystem.this.sinkInfoListCallback(c, i, playbackDevices, playbackDeviceFormats);
                    }
                    Object var7_4 = null;
                    PulseAudioSystem.this.signalMainloop(false);
                }
                catch (Throwable throwable) {
                    Object var7_5 = null;
                    PulseAudioSystem.this.signalMainloop(false);
                    throw throwable;
                }
            }
        };
        this.lockMainloop();
        try {
            long o = PA.context_get_source_info_list(context, sourceInfoListCallback);
            if (o == 0L) {
                throw new RuntimeException("pa_context_get_source_info_list");
            }
            try {
                while (PA.operation_get_state(o) == 0) {
                    this.waitMainloop();
                }
                Object var12_9 = null;
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                PA.operation_unref(o);
                throw throwable;
            }
            PA.operation_unref(o);
            o = PA.context_get_sink_info_list(context, sinkInfoListCallback);
            if (o == 0L) {
                throw new RuntimeException("pa_context_get_sink_info_list");
            }
            try {
                while (PA.operation_get_state(o) == 0) {
                    this.waitMainloop();
                }
                Object var14_12 = null;
            }
            catch (Throwable throwable) {
                Object var14_13 = null;
                PA.operation_unref(o);
                throw throwable;
            }
            PA.operation_unref(o);
            Object var16_15 = null;
            this.unlockMainloop();
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            this.unlockMainloop();
            throw throwable;
        }
        if (!captureDeviceFormats.isEmpty()) {
            captureDevices.add(0, new CaptureDeviceInfo2(NULL_DEV_CAPTURE_DEVICE_INFO_NAME, new MediaLocator("pulseaudio:"), captureDeviceFormats.toArray(new Format[captureDeviceFormats.size()]), null, null, null));
        }
        if (!playbackDevices.isEmpty()) {
            playbackDevices.add(0, new CaptureDeviceInfo2(NULL_DEV_CAPTURE_DEVICE_INFO_NAME, new MediaLocator("pulseaudio:"), null, null, null, null));
        }
        this.setCaptureDevices(captureDevices);
        this.setPlaybackDevices(playbackDevices);
    }

    public synchronized long getContext() {
        if (this.context == 0L) {
            if (!this.createContext) {
                this.createContext = true;
                this.createContext();
            }
            if (this.context == 0L) {
                throw new IllegalStateException("context");
            }
        }
        return this.context;
    }

    public void lockMainloop() {
        PA.threaded_mainloop_lock(this.mainloop);
    }

    private void populateContextProplist(long proplist) {
        String applicationVersion;
        String applicationName = System.getProperty("sip-communicator.application.name");
        if (applicationName != null) {
            PA.proplist_sets(proplist, "application.name", applicationName);
        }
        if ((applicationVersion = System.getProperty("sip-communicator.version")) != null) {
            PA.proplist_sets(proplist, "application.version", applicationVersion);
        }
    }

    public void signalMainloop(boolean waitForAccept) {
        PA.threaded_mainloop_signal(this.mainloop, waitForAccept);
    }

    private void sinkInfoListCallback(long context, long sinkInfo, List<CaptureDeviceInfo2> deviceList, List<Format> formatList) {
        int sampleSpecFormat = PA.sink_info_get_sample_spec_format(sinkInfo);
        if (sampleSpecFormat != 3) {
            return;
        }
        String description = PA.sink_info_get_description(sinkInfo);
        String name = PA.sink_info_get_name(sinkInfo);
        if (description == null) {
            description = name;
        }
        deviceList.add(new CaptureDeviceInfo2(description, new MediaLocator("pulseaudio:" + name), null, null, null, null));
    }

    private void sourceInfoListCallback(long context, long sourceInfo, List<CaptureDeviceInfo2> deviceList, List<Format> formatList) {
        AudioFormat audioFormat;
        int monitorOfSink = PA.source_info_get_monitor_of_sink(sourceInfo);
        if (monitorOfSink != -1) {
            return;
        }
        int sampleSpecFormat = PA.source_info_get_sample_spec_format(sourceInfo);
        if (sampleSpecFormat != 3) {
            return;
        }
        int channels = PA.source_info_get_sample_spec_channels(sourceInfo);
        int rate = PA.source_info_get_sample_spec_rate(sourceInfo);
        LinkedList<AudioFormat> sourceInfoFormatList = new LinkedList<AudioFormat>();
        if (MediaUtils.MAX_AUDIO_CHANNELS != -1 && MediaUtils.MAX_AUDIO_CHANNELS < channels) {
            channels = MediaUtils.MAX_AUDIO_CHANNELS;
        }
        if (MediaUtils.MAX_AUDIO_SAMPLE_RATE != -1.0 && MediaUtils.MAX_AUDIO_SAMPLE_RATE < (double)rate) {
            rate = (int)MediaUtils.MAX_AUDIO_SAMPLE_RATE;
        }
        if (!sourceInfoFormatList.contains(audioFormat = new AudioFormat("LINEAR", (double)rate, 16, channels, 0, 1, -1, -1.0, Format.byteArray))) {
            sourceInfoFormatList.add(audioFormat);
            if (!formatList.contains(audioFormat)) {
                formatList.add((Format)audioFormat);
            }
        }
        if (!formatList.isEmpty()) {
            String description = PA.source_info_get_description(sourceInfo);
            String name = PA.source_info_get_name(sourceInfo);
            if (description == null) {
                description = name;
            }
            deviceList.add(new CaptureDeviceInfo2(description, new MediaLocator("pulseaudio:" + name), sourceInfoFormatList.toArray(new Format[sourceInfoFormatList.size()]), null, null, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startMainloop() {
        if (this.mainloop != 0L) {
            throw new IllegalStateException("mainloop");
        }
        long mainloop = PA.threaded_mainloop_new();
        if (mainloop == 0L) {
            throw new RuntimeException("pa_threaded_mainloop_new");
        }
        try {
            if (PA.threaded_mainloop_start(mainloop) < 0) {
                throw new RuntimeException("pa_threaded_mainloop_start");
            }
            this.mainloop = mainloop;
            Object var4_2 = null;
            if (this.mainloop != 0L) return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (this.mainloop != 0L) throw throwable;
            PA.threaded_mainloop_free(mainloop);
            throw throwable;
        }
        PA.threaded_mainloop_free(mainloop);
    }

    private void stopMainloop() {
        if (this.mainloop == 0L) {
            throw new IllegalStateException("mainloop");
        }
        long mainloop = this.mainloop;
        this.mainloop = 0L;
        PA.threaded_mainloop_stop(mainloop);
        PA.threaded_mainloop_free(mainloop);
    }

    @Override
    public String toString() {
        return "PulseAudio";
    }

    public void unlockMainloop() {
        PA.threaded_mainloop_unlock(this.mainloop);
    }

    private int waitForContextState(long context, int stateToWaitFor) {
        int state;
        while (5 != (state = PA.context_get_state(context)) && stateToWaitFor != state && 6 != state) {
            this.waitMainloop();
        }
        return state;
    }

    public int waitForStreamState(long stream, int stateToWaitFor) {
        int state;
        while (stateToWaitFor != (state = PA.stream_get_state(stream)) && 3 != state && 4 != state) {
            this.waitMainloop();
        }
        return state;
    }

    public void waitMainloop() {
        PA.threaded_mainloop_wait(this.mainloop);
    }
}

