/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.MediaServiceImpl;
import org.jitsi.impl.neomedia.codec.video.AVFrameFormat;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.impl.neomedia.device.DeviceSystem;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.MediaUseCase;
import org.jitsi.util.Logger;
import org.jitsi.util.OSUtils;
import org.jitsi.util.event.PropertyChangeNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceConfiguration
extends PropertyChangeNotifier
implements PropertyChangeListener {
    public static final String AUDIO_CAPTURE_DEVICE = "captureDevice";
    public static final String AUDIO_NOTIFY_DEVICE = "notifyDevice";
    public static final String AUDIO_PLAYBACK_DEVICE = "playbackDevice";
    private static final String[] CUSTOM_RENDERERS = new String[]{OSUtils.IS_ANDROID ? ".audio.AudioTrackRenderer" : null, OSUtils.IS_ANDROID ? ".audio.OpenSLESRenderer" : null, OSUtils.IS_LINUX ? ".audio.PulseAudioRenderer" : null, OSUtils.IS_WINDOWS ? ".audio.WASAPIRenderer" : null, OSUtils.IS_ANDROID ? null : ".audio.PortAudioRenderer", ".video.JAWTRenderer"};
    public static final boolean DEFAULT_AUDIO_DENOISE = true;
    public static final boolean DEFAULT_AUDIO_ECHOCANCEL = true;
    public static final long DEFAULT_AUDIO_ECHOCANCEL_FILTER_LENGTH_IN_MILLIS = 100L;
    public static final int DEFAULT_VIDEO_FRAMERATE = -1;
    public static final int DEFAULT_VIDEO_HEIGHT = 480;
    public static final int DEFAULT_VIDEO_RTP_PACING_THRESHOLD = 256;
    public static final int DEFAULT_VIDEO_BITRATE = 128;
    public static final int DEFAULT_VIDEO_WIDTH = 640;
    static final String PROP_AUDIO_DENOISE = "net.java.sip.communicator.impl.neomedia.denoise";
    static final String PROP_AUDIO_ECHOCANCEL = "net.java.sip.communicator.impl.neomedia.echocancel";
    static final String PROP_AUDIO_ECHOCANCEL_FILTER_LENGTH_IN_MILLIS = "net.java.sip.communicator.impl.neomedia.echocancel.filterLengthInMillis";
    public static final String PROP_AUDIO_SYSTEM = "net.java.sip.communicator.impl.neomedia.audioSystem";
    public static final String PROP_AUDIO_SYSTEM_DEVICES = "net.java.sip.communicator.impl.neomedia.audioSystem.devices";
    private static final String PROP_VIDEO_DEVICE = "net.java.sip.communicator.impl.neomedia.videoDevice";
    private static final String PROP_VIDEO_FRAMERATE = "net.java.sip.communicator.impl.neomedia.video.framerate";
    private static final String PROP_VIDEO_HEIGHT = "net.java.sip.communicator.impl.neomedia.video.height";
    private static final String PROP_VIDEO_RTP_PACING_THRESHOLD = "net.java.sip.communicator.impl.neomedia.video.maxbandwidth";
    private static final String PROP_VIDEO_BITRATE = "net.java.sip.communicator.impl.neomedia.video.bitrate";
    private static final String PROP_VIDEO_WIDTH = "net.java.sip.communicator.impl.neomedia.video.width";
    public static final Dimension[] SUPPORTED_RESOLUTIONS = new Dimension[]{new Dimension(160, 100), new Dimension(176, 144), new Dimension(320, 200), new Dimension(320, 240), new Dimension(352, 288), new Dimension(640, 480), new Dimension(1280, 720)};
    public static final String VIDEO_CAPTURE_DEVICE = "VIDEO_CAPTURE_DEVICE";
    private AudioSystem audioSystem;
    private int frameRate = -1;
    private Logger logger = Logger.getLogger(DeviceConfiguration.class);
    private CaptureDeviceInfo videoCaptureDevice;
    private int videoMaxBandwidth = -1;
    private int videoBitrate = -1;
    private Dimension videoSize;

    public DeviceConfiguration() {
        try {
            DeviceSystem.initializeDeviceSystems();
            this.extractConfiguredCaptureDevices();
            ConfigurationService cfg = LibJitsi.getConfigurationService();
            if (cfg != null) {
                cfg.addPropertyChangeListener(PROP_VIDEO_HEIGHT, this);
                cfg.addPropertyChangeListener(PROP_VIDEO_WIDTH, this);
                cfg.addPropertyChangeListener(PROP_VIDEO_FRAMERATE, this);
                cfg.addPropertyChangeListener(PROP_VIDEO_RTP_PACING_THRESHOLD, this);
            }
        }
        catch (Exception ex) {
            this.logger.error("Failed to initialize media.", ex);
        }
        this.registerCustomRenderers();
        DeviceConfiguration.fixRenderers();
        this.registerToDeviceSystemPropertyChangeListener();
    }

    private static void fixRenderers() {
        Vector renderers = PlugInManager.getPlugInList(null, null, (int)4);
        PlugInManager.removePlugIn((String)"com.sun.media.renderer.audio.JavaSoundRenderer", (int)4);
        if (OSUtils.IS_WINDOWS) {
            if (OSUtils.IS_WINDOWS32 && (OSUtils.IS_WINDOWS_VISTA || OSUtils.IS_WINDOWS_7)) {
                if (renderers.contains("com.sun.media.renderer.video.GDIRenderer")) {
                    PlugInManager.removePlugIn((String)"com.sun.media.renderer.video.DDRenderer", (int)4);
                }
            } else if (OSUtils.IS_WINDOWS64) {
                PlugInManager.removePlugIn((String)"com.sun.media.renderer.video.GDIRenderer", (int)4);
                PlugInManager.removePlugIn((String)"com.sun.media.renderer.video.DDRenderer", (int)4);
            }
        } else if (!OSUtils.IS_LINUX32 && (renderers.contains("com.sun.media.renderer.video.LightWeightRenderer") || renderers.contains("com.sun.media.renderer.video.AWTRenderer"))) {
            PlugInManager.removePlugIn((String)"com.sun.media.renderer.video.XLibRenderer", (int)4);
        }
    }

    private void extractConfiguredCaptureDevices() {
        this.extractConfiguredAudioCaptureDevices();
        this.extractConfiguredVideoCaptureDevices();
    }

    private CaptureDeviceInfo extractConfiguredVideoCaptureDevice(Format format) {
        Vector videoCaptureDevices = CaptureDeviceManager.getDeviceList((Format)format);
        CaptureDeviceInfo videoCaptureDevice = null;
        if (videoCaptureDevices.size() > 0) {
            String videoDevName;
            ConfigurationService cfg = LibJitsi.getConfigurationService();
            String string = videoDevName = cfg == null ? null : cfg.getString(PROP_VIDEO_DEVICE);
            if (videoDevName == null) {
                videoCaptureDevice = (CaptureDeviceInfo)videoCaptureDevices.get(0);
            } else {
                for (CaptureDeviceInfo captureDeviceInfo : videoCaptureDevices) {
                    if (!videoDevName.equals(captureDeviceInfo.getName())) continue;
                    videoCaptureDevice = captureDeviceInfo;
                    break;
                }
            }
            if (videoCaptureDevice != null && this.logger.isInfoEnabled()) {
                this.logger.info("Found " + videoCaptureDevice.getName() + " as a " + format + " video capture device.");
            }
        }
        return videoCaptureDevice;
    }

    public CaptureDeviceInfo2 getAudioCaptureDevice() {
        AudioSystem audioSystem = this.getAudioSystem();
        return audioSystem == null ? null : audioSystem.getSelectedDevice(AudioSystem.DataFlow.CAPTURE);
    }

    public List<CaptureDeviceInfo2> getAvailableAudioCaptureDevices() {
        return this.audioSystem.getDevices(AudioSystem.DataFlow.CAPTURE);
    }

    public AudioSystem getAudioSystem() {
        return this.audioSystem;
    }

    public AudioSystem[] getAvailableAudioSystems() {
        AudioSystem[] audioSystems = AudioSystem.getAudioSystems();
        if (audioSystems == null || audioSystems.length == 0) {
            return audioSystems;
        }
        ArrayList<AudioSystem> audioSystemsWithDevices = new ArrayList<AudioSystem>();
        for (AudioSystem audioSystem : audioSystems) {
            List<CaptureDeviceInfo2> playbackDevices;
            List<CaptureDeviceInfo2> notifyDevices;
            List<CaptureDeviceInfo2> captureDevices;
            if (!("none".equalsIgnoreCase(audioSystem.getLocatorProtocol()) || (captureDevices = audioSystem.getDevices(AudioSystem.DataFlow.CAPTURE)) != null && captureDevices.size() > 0 || (8 & audioSystem.getFeatures()) != 0 && ((notifyDevices = audioSystem.getDevices(AudioSystem.DataFlow.NOTIFY)) != null && notifyDevices.size() > 0 || (playbackDevices = audioSystem.getDevices(AudioSystem.DataFlow.PLAYBACK)) != null && playbackDevices.size() > 0))) continue;
            audioSystemsWithDevices.add(audioSystem);
        }
        int audioSystemsWithDevicesCount = audioSystemsWithDevices.size();
        return audioSystemsWithDevicesCount == audioSystems.length ? audioSystems : audioSystemsWithDevices.toArray(new AudioSystem[audioSystemsWithDevicesCount]);
    }

    public void setAudioSystem(AudioSystem audioSystem, boolean save) {
        if (this.audioSystem != audioSystem) {
            ConfigurationService cfg;
            if (this.audioSystem != null && (this.audioSystem.getFeatures() & 1) == 0) {
                this.audioSystem.removePropertyChangeListener(this);
            }
            AudioSystem oldValue = this.audioSystem;
            this.audioSystem = audioSystem;
            if (this.audioSystem != null) {
                this.audioSystem.addPropertyChangeListener(this);
            }
            if (save && (cfg = LibJitsi.getConfigurationService()) != null) {
                if (this.audioSystem == null) {
                    cfg.removeProperty(PROP_AUDIO_SYSTEM);
                } else {
                    cfg.setProperty(PROP_AUDIO_SYSTEM, this.audioSystem.getLocatorProtocol());
                }
            }
            this.firePropertyChange(PROP_AUDIO_SYSTEM, oldValue, this.audioSystem);
        }
    }

    public List<CaptureDeviceInfo> getAvailableVideoCaptureDevices(MediaUseCase useCase) {
        Format[] formats = new Format[]{new AVFrameFormat(), new VideoFormat("rgb"), new VideoFormat("yuv"), new VideoFormat("h264")};
        HashSet<CaptureDeviceInfo> videoCaptureDevices = new HashSet<CaptureDeviceInfo>();
        for (Format format : formats) {
            Vector cdis = CaptureDeviceManager.getDeviceList((Format)format);
            if (useCase != MediaUseCase.ANY) {
                for (CaptureDeviceInfo cdi : cdis) {
                    MediaUseCase cdiUseCase = "imgstreaming".equalsIgnoreCase(cdi.getLocator().getProtocol()) ? MediaUseCase.DESKTOP : MediaUseCase.CALL;
                    if (!cdiUseCase.equals((Object)useCase)) continue;
                    videoCaptureDevices.add(cdi);
                }
                continue;
            }
            videoCaptureDevices.addAll(cdis);
        }
        return new ArrayList<CaptureDeviceInfo>(videoCaptureDevices);
    }

    public CaptureDeviceInfo getVideoCaptureDevice(MediaUseCase useCase) {
        CaptureDeviceInfo dev = null;
        switch (useCase) {
            case ANY: 
            case CALL: {
                dev = this.videoCaptureDevice;
                break;
            }
            case DESKTOP: {
                List<CaptureDeviceInfo> devs = this.getAvailableVideoCaptureDevices(MediaUseCase.DESKTOP);
                if (devs.size() <= 0) break;
                dev = devs.get(0);
                break;
            }
        }
        return dev;
    }

    public void setVideoCaptureDevice(CaptureDeviceInfo device, boolean save) {
        if (this.videoCaptureDevice != device) {
            ConfigurationService cfg;
            CaptureDeviceInfo oldDevice = this.videoCaptureDevice;
            this.videoCaptureDevice = device;
            if (save && (cfg = LibJitsi.getConfigurationService()) != null) {
                cfg.setProperty(PROP_VIDEO_DEVICE, this.videoCaptureDevice == null ? "none" : this.videoCaptureDevice.getName());
            }
            this.firePropertyChange(VIDEO_CAPTURE_DEVICE, oldDevice, device);
        }
    }

    public CaptureDeviceInfo getAudioNotifyDevice() {
        AudioSystem audioSystem = this.getAudioSystem();
        return audioSystem == null ? null : audioSystem.getSelectedDevice(AudioSystem.DataFlow.NOTIFY);
    }

    public void setEchoCancel(boolean echoCancel) {
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        if (cfg != null) {
            cfg.setProperty(PROP_AUDIO_ECHOCANCEL, echoCancel);
        }
    }

    public void setDenoise(boolean denoise) {
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        if (cfg != null) {
            cfg.setProperty(PROP_AUDIO_DENOISE, denoise);
        }
    }

    public boolean isEchoCancel() {
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        boolean value = true;
        if (cfg != null) {
            value = cfg.getBoolean(PROP_AUDIO_ECHOCANCEL, value);
        }
        return value;
    }

    public long getEchoCancelFilterLengthInMillis() {
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        long value = 100L;
        if (cfg != null) {
            value = cfg.getLong(PROP_AUDIO_ECHOCANCEL_FILTER_LENGTH_IN_MILLIS, value);
        }
        return value;
    }

    public boolean isDenoise() {
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        boolean value = true;
        if (cfg != null) {
            value = cfg.getBoolean(PROP_AUDIO_DENOISE, value);
        }
        return value;
    }

    private void registerCustomRenderers() {
        Vector renderers = PlugInManager.getPlugInList(null, null, (int)4);
        boolean commit = false;
        for (String customRenderer : CUSTOM_RENDERERS) {
            if (customRenderer == null) continue;
            if (customRenderer.startsWith(".")) {
                customRenderer = "org.jitsi.impl.neomedia.jmfext.media.renderer" + customRenderer;
            }
            if (renderers != null && renderers.contains(customRenderer)) continue;
            try {
                Renderer customRendererInstance = (Renderer)Class.forName(customRenderer).newInstance();
                PlugInManager.addPlugIn((String)customRenderer, (Format[])customRendererInstance.getSupportedInputFormats(), null, (int)4);
                commit = true;
            }
            catch (Throwable t) {
                this.logger.error("Failed to register custom Renderer " + customRenderer + " with JMF.", t);
            }
        }
        int pluginType = 4;
        Vector plugins = PlugInManager.getPlugInList(null, null, (int)pluginType);
        if (plugins != null) {
            int pluginCount = plugins.size();
            int pluginBeginIndex = 0;
            int pluginIndex = pluginCount - 1;
            while (pluginIndex >= pluginBeginIndex) {
                String plugin = (String)plugins.get(pluginIndex);
                if (plugin.startsWith("org.jitsi.") || plugin.startsWith("net.java.sip.communicator.")) {
                    plugins.remove(pluginIndex);
                    plugins.add(0, plugin);
                    ++pluginBeginIndex;
                    commit = true;
                    continue;
                }
                --pluginIndex;
            }
            PlugInManager.setPlugInList((Vector)plugins, (int)pluginType);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Reordered plug-in list:" + plugins);
            }
        }
        if (commit && !MediaServiceImpl.isJmfRegistryDisableLoad()) {
            try {
                PlugInManager.commit();
            }
            catch (IOException ioex) {
                this.logger.warn("Failed to commit changes to the JMF plug-in list.");
            }
        }
    }

    public int getVideoRTPPacingThreshold() {
        if (this.videoMaxBandwidth == -1) {
            ConfigurationService cfg = LibJitsi.getConfigurationService();
            int value = 256;
            if (cfg != null) {
                value = cfg.getInt(PROP_VIDEO_RTP_PACING_THRESHOLD, value);
            }
            this.videoMaxBandwidth = value > 0 ? value : 256;
        }
        return this.videoMaxBandwidth;
    }

    public void setVideoRTPPacingThreshold(int videoMaxBandwidth) {
        this.videoMaxBandwidth = videoMaxBandwidth;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        if (cfg != null) {
            if (videoMaxBandwidth != 256) {
                cfg.setProperty(PROP_VIDEO_RTP_PACING_THRESHOLD, videoMaxBandwidth);
            } else {
                cfg.removeProperty(PROP_VIDEO_RTP_PACING_THRESHOLD);
            }
        }
    }

    public int getVideoBitrate() {
        if (this.videoBitrate == -1) {
            ConfigurationService cfg = LibJitsi.getConfigurationService();
            int value = 128;
            if (cfg != null) {
                value = cfg.getInt(PROP_VIDEO_BITRATE, value);
            }
            this.videoBitrate = value > 0 ? value : 128;
        }
        return this.videoBitrate;
    }

    public void setVideoBitrate(int videoBitrate) {
        this.videoBitrate = videoBitrate;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        if (cfg != null) {
            if (videoBitrate != 128) {
                cfg.setProperty(PROP_VIDEO_BITRATE, videoBitrate);
            } else {
                cfg.removeProperty(PROP_VIDEO_BITRATE);
            }
        }
    }

    public int getFrameRate() {
        if (this.frameRate == -1) {
            ConfigurationService cfg = LibJitsi.getConfigurationService();
            int value = -1;
            if (cfg != null) {
                value = cfg.getInt(PROP_VIDEO_FRAMERATE, value);
            }
            this.frameRate = value;
        }
        return this.frameRate;
    }

    public void setFrameRate(int frameRate) {
        this.frameRate = frameRate;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        if (cfg != null) {
            if (frameRate != -1) {
                cfg.setProperty(PROP_VIDEO_FRAMERATE, frameRate);
            } else {
                cfg.removeProperty(PROP_VIDEO_FRAMERATE);
            }
        }
    }

    public Dimension getVideoSize() {
        if (this.videoSize == null) {
            ConfigurationService cfg = LibJitsi.getConfigurationService();
            int height = 480;
            int width = 640;
            if (cfg != null) {
                height = cfg.getInt(PROP_VIDEO_HEIGHT, height);
                width = cfg.getInt(PROP_VIDEO_WIDTH, width);
            }
            this.videoSize = new Dimension(width, height);
        }
        return this.videoSize;
    }

    public void setVideoSize(Dimension videoSize) {
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        if (cfg != null) {
            if (videoSize.getHeight() != 480.0 || videoSize.getWidth() != 640.0) {
                cfg.setProperty(PROP_VIDEO_HEIGHT, videoSize.height);
                cfg.setProperty(PROP_VIDEO_WIDTH, videoSize.width);
            } else {
                cfg.removeProperty(PROP_VIDEO_HEIGHT);
                cfg.removeProperty(PROP_VIDEO_WIDTH);
            }
        }
        this.videoSize = videoSize;
        this.firePropertyChange(VIDEO_CAPTURE_DEVICE, this.videoCaptureDevice, this.videoCaptureDevice);
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        String propertyName = ev.getPropertyName();
        if (AUDIO_CAPTURE_DEVICE.equals(propertyName) || AUDIO_NOTIFY_DEVICE.equals(propertyName) || AUDIO_PLAYBACK_DEVICE.equals(propertyName)) {
            CaptureDeviceInfo device;
            CaptureDeviceInfo oldValue = (CaptureDeviceInfo)ev.getOldValue();
            CaptureDeviceInfo newValue = (CaptureDeviceInfo)ev.getNewValue();
            this.switchFromNoneToActiveAudioSystem(newValue);
            CaptureDeviceInfo captureDeviceInfo = device = oldValue == null ? newValue : oldValue;
            if (device == null || device.getLocator().getProtocol().equals(this.getAudioSystem().getLocatorProtocol())) {
                this.firePropertyChange(propertyName, oldValue, newValue);
            }
        } else if ("devices".equals(propertyName)) {
            if (ev.getSource() instanceof AudioSystem) {
                List newValue = (List)ev.getNewValue();
                this.switchFromNoneToActiveAudioSystem(newValue == null || newValue.isEmpty() ? null : (CaptureDeviceInfo)newValue.get(0));
                this.firePropertyChange(PROP_AUDIO_SYSTEM_DEVICES, ev.getOldValue(), newValue);
            }
        } else if (PROP_VIDEO_FRAMERATE.equals(propertyName)) {
            this.frameRate = -1;
        } else if (PROP_VIDEO_HEIGHT.equals(propertyName) || PROP_VIDEO_WIDTH.equals(propertyName)) {
            this.videoSize = null;
        } else if (PROP_VIDEO_RTP_PACING_THRESHOLD.equals(propertyName)) {
            this.videoMaxBandwidth = -1;
        }
    }

    private void extractConfiguredAudioCaptureDevices() {
        AudioSystem[] availableAudioSystems;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Looking for configured audio devices.");
        }
        if ((availableAudioSystems = this.getAvailableAudioSystems()) != null && availableAudioSystems.length != 0) {
            AudioSystem audioSystem = this.getAudioSystem();
            if (audioSystem != null) {
                boolean audioSystemIsAvailable = false;
                for (AudioSystem availableAudioSystem : availableAudioSystems) {
                    if (!availableAudioSystem.equals(audioSystem)) continue;
                    audioSystemIsAvailable = true;
                    break;
                }
                if (!audioSystemIsAvailable) {
                    audioSystem = null;
                }
            }
            if (audioSystem == null) {
                String locatorProtocol;
                ConfigurationService cfg = LibJitsi.getConfigurationService();
                if (cfg != null && (locatorProtocol = cfg.getString(PROP_AUDIO_SYSTEM)) != null) {
                    for (AudioSystem availableAudioSystem : availableAudioSystems) {
                        if (!locatorProtocol.equalsIgnoreCase(availableAudioSystem.getLocatorProtocol())) continue;
                        audioSystem = availableAudioSystem;
                        break;
                    }
                }
                if (audioSystem == null) {
                    audioSystem = availableAudioSystems[0];
                }
                this.setAudioSystem(audioSystem, false);
            }
        }
    }

    private void extractConfiguredVideoCaptureDevices() {
        String videoCaptureDeviceString;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        String string = videoCaptureDeviceString = cfg == null ? null : cfg.getString(PROP_VIDEO_DEVICE);
        if ("none".equalsIgnoreCase(videoCaptureDeviceString)) {
            this.videoCaptureDevice = null;
        } else {
            Format[] formats;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Scanning for configured Video Devices.");
            }
            for (Format format : formats = new Format[]{new AVFrameFormat(), new VideoFormat("rgb"), new VideoFormat("yuv"), new VideoFormat("h264")}) {
                this.videoCaptureDevice = this.extractConfiguredVideoCaptureDevice(format);
                if (this.videoCaptureDevice != null) break;
            }
            if (this.videoCaptureDevice == null && this.logger.isInfoEnabled()) {
                this.logger.info("No Video Device was found.");
            }
        }
    }

    private void registerToDeviceSystemPropertyChangeListener() {
        for (MediaType mediaType : MediaType.values()) {
            DeviceSystem[] deviceSystems = DeviceSystem.getDeviceSystems(mediaType);
            if (deviceSystems == null) continue;
            for (DeviceSystem deviceSystem : deviceSystems) {
                if ((deviceSystem.getFeatures() & 1) == 0) continue;
                deviceSystem.addPropertyChangeListener(this);
            }
        }
    }

    private void switchFromNoneToActiveAudioSystem(CaptureDeviceInfo newActiveDevice) {
        if (newActiveDevice != null) {
            AudioSystem newActiveAudioSystem;
            String newActiveLocatorProtocol = newActiveDevice.getLocator().getProtocol();
            if (!newActiveLocatorProtocol.equals("none") && this.getAudioSystem().getLocatorProtocol().equals("none") && (newActiveAudioSystem = AudioSystem.getAudioSystem(newActiveLocatorProtocol)) != null) {
                this.setAudioSystem(newActiveAudioSystem, false);
            }
        } else {
            this.extractConfiguredAudioCaptureDevices();
        }
    }
}

