/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.Renderer;
import javax.media.format.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.impl.neomedia.device.CaptureDevices;
import org.jitsi.impl.neomedia.device.DeviceSystem;
import org.jitsi.impl.neomedia.device.Devices;
import org.jitsi.impl.neomedia.device.NotifyDevices;
import org.jitsi.impl.neomedia.device.PlaybackDevices;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.AbstractAudioRenderer;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AudioSystem
extends DeviceSystem {
    public static final int FEATURE_DENOISE = 2;
    public static final int FEATURE_ECHO_CANCELLATION = 4;
    public static final int FEATURE_NOTIFY_AND_PLAYBACK_DEVICES = 8;
    public static final String LOCATOR_PROTOCOL_AUDIORECORD = "audiorecord";
    public static final String LOCATOR_PROTOCOL_JAVASOUND = "javasound";
    public static final String LOCATOR_PROTOCOL_OPENSLES = "opensles";
    public static final String LOCATOR_PROTOCOL_PORTAUDIO = "portaudio";
    public static final String LOCATOR_PROTOCOL_PULSEAUDIO = "pulseaudio";
    public static final String LOCATOR_PROTOCOL_WASAPI = "wasapi";
    private static Logger logger = Logger.getLogger(AudioSystem.class);
    private Devices[] devices;

    public static AudioSystem getAudioSystem(String locatorProtocol) {
        AudioSystem[] audioSystems = AudioSystem.getAudioSystems();
        AudioSystem audioSystemWithLocatorProtocol = null;
        if (audioSystems != null) {
            for (AudioSystem audioSystem : audioSystems) {
                if (!audioSystem.getLocatorProtocol().equalsIgnoreCase(locatorProtocol)) continue;
                audioSystemWithLocatorProtocol = audioSystem;
                break;
            }
        }
        return audioSystemWithLocatorProtocol;
    }

    public static AudioSystem[] getAudioSystems() {
        ArrayList<AudioSystem> audioSystems;
        DeviceSystem[] deviceSystems = DeviceSystem.getDeviceSystems(MediaType.AUDIO);
        if (deviceSystems == null) {
            audioSystems = null;
        } else {
            audioSystems = new ArrayList<AudioSystem>(deviceSystems.length);
            for (DeviceSystem deviceSystem : deviceSystems) {
                if (!(deviceSystem instanceof AudioSystem)) continue;
                audioSystems.add((AudioSystem)deviceSystem);
            }
        }
        return audioSystems == null ? null : audioSystems.toArray(new AudioSystem[audioSystems.size()]);
    }

    protected AudioSystem(String locatorProtocol) throws Exception {
        this(locatorProtocol, 0);
    }

    protected AudioSystem(String locatorProtocol, int features) throws Exception {
        super(MediaType.AUDIO, locatorProtocol, features);
    }

    @Override
    public Renderer createRenderer() {
        return this.createRenderer(true);
    }

    public Renderer createRenderer(boolean playback) {
        Renderer renderer;
        String className = this.getRendererClassName();
        if (className == null) {
            renderer = null;
        } else {
            Class<?> clazz;
            try {
                clazz = Class.forName(className);
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                clazz = null;
                logger.error("Failed to get class " + className, t);
            }
            if (clazz == null) {
                renderer = null;
            } else if (!Renderer.class.isAssignableFrom(clazz)) {
                renderer = null;
            } else {
                boolean superCreateRenderer;
                if ((this.getFeatures() & 8) != 0 && AbstractAudioRenderer.class.isAssignableFrom(clazz)) {
                    Constructor<?> constructor = null;
                    try {
                        constructor = clazz.getConstructor(Boolean.TYPE);
                    }
                    catch (NoSuchMethodException nsme) {
                    }
                    catch (SecurityException se) {
                        // empty catch block
                    }
                    if (constructor != null && constructor.isAccessible()) {
                        superCreateRenderer = false;
                        try {
                            renderer = (Renderer)constructor.newInstance(playback);
                        }
                        catch (Throwable t) {
                            if (t instanceof ThreadDeath) {
                                throw (ThreadDeath)t;
                            }
                            renderer = null;
                            logger.error("Failed to initialize a new " + className + " instance", t);
                        }
                        if (renderer != null && !playback) {
                            CaptureDeviceInfo2 device = this.getSelectedDevice(DataFlow.NOTIFY);
                            if (device == null) {
                                renderer = null;
                            } else {
                                MediaLocator locator = device.getLocator();
                                if (locator != null) {
                                    ((AbstractAudioRenderer)renderer).setLocator(locator);
                                }
                            }
                        }
                    } else {
                        superCreateRenderer = true;
                        renderer = null;
                    }
                } else {
                    superCreateRenderer = true;
                    renderer = null;
                }
                if (superCreateRenderer && renderer == null) {
                    renderer = super.createRenderer();
                }
            }
        }
        return renderer;
    }

    public InputStream getAudioInputStream(String uri) throws IOException {
        ResourceManagementService resources = LibJitsi.getResourceManagementService();
        URL url = resources == null ? null : resources.getSoundURLForPath(uri);
        AudioInputStream audioStream = null;
        try {
            if (url == null) {
                url = new URL(uri);
            }
            audioStream = javax.sound.sampled.AudioSystem.getAudioInputStream(url);
        }
        catch (MalformedURLException murle) {
        }
        catch (UnsupportedAudioFileException uafe) {
            logger.error("Unsupported format of audio stream " + url, uafe);
        }
        return audioStream;
    }

    public CaptureDeviceInfo2 getDevice(DataFlow dataFlow, MediaLocator locator) {
        return this.devices[dataFlow.ordinal()].getDevice(locator);
    }

    public List<CaptureDeviceInfo2> getDevices(DataFlow dataFlow) {
        return this.devices[dataFlow.ordinal()].getDevices();
    }

    public Format getFormat(InputStream audioInputStream) {
        if (audioInputStream instanceof AudioInputStream) {
            javax.sound.sampled.AudioFormat audioInputStreamFormat = ((AudioInputStream)audioInputStream).getFormat();
            return new AudioFormat("LINEAR", (double)audioInputStreamFormat.getSampleRate(), audioInputStreamFormat.getSampleSizeInBits(), audioInputStreamFormat.getChannels());
        }
        return null;
    }

    public CaptureDeviceInfo2 getSelectedDevice(DataFlow dataFlow) {
        return this.devices[dataFlow.ordinal()].getSelectedDevice(this.getLocatorProtocol(), this.getDevices(dataFlow));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postInitialize() {
        try {
            try {
                this.postInitializeSpecificDevices(DataFlow.CAPTURE);
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if ((8 & this.getFeatures()) != 0) {
                    try {
                        this.postInitializeSpecificDevices(DataFlow.NOTIFY);
                        Object var4_5 = null;
                        this.postInitializeSpecificDevices(DataFlow.PLAYBACK);
                    }
                    catch (Throwable throwable2) {
                        Object var4_6 = null;
                        this.postInitializeSpecificDevices(DataFlow.PLAYBACK);
                        throw throwable2;
                    }
                }
                throw throwable;
            }
            if ((8 & this.getFeatures()) != 0) {
                try {
                    this.postInitializeSpecificDevices(DataFlow.NOTIFY);
                    Object var4_3 = null;
                    this.postInitializeSpecificDevices(DataFlow.PLAYBACK);
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.postInitializeSpecificDevices(DataFlow.PLAYBACK);
                    throw throwable;
                }
            }
            Object var6_10 = null;
            super.postInitialize();
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            super.postInitialize();
            throw throwable;
        }
    }

    protected void postInitializeSpecificDevices(DataFlow dataFlow) {
        List<CaptureDeviceInfo2> activeDevices = this.getDevices(dataFlow);
        Devices devices = this.devices[dataFlow.ordinal()];
        String locatorProtocol = this.getLocatorProtocol();
        CaptureDeviceInfo2 selectedActiveDevice = devices.getSelectedDevice(locatorProtocol, activeDevices);
        devices.setDevice(locatorProtocol, selectedActiveDevice, false);
    }

    @Override
    protected void preInitialize() {
        super.preInitialize();
        if (this.devices == null) {
            this.devices = new Devices[3];
            this.devices[DataFlow.CAPTURE.ordinal()] = new CaptureDevices(this);
            this.devices[DataFlow.NOTIFY.ordinal()] = new NotifyDevices(this);
            this.devices[DataFlow.PLAYBACK.ordinal()] = new PlaybackDevices(this);
        }
    }

    public void propertyChange(String property, Object oldValue, Object newValue) {
        this.firePropertyChange(property, oldValue, newValue);
    }

    protected void setCaptureDevices(List<CaptureDeviceInfo2> captureDevices) {
        this.devices[DataFlow.CAPTURE.ordinal()].setDevices(captureDevices);
    }

    public void setDevice(DataFlow dataFlow, CaptureDeviceInfo2 device, boolean save) {
        this.devices[dataFlow.ordinal()].setDevice(this.getLocatorProtocol(), device, save);
    }

    protected void setPlaybackDevices(List<CaptureDeviceInfo2> playbackDevices) {
        this.devices[DataFlow.PLAYBACK.ordinal()].setDevices(playbackDevices);
        this.devices[DataFlow.NOTIFY.ordinal()].setDevices(playbackDevices);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataFlow {
        CAPTURE,
        NOTIFY,
        PLAYBACK;

    }
}

