/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.conference;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.Controls;
import javax.media.Format;
import javax.media.Time;
import javax.media.control.BufferControl;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullBufferStream;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceStream;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.conference.AudioMixerPushBufferStream;
import org.jitsi.impl.neomedia.conference.AudioMixingPushBufferDataSource;
import org.jitsi.impl.neomedia.conference.DataSourceFilter;
import org.jitsi.impl.neomedia.conference.InputDataSourceDesc;
import org.jitsi.impl.neomedia.conference.InputStreamDesc;
import org.jitsi.impl.neomedia.control.ReadOnlyBufferControlDelegate;
import org.jitsi.impl.neomedia.control.ReadOnlyFormatControlDelegate;
import org.jitsi.impl.neomedia.device.MediaDeviceImpl;
import org.jitsi.impl.neomedia.device.ReceiveStreamPushBufferDataSource;
import org.jitsi.impl.neomedia.protocol.BufferStreamAdapter;
import org.jitsi.impl.neomedia.protocol.CachingPushBufferStream;
import org.jitsi.impl.neomedia.protocol.PullBufferStreamAdapter;
import org.jitsi.impl.neomedia.protocol.PushBufferDataSourceAdapter;
import org.jitsi.impl.neomedia.protocol.PushBufferStreamAdapter;
import org.jitsi.impl.neomedia.protocol.TranscodingDataSource;
import org.jitsi.util.Logger;
import org.jitsi.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioMixer {
    private static final Logger logger = Logger.getLogger(AudioMixer.class);
    private static final AudioFormat DEFAULT_OUTPUT_FORMAT = new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1);
    private BufferControl bufferControl;
    protected final CaptureDevice captureDevice;
    private int connected;
    private final List<InputDataSourceDesc> inputDataSources = new ArrayList<InputDataSourceDesc>();
    private final AudioMixingPushBufferDataSource localOutputDataSource;
    private int started;
    private AudioMixerPushBufferStream outputStream;

    public AudioMixer(CaptureDevice captureDevice) {
        if (captureDevice instanceof PullBufferDataSource) {
            captureDevice = new PushBufferDataSourceAdapter((PullBufferDataSource)captureDevice);
        }
        if (logger.isTraceEnabled()) {
            captureDevice = MediaDeviceImpl.createTracingCaptureDevice(captureDevice, logger);
        }
        this.captureDevice = captureDevice;
        this.localOutputDataSource = this.createOutputDataSource();
        this.addInputDataSource((DataSource)this.captureDevice, this.localOutputDataSource);
    }

    public void addInputDataSource(DataSource inputDataSource) {
        this.addInputDataSource(inputDataSource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInputDataSource(DataSource inputDataSource, AudioMixingPushBufferDataSource outputDataSource) {
        if (inputDataSource == null) {
            throw new NullPointerException("inputDataSource");
        }
        List<InputDataSourceDesc> list = this.inputDataSources;
        synchronized (list) {
            for (InputDataSourceDesc inputDataSourceDesc : this.inputDataSources) {
                if (!inputDataSource.equals(inputDataSourceDesc.inputDataSource)) continue;
                throw new IllegalArgumentException("inputDataSource");
            }
            InputDataSourceDesc inputDataSourceDesc = new InputDataSourceDesc(inputDataSource, outputDataSource);
            boolean added = this.inputDataSources.add(inputDataSourceDesc);
            if (added) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Added input DataSource with hashCode " + inputDataSource.hashCode());
                }
                if (this.connected > 0) {
                    try {
                        inputDataSourceDesc.connect(this);
                    }
                    catch (IOException ioex) {
                        throw new UndeclaredThrowableException(ioex);
                    }
                }
                if (this.outputStream != null) {
                    this.getOutputStream();
                }
                if (this.started > 0) {
                    try {
                        inputDataSourceDesc.start();
                    }
                    catch (IOException ioe) {
                        throw new UndeclaredThrowableException(ioe);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect() throws IOException {
        List<InputDataSourceDesc> list = this.inputDataSources;
        synchronized (list) {
            if (this.connected == 0) {
                for (InputDataSourceDesc inputDataSourceDesc : this.inputDataSources) {
                    try {
                        inputDataSourceDesc.connect(this);
                    }
                    catch (IOException ioe) {
                        logger.error("Failed to connect to inputDataSource " + MediaStreamImpl.toString(inputDataSourceDesc.inputDataSource), ioe);
                        throw ioe;
                    }
                }
                if (this.outputStream != null) {
                    this.outputStream.equalizeInputStreamBufferLength();
                }
            }
            ++this.connected;
        }
    }

    protected void connect(DataSource dataSource, DataSource inputDataSource) throws IOException {
        dataSource.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connected(InputDataSourceDesc inputDataSource) throws IOException {
        List<InputDataSourceDesc> list = this.inputDataSources;
        synchronized (list) {
            if (this.inputDataSources.contains(inputDataSource) && this.connected > 0) {
                if (this.started > 0) {
                    inputDataSource.start();
                }
                if (this.outputStream != null) {
                    this.getOutputStream();
                }
            }
        }
    }

    private InputStreamDesc createInputStreamDesc(SourceStream inputStream, InputDataSourceDesc inputDataSourceDesc) {
        return new InputStreamDesc(inputStream, inputDataSourceDesc);
    }

    public AudioMixingPushBufferDataSource createOutputDataSource() {
        return new AudioMixingPushBufferDataSource(this);
    }

    private boolean createTranscodingDataSource(InputDataSourceDesc inputDataSourceDesc, Format outputFormat) throws IOException {
        if (inputDataSourceDesc.createTranscodingDataSource(outputFormat)) {
            if (this.connected > 0) {
                inputDataSourceDesc.connect(this);
            }
            if (this.started > 0) {
                inputDataSourceDesc.start();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        List<InputDataSourceDesc> list = this.inputDataSources;
        synchronized (list) {
            if (this.connected <= 0) {
                return;
            }
            --this.connected;
            if (this.connected == 0) {
                for (InputDataSourceDesc inputDataSourceDesc : this.inputDataSources) {
                    inputDataSourceDesc.disconnect();
                }
                this.outputStream.setInputStreams(null);
                this.outputStream = null;
            }
        }
    }

    BufferControl getBufferControl() {
        BufferControl captureDeviceBufferControl;
        if (this.bufferControl == null && this.captureDevice instanceof Controls && (captureDeviceBufferControl = (BufferControl)((Controls)this.captureDevice).getControl(BufferControl.class.getName())) != null) {
            this.bufferControl = new ReadOnlyBufferControlDelegate(captureDeviceBufferControl);
        }
        return this.bufferControl;
    }

    CaptureDeviceInfo getCaptureDeviceInfo() {
        return this.captureDevice.getCaptureDeviceInfo();
    }

    String getContentType() {
        return "raw";
    }

    private InputStreamDesc getExistingInputStreamDesc(SourceStream inputStream, InputStreamDesc[] existingInputStreamDescs) {
        if (existingInputStreamDescs == null) {
            return null;
        }
        for (InputStreamDesc existingInputStreamDesc : existingInputStreamDescs) {
            SourceStream existingInputStream = existingInputStreamDesc.getInputStream();
            if (existingInputStream == inputStream) {
                return existingInputStreamDesc;
            }
            if (existingInputStream instanceof BufferStreamAdapter && ((BufferStreamAdapter)existingInputStream).getStream() == inputStream) {
                return existingInputStreamDesc;
            }
            if (!(existingInputStream instanceof CachingPushBufferStream) || ((CachingPushBufferStream)existingInputStream).getStream() != inputStream) continue;
            return existingInputStreamDesc;
        }
        return null;
    }

    Time getDuration() {
        return ((DataSource)this.captureDevice).getDuration();
    }

    private static Format getFormat(DataSource dataSource) {
        FormatControl formatControl = (FormatControl)dataSource.getControl(FormatControl.class.getName());
        return formatControl == null ? null : formatControl.getFormat();
    }

    private static Format getFormat(SourceStream stream) {
        if (stream instanceof PushBufferStream) {
            return ((PushBufferStream)stream).getFormat();
        }
        if (stream instanceof PullBufferStream) {
            return ((PullBufferStream)stream).getFormat();
        }
        return null;
    }

    FormatControl[] getFormatControls() {
        FormatControl[] formatControls = this.captureDevice.getFormatControls();
        if (!OSUtils.IS_ANDROID && formatControls != null) {
            for (int i = 0; i < formatControls.length; ++i) {
                formatControls[i] = new ReadOnlyFormatControlDelegate(formatControls[i]);
            }
        }
        return formatControls;
    }

    private boolean getInputStreamsFromInputDataSource(InputDataSourceDesc inputDataSourceDesc, AudioFormat outputFormat, InputStreamDesc[] existingInputStreams, List<InputStreamDesc> inputStreams) {
        SourceStream[] inputDataSourceStreams = inputDataSourceDesc.getStreams();
        if (inputDataSourceStreams != null) {
            boolean added = false;
            for (SourceStream inputStream : inputDataSourceStreams) {
                Format inputFormat = AudioMixer.getFormat(inputStream);
                if (inputFormat == null || !this.matches(inputFormat, outputFormat)) continue;
                InputStreamDesc inputStreamDesc = this.getExistingInputStreamDesc(inputStream, existingInputStreams);
                if (inputStreamDesc == null) {
                    inputStreamDesc = this.createInputStreamDesc(inputStream, inputDataSourceDesc);
                }
                if (!inputStreams.add(inputStreamDesc)) continue;
                added = true;
            }
            return added;
        }
        DataSource inputDataSource = inputDataSourceDesc.getEffectiveInputDataSource();
        if (inputDataSource == null) {
            return false;
        }
        Format inputFormat = AudioMixer.getFormat(inputDataSource);
        if (inputFormat != null && !this.matches(inputFormat, outputFormat)) {
            if (inputDataSource instanceof PushDataSource) {
                for (PushSourceStream inputStream : ((PushDataSource)inputDataSource).getStreams()) {
                    InputStreamDesc inputStreamDesc = this.getExistingInputStreamDesc((SourceStream)inputStream, existingInputStreams);
                    if (inputStreamDesc == null) {
                        inputStreamDesc = this.createInputStreamDesc(new PushBufferStreamAdapter(inputStream, inputFormat), inputDataSourceDesc);
                    }
                    inputStreams.add(inputStreamDesc);
                }
                return true;
            }
            if (inputDataSource instanceof PullDataSource) {
                for (PullSourceStream inputStream : ((PullDataSource)inputDataSource).getStreams()) {
                    InputStreamDesc inputStreamDesc = this.getExistingInputStreamDesc((SourceStream)inputStream, existingInputStreams);
                    if (inputStreamDesc == null) {
                        inputStreamDesc = this.createInputStreamDesc(new PullBufferStreamAdapter(inputStream, inputFormat), inputDataSourceDesc);
                    }
                    inputStreams.add(inputStreamDesc);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<InputStreamDesc> getInputStreamsFromInputDataSources(AudioFormat outputFormat, InputStreamDesc[] existingInputStreams) throws IOException {
        ArrayList<InputStreamDesc> inputStreams = new ArrayList<InputStreamDesc>();
        List<InputDataSourceDesc> list = this.inputDataSources;
        synchronized (list) {
            for (InputDataSourceDesc inputDataSourceDesc : this.inputDataSources) {
                boolean got = this.getInputStreamsFromInputDataSource(inputDataSourceDesc, outputFormat, existingInputStreams, inputStreams);
                if (got || !this.createTranscodingDataSource(inputDataSourceDesc, (Format)outputFormat)) continue;
                this.getInputStreamsFromInputDataSource(inputDataSourceDesc, outputFormat, existingInputStreams, inputStreams);
            }
        }
        return inputStreams;
    }

    public AudioMixingPushBufferDataSource getLocalOutputDataSource() {
        return this.localOutputDataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AudioFormat getOutputFormatFromInputDataSources() {
        String formatControlType = FormatControl.class.getName();
        AudioFormat outputFormat = null;
        List<InputDataSourceDesc> list = this.inputDataSources;
        synchronized (list) {
            for (InputDataSourceDesc inputDataSource : this.inputDataSources) {
                int endian;
                int signed;
                AudioFormat format;
                FormatControl formatControl;
                DataSource effectiveInputDataSource = inputDataSource.getEffectiveInputDataSource();
                if (effectiveInputDataSource == null || (formatControl = (FormatControl)effectiveInputDataSource.getControl(formatControlType)) == null || (format = (AudioFormat)formatControl.getFormat()) == null || 1 != (signed = format.getSigned()) && -1 != signed || 0 != (endian = format.getEndian()) && -1 != endian) continue;
                outputFormat = format;
                break;
            }
        }
        if (outputFormat == null) {
            outputFormat = DEFAULT_OUTPUT_FORMAT;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Determined outputFormat of AudioMixer from inputDataSources to be " + outputFormat);
        }
        return outputFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AudioMixerPushBufferStream getOutputStream() {
        List<InputDataSourceDesc> list = this.inputDataSources;
        synchronized (list) {
            Collection<InputStreamDesc> inputStreams;
            AudioFormat outputFormat = this.outputStream == null ? this.getOutputFormatFromInputDataSources() : this.outputStream.getFormat();
            this.setOutputFormatToInputDataSources(outputFormat);
            try {
                inputStreams = this.getInputStreamsFromInputDataSources(outputFormat, this.outputStream == null ? null : this.outputStream.getInputStreams());
            }
            catch (IOException ioex) {
                throw new UndeclaredThrowableException(ioex);
            }
            if (this.outputStream == null) {
                this.outputStream = new AudioMixerPushBufferStream(this, outputFormat);
            }
            this.outputStream.setInputStreams(inputStreams);
            return this.outputStream;
        }
    }

    private boolean matches(Format input, AudioFormat pattern) {
        return input instanceof AudioFormat && input.isSameEncoding((Format)pattern);
    }

    protected void read(PushBufferStream stream, Buffer buffer, DataSource dataSource) throws IOException {
        stream.read(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInputDataSources(DataSourceFilter dataSourceFilter) {
        List<InputDataSourceDesc> list = this.inputDataSources;
        synchronized (list) {
            Iterator<InputDataSourceDesc> inputDataSourceIter = this.inputDataSources.iterator();
            boolean removed = false;
            while (inputDataSourceIter.hasNext()) {
                if (!dataSourceFilter.accept(inputDataSourceIter.next().inputDataSource)) continue;
                inputDataSourceIter.remove();
                removed = true;
            }
            if (removed && this.outputStream != null) {
                this.getOutputStream();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOutputFormatToInputDataSources(AudioFormat outputFormat) {
        String formatControlType = FormatControl.class.getName();
        List<InputDataSourceDesc> list = this.inputDataSources;
        synchronized (list) {
            for (InputDataSourceDesc inputDataSourceDesc : this.inputDataSources) {
                Format inputFormat;
                FormatControl formatControl = (FormatControl)inputDataSourceDesc.getControl(formatControlType);
                if (formatControl == null || (inputFormat = formatControl.getFormat()) != null && this.matches(inputFormat, outputFormat)) continue;
                Format setFormat = formatControl.setFormat((Format)outputFormat);
                if (setFormat == null) {
                    logger.error("Failed to set format of inputDataSource to " + outputFormat);
                    continue;
                }
                if (setFormat != outputFormat) {
                    logger.warn("Failed to change format of inputDataSource from " + setFormat + " to " + outputFormat);
                    continue;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Set format of inputDataSource to " + setFormat);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(AudioMixerPushBufferStream outputStream) throws IOException {
        List<InputDataSourceDesc> list = this.inputDataSources;
        synchronized (list) {
            if (this.outputStream != outputStream) {
                return;
            }
            if (this.started == 0) {
                for (InputDataSourceDesc inputDataSourceDesc : this.inputDataSources) {
                    inputDataSourceDesc.start();
                }
            }
            ++this.started;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop(AudioMixerPushBufferStream outputStream) throws IOException {
        List<InputDataSourceDesc> list = this.inputDataSources;
        synchronized (list) {
            if (this.outputStream != outputStream) {
                return;
            }
            if (this.started <= 0) {
                return;
            }
            --this.started;
            if (this.started == 0) {
                for (InputDataSourceDesc inputDataSourceDesc : this.inputDataSources) {
                    inputDataSourceDesc.stop();
                }
            }
        }
    }

    public TranscodingDataSource getTranscodingDataSource(DataSource inputDataSource) {
        for (InputDataSourceDesc inputDataSourceDesc : this.inputDataSources) {
            DataSource ourDataSource = inputDataSourceDesc.getInputDataSource();
            if (ourDataSource == inputDataSource) {
                return inputDataSourceDesc.getTranscodingDataSource();
            }
            if (!(ourDataSource instanceof ReceiveStreamPushBufferDataSource) || ((ReceiveStreamPushBufferDataSource)ourDataSource).getDataSource() != inputDataSource) continue;
            return inputDataSourceDesc.getTranscodingDataSource();
        }
        return null;
    }
}

