/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video.h263p;

import java.util.Arrays;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.util.Logger;

public class DePacketizer
extends AbstractCodec2 {
    private static final Logger logger = Logger.getLogger(DePacketizer.class);
    private final int outputPaddingSize = 8;
    private long lastSequenceNumber = -1L;
    private static final boolean OUTPUT_INCOMPLETE_BUFFER = true;

    public DePacketizer() {
        super("H263+ DePacketizer", VideoFormat.class, (Format[])new VideoFormat[]{new VideoFormat("H263-1998")});
        this.inputFormats = new VideoFormat[]{new VideoFormat("h263-1998/rtp")};
    }

    protected void doClose() {
    }

    protected void doOpen() throws ResourceUnavailableException {
    }

    protected int doProcess(Buffer inBuffer, Buffer outBuffer) {
        long sequenceNumber = inBuffer.getSequenceNumber();
        if (this.lastSequenceNumber != -1L && sequenceNumber - this.lastSequenceNumber != 1L) {
            int ret = 0;
            if (logger.isTraceEnabled()) {
                logger.trace("Dropped RTP packets upto sequenceNumber " + this.lastSequenceNumber + " and continuing with sequenceNumber " + sequenceNumber);
            }
            if (((ret = this.reset(outBuffer)) & 4) == 0) {
                this.lastSequenceNumber = -1L;
                return ret;
            }
        }
        this.lastSequenceNumber = sequenceNumber;
        byte[] in = (byte[])inBuffer.getData();
        int inLength = inBuffer.getLength();
        int inOffset = inBuffer.getOffset();
        int outOffset = outBuffer.getOffset();
        if (inLength < 3) {
            return 1;
        }
        boolean pBit = (in[inOffset] & 4) > 0;
        boolean vBit = (in[inOffset] & 2) > 0;
        int plen = ((in[inOffset] & 1) << 5) + ((in[inOffset + 1] & 0xF8) >> 3);
        int dataLength = inLength - plen - (vBit ? 1 : 0) - (pBit ? 0 : 2);
        byte[] out = DePacketizer.validateByteArraySize(outBuffer, outOffset + dataLength + 8, true);
        if (pBit) {
            out[0] = 0;
            out[1] = 0;
        }
        if (vBit) {
            // empty if block
        }
        if (plen > 0 && logger.isInfoEnabled()) {
            logger.info("Extra picture header present PLEN=" + plen);
        }
        System.arraycopy(in, inOffset + 2 + (vBit ? 1 : 0) + plen, out, outOffset + (pBit ? 2 : 0), dataLength - (pBit ? 2 : 0));
        this.padOutput(out, outOffset + dataLength);
        outBuffer.setLength(outOffset + dataLength);
        outBuffer.setSequenceNumber(sequenceNumber);
        if ((inBuffer.getFlags() & 0x800) != 0) {
            outBuffer.setFlags(outBuffer.getFlags() | 0x800);
            outBuffer.setOffset(0);
            return 0;
        }
        outBuffer.setOffset(outOffset + dataLength);
        return 4;
    }

    private void padOutput(byte[] out, int outOffset) {
        Arrays.fill(out, outOffset, outOffset + 8, (byte)0);
    }

    private int reset(Buffer outBuffer) {
        Object outData;
        if (outBuffer.getLength() > 0 && (outData = outBuffer.getData()) instanceof byte[]) {
            return 2;
        }
        outBuffer.setLength(0);
        return 4;
    }
}

