/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.opus;

import java.awt.Component;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.audio.opus.Opus;
import org.jitsi.service.neomedia.control.FECDecoderControl;
import org.jitsi.util.Logger;

public class JNIDecoder
extends AbstractCodec2
implements FECDecoderControl {
    private static final Logger logger = Logger.getLogger(JNIDecoder.class);
    private static final Format[] SUPPORTED_INPUT_FORMATS = new Format[]{new AudioFormat("opus/rtp")};
    private static final Format[] SUPPORTED_OUTPUT_FORMATS = new Format[]{new AudioFormat("LINEAR", 48000.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)};
    private int channels = 1;
    private long decoder = 0L;
    private final byte[] fecBuffer;
    private boolean firstPacketProcessed = false;
    private long lastPacketSeq;
    private int nbDecodedFec = 0;
    private final int outputSampleRate = 48000;

    public JNIDecoder() {
        super("Opus JNI Decoder", AudioFormat.class, SUPPORTED_OUTPUT_FORMATS);
        this.inputFormats = SUPPORTED_INPUT_FORMATS;
        this.fecBuffer = new byte[23040];
        this.addControl(this);
    }

    protected void doClose() {
        if (this.decoder != 0L) {
            Opus.decoder_destroy(this.decoder);
        }
    }

    protected void doOpen() throws ResourceUnavailableException {
        this.decoder = Opus.decoder_create(48000, this.channels);
        if (this.decoder == 0L) {
            throw new ResourceUnavailableException("opus_decoder_create");
        }
    }

    protected int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        Format inputFormat = inputBuffer.getFormat();
        if (inputFormat != null && inputFormat != this.inputFormat && !inputFormat.equals((Object)this.inputFormat) && null == this.setInputFormat(inputFormat)) {
            return 1;
        }
        boolean decodeFec = false;
        long inputSequenceNumber = inputBuffer.getSequenceNumber();
        if (this.firstPacketProcessed && inputSequenceNumber != this.lastPacketSeq + 1L && (inputSequenceNumber != 0L || this.lastPacketSeq != 65535L)) {
            decodeFec = true;
        }
        if ((inputBuffer.getFlags() & 0x10000) != 0) {
            decodeFec = false;
            if (logger.isTraceEnabled()) {
                logger.trace("Not decoding FEC for " + inputSequenceNumber + " because SKIP_FEC is set");
            }
        }
        int fecSamples = 0;
        int outputLength = 0;
        byte[] inputData = (byte[])inputBuffer.getData();
        int inputOffset = inputBuffer.getOffset();
        int inputLength = inputBuffer.getLength();
        if (decodeFec) {
            fecSamples = Opus.decode(this.decoder, inputData, inputOffset, inputLength, this.fecBuffer, this.fecBuffer.length, 1);
            outputLength += fecSamples * 2;
        }
        byte[] outputData = JNIDecoder.validateByteArraySize(outputBuffer, outputLength += Opus.decoder_get_nb_samples(this.decoder, inputData, inputOffset, inputLength) * 2, false);
        int samplesCount = Opus.decode(this.decoder, inputData, inputOffset, inputLength, outputData, outputLength, 0);
        if (fecSamples > 0) {
            System.arraycopy(outputData, 0, outputData, fecSamples * 2, samplesCount * 2);
            System.arraycopy(this.fecBuffer, 0, outputData, 0, fecSamples * 2);
        }
        if (outputLength > 0) {
            outputBuffer.setDuration((long)((samplesCount + fecSamples) * 1000 * 1000 / 48000));
            outputBuffer.setFormat(this.getOutputFormat());
            outputBuffer.setLength(outputLength);
            outputBuffer.setOffset(0);
            if (fecSamples > 0) {
                ++this.nbDecodedFec;
            }
        } else {
            outputBuffer.setLength(0);
            this.discardOutputBuffer(outputBuffer);
        }
        this.firstPacketProcessed = true;
        this.lastPacketSeq = inputSequenceNumber;
        return 0;
    }

    public int fecPacketsDecoded() {
        return this.nbDecodedFec;
    }

    public Component getControlComponent() {
        return null;
    }

    protected Format[] getMatchingOutputFormats(Format inputFormat) {
        AudioFormat inputAudioFormat = (AudioFormat)inputFormat;
        return new Format[]{new AudioFormat("LINEAR", inputAudioFormat.getSampleRate(), 16, 1, 0, 1, -1, -1.0, Format.byteArray)};
    }

    public Format setInputFormat(Format format) {
        Format inputFormat = super.setInputFormat(format);
        if (inputFormat != null) {
            int outputChannels;
            double outputSampleRate;
            if (this.outputFormat == null) {
                outputSampleRate = -1.0;
                outputChannels = -1;
            } else {
                AudioFormat outputAudioFormat = (AudioFormat)this.outputFormat;
                outputSampleRate = outputAudioFormat.getSampleRate();
                outputChannels = outputAudioFormat.getChannels();
            }
            AudioFormat inputAudioFormat = (AudioFormat)inputFormat;
            double inputSampleRate = inputAudioFormat.getSampleRate();
            int inputChannels = inputAudioFormat.getChannels();
            if (outputSampleRate != inputSampleRate || outputChannels != inputChannels) {
                this.setOutputFormat((Format)new AudioFormat("LINEAR", inputSampleRate, 16, inputChannels, 0, 1, -1, -1.0, Format.byteArray));
            }
        }
        return inputFormat;
    }

    static {
        Opus.assertOpusIsFunctional();
    }
}

