/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.media.DataSink;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoDataSinkException;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import org.jitsi.impl.neomedia.device.AudioMixerMediaDevice;
import org.jitsi.impl.neomedia.device.MediaDeviceSession;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaException;
import org.jitsi.service.neomedia.Recorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecorderImpl
implements Recorder {
    public static final String[] SUPPORTED_FORMATS = new String[]{"aiff", "au", "gsm", "mp3", "wav"};
    private final AudioMixerMediaDevice device;
    private MediaDeviceSession deviceSession;
    private final List<Recorder.Listener> listeners = new ArrayList<Recorder.Listener>();
    private DataSink sink;
    private boolean mute = false;
    private String filename = null;

    public RecorderImpl(AudioMixerMediaDevice device) {
        if (device == null) {
            throw new NullPointerException("device");
        }
        this.device = device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Recorder.Listener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<Recorder.Listener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    private ContentDescriptor getContentDescriptor(String format) throws IllegalArgumentException {
        String type;
        if ("wav".equalsIgnoreCase(format)) {
            type = "audio.x_wav";
        } else if ("mp3".equalsIgnoreCase(format)) {
            type = "audio.mpeg";
        } else if ("gsm".equalsIgnoreCase(format)) {
            type = "audio.x_gsm";
        } else if ("au".equalsIgnoreCase(format)) {
            type = "audio.basic";
        } else if ("aiff".equalsIgnoreCase(format)) {
            type = "audio.x_aiff";
        } else {
            throw new IllegalArgumentException(format + " is not a supported recording format.");
        }
        return new ContentDescriptor(type);
    }

    @Override
    public List<String> getSupportedFormats() {
        return Arrays.asList(SUPPORTED_FORMATS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Recorder.Listener listener) {
        if (listener != null) {
            List<Recorder.Listener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void start(String format, String filename) throws IOException, MediaException {
        MediaDeviceSession deviceSession;
        block14: {
            if (this.sink != null) return;
            if (format == null) {
                throw new NullPointerException("format");
            }
            if (filename == null) {
                throw new NullPointerException("filename");
            }
            this.filename = filename;
            int extensionBeginIndex = filename.lastIndexOf(46);
            if (extensionBeginIndex < 0) {
                filename = filename + '.' + format;
            } else if (extensionBeginIndex == filename.length() - 1) {
                filename = filename + format;
            }
            deviceSession = this.device.createSession();
            try {
                deviceSession.setContentDescriptor(this.getContentDescriptor(format));
                deviceSession.setMute(this.mute);
                deviceSession.start(MediaDirection.SENDONLY);
                this.deviceSession = deviceSession;
                Object var6_5 = null;
                if (this.deviceSession != null) break block14;
                throw new MediaException("Failed to create MediaDeviceSession from AudioMixerMediaDevice for the purposes of recording");
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (this.deviceSession != null) throw throwable;
                throw new MediaException("Failed to create MediaDeviceSession from AudioMixerMediaDevice for the purposes of recording");
            }
        }
        NoDataSinkException exception = null;
        try {
            try {
                DataSource outputDataSource = deviceSession.getOutputDataSource();
                DataSink sink = Manager.createDataSink((DataSource)outputDataSource, (MediaLocator)new MediaLocator("file:" + filename));
                sink.open();
                sink.start();
                this.sink = sink;
            }
            catch (NoDataSinkException ndsex) {
                exception = ndsex;
                Object var9_12 = null;
                if (this.sink != null && exception == null) return;
                this.stop();
                throw new MediaException("Failed to start recording into file " + filename, exception);
            }
            Object var9_11 = null;
            if (this.sink != null && exception == null) return;
            this.stop();
            throw new MediaException("Failed to start recording into file " + filename, exception);
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (this.sink != null && exception == null) {
                throw throwable;
            }
            this.stop();
            throw new MediaException("Failed to start recording into file " + filename, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.deviceSession != null) {
            this.deviceSession.close();
            this.deviceSession = null;
        }
        if (this.sink != null) {
            Recorder.Listener[] listeners;
            this.sink.close();
            this.sink = null;
            List<Recorder.Listener> list = this.listeners;
            synchronized (list) {
                listeners = this.listeners.toArray(new Recorder.Listener[this.listeners.size()]);
            }
            for (Recorder.Listener listener : listeners) {
                listener.recorderStopped(this);
            }
        }
    }

    @Override
    public void setMute(boolean mute) {
        this.mute = mute;
        if (this.deviceSession != null) {
            this.deviceSession.setMute(mute);
        }
    }

    @Override
    public String getFilename() {
        return this.filename;
    }
}

