/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.zrtp.zidfile;

import gnu.java.zrtp.utils.ZrtpUtils;

public class ZidRecord {
    public static final int IDENTIFIER_LENGTH = 12;
    public static final int RS_LENGTH = 32;
    private static final int VERSION = 2;
    private static final int TIME_LENGTH = 8;
    private static final int VERSION_OFFSET = 0;
    private static final int FLAGS_OFFSET = 1;
    private static final int FILLER_OFFSET = 2;
    private static final int IDENTIFIER_OFFSET = 4;
    private static final int RS1INTERVAL_OFFSET = 16;
    private static final int RS1DATA_OFFSET = 24;
    private static final int RS2INTERVAL_OFFSET = 56;
    private static final int RS2DATA_OFFSET = 64;
    private static final int MITMKEY_OFFSET = 96;
    private static final int Valid = 1;
    private static final int SASVerified = 2;
    private static final int RS1Valid = 4;
    private static final int RS2Valid = 8;
    private static final int MITMKeyAvailable = 16;
    private static final int OwnZIDRecord = 32;
    private static final int ZID_RECORD_LENGTH = 128;
    private byte[] buffer = new byte[128];
    private long position;

    public ZidRecord() {
        this.buffer[0] = 2;
    }

    protected boolean isValid() {
        return (this.buffer[1] & 1) == 1;
    }

    protected void setValid() {
        this.buffer[1] = (byte)(this.buffer[1] | 1);
    }

    protected byte[] getBuffer() {
        return this.buffer;
    }

    public void setRs1Valid() {
        this.buffer[1] = (byte)(this.buffer[1] | 4);
    }

    public void resetRs1Valid() {
        this.buffer[1] = (byte)(this.buffer[1] & 0xFFFFFFFB);
    }

    public boolean isRs1Valid() {
        return (this.buffer[1] & 4) == 4;
    }

    public void setRs2Valid() {
        this.buffer[1] = (byte)(this.buffer[1] | 8);
    }

    public void resetRs2Valid() {
        this.buffer[1] = (byte)(this.buffer[1] & 0xFFFFFFF7);
    }

    public boolean isRs2Valid() {
        return (this.buffer[1] & 8) == 8;
    }

    public void setMITMKeyAvailable() {
        this.buffer[1] = (byte)(this.buffer[1] | 0x10);
    }

    public void resetMITMKeyAvailable() {
        this.buffer[1] = (byte)(this.buffer[1] & 0xFFFFFFEF);
    }

    public boolean isMITMKeyAvailable() {
        return (this.buffer[1] & 0x10) == 16;
    }

    public void setOwnZIDRecord() {
        this.buffer[1] = 32;
    }

    public void resetOwnZIDRecord() {
        this.buffer[1] = 0;
    }

    public boolean isOwnZIDRecord() {
        return this.buffer[1] == 32;
    }

    public void setSasVerified() {
        this.buffer[1] = (byte)(this.buffer[1] | 2);
    }

    public void resetSasVerified() {
        this.buffer[1] = (byte)(this.buffer[1] & 0xFFFFFFFD);
    }

    public boolean isSasVerified() {
        return (this.buffer[1] & 2) == 2;
    }

    public void getIdentifierInto(byte[] data) {
        System.arraycopy(this.buffer, 4, data, 0, 12);
    }

    public byte[] getIdentifier() {
        return ZrtpUtils.readRegion(this.buffer, 4, 12);
    }

    public void setIdentifier(byte[] id) {
        System.arraycopy(id, 0, this.buffer, 4, 12);
    }

    public byte[] getRs1() {
        return ZrtpUtils.readRegion(this.buffer, 24, 32);
    }

    public byte[] getRs2() {
        return ZrtpUtils.readRegion(this.buffer, 64, 32);
    }

    public boolean isSameIdentifier(byte[] data) {
        int i = 0;
        while (i < 12) {
            if (this.buffer[4 + i] != data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isSameRs1(byte[] data) {
        int i = 0;
        while (i < 32) {
            if (this.buffer[24 + i] != data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isSameRs2(byte[] data) {
        int i = 0;
        while (i < 32) {
            if (this.buffer[64 + i] != data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setNewRs1(byte[] data, int expire) {
        long validThru = 0L;
        validThru = expire == -1 ? -1L : (expire <= 0 ? 0L : System.currentTimeMillis() / 1000L + (long)expire);
        if (validThru != 0L) {
            System.arraycopy(this.buffer, 24, this.buffer, 64, 32);
            System.arraycopy(this.buffer, 16, this.buffer, 56, 8);
            if (this.isRs1Valid()) {
                this.setRs2Valid();
            }
            System.arraycopy(data, 0, this.buffer, 24, 32);
            this.setRs1Valid();
        }
        this.buffer[16] = (byte)validThru;
        this.buffer[17] = (byte)(validThru >> 8);
        this.buffer[18] = (byte)(validThru >> 16);
        this.buffer[19] = (byte)(validThru >> 24);
        this.buffer[20] = (byte)(validThru >> 32);
        this.buffer[21] = (byte)(validThru >> 40);
        this.buffer[22] = (byte)(validThru >> 48);
        this.buffer[23] = (byte)(validThru >> 56);
    }

    public boolean isRs1NotExpired() {
        long current = System.currentTimeMillis() / 1000L;
        long validThru = this.buffer[16] & 0xFF | (this.buffer[17] & 0xFF) << 8 | (this.buffer[18] & 0xFF) << 16 | (this.buffer[19] & 0xFF) << 24 | (this.buffer[20] & 0xFF) << 32 | (this.buffer[21] & 0xFF) << 40 | (this.buffer[22] & 0xFF) << 48 | (this.buffer[23] & 0xFF) << 56;
        if (validThru == -1L) {
            return true;
        }
        if (validThru == 0L) {
            return false;
        }
        return current <= validThru;
    }

    public boolean isRs2NotExpired() {
        long current = System.currentTimeMillis() / 1000L;
        long validThru = this.buffer[56] & 0xFF | (this.buffer[57] & 0xFF) << 8 | (this.buffer[58] & 0xFF) << 16 | (this.buffer[59] & 0xFF) << 24 | (this.buffer[60] & 0xFF) << 32 | (this.buffer[61] & 0xFF) << 40 | (this.buffer[62] & 0xFF) << 48 | (this.buffer[63] & 0xFF) << 56;
        if (validThru == -1L) {
            return true;
        }
        if (validThru == 0L) {
            return false;
        }
        return current <= validThru;
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public void setMiTMData(byte[] data) {
        System.arraycopy(data, 0, this.buffer, 96, 32);
        this.setMITMKeyAvailable();
    }

    public byte[] getMiTMData() {
        return ZrtpUtils.readRegion(this.buffer, 96, 32);
    }

    public static void main(String[] argv) {
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
        byte[] dataLong = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32};
        ZidRecord rec = new ZidRecord();
        rec.setIdentifier(data);
        rec.setNewRs1(dataLong, 10);
        rec.setMiTMData(dataLong);
        System.err.println("is rs 1 valid: " + rec.isRs1NotExpired());
        dataLong[0] = (byte)(dataLong[0] + 1);
        rec.setNewRs1(dataLong, 16);
        System.err.println("is rs 2 valid: " + rec.isRs2NotExpired());
        ZrtpUtils.hexdump("ZID record", rec.getBuffer(), rec.getBuffer().length);
    }
}

