/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.zrtp.utils;

public class ZrtpUtils {
    private static final char[] hex = "0123456789abcdef".toCharArray();

    public static byte[] int32ToArray(int data) {
        byte[] output = new byte[]{(byte)(data >> 24), (byte)(data >> 16), (byte)(data >> 8), (byte)data};
        return output;
    }

    public static void int32ToArrayInPlace(int data, byte[] buffer, int offset) {
        buffer[offset] = (byte)(data >> 24);
        buffer[offset + 1] = (byte)(data >> 16);
        buffer[offset + 2] = (byte)(data >> 8);
        buffer[offset + 3] = (byte)data;
    }

    public static byte[] short16ToArray(int data) {
        byte[] output = new byte[]{(byte)(data >> 8), (byte)data};
        return output;
    }

    public static void short16ToArrayInPlace(int data, byte[] buffer, int offset) {
        buffer[offset] = (byte)(data >> 8);
        buffer[offset + 1] = (byte)data;
    }

    public static short readShort(byte[] buffer, int offset) {
        return (short)((buffer[offset + 0] & 0xFF) << 8 | buffer[offset + 1] & 0xFF);
    }

    public static int readInt(byte[] buffer, int offset) {
        return buffer[offset + 0] << 24 | (buffer[offset + 1] & 0xFF) << 16 | (buffer[offset + 2] & 0xFF) << 8 | buffer[offset + 3] & 0xFF;
    }

    public static byte[] readRegion(byte[] buffer, int offset, int length) {
        if (offset < 0 || length <= 0 || offset + length > buffer.length) {
            return null;
        }
        byte[] region = new byte[length];
        System.arraycopy(buffer, offset, region, 0, length);
        return region;
    }

    public static void hexdump(String title, byte[] buf, int len) {
        System.err.println(title);
        int i = 0;
        while (true) {
            byte b;
            int j = 0;
            while (j < 16) {
                if (i + j >= len) {
                    System.err.print("   ");
                } else {
                    b = buf[i + j];
                    System.err.print(" " + hex[b >>> 4 & 0xF] + hex[b & 0xF]);
                }
                ++j;
            }
            System.err.print("  ");
            j = 0;
            while (j < 16) {
                if (i + j >= len) break;
                b = buf[i + j];
                if ((byte)(b + 1) < 33) {
                    System.err.print('.');
                } else {
                    System.err.print((char)b);
                }
                ++j;
            }
            System.err.println();
            if (i + 16 >= len) break;
            i += 16;
        }
    }

    public static char[] bytesToHexString(byte[] in, int length) {
        if (length > in.length) {
            return null;
        }
        char[] out = new char[length * 2];
        int i = 0;
        while (i < length) {
            byte b = in[i];
            out[i * 2] = hex[b >>> 4 & 0xF];
            out[i * 2 + 1] = hex[b & 0xF];
            ++i;
        }
        return out;
    }

    public static int byteArrayCompare(byte[] arg1, byte[] arg2, int length) {
        int i = 0;
        while (i < length) {
            if ((arg1[i] & 0xFF) != (arg2[i] & 0xFF)) {
                return (arg1[i] & 0xFF) < (arg2[i] & 0xFF) ? -1 : 1;
            }
            ++i;
        }
        return 0;
    }
}

