/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.zrtp;

import gnu.java.bigintcrypto.BigIntegerCrypto;
import gnu.java.zrtp.utils.ZrtpFortuna;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.prng.RandomGenerator;
import org.bouncycastle.cryptozrtp.agreement.DHBasicAgreement;
import org.bouncycastle.cryptozrtp.agreement.ECDHBasicAgreement;
import org.bouncycastle.cryptozrtp.generators.DHBasicKeyPairGenerator;
import org.bouncycastle.cryptozrtp.generators.ECKeyPairGenerator;
import org.bouncycastle.cryptozrtp.params.DHKeyGenerationParameters;
import org.bouncycastle.cryptozrtp.params.DHParameters;
import org.bouncycastle.cryptozrtp.params.ECDomainParameters;
import org.bouncycastle.cryptozrtp.params.ECKeyGenerationParameters;
import org.bouncycastle.mathzrtp.ec.ECCurve;

public class ZrtpConstants {
    public static final int SHA256_DIGEST_LENGTH = 32;
    public static final int SHA384_DIGEST_LENGTH = 48;
    public static final int MAX_DIGEST_LENGTH = 64;
    public static final String clientId = "GNU ZRTP4J 2.1.0";
    public static final byte[] zrtpVersion = new byte[]{49, 46, 49, 48};
    public static final String AES_128 = "AES-CM-128";
    public static final String AES_256 = "AES-CM-256";
    public static final String TWO_128 = "TWO-CM-128";
    public static final String TWO_256 = "TWO-CM-256";
    public static final byte[] HelloMsg = new byte[]{72, 101, 108, 108, 111, 32, 32, 32};
    public static final byte[] HelloAckMsg = new byte[]{72, 101, 108, 108, 111, 65, 67, 75};
    public static final byte[] CommitMsg = new byte[]{67, 111, 109, 109, 105, 116, 32, 32};
    public static final byte[] DHPart1Msg = new byte[]{68, 72, 80, 97, 114, 116, 49, 32};
    public static final byte[] DHPart2Msg = new byte[]{68, 72, 80, 97, 114, 116, 50, 32};
    public static final byte[] Confirm1Msg = new byte[]{67, 111, 110, 102, 105, 114, 109, 49};
    public static final byte[] Confirm2Msg = new byte[]{67, 111, 110, 102, 105, 114, 109, 50};
    public static final byte[] Conf2AckMsg = new byte[]{67, 111, 110, 102, 50, 65, 67, 75};
    public static final byte[] ErrorMsg = new byte[]{69, 114, 114, 111, 114, 32, 32, 32};
    public static final byte[] ErrorAckMsg = new byte[]{69, 114, 114, 111, 114, 65, 67, 75};
    public static final byte[] PingMsg = new byte[]{80, 105, 110, 103, 32, 32, 32, 32};
    public static final byte[] PingAckMsg = new byte[]{80, 105, 110, 103, 65, 67, 75, 32};
    public static final byte[] GoClearMsg = new byte[]{71, 111, 67, 108, 101, 97, 114, 32};
    public static final byte[] ClearAckMsg = new byte[]{67, 108, 101, 97, 114, 65, 67, 75};
    public static final byte[] SASRelayMsg = new byte[]{83, 65, 83, 114, 101, 108, 97, 121};
    public static final byte[] RelayAckMsg = new byte[]{82, 101, 108, 97, 121, 65, 67, 75};
    public static final byte[] responder = new byte[]{82, 101, 115, 112, 111, 110, 100, 101, 114};
    public static final byte[] initiator = new byte[]{73, 110, 105, 116, 105, 97, 116, 111, 114};
    public static final byte[] iniMasterKey;
    public static final byte[] iniMasterSalt;
    public static final byte[] respMasterKey;
    public static final byte[] respMasterSalt;
    public static final byte[] iniHmacKey;
    public static final byte[] respHmacKey;
    public static final byte[] retainedSec;
    public static final byte[] iniZrtpKey;
    public static final byte[] respZrtpKey;
    public static final byte[] sasString;
    public static final byte[] KDFString;
    public static final byte[] zrtpSessionKey;
    public static final byte[] zrtpMsk;
    public static final byte[] zrtpTrustedMitm;
    public static final byte[] s256;
    public static final byte[] s384;
    public static final byte[] aes3;
    public static final byte[] aes1;
    public static final byte[] two1;
    public static final byte[] two3;
    public static final byte[] dh4k;
    public static final byte[] dh3k;
    public static final byte[] dh2k;
    public static final byte[] mult;
    public static final byte[] b32;
    public static final byte[] hs32;
    public static final byte[] hs80;
    public static final byte[] sk32;
    public static final byte[] sk64;
    public static final byte[] ec25;
    public static final byte[] ec38;
    public static final X9ECParameters x9Ec25;
    public static final X9ECParameters x9Ec38;
    public static final BigIntegerCrypto P2048;
    public static final BigIntegerCrypto P3072;
    public static final BigIntegerCrypto two;
    public static final BigIntegerCrypto P2048MinusOne;
    public static final BigIntegerCrypto P3072MinusOne;
    public static final DHParameters specDh2k;
    public static final DHParameters specDh3k;

    static {
        byte[] byArray = new byte[26];
        byArray[0] = 73;
        byArray[1] = 110;
        byArray[2] = 105;
        byArray[3] = 116;
        byArray[4] = 105;
        byArray[5] = 97;
        byArray[6] = 116;
        byArray[7] = 111;
        byArray[8] = 114;
        byArray[9] = 32;
        byArray[10] = 83;
        byArray[11] = 82;
        byArray[12] = 84;
        byArray[13] = 80;
        byArray[14] = 32;
        byArray[15] = 109;
        byArray[16] = 97;
        byArray[17] = 115;
        byArray[18] = 116;
        byArray[19] = 101;
        byArray[20] = 114;
        byArray[21] = 32;
        byArray[22] = 107;
        byArray[23] = 101;
        byArray[24] = 121;
        iniMasterKey = byArray;
        byte[] byArray2 = new byte[27];
        byArray2[0] = 73;
        byArray2[1] = 110;
        byArray2[2] = 105;
        byArray2[3] = 116;
        byArray2[4] = 105;
        byArray2[5] = 97;
        byArray2[6] = 116;
        byArray2[7] = 111;
        byArray2[8] = 114;
        byArray2[9] = 32;
        byArray2[10] = 83;
        byArray2[11] = 82;
        byArray2[12] = 84;
        byArray2[13] = 80;
        byArray2[14] = 32;
        byArray2[15] = 109;
        byArray2[16] = 97;
        byArray2[17] = 115;
        byArray2[18] = 116;
        byArray2[19] = 101;
        byArray2[20] = 114;
        byArray2[21] = 32;
        byArray2[22] = 115;
        byArray2[23] = 97;
        byArray2[24] = 108;
        byArray2[25] = 116;
        iniMasterSalt = byArray2;
        byte[] byArray3 = new byte[26];
        byArray3[0] = 82;
        byArray3[1] = 101;
        byArray3[2] = 115;
        byArray3[3] = 112;
        byArray3[4] = 111;
        byArray3[5] = 110;
        byArray3[6] = 100;
        byArray3[7] = 101;
        byArray3[8] = 114;
        byArray3[9] = 32;
        byArray3[10] = 83;
        byArray3[11] = 82;
        byArray3[12] = 84;
        byArray3[13] = 80;
        byArray3[14] = 32;
        byArray3[15] = 109;
        byArray3[16] = 97;
        byArray3[17] = 115;
        byArray3[18] = 116;
        byArray3[19] = 101;
        byArray3[20] = 114;
        byArray3[21] = 32;
        byArray3[22] = 107;
        byArray3[23] = 101;
        byArray3[24] = 121;
        respMasterKey = byArray3;
        byte[] byArray4 = new byte[27];
        byArray4[0] = 82;
        byArray4[1] = 101;
        byArray4[2] = 115;
        byArray4[3] = 112;
        byArray4[4] = 111;
        byArray4[5] = 110;
        byArray4[6] = 100;
        byArray4[7] = 101;
        byArray4[8] = 114;
        byArray4[9] = 32;
        byArray4[10] = 83;
        byArray4[11] = 82;
        byArray4[12] = 84;
        byArray4[13] = 80;
        byArray4[14] = 32;
        byArray4[15] = 109;
        byArray4[16] = 97;
        byArray4[17] = 115;
        byArray4[18] = 116;
        byArray4[19] = 101;
        byArray4[20] = 114;
        byArray4[21] = 32;
        byArray4[22] = 115;
        byArray4[23] = 97;
        byArray4[24] = 108;
        byArray4[25] = 116;
        respMasterSalt = byArray4;
        byte[] byArray5 = new byte[19];
        byArray5[0] = 73;
        byArray5[1] = 110;
        byArray5[2] = 105;
        byArray5[3] = 116;
        byArray5[4] = 105;
        byArray5[5] = 97;
        byArray5[6] = 116;
        byArray5[7] = 111;
        byArray5[8] = 114;
        byArray5[9] = 32;
        byArray5[10] = 72;
        byArray5[11] = 77;
        byArray5[12] = 65;
        byArray5[13] = 67;
        byArray5[14] = 32;
        byArray5[15] = 107;
        byArray5[16] = 101;
        byArray5[17] = 121;
        iniHmacKey = byArray5;
        byte[] byArray6 = new byte[19];
        byArray6[0] = 82;
        byArray6[1] = 101;
        byArray6[2] = 115;
        byArray6[3] = 112;
        byArray6[4] = 111;
        byArray6[5] = 110;
        byArray6[6] = 100;
        byArray6[7] = 101;
        byArray6[8] = 114;
        byArray6[9] = 32;
        byArray6[10] = 72;
        byArray6[11] = 77;
        byArray6[12] = 65;
        byArray6[13] = 67;
        byArray6[14] = 32;
        byArray6[15] = 107;
        byArray6[16] = 101;
        byArray6[17] = 121;
        respHmacKey = byArray6;
        byte[] byArray7 = new byte[16];
        byArray7[0] = 114;
        byArray7[1] = 101;
        byArray7[2] = 116;
        byArray7[3] = 97;
        byArray7[4] = 105;
        byArray7[5] = 110;
        byArray7[6] = 101;
        byArray7[7] = 100;
        byArray7[8] = 32;
        byArray7[9] = 115;
        byArray7[10] = 101;
        byArray7[11] = 99;
        byArray7[12] = 114;
        byArray7[13] = 101;
        byArray7[14] = 116;
        retainedSec = byArray7;
        byte[] byArray8 = new byte[19];
        byArray8[0] = 73;
        byArray8[1] = 110;
        byArray8[2] = 105;
        byArray8[3] = 116;
        byArray8[4] = 105;
        byArray8[5] = 97;
        byArray8[6] = 116;
        byArray8[7] = 111;
        byArray8[8] = 114;
        byArray8[9] = 32;
        byArray8[10] = 90;
        byArray8[11] = 82;
        byArray8[12] = 84;
        byArray8[13] = 80;
        byArray8[14] = 32;
        byArray8[15] = 107;
        byArray8[16] = 101;
        byArray8[17] = 121;
        iniZrtpKey = byArray8;
        byte[] byArray9 = new byte[19];
        byArray9[0] = 82;
        byArray9[1] = 101;
        byArray9[2] = 115;
        byArray9[3] = 112;
        byArray9[4] = 111;
        byArray9[5] = 110;
        byArray9[6] = 100;
        byArray9[7] = 101;
        byArray9[8] = 114;
        byArray9[9] = 32;
        byArray9[10] = 90;
        byArray9[11] = 82;
        byArray9[12] = 84;
        byArray9[13] = 80;
        byArray9[14] = 32;
        byArray9[15] = 107;
        byArray9[16] = 101;
        byArray9[17] = 121;
        respZrtpKey = byArray9;
        byte[] byArray10 = new byte[4];
        byArray10[0] = 83;
        byArray10[1] = 65;
        byArray10[2] = 83;
        sasString = byArray10;
        KDFString = new byte[]{90, 82, 84, 80, 45, 72, 77, 65, 67, 45, 75, 68, 70};
        byte[] byArray11 = new byte[17];
        byArray11[0] = 90;
        byArray11[1] = 82;
        byArray11[2] = 84;
        byArray11[3] = 80;
        byArray11[4] = 32;
        byArray11[5] = 83;
        byArray11[6] = 101;
        byArray11[7] = 115;
        byArray11[8] = 115;
        byArray11[9] = 105;
        byArray11[10] = 111;
        byArray11[11] = 110;
        byArray11[12] = 32;
        byArray11[13] = 75;
        byArray11[14] = 101;
        byArray11[15] = 121;
        zrtpSessionKey = byArray11;
        byte[] byArray12 = new byte[9];
        byArray12[0] = 90;
        byArray12[1] = 82;
        byArray12[2] = 84;
        byArray12[3] = 80;
        byArray12[4] = 32;
        byArray12[5] = 77;
        byArray12[6] = 83;
        byArray12[7] = 75;
        zrtpMsk = byArray12;
        byte[] byArray13 = new byte[17];
        byArray13[0] = 84;
        byArray13[1] = 114;
        byArray13[2] = 117;
        byArray13[3] = 115;
        byArray13[4] = 116;
        byArray13[5] = 101;
        byArray13[6] = 100;
        byArray13[7] = 32;
        byArray13[8] = 77;
        byArray13[9] = 105;
        byArray13[10] = 84;
        byArray13[11] = 77;
        byArray13[12] = 32;
        byArray13[13] = 107;
        byArray13[14] = 101;
        byArray13[15] = 121;
        zrtpTrustedMitm = byArray13;
        s256 = new byte[]{83, 50, 53, 54};
        s384 = new byte[]{83, 51, 56, 52};
        aes3 = new byte[]{65, 69, 83, 51};
        aes1 = new byte[]{65, 69, 83, 49};
        two1 = new byte[]{50, 70, 83, 49};
        two3 = new byte[]{50, 70, 83, 51};
        dh4k = new byte[]{68, 72, 52, 107};
        dh3k = new byte[]{68, 72, 51, 107};
        dh2k = new byte[]{68, 72, 50, 107};
        mult = new byte[]{77, 117, 108, 116};
        b32 = new byte[]{66, 51, 50, 32};
        hs32 = new byte[]{72, 83, 51, 50};
        hs80 = new byte[]{72, 83, 56, 48};
        sk32 = new byte[]{83, 75, 51, 50};
        sk64 = new byte[]{83, 75, 54, 52};
        ec25 = new byte[]{69, 67, 50, 53};
        ec38 = new byte[]{69, 67, 51, 56};
        x9Ec25 = SECNamedCurves.getByName((String)"secp256r1");
        x9Ec38 = SECNamedCurves.getByName((String)"secp384r1");
        P2048 = new BigIntegerCrypto("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AACAA68FFFFFFFFFFFFFFFF", 16);
        P3072 = new BigIntegerCrypto("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64ECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7ABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6BF12FFA06D98A0864D87602733EC86A64521F2B18177B200CBBE117577A615D6C770988C0BAD946E208E24FA074E5AB3143DB5BFCE0FD108E4B82D120A93AD2CAFFFFFFFFFFFFFFFF", 16);
        two = BigIntegerCrypto.valueOf(2L);
        P2048MinusOne = P2048.subtract(BigIntegerCrypto.ONE);
        P3072MinusOne = P3072.subtract(BigIntegerCrypto.ONE);
        specDh2k = new DHParameters(P2048, two, null, 256);
        specDh3k = new DHParameters(P3072, two, null, 512);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SupportedAuthAlgos {
        HS,
        SK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SupportedAuthLengths {
        SK32(sk32, SupportedAuthAlgos.SK, 32),
        HS32(hs32, SupportedAuthAlgos.HS, 32),
        SK64(sk64, SupportedAuthAlgos.SK, 64),
        HS80(hs80, SupportedAuthAlgos.HS, 80);

        public final byte[] name;
        public final SupportedAuthAlgos algo;
        public final int length;

        private SupportedAuthLengths(byte[] nm, SupportedAuthAlgos al, int len) {
            this.name = nm;
            this.algo = al;
            this.length = len;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SupportedHashes {
        S256(s256),
        S384(s384);

        public byte[] name;

        private SupportedHashes(byte[] nm) {
            this.name = nm;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SupportedPubKeys {
        EC25(ec25, 64, new ECKeyGenerationParameters(new ECDomainParameters(x9Ec25.getCurve(), x9Ec25.getG(), x9Ec25.getN(), x9Ec25.getH(), x9Ec25.getSeed()), ZrtpFortuna.getInstance())),
        EC38(ec38, 96, new ECKeyGenerationParameters(new ECDomainParameters(x9Ec38.getCurve(), x9Ec38.getG(), x9Ec38.getN(), x9Ec38.getH(), x9Ec38.getSeed()), ZrtpFortuna.getInstance())),
        DH2K(dh2k, 256, new DHKeyGenerationParameters((RandomGenerator)ZrtpFortuna.getInstance(), specDh2k)),
        DH3K(dh3k, 384, new DHKeyGenerationParameters((RandomGenerator)ZrtpFortuna.getInstance(), specDh3k)),
        MULT(mult);

        public byte[] name;
        public final DHBasicKeyPairGenerator dhKeyPairGen;
        public final ECKeyPairGenerator ecKeyPairGen;
        public final int pubKeySize;
        public final DHParameters specDh;
        public final ECCurve curve;
        public final ECDHBasicAgreement ecdhContext;
        public final DHBasicAgreement dhContext;

        private SupportedPubKeys(byte[] nm) {
            this.name = nm;
            this.pubKeySize = 0;
            this.dhKeyPairGen = null;
            this.specDh = null;
            this.dhContext = null;
            this.ecdhContext = null;
            this.ecKeyPairGen = null;
            this.curve = null;
        }

        private SupportedPubKeys(byte[] nm, int size, ECKeyGenerationParameters ecdh) {
            this.name = nm;
            this.pubKeySize = size;
            if (ecdh != null) {
                this.ecKeyPairGen = new ECKeyPairGenerator();
                this.ecKeyPairGen.init(ecdh);
                this.curve = ecdh.getDomainParameters().getCurve();
                this.ecdhContext = new ECDHBasicAgreement();
            } else {
                this.ecKeyPairGen = null;
                this.curve = null;
                this.ecdhContext = null;
            }
            this.dhKeyPairGen = null;
            this.specDh = null;
            this.dhContext = null;
        }

        private SupportedPubKeys(byte[] nm, int size, DHKeyGenerationParameters dh) {
            this.name = nm;
            this.pubKeySize = size;
            if (dh != null) {
                this.dhKeyPairGen = new DHBasicKeyPairGenerator();
                this.dhKeyPairGen.init(dh);
                this.specDh = dh.getParameters();
                this.dhContext = new DHBasicAgreement();
            } else {
                this.dhKeyPairGen = null;
                this.specDh = null;
                this.dhContext = null;
            }
            this.ecdhContext = null;
            this.ecKeyPairGen = null;
            this.curve = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SupportedSASTypes {
        B32(b32);

        public byte[] name;

        private SupportedSASTypes(byte[] nm) {
            this.name = nm;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SupportedSymAlgos {
        AES,
        TwoFish;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SupportedSymCiphers {
        AES3(aes3, 32, "AES-CM-256", new BufferedBlockCipher((BlockCipher)new CFBBlockCipher((BlockCipher)new AESFastEngine(), 128)), SupportedSymAlgos.AES),
        AES1(aes1, 16, "AES-CM-128", new BufferedBlockCipher((BlockCipher)new CFBBlockCipher((BlockCipher)new AESFastEngine(), 128)), SupportedSymAlgos.AES),
        TWO3(two3, 32, "TWO-CM-256", new BufferedBlockCipher((BlockCipher)new CFBBlockCipher((BlockCipher)new TwofishEngine(), 128)), SupportedSymAlgos.TwoFish),
        TWO1(two1, 16, "TWO-CM-128", new BufferedBlockCipher((BlockCipher)new CFBBlockCipher((BlockCipher)new TwofishEngine(), 128)), SupportedSymAlgos.TwoFish);

        public final byte[] name;
        public final int keyLength;
        public final String readable;
        public final BufferedBlockCipher cipher;
        public final SupportedSymAlgos algo;

        private SupportedSymCiphers(byte[] nm, int klen, String ra, BufferedBlockCipher ci, SupportedSymAlgos al) {
            this.name = nm;
            this.keyLength = klen;
            this.readable = ra;
            this.cipher = ci;
            this.algo = al;
        }
    }
}

