/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.util;

import java.util.Vector;
import javax.media.ControllerEvent;
import net.sf.fmj.media.util.MediaThread;

public abstract class ThreadedEventQueue
extends MediaThread {
    private Vector eventQueue = new Vector();
    private boolean killed = false;

    public ThreadedEventQueue() {
        this.useControlPriority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchEvents() {
        ControllerEvent evt = null;
        ThreadedEventQueue threadedEventQueue = this;
        synchronized (threadedEventQueue) {
            try {
                while (!this.killed && this.eventQueue.size() == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                System.err.println("MediaNode event thread " + e);
                return true;
            }
            if (this.eventQueue.size() > 0) {
                evt = (ControllerEvent)this.eventQueue.firstElement();
                this.eventQueue.removeElementAt(0);
            }
        }
        if (evt != null) {
            this.processEvent(evt);
        }
        return !this.killed || this.eventQueue.size() != 0;
    }

    public synchronized void kill() {
        this.killed = true;
        this.notifyAll();
    }

    public synchronized void postEvent(ControllerEvent evt) {
        this.eventQueue.addElement(evt);
        this.notifyAll();
    }

    protected abstract void processEvent(ControllerEvent var1);

    public void run() {
        while (this.dispatchEvents()) {
        }
    }
}

