/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import com.sun.media.util.Registry;
import java.awt.Component;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.BufferControl;
import javax.media.control.PacketQueueControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.protocol.BasicSourceStream;
import net.sf.fmj.media.protocol.BufferListener;
import net.sf.fmj.media.protocol.rtp.DataSource;
import net.sf.fmj.media.rtp.BufferControlImpl;
import net.sf.fmj.media.rtp.RTPRawReceiver;
import net.sf.fmj.media.rtp.util.RTPMediaThread;

public class RTPSourceStream
extends BasicSourceStream
implements PushBufferStream,
Runnable,
PacketQueueControl {
    private int nbAdd = 0;
    private int nbReset = 0;
    private int nbAppend = 0;
    private int nbInsert = 0;
    private int nbCutByHalf = 0;
    private int nbGrow = 0;
    private int nbPrepend = 0;
    private int nbRemoveAt = 0;
    private int nbReadWhileEmpty = 0;
    private int nbShrink = 0;
    private int nbDiscardedFull = 0;
    private int nbDiscardedShrink = 0;
    private int nbDiscardedLate = 0;
    private int nbDiscardedReset = 0;
    private int nbDiscardedVeryLate = 0;
    private int maxSizeReached = 0;
    private static final int DEFAULT_AUDIO_RATE = 8000;
    private static final int DEFAULT_VIDEO_RATE = 15;
    private static final int NOT_SPECIFIED = -1;
    private DataSource dsource;
    private Format format = null;
    BufferTransferHandler handler = null;
    boolean started = false;
    boolean killed = false;
    boolean replenish = true;
    PktQue pktQ;
    Object startReq = new Object();
    private RTPMediaThread thread = null;
    private boolean hasRead = false;
    private BufferControlImpl bc = null;
    private long lastSeqRecv = -1L;
    private long lastSeqSent = -1L;
    private BufferListener listener = null;
    private int threshold = 0;
    private boolean prebuffering = false;
    private boolean prebufferNotice = false;
    private boolean bufferWhenStopped = true;
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");
    static VideoFormat mpegVideo = new VideoFormat("mpeg/rtp");
    static VideoFormat h264Video = new VideoFormat("h264/rtp");

    private void printStats() {
        String cn = this.getClass().getCanonicalName() + " ";
        Log.info(cn + "Total packets added: " + this.nbAdd);
        Log.info(cn + "Times reset() called: " + this.nbReset);
        Log.info(cn + "Times grow() called: " + this.nbGrow);
        Log.info(cn + "Times shrink() called: " + this.nbShrink);
        Log.info(cn + "Times read() while empty:" + this.nbReadWhileEmpty);
        Log.info(cn + "Packets dropped because full: " + this.nbDiscardedFull);
        Log.info(cn + "Packets dropped while shrinking: " + this.nbDiscardedShrink);
        Log.info(cn + "Packets dropped because they were late: " + this.nbDiscardedLate);
        Log.info(cn + "Packets dropped because they were late by more than MAX_SIZE: " + this.nbDiscardedVeryLate);
        Log.info(cn + "Packets dropped in reset(): " + this.nbDiscardedReset);
        Log.info(cn + "Max size reached: " + this.maxSizeReached);
        Log.info(cn + "Adaptive jitter buffer mode was " + (this.pktQ.AJB_ENABLED ? "enabled" : "disabled"));
    }

    public RTPSourceStream(DataSource datasource) {
        this.dsource = datasource;
        datasource.setSourceStream(this);
        this.pktQ = new PktQue(4);
        this.createThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Buffer buffer, boolean flag, RTPRawReceiver rtprawreceiver) {
        if (!this.started && !this.bufferWhenStopped) {
            return;
        }
        long bufferSN = buffer.getSequenceNumber();
        if (this.lastSeqRecv - bufferSN > 256L) {
            Log.info("Resetting queue, last seq added: " + this.lastSeqRecv + ", current seq: " + bufferSN);
            this.reset();
            this.lastSeqRecv = bufferSN;
        }
        if (this.lastSeqSent != -1L && bufferSN < this.lastSeqSent && this.format instanceof AudioFormat) {
            if (this.lastSeqSent - bufferSN < (long)this.pktQ.AJB_MAX_SIZE) {
                this.pktQ.recordInHistory(true);
                ++this.nbDiscardedLate;
            } else {
                ++this.nbDiscardedVeryLate;
            }
            return;
        }
        ++this.nbAdd;
        this.pktQ.recordInHistory(false);
        this.lastSeqRecv = bufferSN;
        boolean almostFull = false;
        PktQue pktQue = this.pktQ;
        synchronized (pktQue) {
            this.pktQ.monitorQueueSize(buffer, rtprawreceiver);
            if (this.pktQ.noMoreFree()) {
                ++this.nbDiscardedFull;
                long l = this.pktQ.getFirstSeq();
                if (l != -1L && buffer.getSequenceNumber() < l) {
                    return;
                }
                this.pktQ.dropPkt();
            }
        }
        if (this.pktQ.totalFree() <= 1) {
            almostFull = true;
        }
        Buffer freeBuffer = this.pktQ.getFree();
        byte[] bufferData = (byte[])buffer.getData();
        byte[] freeBufferData = (byte[])freeBuffer.getData();
        if (freeBufferData == null || freeBufferData.length < bufferData.length) {
            freeBufferData = new byte[bufferData.length];
        }
        System.arraycopy(bufferData, buffer.getOffset(), freeBufferData, buffer.getOffset(), buffer.getLength());
        freeBuffer.copy(buffer);
        freeBuffer.setData(freeBufferData);
        if (almostFull) {
            freeBuffer.setFlags(freeBuffer.getFlags() | 0x2000 | 0x20);
        } else {
            freeBuffer.setFlags(freeBuffer.getFlags() | 0x20);
        }
        this.pktQ.addPkt(freeBuffer);
        PktQue pktQue2 = this.pktQ;
        synchronized (pktQue2) {
            if (this.started && this.prebufferNotice && this.listener != null && this.pktQ.totalPkts() >= this.threshold) {
                this.listener.minThresholdReached(this.dsource);
                this.prebufferNotice = false;
                this.prebuffering = false;
                Object object = this.startReq;
                synchronized (object) {
                    this.startReq.notifyAll();
                }
            }
            if (this.replenish && this.format instanceof AudioFormat) {
                if (this.pktQ.totalPkts() >= this.pktQ.size / 2) {
                    this.replenish = false;
                    this.pktQ.notifyAll();
                }
            } else {
                this.pktQ.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.killed) {
            return;
        }
        this.printStats();
        this.stop();
        this.killed = true;
        Object object = this.startReq;
        synchronized (object) {
            this.startReq.notifyAll();
        }
        object = this.pktQ;
        synchronized (object) {
            this.pktQ.notifyAll();
        }
        this.thread = null;
        if (this.bc != null) {
            this.bc.removeSourceStream(this);
        }
    }

    public void connect() {
        this.killed = false;
        this.createThread();
    }

    private void createThread() {
        if (this.thread != null) {
            return;
        }
        this.thread = new RTPMediaThread(this, "RTPStream");
        this.thread.useControlPriority();
        this.thread.start();
    }

    public Format getFormat() {
        return this.format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prebuffer() {
        PktQue pktQue = this.pktQ;
        synchronized (pktQue) {
            this.prebuffering = true;
            this.prebufferNotice = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Buffer buffer) {
        if (this.pktQ.totalPkts() == 0) {
            ++this.nbReadWhileEmpty;
            buffer.setDiscard(true);
            return;
        }
        Buffer bufferFromQueue = this.pktQ.getPkt();
        this.lastSeqSent = bufferFromQueue.getSequenceNumber();
        Object bufferData = buffer.getData();
        Object bufferHeader = buffer.getHeader();
        buffer.copy(bufferFromQueue);
        bufferFromQueue.setData(bufferData);
        bufferFromQueue.setHeader(bufferHeader);
        this.pktQ.returnFree(bufferFromQueue);
        PktQue pktQue = this.pktQ;
        synchronized (pktQue) {
            this.hasRead = true;
            if (this.format instanceof AudioFormat) {
                if (this.pktQ.totalPkts() > 0) {
                    this.pktQ.notifyAll();
                } else {
                    this.replenish = true;
                }
            } else {
                this.pktQ.notifyAll();
            }
        }
    }

    public void reset() {
        this.pktQ.reset();
        this.lastSeqSent = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block8: while (true) {
            try {
                while (true) {
                    Object object = this.startReq;
                    synchronized (object) {
                        while (!(this.started && !this.prebuffering || this.killed)) {
                            this.startReq.wait();
                        }
                    }
                    object = this.pktQ;
                    synchronized (object) {
                        do {
                            if (!this.hasRead && !this.killed) {
                                this.pktQ.wait();
                            }
                            this.hasRead = false;
                        } while (this.pktQ.totalPkts() <= 0 && !this.killed);
                    }
                    if (this.killed) break block8;
                    if (this.handler == null) continue;
                    this.handler.transferData(this);
                }
            }
            catch (InterruptedException interruptedexception) {
                Log.error("Thread " + interruptedexception.getMessage());
                continue;
            }
            break;
        }
    }

    public void setBufferControl(BufferControl buffercontrol) {
        this.bc = (BufferControlImpl)buffercontrol;
        this.updateBuffer(this.bc.getBufferLength());
        this.updateThreshold(this.bc.getMinimumThreshold());
    }

    public void setBufferListener(BufferListener bufferlistener) {
        this.listener = bufferlistener;
    }

    public void setBufferWhenStopped(boolean flag) {
        this.bufferWhenStopped = flag;
    }

    void setContentDescriptor(String s) {
        this.contentDescriptor = new ContentDescriptor(s);
    }

    protected void setFormat(Format format1) {
        this.format = format1;
    }

    public void setTransferHandler(BufferTransferHandler buffertransferhandler) {
        this.handler = buffertransferhandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Log.info("Starting RTPSourceStream");
        Object object = this.startReq;
        synchronized (object) {
            this.started = true;
            this.startReq.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Log.info("Stopping RTPSourceStream, dumping stack trace (this is not an error)");
        for (StackTraceElement s : new Throwable().getStackTrace()) {
            Log.info(s.toString());
        }
        Object object = this.startReq;
        synchronized (object) {
            this.started = false;
            this.prebuffering = false;
            if (!this.bufferWhenStopped) {
                this.reset();
            }
        }
    }

    public long updateBuffer(long l) {
        return l;
    }

    public long updateThreshold(long l) {
        return l;
    }

    public int getDiscarded() {
        return this.nbDiscardedFull + this.nbDiscardedLate + this.nbDiscardedReset + this.nbDiscardedShrink + this.nbDiscardedVeryLate;
    }

    public int getDiscardedShrink() {
        return this.nbDiscardedShrink;
    }

    public int getDiscardedLate() {
        return this.nbDiscardedLate;
    }

    public int getDiscardedReset() {
        return this.nbDiscardedReset;
    }

    public int getDiscardedFull() {
        return this.nbDiscardedFull;
    }

    public int getCurrentDelayMs() {
        return (int)((long)this.getCurrentDelayPackets() * this.pktQ.msPerPkt);
    }

    public int getCurrentDelayPackets() {
        return this.pktQ.size / 2;
    }

    public int getCurrentSizePackets() {
        return this.pktQ.size;
    }

    public int getMaxSizeReached() {
        return this.maxSizeReached;
    }

    public boolean isAdaptiveBufferEnabled() {
        return this.pktQ.AJB_ENABLED;
    }

    public int getCurrentPacketCount() {
        return this.pktQ.totalPkts();
    }

    public Component getControlComponent() {
        return null;
    }

    public Object getControl(String controlType) {
        if (PacketQueueControl.class.getName().equals(controlType)) {
            return this;
        }
        return super.getControl(controlType);
    }

    public Object[] getControls() {
        Object[] superControls = super.getControls();
        Object[] controls = new Object[superControls.length + 1];
        System.arraycopy(superControls, 0, controls, 0, superControls.length);
        controls[superControls.length] = this;
        return controls;
    }

    private class PktQue {
        private static final int FUDGE = 5;
        private static final int DEFAULT_AUD_PKT_SIZE = 256;
        private static final int DEFAULT_MS_PER_PKT = 20;
        private static final int DEFAULT_PKTS_TO_BUFFER = 90;
        private static final int MIN_BUF_CHECK = 10000;
        private static final int BUF_CHECK_INTERVAL = 7000;
        private final int AJB_GROW_INTERVAL;
        private final int AJB_GROW_THRESHOLD;
        private final int AJB_GROW_INCREMENT;
        private final int AJB_SHRINK_INTERVAL;
        private final int AJB_SHRINK_THRESHOLD;
        private final int AJB_SHRINK_DECREMENT;
        private final boolean AJB_ENABLED;
        private final int AJB_MIN_SIZE;
        private final int AJB_MAX_SIZE;
        private final int AJB_HISTORY_SIZE;
        private int[] history;
        private int growCount;
        private int shrinkCount;
        private int historyPointer;
        private int historyCount;
        int pktsEst;
        int framesEst = 0;
        int fps = 15;
        int pktsPerFrame = 15;
        private int sizePerPkt = 256;
        private long msPerPkt = 20L;
        int maxPktsToBuffer = 0;
        private int sockBufSize = 0;
        int tooMuchBufferingCount = 0;
        long lastPktSeq = 0L;
        long lastCheckTime = 0L;
        private Buffer[] fill;
        private Buffer[] free;
        private int headFill;
        private int tailFill;
        private int headFree;
        private int tailFree;
        protected int size;

        public PktQue(int size) {
            this.allocBuffers(size);
            Object value = Registry.get("adaptive_jitter_buffer_GROW_INTERVAL");
            int growInterval = 30;
            try {
                growInterval = Integer.parseInt((String)value);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.AJB_GROW_INTERVAL = growInterval;
            value = Registry.get("adaptive_jitter_buffer_GROW_THRESHOLD");
            int growThreshold = 3;
            try {
                growThreshold = Integer.parseInt((String)value);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.AJB_GROW_THRESHOLD = growThreshold;
            value = Registry.get("adaptive_jitter_buffer_GROW_INCREMENT");
            int growIncrement = 2;
            try {
                growIncrement = Integer.parseInt((String)value);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.AJB_GROW_INCREMENT = growIncrement;
            value = Registry.get("adaptive_jitter_buffer_SHRINK_INTERVAL");
            int shrinkInterval = 200;
            try {
                shrinkInterval = Integer.parseInt((String)value);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.AJB_SHRINK_INTERVAL = shrinkInterval;
            value = Registry.get("adaptive_jitter_buffer_SHRINK_THRESHOLD");
            int shrinkThreshold = 0;
            try {
                shrinkThreshold = Integer.parseInt((String)value);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.AJB_SHRINK_THRESHOLD = shrinkThreshold;
            value = Registry.get("adaptive_jitter_buffer_SHRINK_DECREMENT");
            int shrinkDecrement = 2;
            try {
                shrinkDecrement = Integer.parseInt((String)value);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.AJB_SHRINK_DECREMENT = shrinkDecrement;
            value = Registry.get("adaptive_jitter_buffer_MIN_SIZE");
            int minSize = 4;
            try {
                minSize = Integer.parseInt((String)value);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.AJB_MIN_SIZE = minSize;
            value = Registry.get("adaptive_jitter_buffer_MAX_SIZE");
            int maxSize = 50;
            try {
                maxSize = Integer.parseInt((String)value);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.AJB_MAX_SIZE = maxSize;
            value = Registry.get("adaptive_jitter_buffer_ENABLE");
            boolean enableAJB = true;
            try {
                if (value != null) {
                    enableAJB = Boolean.parseBoolean((String)value);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.AJB_ENABLED = enableAJB;
            this.AJB_HISTORY_SIZE = this.AJB_GROW_INTERVAL < this.AJB_SHRINK_INTERVAL ? this.AJB_SHRINK_INTERVAL : this.AJB_GROW_INTERVAL;
            this.initHistory();
        }

        public void recordInHistory(boolean late) {
            int n = late ? 1 : 0;
            int growPointer = (this.historyPointer - this.AJB_GROW_INTERVAL + this.AJB_HISTORY_SIZE) % this.AJB_HISTORY_SIZE;
            this.growCount = this.growCount - this.history[growPointer] + n;
            int shrinkPointer = (this.historyPointer - this.AJB_SHRINK_INTERVAL + this.AJB_HISTORY_SIZE) % this.AJB_HISTORY_SIZE;
            this.shrinkCount = this.shrinkCount - this.history[shrinkPointer] + n;
            this.history[this.historyPointer] = n;
            this.historyPointer = (this.historyPointer + 1) % this.AJB_HISTORY_SIZE;
            if (this.historyCount < this.AJB_HISTORY_SIZE) {
                ++this.historyCount;
            }
        }

        private void resetHistory() {
            this.historyCount = 0;
        }

        private void initHistory() {
            this.history = new int[this.AJB_HISTORY_SIZE];
            this.historyCount = 0;
            this.historyPointer = 0;
            this.growCount = 0;
            this.shrinkCount = 0;
        }

        public synchronized void addPkt(Buffer buffer) {
            long firstSN = -1L;
            long lastSN = -1L;
            long bufferSN = buffer.getSequenceNumber();
            if (this.fillNotEmpty()) {
                firstSN = this.fill[this.headFill].getSequenceNumber();
                int i = this.tailFill - 1;
                if (i < 0) {
                    i = this.size - 1;
                }
                lastSN = this.fill[i].getSequenceNumber();
            }
            if (firstSN == -1L && lastSN == -1L) {
                this.append(buffer);
            } else if (bufferSN < firstSN) {
                this.prepend(buffer);
            } else if (firstSN < bufferSN && bufferSN < lastSN) {
                this.insert(buffer);
            } else if (bufferSN > lastSN) {
                this.append(buffer);
            } else {
                this.returnFree(buffer);
            }
        }

        private void allocBuffers(int i) {
            this.fill = new Buffer[i];
            this.free = new Buffer[i];
            for (int j = 0; j < i - 1; ++j) {
                this.free[j] = new Buffer();
            }
            this.size = i;
            this.tailFill = 0;
            this.headFill = 0;
            this.headFree = 0;
            this.tailFree = this.size - 1;
        }

        private synchronized void append(Buffer buffer) {
            RTPSourceStream.this.nbAppend++;
            this.fill[this.tailFill] = buffer;
            ++this.tailFill;
            if (this.tailFill >= this.size) {
                this.tailFill = 0;
            }
        }

        private synchronized void cutByHalf() {
            int k;
            RTPSourceStream.this.nbCutByHalf++;
            int i = this.size / 2;
            if (i <= 0) {
                return;
            }
            Buffer[] abuffer = new Buffer[this.size / 2];
            Buffer[] abuffer1 = new Buffer[this.size / 2];
            int j = this.totalPkts();
            for (k = 0; k < i && k < j; ++k) {
                abuffer[k] = this.get();
            }
            j = i - k - (this.size - j - this.totalFree());
            this.headFill = 0;
            this.tailFill = k;
            for (int l = 0; l <= j; ++l) {
                abuffer1[l] = new Buffer();
            }
            this.headFree = 0;
            this.tailFree = j;
            this.fill = abuffer;
            this.free = abuffer1;
            this.size = i;
        }

        private synchronized void dropFirstPkt() {
            Buffer buffer = this.get();
            this.returnFree(buffer);
        }

        private synchronized void dropMpegPkt() {
            int i = this.headFill;
            int j = -1;
            int k = -1;
            while (i != this.tailFill) {
                int l;
                Buffer buffer = this.fill[i];
                byte[] abyte0 = (byte[])buffer.getData();
                int i1 = abyte0[(l = buffer.getOffset()) + 2] & 7;
                if (i1 > 2) {
                    k = i;
                    break;
                }
                if (i1 == 2 && j == -1) {
                    j = i;
                }
                if (++i < this.size) continue;
                i = 0;
            }
            if (k == -1) {
                i = j != -1 ? j : this.headFill;
            }
            Buffer buffer1 = this.fill[i];
            this.removeAt(i);
        }

        public void dropPkt() {
            while (!this.fillNotEmpty()) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            if (RTPSourceStream.this.format instanceof AudioFormat) {
                this.dropFirstPkt();
            } else if (mpegVideo.matches(RTPSourceStream.this.format)) {
                this.dropMpegPkt();
            } else {
                this.dropFirstPkt();
            }
        }

        private synchronized Buffer get() {
            Buffer buffer = this.fill[this.headFill];
            this.fill[this.headFill] = null;
            ++this.headFill;
            if (this.headFill >= this.size) {
                this.headFill = 0;
            }
            return buffer;
        }

        public synchronized long getFirstSeq() {
            if (!this.fillNotEmpty()) {
                return -1L;
            }
            return this.fill[this.headFill].getSequenceNumber();
        }

        public synchronized Buffer getFree() {
            Buffer buffer = this.free[this.headFree];
            this.free[this.headFree] = null;
            ++this.headFree;
            if (this.headFree >= this.size) {
                this.headFree = 0;
            }
            return buffer;
        }

        public synchronized Buffer getPkt() {
            while (!this.fillNotEmpty()) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            return this.get();
        }

        private synchronized void shrink(int newSize) {
            RTPSourceStream.this.nbShrink++;
            if (this.size == newSize) {
                return;
            }
            int packetCount = this.totalPkts();
            while (packetCount > newSize / 2) {
                this.dropPkt();
                RTPSourceStream.this.nbDiscardedShrink++;
                packetCount = this.totalPkts();
            }
            Buffer[] newFill = new Buffer[newSize];
            Buffer[] newFree = new Buffer[newSize];
            for (int k = 0; k < packetCount; ++k) {
                newFill[k] = this.get();
            }
            this.headFill = 0;
            this.tailFill = packetCount % newSize;
            int newFreeCount = newSize - packetCount;
            for (int l = 0; l < newFreeCount; ++l) {
                newFree[l] = new Buffer();
            }
            this.headFree = 0;
            this.tailFree = newFreeCount - 1;
            this.fill = newFill;
            this.free = newFree;
            this.size = newSize;
        }

        private synchronized void grow(int newSize) {
            RTPSourceStream.this.nbGrow++;
            Buffer[] newFill = new Buffer[newSize];
            Buffer[] newFree = new Buffer[newSize];
            int j1 = this.totalPkts();
            int k1 = this.totalFree();
            int j = this.headFill;
            int l = 0;
            while (j != this.tailFill) {
                newFill[l] = this.fill[j];
                if (++j >= this.size) {
                    j = 0;
                }
                ++l;
            }
            this.headFill = 0;
            this.tailFill = j1;
            this.fill = newFill;
            j = this.headFree;
            int i1 = 0;
            while (j != this.tailFree) {
                newFree[i1] = this.free[j];
                if (++j >= this.size) {
                    j = 0;
                }
                ++i1;
            }
            this.headFree = 0;
            this.tailFree = k1;
            for (int k = newSize - this.size; k > 0; --k) {
                newFree[this.tailFree] = new Buffer();
                ++this.tailFree;
            }
            this.free = newFree;
            this.size = newSize;
        }

        private synchronized void insert(Buffer buffer) {
            RTPSourceStream.this.nbInsert++;
            int i = this.headFill;
            while (i != this.tailFill && this.fill[i].getSequenceNumber() <= buffer.getSequenceNumber()) {
                if (++i < this.size) continue;
                i = 0;
            }
            if (i != this.tailFill) {
                int k;
                ++this.tailFill;
                if (this.tailFill >= this.size) {
                    this.tailFill = 0;
                }
                int j = k = this.tailFill;
                do {
                    if (--k < 0) {
                        k = this.size - 1;
                    }
                    this.fill[j] = this.fill[k];
                } while ((j = k) != i);
                this.fill[i] = buffer;
            }
        }

        public void monitorQueueSize(Buffer buffer, RTPRawReceiver rtprawreceiver) {
            if (this.size > RTPSourceStream.this.maxSizeReached) {
                RTPSourceStream.this.maxSizeReached = this.size;
            }
            this.sizePerPkt = (this.sizePerPkt + buffer.getLength()) / 2;
            if (RTPSourceStream.this.format instanceof VideoFormat) {
                int i;
                this.pktsEst = this.lastPktSeq + 1L == buffer.getSequenceNumber() ? ++this.pktsEst : 1;
                this.lastPktSeq = buffer.getSequenceNumber();
                if (mpegVideo.matches(RTPSourceStream.this.format)) {
                    int k;
                    byte[] abyte0 = (byte[])buffer.getData();
                    int k1 = abyte0[(k = buffer.getOffset()) + 2] & 7;
                    if (k1 < 3 && (buffer.getFlags() & 0x800) != 0) {
                        this.pktsPerFrame = (this.pktsPerFrame + this.pktsEst) / 2;
                        this.pktsEst = 0;
                    }
                    this.fps = 30;
                } else if (h264Video.matches(RTPSourceStream.this.format)) {
                    this.pktsPerFrame = 300;
                    this.fps = 15;
                }
                if ((buffer.getFlags() & 0x800) != 0) {
                    this.pktsPerFrame = (this.pktsPerFrame + this.pktsEst) / 2;
                    this.pktsEst = 0;
                    ++this.framesEst;
                    long l = System.currentTimeMillis();
                    if (l - this.lastCheckTime >= 1000L) {
                        this.lastCheckTime = l;
                        this.fps = (this.fps + this.framesEst) / 2;
                        this.framesEst = 0;
                        if (this.fps > 30) {
                            this.fps = 30;
                        }
                    }
                }
                if (RTPSourceStream.this.bc != null) {
                    i = (int)(RTPSourceStream.this.bc.getBufferLength() * (long)this.fps / 1000L);
                    if (i <= 0) {
                        i = 1;
                    }
                    i = this.pktsPerFrame * i;
                    RTPSourceStream.this.threshold = i / 2;
                } else {
                    i = 90;
                }
                this.maxPktsToBuffer = h264Video.matches(RTPSourceStream.this.format) ? 200 : (this.maxPktsToBuffer > 0 ? (this.maxPktsToBuffer + i) / 2 : i);
                int i1 = this.totalPkts();
                if (this.size > 10000 && i1 < this.size / 4) {
                    if (!RTPSourceStream.this.prebuffering && this.tooMuchBufferingCount++ > this.pktsPerFrame * this.fps * 7000) {
                        this.cutByHalf();
                        this.tooMuchBufferingCount = 0;
                    }
                } else if (i1 >= this.size / 2 && this.size < this.maxPktsToBuffer) {
                    i = this.size + this.size / 2;
                    if (i > this.maxPktsToBuffer) {
                        i = this.maxPktsToBuffer;
                    }
                    this.grow(i + 5);
                    Log.comment("RTP video buffer size: " + this.size + " pkts, " + i * this.sizePerPkt + " bytes.\n");
                    this.tooMuchBufferingCount = 0;
                } else {
                    this.tooMuchBufferingCount = 0;
                }
                int l1 = i * this.sizePerPkt / 2;
                if (rtprawreceiver != null && l1 > this.sockBufSize) {
                    rtprawreceiver.setRecvBufSize(l1);
                    this.sockBufSize = rtprawreceiver.getRecvBufSize() < l1 ? Integer.MAX_VALUE : l1;
                    Log.comment("RTP video socket receive buffer size: " + rtprawreceiver.getRecvBufSize() + " bytes.\n");
                }
            } else if (RTPSourceStream.this.format instanceof AudioFormat) {
                int n;
                if (this.AJB_ENABLED && this.historyCount >= this.AJB_GROW_INTERVAL && this.growCount >= this.AJB_GROW_THRESHOLD && this.size < this.AJB_MAX_SIZE) {
                    n = this.size + this.AJB_GROW_INCREMENT;
                    if (n > this.AJB_MAX_SIZE) {
                        n = this.AJB_MAX_SIZE;
                    }
                    if (n > this.size) {
                        Log.info("Growing packet queue to " + n);
                        this.grow(n);
                        this.resetHistory();
                    }
                } else if (this.AJB_ENABLED && this.historyCount >= this.AJB_SHRINK_INTERVAL && this.shrinkCount <= this.AJB_SHRINK_THRESHOLD && this.size > this.AJB_MIN_SIZE) {
                    n = this.size - this.AJB_SHRINK_DECREMENT;
                    if (n < this.AJB_MIN_SIZE) {
                        n = this.AJB_MIN_SIZE;
                    }
                    if (n < this.size) {
                        Log.info("Shrinking the queue to " + n);
                        this.shrink(n);
                        this.resetHistory();
                    }
                }
                if (this.sizePerPkt <= 0) {
                    this.sizePerPkt = 256;
                }
                if (RTPSourceStream.this.bc != null) {
                    long ms;
                    block39: {
                        if (mpegAudio.matches(RTPSourceStream.this.format)) {
                            ms = this.sizePerPkt / 4;
                        } else {
                            ms = 20L;
                            try {
                                long ns = buffer.getDuration();
                                if (ns <= 0L) {
                                    ns = ((AudioFormat)RTPSourceStream.this.format).computeDuration(buffer.getLength());
                                    if (ns > 0L) {
                                        ms = ns / 1000000L;
                                    }
                                } else {
                                    ms = ns / 1000000L;
                                }
                            }
                            catch (Throwable t) {
                                if (!(t instanceof ThreadDeath)) break block39;
                                throw (ThreadDeath)t;
                            }
                        }
                    }
                    this.msPerPkt = (this.msPerPkt + ms) / 2L;
                    ms = this.msPerPkt == 0L ? 20L : this.msPerPkt;
                    int aprxBufferLengthInPkts = (int)(RTPSourceStream.this.bc.getBufferLength() / ms);
                    RTPSourceStream.this.threshold = aprxBufferLengthInPkts / 2;
                    if (aprxBufferLengthInPkts > this.size && !this.AJB_ENABLED) {
                        this.grow(aprxBufferLengthInPkts);
                        Log.comment("Grew audio RTP packet queue to: " + this.size + " pkts, " + this.size * this.sizePerPkt + " bytes.\n");
                    }
                    int aprxThresholdInBytes = aprxBufferLengthInPkts * this.sizePerPkt / 2;
                    if (rtprawreceiver != null && aprxThresholdInBytes > this.sockBufSize) {
                        rtprawreceiver.setRecvBufSize(aprxThresholdInBytes);
                        this.sockBufSize = rtprawreceiver.getRecvBufSize() < aprxThresholdInBytes ? Integer.MAX_VALUE : aprxThresholdInBytes;
                        Log.comment("RTP audio socket receive buffer size: " + rtprawreceiver.getRecvBufSize() + " bytes.\n");
                    }
                }
            }
        }

        private boolean fillNotEmpty() {
            return this.headFill != this.tailFill;
        }

        private boolean noMoreFree() {
            return this.headFree == this.tailFree;
        }

        private synchronized void prepend(Buffer buffer) {
            RTPSourceStream.this.nbPrepend++;
            if (this.headFill == this.tailFill) {
                return;
            }
            --this.headFill;
            if (this.headFill < 0) {
                this.headFill = this.size - 1;
            }
            this.fill[this.headFill] = buffer;
        }

        private void removeAt(int i) {
            RTPSourceStream.this.nbRemoveAt++;
            Buffer buffer = this.fill[i];
            if (i == this.headFill) {
                ++this.headFill;
                if (this.headFill >= this.size) {
                    this.headFill = 0;
                }
            } else if (i == this.tailFill) {
                --this.tailFill;
                if (this.tailFill < 0) {
                    this.tailFill = this.size - 1;
                }
            } else {
                int j = i;
                do {
                    if (--j < 0) {
                        j = this.size - 1;
                    }
                    this.fill[i] = this.fill[j];
                } while ((i = j) != this.headFill);
                ++this.headFill;
                if (this.headFill >= this.size) {
                    this.headFill = 0;
                }
            }
            this.returnFree(buffer);
        }

        public synchronized void reset() {
            Log.comment("Resetting the packet queue");
            this.resetHistory();
            RTPSourceStream.this.nbReset++;
            while (this.fillNotEmpty()) {
                RTPSourceStream.this.nbDiscardedReset++;
                this.returnFree(this.get());
            }
            this.tooMuchBufferingCount = 0;
            this.notifyAll();
        }

        private synchronized void returnFree(Buffer buffer) {
            this.free[this.tailFree] = buffer;
            ++this.tailFree;
            if (this.tailFree >= this.size) {
                this.tailFree = 0;
            }
        }

        public int totalFree() {
            return this.tailFree < this.headFree ? this.size - (this.headFree - this.tailFree) : this.tailFree - this.headFree;
        }

        public int totalPkts() {
            return this.tailFill < this.headFill ? this.size - (this.headFill - this.tailFill) : this.tailFill - this.headFill;
        }
    }
}

