/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.media.Format;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionManager;
import javax.media.rtp.event.ActiveReceiveStreamEvent;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.RemotePayloadChangeEvent;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.protocol.rtp.DataSource;
import net.sf.fmj.media.rtp.BufferControlImpl;
import net.sf.fmj.media.rtp.RTPControlImpl;
import net.sf.fmj.media.rtp.RTPDemultiplexer;
import net.sf.fmj.media.rtp.RTPRawReceiver;
import net.sf.fmj.media.rtp.RTPSourceStream;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.SSRCInfo;
import net.sf.fmj.media.rtp.SourceRTPPacket;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketFilter;
import net.sf.fmj.media.rtp.util.PacketSource;
import net.sf.fmj.media.rtp.util.RTPPacket;
import net.sf.fmj.media.rtp.util.SSRCTable;
import net.sf.fmj.media.rtp.util.UDPPacket;

public class RTPReceiver
extends PacketFilter {
    SSRCCache cache;
    RTPDemultiplexer rtpdemultiplexer;
    int lastseqnum = -1;
    private boolean rtcpstarted = false;
    private boolean setpriority = false;
    private boolean mismatchprinted = false;
    private String content = "";
    SSRCTable probationList = new SSRCTable();
    static final int MAX_DROPOUT = 3000;
    static final int MAX_MISORDER = 100;
    static final int SEQ_MOD = 65536;
    static final int MIN_SEQUENTIAL = 2;
    private boolean initBC = false;
    public String controlstr = "javax.media.rtp.RTPControl";
    private int errorPayload = -1;

    public RTPReceiver(SSRCCache ssrccache, RTPDemultiplexer rtpdemultiplexer1) {
        this.cache = ssrccache;
        this.rtpdemultiplexer = rtpdemultiplexer1;
        this.setConsumer(null);
    }

    public RTPReceiver(SSRCCache ssrccache, RTPDemultiplexer rtpdemultiplexer1, DatagramSocket datagramsocket) {
        this(ssrccache, rtpdemultiplexer1, new RTPRawReceiver(datagramsocket, ssrccache.sm.defaultstats));
    }

    public RTPReceiver(SSRCCache ssrccache, RTPDemultiplexer rtpdemultiplexer1, int i, String s) throws UnknownHostException, IOException {
        this(ssrccache, rtpdemultiplexer1, new RTPRawReceiver(i & 0xFFFFFFFE, s, ssrccache.sm.defaultstats));
    }

    public RTPReceiver(SSRCCache ssrccache, RTPDemultiplexer rtpdemultiplexer1, PacketSource packetsource) {
        this(ssrccache, rtpdemultiplexer1);
        this.setSource(packetsource);
    }

    public String filtername() {
        return "RTP Packet Receiver";
    }

    public Packet handlePacket(Packet packet) {
        return this.handlePacket((RTPPacket)packet);
    }

    public Packet handlePacket(Packet packet, int i) {
        return null;
    }

    public Packet handlePacket(Packet packet, SessionAddress sessionaddress) {
        return null;
    }

    public Packet handlePacket(Packet packet, SessionAddress sessionaddress, boolean flag) {
        return null;
    }

    public Packet handlePacket(RTPPacket rtppacket) {
        RTPControlImpl rtpcontrolimpl1;
        if (rtppacket.payloadType == 13) {
            return rtppacket;
        }
        if (rtppacket.payloadType == 126) {
            return null;
        }
        SSRCInfo ssrcinfo = null;
        if (rtppacket.base instanceof UDPPacket) {
            InetAddress inetaddress = ((UDPPacket)rtppacket.base).remoteAddress;
            if (this.cache.sm.bindtome && !this.cache.sm.isBroadcast(this.cache.sm.dataaddress) && !inetaddress.equals(this.cache.sm.dataaddress)) {
                return null;
            }
        }
        if (ssrcinfo == null) {
            ssrcinfo = rtppacket.base instanceof UDPPacket ? this.cache.get(rtppacket.ssrc, ((UDPPacket)rtppacket.base).remoteAddress, ((UDPPacket)rtppacket.base).remotePort, 1) : this.cache.get(rtppacket.ssrc, null, 0, 1);
        }
        if (ssrcinfo == null) {
            return null;
        }
        for (int i = 0; i < rtppacket.csrc.length; ++i) {
            SSRCInfo ssrcinfo1 = null;
            ssrcinfo1 = rtppacket.base instanceof UDPPacket ? this.cache.get(rtppacket.csrc[i], ((UDPPacket)rtppacket.base).remoteAddress, ((UDPPacket)rtppacket.base).remotePort, 1) : this.cache.get(rtppacket.csrc[i], null, 0, 1);
            if (ssrcinfo1 == null) continue;
            ssrcinfo1.lastHeardFrom = rtppacket.receiptTime;
        }
        if (ssrcinfo.lastPayloadType != -1 && ssrcinfo.lastPayloadType == rtppacket.payloadType && this.mismatchprinted) {
            return null;
        }
        if (!ssrcinfo.sender) {
            ssrcinfo.initsource(rtppacket.seqnum);
            ssrcinfo.payloadType = rtppacket.payloadType;
        }
        int diff = rtppacket.seqnum - ssrcinfo.maxseq;
        if (ssrcinfo.maxseq + 1 != rtppacket.seqnum && diff > 0) {
            ssrcinfo.stats.update(0, diff - 1);
        }
        if (diff > -100 && diff < 0) {
            ssrcinfo.stats.update(0, -1);
        }
        if (ssrcinfo.wrapped) {
            ssrcinfo.wrapped = false;
        }
        boolean flag = false;
        if (ssrcinfo.probation > 0) {
            if (rtppacket.seqnum == ssrcinfo.maxseq + 1) {
                --ssrcinfo.probation;
                ssrcinfo.maxseq = rtppacket.seqnum;
                if (ssrcinfo.probation == 0) {
                    flag = true;
                }
            } else {
                ssrcinfo.probation = 1;
                ssrcinfo.maxseq = rtppacket.seqnum;
                ssrcinfo.stats.update(2);
            }
        } else if (diff < 3000) {
            if (rtppacket.seqnum < ssrcinfo.baseseq && diff < -32767) {
                ssrcinfo.cycles += 65536;
                ssrcinfo.wrapped = true;
            }
            ssrcinfo.maxseq = rtppacket.seqnum;
        } else if (diff <= 65436) {
            ssrcinfo.stats.update(3);
            if (rtppacket.seqnum == ssrcinfo.lastbadseq) {
                ssrcinfo.initsource(rtppacket.seqnum);
            } else {
                ssrcinfo.lastbadseq = rtppacket.seqnum + 1 & 0xFFFF;
            }
        } else {
            ssrcinfo.stats.update(4);
        }
        if (this.cache.sm.isUnicast()) {
            if (!this.rtcpstarted) {
                this.cache.sm.startRTCPReports(((UDPPacket)rtppacket.base).remoteAddress);
                this.rtcpstarted = true;
                byte[] abyte0 = this.cache.sm.controladdress.getAddress();
                int k = abyte0[3] & 0xFF;
                if ((k & 0xFF) == 255) {
                    this.cache.sm.addUnicastAddr(this.cache.sm.controladdress);
                } else {
                    InetAddress inetaddress1 = null;
                    boolean flag2 = true;
                    try {
                        inetaddress1 = InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException unknownhostexception) {
                        flag2 = false;
                    }
                    if (flag2) {
                        this.cache.sm.addUnicastAddr(inetaddress1);
                    }
                }
            } else if (!this.cache.sm.isSenderDefaultAddr(((UDPPacket)rtppacket.base).remoteAddress)) {
                this.cache.sm.addUnicastAddr(((UDPPacket)rtppacket.base).remoteAddress);
            }
        }
        ++ssrcinfo.received;
        ssrcinfo.stats.update(1);
        if (ssrcinfo.probation > 0) {
            this.probationList.put(ssrcinfo.ssrc, rtppacket.clone());
            return null;
        }
        ssrcinfo.maxseq = rtppacket.seqnum;
        if (ssrcinfo.lastPayloadType != -1 && ssrcinfo.lastPayloadType != rtppacket.payloadType) {
            RTPControlImpl rtpcontrolimpl;
            ssrcinfo.currentformat = null;
            if (ssrcinfo.dsource != null && (rtpcontrolimpl = (RTPControlImpl)ssrcinfo.dsource.getControl(this.controlstr)) != null) {
                rtpcontrolimpl.currentformat = null;
                rtpcontrolimpl.payload = -1;
            }
            ssrcinfo.lastPayloadType = rtppacket.payloadType;
            if (ssrcinfo.dsource != null) {
                try {
                    Log.warning("Stopping stream because of payload type mismatch: expecting pt=" + ssrcinfo.lastPayloadType + ", got pt=" + rtppacket.payloadType);
                    ssrcinfo.dsource.stop();
                }
                catch (IOException ioexception) {
                    System.err.println("Stopping DataSource after PCE " + ioexception.getMessage());
                }
            }
            RemotePayloadChangeEvent remotepayloadchangeevent = new RemotePayloadChangeEvent(this.cache.sm, (ReceiveStream)((Object)ssrcinfo), ssrcinfo.lastPayloadType, rtppacket.payloadType);
            this.cache.eventhandler.postEvent(remotepayloadchangeevent);
        }
        if (ssrcinfo.currentformat == null) {
            ssrcinfo.currentformat = this.cache.sm.formatinfo.get(rtppacket.payloadType);
            if (ssrcinfo.currentformat == null) {
                if (this.errorPayload != rtppacket.payloadType) {
                    Log.error("No format has been registered for RTP Payload type " + rtppacket.payloadType);
                    this.errorPayload = rtppacket.payloadType;
                }
                return rtppacket;
            }
            if (ssrcinfo.dstream != null) {
                ssrcinfo.dstream.setFormat(ssrcinfo.currentformat);
            }
        }
        if (ssrcinfo.currentformat == null) {
            System.err.println("No Format for PT= " + rtppacket.payloadType);
            return rtppacket;
        }
        if (ssrcinfo.dsource != null && (rtpcontrolimpl1 = (RTPControlImpl)ssrcinfo.dsource.getControl(this.controlstr)) != null) {
            Format format;
            rtpcontrolimpl1.currentformat = format = this.cache.sm.formatinfo.get(rtppacket.payloadType);
        }
        if (!this.initBC) {
            ((BufferControlImpl)this.cache.sm.buffercontrol).initBufferControl(ssrcinfo.currentformat);
            this.initBC = true;
        }
        if (!ssrcinfo.streamconnect) {
            DataSource datasource = (DataSource)this.cache.sm.dslist.get(ssrcinfo.ssrc);
            if (datasource == null) {
                DataSource datasource1 = this.cache.sm.getDataSource(null);
                if (datasource1 == null) {
                    datasource = this.cache.sm.createNewDS(null);
                    this.cache.sm.setDefaultDSassigned(ssrcinfo.ssrc);
                } else if (!this.cache.sm.isDefaultDSassigned()) {
                    datasource = datasource1;
                    this.cache.sm.setDefaultDSassigned(ssrcinfo.ssrc);
                } else {
                    datasource = this.cache.sm.createNewDS(ssrcinfo.ssrc);
                }
            }
            PushBufferStream[] apushbufferstream = datasource.getStreams();
            ssrcinfo.dsource = datasource;
            ssrcinfo.dstream = (RTPSourceStream)apushbufferstream[0];
            ssrcinfo.dstream.setContentDescriptor(this.content);
            ssrcinfo.dstream.setFormat(ssrcinfo.currentformat);
            RTPControlImpl rtpcontrolimpl2 = (RTPControlImpl)ssrcinfo.dsource.getControl(this.controlstr);
            if (rtpcontrolimpl2 != null) {
                Format format1;
                rtpcontrolimpl2.currentformat = format1 = this.cache.sm.formatinfo.get(rtppacket.payloadType);
                rtpcontrolimpl2.stream = ssrcinfo;
            }
            ssrcinfo.streamconnect = true;
        }
        if (ssrcinfo.dsource != null) {
            ssrcinfo.active = true;
        }
        if (!ssrcinfo.newrecvstream) {
            NewReceiveStreamEvent newreceivestreamevent = new NewReceiveStreamEvent(this.cache.sm, (ReceiveStream)((Object)ssrcinfo));
            ssrcinfo.newrecvstream = true;
            this.cache.eventhandler.postEvent(newreceivestreamevent);
        }
        if (ssrcinfo.lastRTPReceiptTime != 0L && ssrcinfo.lastPayloadType == rtppacket.payloadType) {
            long l = rtppacket.receiptTime - ssrcinfo.lastRTPReceiptTime;
            long l1 = rtppacket.timestamp - ssrcinfo.lasttimestamp;
            double d = (l = l * (long)this.cache.clockrate[ssrcinfo.payloadType] / 1000L) - l1;
            if (d < 0.0) {
                d = -d;
            }
            ssrcinfo.jitter += 0.0625 * (d - ssrcinfo.jitter);
        }
        ssrcinfo.lastRTPReceiptTime = rtppacket.receiptTime;
        ssrcinfo.lasttimestamp = rtppacket.timestamp;
        ssrcinfo.payloadType = rtppacket.payloadType;
        ssrcinfo.lastPayloadType = rtppacket.payloadType;
        ssrcinfo.bytesreceived += rtppacket.payloadlength;
        ssrcinfo.lastHeardFrom = rtppacket.receiptTime;
        if (ssrcinfo.quiet) {
            ssrcinfo.quiet = false;
            ActiveReceiveStreamEvent activereceivestreamevent = null;
            activereceivestreamevent = ssrcinfo instanceof ReceiveStream ? new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, ssrcinfo.sourceInfo, (ReceiveStream)((Object)ssrcinfo)) : new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, ssrcinfo.sourceInfo, null);
            this.cache.eventhandler.postEvent(activereceivestreamevent);
        }
        SourceRTPPacket sourcertppacket = new SourceRTPPacket(rtppacket, ssrcinfo);
        if (ssrcinfo.dsource != null) {
            RTPPacket rtppacket1;
            if (this.mismatchprinted) {
                this.mismatchprinted = false;
            }
            if (flag && (rtppacket1 = (RTPPacket)this.probationList.remove(ssrcinfo.ssrc)) != null) {
                this.rtpdemultiplexer.demuxpayload(new SourceRTPPacket(rtppacket1, ssrcinfo));
            }
            this.rtpdemultiplexer.demuxpayload(sourcertppacket);
        }
        return rtppacket;
    }
}

