/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.util.Vector;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.SendStreamListener;
import javax.media.rtp.SessionListener;
import javax.media.rtp.event.RTPEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.RemoteEvent;
import javax.media.rtp.event.SendStreamEvent;
import javax.media.rtp.event.SessionEvent;
import net.sf.fmj.media.rtp.RTPSessionMgr;
import net.sf.fmj.media.rtp.util.RTPMediaThread;

public class RTPEventHandler
extends RTPMediaThread {
    private RTPSessionMgr sm;
    private Vector eventQueue = new Vector();
    private boolean killed = false;

    public RTPEventHandler(RTPSessionMgr sm) {
        super("RTPEventHandler");
        this.sm = sm;
        this.useControlPriority();
        this.setDaemon(true);
        this.start();
    }

    public synchronized void close() {
        this.killed = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvents() {
        RTPEvent evt;
        RTPEventHandler rTPEventHandler = this;
        synchronized (rTPEventHandler) {
            try {
                while (this.eventQueue.size() == 0 && !this.killed) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.killed) {
                return;
            }
            evt = (RTPEvent)this.eventQueue.elementAt(0);
            this.eventQueue.removeElementAt(0);
        }
        this.processEvent(evt);
    }

    public synchronized void postEvent(RTPEvent evt) {
        this.eventQueue.addElement(evt);
        this.notifyAll();
    }

    protected void processEvent(RTPEvent evt) {
        if (evt instanceof SessionEvent) {
            for (int i = 0; i < this.sm.sessionlistener.size(); ++i) {
                SessionListener sl = (SessionListener)this.sm.sessionlistener.elementAt(i);
                if (sl == null) continue;
                sl.update((SessionEvent)evt);
            }
            return;
        }
        if (evt instanceof RemoteEvent) {
            for (int i = 0; i < this.sm.remotelistener.size(); ++i) {
                RemoteListener sl = (RemoteListener)this.sm.remotelistener.elementAt(i);
                if (sl == null) continue;
                sl.update((RemoteEvent)evt);
            }
            return;
        }
        if (evt instanceof ReceiveStreamEvent) {
            for (int i = 0; i < this.sm.streamlistener.size(); ++i) {
                ReceiveStreamListener sl = (ReceiveStreamListener)this.sm.streamlistener.elementAt(i);
                if (sl == null) continue;
                sl.update((ReceiveStreamEvent)evt);
            }
            return;
        }
        if (evt instanceof SendStreamEvent) {
            for (int i = 0; i < this.sm.sendstreamlistener.size(); ++i) {
                SendStreamListener sl = (SendStreamListener)this.sm.sendstreamlistener.elementAt(i);
                if (sl == null) continue;
                sl.update((SendStreamEvent)evt);
            }
        }
    }

    public void run() {
        while (!this.killed) {
            this.dispatchEvents();
        }
    }
}

