/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimeTable {
    private final Hashtable<String, String> hashTable = new Hashtable();
    private static final Hashtable<String, String> reverseHashTable = new Hashtable();

    public boolean addMimeType(String fileExtension, String mimeType) {
        this.hashTable.put(fileExtension, mimeType);
        reverseHashTable.put(mimeType, fileExtension);
        return true;
    }

    public void clear() {
        this.hashTable.clear();
        reverseHashTable.clear();
    }

    public String getDefaultExtension(String mimeType) {
        return reverseHashTable.get(mimeType);
    }

    public List<String> getExtensions(String mimeType) {
        ArrayList<String> result = new ArrayList<String>();
        for (String k : this.hashTable.keySet()) {
            if (!this.hashTable.get(k).equals(mimeType)) continue;
            result.add(k);
        }
        return result;
    }

    public Hashtable<String, String> getMimeTable() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        result.putAll(this.hashTable);
        return result;
    }

    public String getMimeType(String fileExtension) {
        String result = this.hashTable.get(fileExtension);
        return result;
    }

    public Set<String> getMimeTypes() {
        HashSet<String> result = new HashSet<String>();
        Iterator<String> i = this.hashTable.values().iterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    public boolean removeMimeType(String fileExtension) {
        if (this.hashTable.get(fileExtension) == null) {
            return false;
        }
        reverseHashTable.remove(this.hashTable.get(fileExtension));
        this.hashTable.remove(fileExtension);
        return true;
    }
}

