/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.packet.StreamInitiation;

public class FaultTolerantNegotiator
extends StreamNegotiator {
    private StreamNegotiator primaryNegotiator;
    private StreamNegotiator secondaryNegotiator;
    private Connection connection;
    private PacketFilter primaryFilter;
    private PacketFilter secondaryFilter;

    public FaultTolerantNegotiator(Connection connection, StreamNegotiator primary, StreamNegotiator secondary) {
        this.primaryNegotiator = primary;
        this.secondaryNegotiator = secondary;
        this.connection = connection;
    }

    public PacketFilter getInitiationPacketFilter(String from, String streamID) {
        if (this.primaryFilter == null || this.secondaryFilter == null) {
            this.primaryFilter = this.primaryNegotiator.getInitiationPacketFilter(from, streamID);
            this.secondaryFilter = this.secondaryNegotiator.getInitiationPacketFilter(from, streamID);
        }
        return new OrFilter(this.primaryFilter, this.secondaryFilter);
    }

    InputStream negotiateIncomingStream(Packet streamInitiation) throws XMPPException {
        throw new UnsupportedOperationException("Negotiation only handled by create incoming stream method.");
    }

    final Packet initiateIncomingStream(Connection connection, StreamInitiation initiation) {
        throw new UnsupportedOperationException("Initiation handled by createIncomingStream method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream createIncomingStream(StreamInitiation initiation) throws XMPPException {
        PacketCollector collector = this.connection.createPacketCollector(this.getInitiationPacketFilter(initiation.getFrom(), initiation.getSessionID()));
        this.connection.sendPacket(super.createInitiationAccept(initiation, this.getNamespaces()));
        ExecutorService threadPoolExecutor = Executors.newFixedThreadPool(2);
        ExecutorCompletionService<InputStream> service = new ExecutorCompletionService<InputStream>(threadPoolExecutor);
        ArrayList<Future<InputStream>> futures = new ArrayList<Future<InputStream>>();
        InputStream stream = null;
        XMPPException exception = null;
        try {
            futures.add(service.submit(new NegotiatorService(collector)));
            futures.add(service.submit(new NegotiatorService(collector)));
            int i = 0;
            while (stream == null && i < futures.size()) {
                Future future;
                try {
                    ++i;
                    future = service.poll(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    continue;
                }
                if (future == null) continue;
                try {
                    stream = (InputStream)future.get();
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException e) {
                    exception = new XMPPException(e.getCause());
                }
            }
        }
        finally {
            for (Future future : futures) {
                future.cancel(true);
            }
            collector.cancel();
            threadPoolExecutor.shutdownNow();
        }
        if (stream == null) {
            if (exception != null) {
                throw exception;
            }
            throw new XMPPException("File transfer negotiation failed.");
        }
        return stream;
    }

    private StreamNegotiator determineNegotiator(Packet streamInitiation) {
        return this.primaryFilter.accept(streamInitiation) ? this.primaryNegotiator : this.secondaryNegotiator;
    }

    public OutputStream createOutgoingStream(String streamID, String initiator, String target) throws XMPPException {
        OutputStream stream;
        try {
            stream = this.primaryNegotiator.createOutgoingStream(streamID, initiator, target);
        }
        catch (XMPPException ex) {
            stream = this.secondaryNegotiator.createOutgoingStream(streamID, initiator, target);
        }
        return stream;
    }

    public String[] getNamespaces() {
        String[] primary = this.primaryNegotiator.getNamespaces();
        String[] secondary = this.secondaryNegotiator.getNamespaces();
        String[] namespaces = new String[primary.length + secondary.length];
        System.arraycopy(primary, 0, namespaces, 0, primary.length);
        System.arraycopy(secondary, 0, namespaces, primary.length, secondary.length);
        return namespaces;
    }

    public void cleanup() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NegotiatorService
    implements Callable<InputStream> {
        private PacketCollector collector;

        NegotiatorService(PacketCollector collector) {
            this.collector = collector;
        }

        @Override
        public InputStream call() throws Exception {
            Packet streamInitiation = this.collector.nextResult(SmackConfiguration.getPacketReplyTimeout() * 2);
            if (streamInitiation == null) {
                throw new XMPPException("No response from remote client");
            }
            StreamNegotiator negotiator = FaultTolerantNegotiator.this.determineNegotiator(streamInitiation);
            return negotiator.negotiateIncomingStream(streamInitiation);
        }
    }
}

