/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.management.MemoryUsage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.profiler4j.console.AllocDiffPanel;
import net.sf.profiler4j.console.AppEvent;
import net.sf.profiler4j.console.AppEventListener;
import net.sf.profiler4j.console.AppEventType;
import net.sf.profiler4j.console.Console;
import net.sf.profiler4j.console.MemoryPlotPanel;
import net.sf.profiler4j.console.client.MemoryInfo;
import org.jfree.data.time.Millisecond;

public class MemoryPanel
extends JPanel
implements AppEventListener {
    private static final long MEGA = 0x100000L;
    private AllocDiffPanel allocDiffPanel = null;
    private JLabel jLabel1 = null;
    private JTextField maxNonHeapMemTextField = null;
    private MemoryPlotPanel nonHeapMemoryUsagePanel = null;
    private JPanel infoPanel = null;
    private JTextField maxHeapMemTextField = null;
    private JLabel jLabel = null;
    private MemoryPlotPanel heapMemoryUsagePanel = null;
    private Console app;

    public MemoryPanel(Console app) {
        this.app = app;
        this.initialize();
        app.addListener(this);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 2;
        gridBagConstraints12.fill = 1;
        gridBagConstraints12.weightx = 1.0;
        gridBagConstraints12.weighty = 1.0;
        gridBagConstraints12.gridy = 1;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 1;
        gridBagConstraints11.fill = 1;
        gridBagConstraints11.weightx = 1.0;
        gridBagConstraints11.weighty = 1.0;
        gridBagConstraints11.gridy = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 1;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.ipadx = 16;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridwidth = 3;
        gridBagConstraints1.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints1.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(541, 332);
        this.add((Component)this.getInfoPanel(), gridBagConstraints1);
        this.add((Component)this.getMemoryUsagePanel(), gridBagConstraints);
        this.add((Component)this.getAllocDiffPanel(), gridBagConstraints11);
        this.add((Component)this.getNonHeapMemoryUsagePanel(), gridBagConstraints12);
    }

    private JPanel getInfoPanel() {
        if (this.infoPanel == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("        Max Non-Heap Memory (MB):");
            this.jLabel1.setHorizontalAlignment(4);
            this.jLabel = new JLabel();
            this.jLabel.setText("Max Heap Memory (MB):");
            this.infoPanel = new JPanel();
            this.infoPanel.setLayout(new FlowLayout());
            this.infoPanel.add((Component)this.jLabel, null);
            this.infoPanel.add((Component)this.getMaxHeapMemTextField(), null);
            this.infoPanel.add((Component)this.jLabel1, null);
            this.infoPanel.add((Component)this.getMaxNonHeapMemTextField(), null);
        }
        return this.infoPanel;
    }

    private JTextField getMaxHeapMemTextField() {
        if (this.maxHeapMemTextField == null) {
            this.maxHeapMemTextField = new JTextField();
            this.maxHeapMemTextField.setEditable(false);
            this.maxHeapMemTextField.setFont(new Font("Tahoma", 1, 11));
            this.maxHeapMemTextField.setColumns(7);
        }
        return this.maxHeapMemTextField;
    }

    private MemoryPlotPanel getMemoryUsagePanel() {
        if (this.heapMemoryUsagePanel == null) {
            this.heapMemoryUsagePanel = new MemoryPlotPanel("Heap Memory");
        }
        return this.heapMemoryUsagePanel;
    }

    private void addInfo(MemoryInfo info) {
        Millisecond ms = new Millisecond();
        MemoryUsage hmu = info.getHeapUsage();
        MemoryUsage nhmu = info.getNonHeapUsage();
        this.heapMemoryUsagePanel.addSample(ms, hmu.getCommitted(), hmu.getUsed());
        this.maxHeapMemTextField.setText(String.valueOf(hmu.getMax() / 0x100000L));
        this.nonHeapMemoryUsagePanel.addSample(ms, nhmu.getCommitted(), nhmu.getUsed());
        this.maxNonHeapMemTextField.setText(String.valueOf(nhmu.getMax() / 0x100000L));
    }

    public boolean receiveEvent(AppEvent ev) {
        if (ev.getType() == AppEventType.DISCONNECTED || ev.getType() == AppEventType.CONNECTED) {
            this.heapMemoryUsagePanel.reset();
            this.nonHeapMemoryUsagePanel.reset();
        } else if (ev.getType() == AppEventType.GOT_MEMORY_INFO) {
            this.addInfo((MemoryInfo)ev.getArg());
        }
        return false;
    }

    private AllocDiffPanel getAllocDiffPanel() {
        if (this.allocDiffPanel == null) {
            this.allocDiffPanel = new AllocDiffPanel();
            this.allocDiffPanel.setVisible(false);
        }
        return this.allocDiffPanel;
    }

    private JTextField getMaxNonHeapMemTextField() {
        if (this.maxNonHeapMemTextField == null) {
            this.maxNonHeapMemTextField = new JTextField();
            this.maxNonHeapMemTextField.setEditable(false);
            this.maxNonHeapMemTextField.setFont(new Font("Tahoma", 1, 11));
            this.maxNonHeapMemTextField.setColumns(7);
        }
        return this.maxNonHeapMemTextField;
    }

    private MemoryPlotPanel getNonHeapMemoryUsagePanel() {
        if (this.nonHeapMemoryUsagePanel == null) {
            this.nonHeapMemoryUsagePanel = new MemoryPlotPanel("Non-Heap Memory");
        }
        return this.nonHeapMemoryUsagePanel;
    }
}

