/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.uploader;

import com.google.gdata.client.uploader.BackoffPolicy;
import com.google.gdata.client.uploader.FileUploadData;
import com.google.gdata.client.uploader.ProgressListener;
import com.google.gdata.client.uploader.ResumableHttpUploadTask;
import com.google.gdata.client.uploader.UploadData;
import com.google.gdata.client.uploader.UrlConnectionFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResumableHttpFileUploader {
    public static long DEFAULT_MAX_CHUNK_SIZE = 0xA00000L;
    public static final long DEFAULT_PROGRESS_INTERVAL_MS = 100L;
    public static final String METHOD_OVERRIDE = "X-HTTP-Method-Override";
    private long numBytesUploaded = 0L;
    private UploadState uploadState = UploadState.NOT_STARTED;
    private Future<ResponseMessage> uploadResultFuture;
    private final UploadData data;
    private URL url;
    private RequestMethod httpRequestMethod;
    private Map<String, String> headers = new HashMap<String, String>();
    private Timer progressNotifier;
    private final ExecutorService executor;
    private final UrlConnectionFactory urlConnectionFactory;
    private final ProgressListener progressListener;
    private final long progressIntervalMillis;
    private final long chunkSize;
    private final BackoffPolicy backoffPolicy;

    @Deprecated
    public ResumableHttpFileUploader(URL url, File file, ExecutorService executor, ProgressListener progressListener, long progressIntervalMillis) throws IOException {
        this(new Builder().setUrl(url).setFile(file).setExecutorService(executor).setProgressListener(progressListener).setProgressIntervalMillis(progressIntervalMillis));
    }

    @Deprecated
    public ResumableHttpFileUploader(URL url, File file, ExecutorService executor, ProgressListener progressListener, long chunkSize, long progressIntervalMillis) throws IOException {
        this(new Builder().setUrl(url).setFile(file).setExecutorService(executor).setProgressListener(progressListener).setChunkSize(chunkSize).setProgressIntervalMillis(progressIntervalMillis));
    }

    ResumableHttpFileUploader(Builder builder) throws IOException {
        this.url = builder.url;
        this.data = builder.data;
        this.executor = builder.executor;
        this.urlConnectionFactory = builder.urlConnectionFactory;
        this.progressListener = builder.progressListener;
        this.progressIntervalMillis = Math.max(0L, builder.progressIntervalMillis);
        this.chunkSize = builder.chunkSize;
        this.httpRequestMethod = builder.requestMethod;
        this.backoffPolicy = builder.backoffPolicy;
        this.checkArgument(this.url != null && this.url.getHost() != null && this.url.getHost().length() > 0 && this.url.getPath() != null && this.url.getPath().length() > 0, "The url must be non null and have a non-empty host and path.");
        this.checkArgument(this.executor != null, "Must provide a non-null executor service.");
        this.checkArgument(this.urlConnectionFactory != null, "Factories must be non-null.");
        if (RequestMethod.POST.equals((Object)this.httpRequestMethod)) {
            this.addHeader(METHOD_OVERRIDE, RequestMethod.PUT.toString());
        }
    }

    @Deprecated
    public void setHttpRequestMethod(RequestMethod requestMethod) {
        this.httpRequestMethod = requestMethod;
        if (RequestMethod.POST.equals((Object)requestMethod)) {
            this.addHeader(METHOD_OVERRIDE, RequestMethod.PUT.toString());
        }
    }

    public RequestMethod getHttpRequestMethod() {
        return this.httpRequestMethod;
    }

    public String addHeader(String key, String value) {
        return this.headers.put(key, value);
    }

    Map<String, String> getHeaders() {
        return this.headers;
    }

    BackoffPolicy getBackoffPolicy() {
        return this.backoffPolicy;
    }

    public synchronized long getNumBytesUploaded() {
        return this.numBytesUploaded;
    }

    public double getProgress() {
        long fileLength = this.data.length();
        if (fileLength == 0L) {
            return this.uploadState.equals((Object)UploadState.COMPLETE) ? 1.0 : 0.0;
        }
        return (double)this.getNumBytesUploaded() / (double)fileLength;
    }

    public ResponseMessage getResponse() {
        if (this.uploadResultFuture != null && this.uploadResultFuture.isDone()) {
            try {
                return this.uploadResultFuture.get();
            }
            catch (ExecutionException e) {
                this.setUploadState(UploadState.CLIENT_ERROR);
            }
            catch (InterruptedException e) {
                this.setUploadState(UploadState.CLIENT_ERROR);
                throw new IllegalStateException("InterruptedException even though upload is done (should never get here).");
            }
        }
        return null;
    }

    public synchronized UploadState getUploadState() {
        return this.uploadState;
    }

    public synchronized boolean isPaused() {
        return this.uploadState.equals((Object)UploadState.PAUSED);
    }

    public synchronized void pause() {
        this.setUploadState(UploadState.PAUSED);
        if (this.progressNotifier != null) {
            this.progressNotifier.cancel();
        }
    }

    public void resume() {
        if (this.uploadState.equals((Object)UploadState.PAUSED) || this.uploadState.equals((Object)UploadState.NOT_STARTED)) {
            this.upload(true);
        }
    }

    public Future<ResponseMessage> start() {
        this.upload(false);
        return this.uploadResultFuture;
    }

    public synchronized boolean isDone() {
        return this.uploadResultFuture != null && this.uploadResultFuture.isDone();
    }

    synchronized void addNumBytesUploaded(long numBytes) {
        this.numBytesUploaded += numBytes;
    }

    public UploadData getData() {
        return this.data;
    }

    URL getUrl() {
        return this.url;
    }

    void setUrl(URL url) {
        this.url = url;
    }

    long getChunkSize() {
        return this.chunkSize;
    }

    void sendCompletionNotification() {
        if (this.progressListener != null) {
            new NotificationTask(this, this.progressListener, this.progressNotifier).run();
        }
    }

    synchronized void setNumBytesUploaded(long numBytes) {
        this.numBytesUploaded = numBytes;
    }

    synchronized void setUploadState(UploadState state) {
        this.uploadState = state;
    }

    private void checkArgument(boolean condition, String errorMsg) {
        if (!condition) {
            throw new IllegalArgumentException(errorMsg);
        }
    }

    private void upload(boolean resume) {
        this.setUploadState(UploadState.IN_PROGRESS);
        ResumableHttpUploadTask task = new ResumableHttpUploadTask(this.urlConnectionFactory, this, resume);
        if (this.progressListener != null) {
            this.progressNotifier = new Timer();
            this.progressNotifier.schedule((TimerTask)new NotificationTask(this, this.progressListener, this.progressNotifier), 0L, this.progressIntervalMillis);
        }
        this.uploadResultFuture = this.executor.submit(task);
    }

    public static class Builder {
        private URL url;
        private UploadData data;
        private ExecutorService executor;
        private UrlConnectionFactory urlConnectionFactory = UrlConnectionFactory.DEFAULT;
        private ProgressListener progressListener;
        private long chunkSize = DEFAULT_MAX_CHUNK_SIZE;
        private long progressIntervalMillis = 100L;
        private RequestMethod requestMethod = RequestMethod.PUT;
        private BackoffPolicy backoffPolicy = BackoffPolicy.DEFAULT;

        public Builder setUrl(URL url) {
            this.url = url;
            return this;
        }

        public Builder setFile(File file) throws IOException {
            if (file == null || !file.exists() || !file.canRead()) {
                throw new IOException("The file must exist and be readable.");
            }
            this.data = new FileUploadData(file);
            return this;
        }

        public Builder setData(UploadData data) {
            this.data = data;
            return this;
        }

        public Builder setExecutorService(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder setUrlConnectionFactory(UrlConnectionFactory urlConnectionFactory) {
            this.urlConnectionFactory = urlConnectionFactory;
            return this;
        }

        public Builder setProgressListener(ProgressListener progressListener) {
            this.progressListener = progressListener;
            return this;
        }

        public Builder setChunkSize(long chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public Builder setProgressIntervalMillis(long progressIntervalMillis) {
            this.progressIntervalMillis = progressIntervalMillis;
            return this;
        }

        public Builder setRequestMethod(RequestMethod requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public Builder setBackoffPolicy(BackoffPolicy backoffPolicy) {
            this.backoffPolicy = backoffPolicy;
            return this;
        }

        public ResumableHttpFileUploader build() throws IOException {
            return new ResumableHttpFileUploader(this);
        }
    }

    private class NotificationTask
    extends TimerTask {
        private final ResumableHttpFileUploader fileUploader;
        private final ProgressListener listener;
        private final Timer timer;

        public NotificationTask(ResumableHttpFileUploader fileUploader, ProgressListener listener, Timer timer) {
            this.fileUploader = fileUploader;
            this.listener = listener;
            this.timer = timer;
        }

        public void run() {
            if (!this.fileUploader.getUploadState().equals((Object)UploadState.IN_PROGRESS)) {
                this.timer.cancel();
            }
            this.listener.progressChanged(this.fileUploader);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestMethod {
        POST,
        PUT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UploadState {
        COMPLETE,
        CLIENT_ERROR,
        IN_PROGRESS,
        NOT_STARTED,
        PAUSED;

    }

    public static class ResponseMessage {
        private final int contentLength;
        private final InputStream inputStream;

        public ResponseMessage(int contentLength, InputStream inputStream) {
            this.contentLength = contentLength;
            this.inputStream = inputStream;
        }

        public int getContentLength() {
            return this.contentLength;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public String receiveMessage(long timeoutMs) throws InterruptedException, ExecutionException, TimeoutException {
            return Executors.newSingleThreadExecutor().submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    int received = 0;
                    StringBuilder message = new StringBuilder();
                    while (received < ResponseMessage.this.contentLength) {
                        int avail = ResponseMessage.this.inputStream.available();
                        if (avail > 0) {
                            byte[] buf = new byte[avail];
                            received += ResponseMessage.this.inputStream.read(buf, 0, avail);
                            message.append(new String(buf));
                            continue;
                        }
                        Thread.sleep(10L);
                    }
                    return message.toString();
                }
            }).get(timeoutMs, TimeUnit.MILLISECONDS);
        }
    }
}

