/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.neomedia;

import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.SrtpControlType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaTypeSrtpControl
implements Comparable<MediaTypeSrtpControl> {
    public final MediaType mediaType;
    public final SrtpControlType srtpControlType;

    public MediaTypeSrtpControl(MediaType mt, SrtpControlType sct) {
        this.mediaType = mt;
        this.srtpControlType = sct;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != MediaTypeSrtpControl.class) {
            return false;
        }
        MediaTypeSrtpControl other = (MediaTypeSrtpControl)obj;
        return this.mediaType == other.mediaType && this.srtpControlType == other.srtpControlType;
    }

    public int hashCode() {
        return this.mediaType.hashCode() ^ this.srtpControlType.hashCode();
    }

    @Override
    public int compareTo(MediaTypeSrtpControl o) {
        return this.getWeight() == o.getWeight() ? 0 : (this.getWeight() < o.getWeight() ? -1 : 1);
    }

    private int getWeight() {
        int mtWeight = 0;
        switch (this.mediaType) {
            case AUDIO: {
                mtWeight = 1;
                break;
            }
            case VIDEO: {
                mtWeight = 2;
            }
        }
        int stWeight = 0;
        switch (this.srtpControlType) {
            case ZRTP: {
                stWeight = 1;
                break;
            }
            case MIKEY: {
                stWeight = 2;
                break;
            }
            case SDES: {
                stWeight = 3;
            }
        }
        return mtWeight * 10 + stWeight;
    }
}

