/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.notify;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import org.jitsi.impl.neomedia.codec.audio.speex.SpeexResampler;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.service.audionotifier.AbstractSCAudioClip;
import org.jitsi.service.audionotifier.AudioNotifierService;
import org.jitsi.util.Logger;

public class AudioSystemClipImpl
extends AbstractSCAudioClip {
    private static final Logger logger = Logger.getLogger(AudioSystemClipImpl.class);
    private final AudioSystem audioSystem;
    private Buffer buffer;
    private byte[] bufferData;
    private final boolean playback;
    private Renderer renderer;

    public AudioSystemClipImpl(String url, AudioNotifierService audioNotifier, AudioSystem audioSystem, boolean playback) throws IOException {
        super(url, audioNotifier);
        this.audioSystem = audioSystem;
        this.playback = playback;
    }

    protected void enterRunInPlayThread() {
        this.buffer = new Buffer();
        this.bufferData = new byte[1024];
        this.buffer.setData((Object)this.bufferData);
        this.renderer = this.audioSystem.createRenderer(this.playback);
    }

    protected void exitRunInPlayThread() {
        this.buffer = null;
        this.bufferData = null;
        this.renderer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exitRunOnceInPlayThread() {
        try {
            this.renderer.stop();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.renderer.close();
            throw throwable;
        }
        this.renderer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean runOnceInPlayThread() {
        block37: {
            block30: {
                block34: {
                    block29: {
                        audioStream = null;
                        try {
                            audioStream = this.audioSystem.getAudioInputStream(this.uri);
                        }
                        catch (IOException ioex) {
                            AudioSystemClipImpl.logger.error("Failed to get audio stream " + this.uri, ioex);
                        }
                        if (audioStream == null) {
                            return false;
                        }
                        resampler = null;
                        try {
                            try {
                                rendererFormat = this.audioSystem.getFormat(audioStream);
                                if (rendererFormat == null) {
                                    var4_6 = false;
                                    var15_9 = null;
                                    break block29;
                                }
                                resamplerFormat = null;
                                if (this.renderer.setInputFormat(rendererFormat) == null) {
                                    resampler = new SpeexResampler();
                                    resamplerFormat = rendererFormat;
                                    resampler.setInputFormat(resamplerFormat);
                                    supportedResamplerFormats = resampler.getSupportedOutputFormats(resamplerFormat);
                                    block17: for (Format supportedRendererFormat : this.renderer.getSupportedInputFormats()) {
                                        for (Format supportedResamplerFormat : supportedResamplerFormats) {
                                            if (!supportedRendererFormat.matches(supportedResamplerFormat)) continue;
                                            rendererFormat = supportedRendererFormat;
                                            resampler.setOutputFormat(rendererFormat);
                                            this.renderer.setInputFormat(rendererFormat);
                                            continue block17;
                                        }
                                    }
                                }
                                break block30;
                            }
                            catch (ResourceUnavailableException ruex) {
                                block32: {
                                    if (resampler != null) {
                                        AudioSystemClipImpl.logger.error("Failed to open SpeexResampler.", ruex);
                                        var4_8 = false;
                                        var15_13 = null;
                                        try {
                                            audioStream.close();
                                        }
                                        catch (IOException ioex) {
                                            // empty catch block
                                        }
                                        if (resampler == null) return var4_8;
                                        resampler.close();
                                        return var4_8;
                                    }
                                    var15_14 = null;
                                    ** try [egrp 4[TRYBLOCK] [13 : 519->526)] { 
lbl53:
                                    // 1 sources

                                    audioStream.close();
                                    break block32;
lbl55:
                                    // 1 sources

                                    catch (IOException ioex) {
                                        // empty catch block
                                    }
                                }
                                if (resampler == null) return true;
                                resampler.close();
                                return true;
                            }
                        }
                        catch (Throwable var14_34) {
                            block33: {
                                var15_15 = null;
                                ** try [egrp 4[TRYBLOCK] [13 : 519->526)] { 
lbl65:
                                // 1 sources

                                audioStream.close();
                                break block33;
lbl67:
                                // 1 sources

                                catch (IOException ioex) {
                                    // empty catch block
                                }
                            }
                            if (resampler == null) throw var14_34;
                            resampler.close();
                            throw var14_34;
                        }
                    }
                    ** try [egrp 4[TRYBLOCK] [13 : 519->526)] { 
lbl75:
                    // 1 sources

                    audioStream.close();
                    break block34;
lbl77:
                    // 1 sources

                    catch (IOException ioex) {
                        // empty catch block
                    }
                }
                if (resampler == null) return var4_6;
                resampler.close();
                return var4_6;
            }
            rendererBuffer = this.buffer;
            rendererBuffer.setFormat(rendererFormat);
            if (resampler == null) {
                resamplerBuffer = null;
            } else {
                resamplerBuffer = new Buffer();
                this.bufferData = new byte[this.bufferData.length];
                resamplerBuffer.setData((Object)this.bufferData);
                resamplerBuffer.setFormat(resamplerFormat);
                resampler.open();
            }
            try {
                this.renderer.open();
                this.renderer.start();
                while (this.isStarted() && (bufferLength = audioStream.read(this.bufferData)) != -1) {
                    if (resampler == null) {
                        rendererBuffer.setLength(bufferLength);
                        rendererBuffer.setOffset(0);
                    } else {
                        resamplerBuffer.setLength(bufferLength);
                        resamplerBuffer.setOffset(0);
                        rendererBuffer.setLength(0);
                        rendererBuffer.setOffset(0);
                        resampler.process(resamplerBuffer, rendererBuffer);
                    }
                    while ((this.renderer.process(rendererBuffer) & 2) == 2) {
                    }
                }
            }
            catch (IOException ioex) {
                block35: {
                    AudioSystemClipImpl.logger.error("Failed to read from audio stream " + this.uri, ioex);
                    var8_28 = false;
                    var15_10 = null;
                    ** try [egrp 4[TRYBLOCK] [13 : 519->526)] { 
lbl118:
                    // 1 sources

                    audioStream.close();
                    break block35;
lbl120:
                    // 1 sources

                    catch (IOException ioex) {
                        // empty catch block
                    }
                }
                if (resampler == null) return var8_28;
                resampler.close();
                return var8_28;
            }
            catch (ResourceUnavailableException ruex) {
                block36: {
                    AudioSystemClipImpl.logger.error("Failed to open PortAudioRenderer.", ruex);
                    var8_28 = false;
                    var15_11 = null;
                    ** try [egrp 4[TRYBLOCK] [13 : 519->526)] { 
lbl132:
                    // 1 sources

                    audioStream.close();
                    break block36;
lbl134:
                    // 1 sources

                    catch (IOException ioex) {
                        // empty catch block
                    }
                }
                if (resampler == null) return var8_28;
                resampler.close();
                return var8_28;
            }
            var15_12 = null;
            ** try [egrp 4[TRYBLOCK] [13 : 519->526)] { 
lbl142:
            // 1 sources

            audioStream.close();
            break block37;
lbl144:
            // 1 sources

            catch (IOException ioex) {
                // empty catch block
            }
        }
        if (resampler == null) return true;
        resampler.close();
        return true;
    }
}

