/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.renderer.audio;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.MediaLocator;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.AbstractVolumeControl;
import org.jitsi.impl.neomedia.MediaServiceImpl;
import org.jitsi.impl.neomedia.MediaUtils;
import org.jitsi.impl.neomedia.NeomediaServiceUtils;
import org.jitsi.impl.neomedia.device.PulseAudioSystem;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.AbstractAudioRenderer;
import org.jitsi.impl.neomedia.pulseaudio.PA;
import org.jitsi.util.StringUtils;

public class PulseAudioRenderer
extends AbstractAudioRenderer {
    private static final String PLUGIN_NAME = "PulseAudio Renderer";
    private static final boolean SOFTWARE_GAIN = false;
    private static final Format[] SUPPORTED_INPUT_FORMATS = new Format[]{new AudioFormat("LINEAR", -1.0, 16, -1, 0, 1, -1, -1.0, Format.byteArray)};
    private int channels;
    private boolean corked = true;
    private long cvolume;
    private String dev;
    private final GainControl gainControl;
    private float gainControlLevel;
    private final String mediaRole;
    private final PulseAudioSystem pulseAudioSystem;
    private long stream;
    private final PA.stream_request_cb_t writeCallback = new PA.stream_request_cb_t(){

        public void callback(long s, int nbytes) {
            PulseAudioRenderer.this.pulseAudioSystem.signalMainloop(false);
        }
    };

    public PulseAudioRenderer() {
        this((String)null);
    }

    public PulseAudioRenderer(String mediaRole) {
        super(PulseAudioSystem.getPulseAudioSystem());
        MediaServiceImpl mediaServiceImpl;
        this.pulseAudioSystem = (PulseAudioSystem)this.audioSystem;
        if (this.pulseAudioSystem == null) {
            throw new IllegalStateException("pulseAudioSystem");
        }
        String string = this.mediaRole = mediaRole == null ? "phone" : mediaRole;
        this.gainControl = "phone".equals(this.mediaRole) ? ((mediaServiceImpl = NeomediaServiceUtils.getMediaServiceImpl()) == null ? null : (GainControl)mediaServiceImpl.getOutputVolumeControl()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.pulseAudioSystem.lockMainloop();
        try {
            long stream = this.stream;
            if (stream != 0L) {
                block6: {
                    long cvolume2;
                    try {
                        this.stopWithMainloopLock();
                        Object var4_2 = null;
                        cvolume2 = this.cvolume;
                        this.cvolume = 0L;
                        this.stream = 0L;
                        this.corked = true;
                        this.dev = null;
                        this.pulseAudioSystem.signalMainloop(false);
                        if (cvolume2 == 0L) break block6;
                    }
                    catch (Throwable throwable) {
                        Object var4_3 = null;
                        long cvolume2 = this.cvolume;
                        this.cvolume = 0L;
                        this.stream = 0L;
                        this.corked = true;
                        this.dev = null;
                        this.pulseAudioSystem.signalMainloop(false);
                        if (cvolume2 != 0L) {
                            PA.cvolume_free(cvolume2);
                        }
                        PA.stream_disconnect(stream);
                        PA.stream_unref(stream);
                        throw throwable;
                    }
                    PA.cvolume_free(cvolume2);
                }
                PA.stream_disconnect(stream);
                PA.stream_unref(stream);
                {
                }
            }
            super.close();
            Object var8_7 = null;
            this.pulseAudioSystem.unlockMainloop();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.pulseAudioSystem.unlockMainloop();
            throw throwable;
        }
    }

    private void cork(boolean b) {
        try {
            try {
                PulseAudioSystem.corkStream(this.stream, b);
                this.corked = b;
            }
            catch (IOException ioe) {
                throw new UndeclaredThrowableException(ioe);
            }
            Object var4_2 = null;
            this.pulseAudioSystem.signalMainloop(false);
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.pulseAudioSystem.signalMainloop(false);
            throw throwable;
        }
    }

    private String getLocatorDev() {
        String locatorDev;
        MediaLocator locator = this.getLocator();
        if (locator == null) {
            locatorDev = null;
        } else {
            locatorDev = locator.getRemainder();
            if (locatorDev != null && locatorDev.length() <= 0) {
                locatorDev = null;
            }
        }
        return locatorDev;
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public Format[] getSupportedInputFormats() {
        return (Format[])SUPPORTED_INPUT_FORMATS.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws ResourceUnavailableException {
        this.pulseAudioSystem.lockMainloop();
        try {
            this.openWithMainloopLock();
            super.open();
            Object var2_1 = null;
            this.pulseAudioSystem.unlockMainloop();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.pulseAudioSystem.unlockMainloop();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openWithMainloopLock() throws ResourceUnavailableException {
        void var7_9;
        if (this.stream != 0L) {
            return;
        }
        AudioFormat format = (AudioFormat)this.inputFormat;
        int sampleRate = (int)format.getSampleRate();
        int channels = format.getChannels();
        int sampleSizeInBits = format.getSampleSizeInBits();
        if (sampleRate == -1 && MediaUtils.MAX_AUDIO_SAMPLE_RATE != -1.0) {
            sampleRate = (int)MediaUtils.MAX_AUDIO_SAMPLE_RATE;
        }
        if (channels == -1) {
            channels = 1;
        }
        if (sampleSizeInBits == -1) {
            sampleSizeInBits = 16;
        }
        long stream = 0L;
        Object var7_6 = null;
        try {
            stream = this.pulseAudioSystem.createStream(sampleRate, channels, this.getClass().getName(), this.mediaRole);
            this.channels = channels;
        }
        catch (IllegalStateException ise) {
            IllegalStateException illegalStateException = ise;
        }
        catch (RuntimeException re) {
            RuntimeException runtimeException = re;
        }
        if (var7_9 != null) {
            ResourceUnavailableException rue = new ResourceUnavailableException();
            rue.initCause((Throwable)var7_9);
            throw rue;
        }
        if (stream == 0L) {
            throw new ResourceUnavailableException("stream");
        }
        try {
            block23: {
                long attr = PA.buffer_attr_new(-1, 2 * (sampleRate / 100) * channels * (sampleSizeInBits / 8), -1, -1, -1);
                if (attr == 0L) {
                    throw new ResourceUnavailableException("pa_buffer_attr_new");
                }
                try {
                    block22: {
                        Runnable stateCallback = new Runnable(){

                            public void run() {
                                PulseAudioRenderer.this.pulseAudioSystem.signalMainloop(false);
                            }
                        };
                        PA.stream_set_state_callback(stream, stateCallback);
                        String dev = this.getLocatorDev();
                        PA.stream_connect_playback(stream, dev, attr, 8193, 0L, 0L);
                        try {
                            block21: {
                                int state;
                                if (attr != 0L) {
                                    PA.buffer_attr_free(attr);
                                    attr = 0L;
                                }
                                if ((state = this.pulseAudioSystem.waitForStreamState(stream, 2)) != 2) {
                                    throw new ResourceUnavailableException("stream.state");
                                }
                                PA.stream_set_write_callback(stream, this.writeCallback);
                                if (this.gainControl != null) {
                                    this.cvolume = PA.cvolume_new();
                                    boolean freeCvolume = true;
                                    try {
                                        float gainControlLevel = this.gainControl.getLevel();
                                        this.setStreamVolume(stream, gainControlLevel);
                                        this.gainControlLevel = gainControlLevel;
                                        freeCvolume = false;
                                        Object var16_19 = null;
                                        if (!freeCvolume) break block21;
                                    }
                                    catch (Throwable throwable) {
                                        Object var16_20 = null;
                                        if (!freeCvolume) throw throwable;
                                        PA.cvolume_free(this.cvolume);
                                        this.cvolume = 0L;
                                        throw throwable;
                                    }
                                    PA.cvolume_free(this.cvolume);
                                    this.cvolume = 0L;
                                }
                            }
                            this.stream = stream;
                            this.dev = dev;
                            Object var18_22 = null;
                            if (this.stream != 0L) break block22;
                        }
                        catch (Throwable throwable) {
                            Object var18_23 = null;
                            if (this.stream != 0L) throw throwable;
                            PA.stream_disconnect(stream);
                            throw throwable;
                        }
                        PA.stream_disconnect(stream);
                    }
                    Object var20_25 = null;
                    if (attr == 0L) break block23;
                }
                catch (Throwable throwable) {
                    Object var20_26 = null;
                    if (attr == 0L) throw throwable;
                    PA.buffer_attr_free(attr);
                    throw throwable;
                }
                PA.buffer_attr_free(attr);
            }
            Object var22_28 = null;
            if (this.stream != 0L) return;
        }
        catch (Throwable throwable) {
            Object var22_29 = null;
            if (this.stream != 0L) throw throwable;
            PA.stream_unref(stream);
            throw throwable;
        }
        PA.stream_unref(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void playbackDevicePropertyChange(PropertyChangeEvent event) {
        this.pulseAudioSystem.lockMainloop();
        try {
            String streamDev;
            String locatorDev;
            boolean open;
            boolean bl = open = this.stream != 0L;
            if (open && !StringUtils.isEquals(this.dev, locatorDev = this.getLocatorDev()) && !StringUtils.isEquals(streamDev = PA.stream_get_device_name(this.stream), locatorDev)) {
                boolean start = !this.corked;
                this.close();
                try {
                    this.open();
                }
                catch (ResourceUnavailableException rue) {
                    throw new UndeclaredThrowableException(rue);
                }
                if (start) {
                    this.start();
                }
            }
            Object var8_7 = null;
            this.pulseAudioSystem.unlockMainloop();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.pulseAudioSystem.unlockMainloop();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int process(Buffer buffer) {
        int ret;
        if (buffer.isDiscard()) {
            return 0;
        }
        if (buffer.getLength() <= 0) {
            return 0;
        }
        this.pulseAudioSystem.lockMainloop();
        try {
            ret = this.processWithMainloopLock(buffer);
            Object var4_3 = null;
            this.pulseAudioSystem.unlockMainloop();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.pulseAudioSystem.unlockMainloop();
            throw throwable;
        }
        if (ret != 1 && buffer.getLength() > 0) {
            ret |= 2;
        }
        return ret;
    }

    private int processWithMainloopLock(Buffer buffer) {
        int ret;
        if (this.stream == 0L || this.corked) {
            return 1;
        }
        int writableSize = PA.stream_writable_size(this.stream);
        if (writableSize <= 0) {
            this.pulseAudioSystem.waitMainloop();
            ret = 0;
        } else {
            int writtenSize;
            byte[] data = (byte[])buffer.getData();
            int offset = buffer.getOffset();
            int length = buffer.getLength();
            if (length < writableSize) {
                writableSize = length;
            }
            if (this.gainControl != null) {
                if (this.cvolume == 0L) {
                    if (length > 0) {
                        AbstractVolumeControl.applyGain(this.gainControl, data, offset, writableSize);
                    }
                } else {
                    float gainControlLevel = this.gainControl.getLevel();
                    if (this.gainControlLevel != gainControlLevel) {
                        this.gainControlLevel = gainControlLevel;
                        this.setStreamVolume(this.stream, gainControlLevel);
                    }
                }
            }
            if ((writtenSize = PA.stream_write(this.stream, data, offset, writableSize, null, 0L, 0)) < 0) {
                ret = 1;
            } else {
                ret = 0;
                buffer.setLength(length - writtenSize);
                buffer.setOffset(offset + writtenSize);
            }
        }
        return ret;
    }

    private void setStreamVolume(long stream, float level) {
        int volume = PA.sw_volume_from_linear(level * 2.0f);
        PA.cvolume_set(this.cvolume, this.channels, volume);
        long o = PA.context_set_sink_input_volume(this.pulseAudioSystem.getContext(), PA.stream_get_index(stream), this.cvolume, null);
        if (o != 0L) {
            PA.operation_unref(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.pulseAudioSystem.lockMainloop();
        try {
            if (this.stream == 0L) {
                try {
                    this.openWithMainloopLock();
                }
                catch (ResourceUnavailableException rue) {
                    throw new UndeclaredThrowableException(rue);
                }
            }
            this.cork(false);
            Object var3_2 = null;
            this.pulseAudioSystem.unlockMainloop();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.pulseAudioSystem.unlockMainloop();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.pulseAudioSystem.lockMainloop();
        try {
            this.stopWithMainloopLock();
            Object var2_1 = null;
            this.pulseAudioSystem.unlockMainloop();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.pulseAudioSystem.unlockMainloop();
            throw throwable;
        }
    }

    private void stopWithMainloopLock() {
        if (this.stream != 0L) {
            this.cork(true);
        }
    }
}

