/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.renderer.audio;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.media.MediaLocator;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.ExtendedCaptureDeviceInfo;
import org.jitsi.impl.neomedia.jmfext.media.renderer.AbstractRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAudioRenderer
extends AbstractRenderer<AudioFormat> {
    protected final AudioSystem audioSystem;
    private MediaLocator locator;
    private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            AbstractAudioRenderer.this.propertyChange(event);
        }
    };

    protected AbstractAudioRenderer(AudioSystem audioSystem) {
        this.audioSystem = audioSystem;
    }

    protected AbstractAudioRenderer(String locatorProtocol) {
        this(AudioSystem.getAudioSystem(locatorProtocol));
    }

    public void close() {
        if (this.audioSystem != null) {
            this.audioSystem.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public MediaLocator getLocator() {
        ExtendedCaptureDeviceInfo playbackDevice;
        MediaLocator locator = this.locator;
        if (locator == null && this.audioSystem != null && (playbackDevice = this.audioSystem.getDevice(2)) != null) {
            locator = playbackDevice.getLocator();
        }
        return locator;
    }

    public void open() throws ResourceUnavailableException {
        MediaLocator locator;
        if (this.locator == null && this.audioSystem != null && (locator = this.getLocator()) != null) {
            this.audioSystem.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void playbackDevicePropertyChange(PropertyChangeEvent event) {
    }

    private void propertyChange(PropertyChangeEvent event) {
        if ("playbackDevice".equals(event.getPropertyName())) {
            this.playbackDevicePropertyChange(event);
        }
    }

    public void setLocator(MediaLocator locator) {
        if (this.locator == null ? locator == null : this.locator.equals((Object)locator)) {
            return;
        }
        this.locator = locator;
    }
}

