/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.quicktime;

import java.awt.Dimension;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.FormatControl;
import javax.media.control.FrameRateControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.PushBufferStream;
import org.jitsi.impl.neomedia.NeomediaServiceUtils;
import org.jitsi.impl.neomedia.codec.video.AVFrame;
import org.jitsi.impl.neomedia.codec.video.AVFrameFormat;
import org.jitsi.impl.neomedia.codec.video.ByteBuffer;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPushBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.ByteBufferPool;
import org.jitsi.impl.neomedia.jmfext.media.protocol.quicktime.DataSource;
import org.jitsi.impl.neomedia.quicktime.CVImageBuffer;
import org.jitsi.impl.neomedia.quicktime.CVPixelBuffer;
import org.jitsi.impl.neomedia.quicktime.CVPixelBufferAttributeKey;
import org.jitsi.impl.neomedia.quicktime.NSDictionary;
import org.jitsi.impl.neomedia.quicktime.NSMutableDictionary;
import org.jitsi.impl.neomedia.quicktime.QTCaptureDecompressedVideoOutput;
import org.jitsi.impl.neomedia.quicktime.QTCaptureOutput;
import org.jitsi.impl.neomedia.quicktime.QTSampleBuffer;

public class QuickTimeStream
extends AbstractPushBufferStream {
    private final boolean automaticallyDropsLateVideoFrames;
    private final ByteBufferPool byteBufferPool = new ByteBufferPool();
    final QTCaptureDecompressedVideoOutput captureOutput = new QTCaptureDecompressedVideoOutput();
    private VideoFormat captureOutputFormat;
    private ByteBuffer data;
    private Format dataFormat;
    private final Object dataSyncRoot = new Object();
    private long dataTimeStamp;
    private Format format;
    private ByteBuffer nextData;
    private Format nextDataFormat;
    private long nextDataTimeStamp;
    private Thread transferDataThread;

    QuickTimeStream(DataSource dataSource, FormatControl formatControl) {
        super(dataSource, formatControl);
        float frameRate;
        Format format;
        if (formatControl != null && (format = formatControl.getFormat()) != null) {
            this.setCaptureOutputFormat(format);
        }
        this.automaticallyDropsLateVideoFrames = this.captureOutput.setAutomaticallyDropsLateVideoFrames(true);
        this.captureOutput.setDelegate(new QTCaptureDecompressedVideoOutput.Delegate(){

            public void outputVideoFrameWithSampleBuffer(CVImageBuffer videoFrame, QTSampleBuffer sampleBuffer) {
                QuickTimeStream.this.captureOutputDidOutputVideoFrameWithSampleBuffer(QuickTimeStream.this.captureOutput, videoFrame, sampleBuffer);
            }
        });
        FrameRateControl frameRateControl = (FrameRateControl)dataSource.getControl(FrameRateControl.class.getName());
        if (frameRateControl != null && (frameRate = frameRateControl.getFrameRate()) > 0.0f) {
            this.setFrameRate(frameRate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureOutputDidOutputVideoFrameWithSampleBuffer(QTCaptureOutput captureOutput, CVImageBuffer videoFrame, QTSampleBuffer sampleBuffer) {
        BufferTransferHandler transferHandler;
        boolean transferData;
        CVPixelBuffer pixelBuffer = (CVPixelBuffer)videoFrame;
        Format videoFrameFormat = this.getVideoFrameFormat(pixelBuffer);
        Object object = this.dataSyncRoot;
        synchronized (object) {
            if (!this.automaticallyDropsLateVideoFrames && this.data != null) {
                if (this.nextData != null) {
                    this.nextData.free();
                    this.nextData = null;
                }
                this.nextData = this.byteBufferPool.getBuffer(pixelBuffer.getByteCount());
                if (this.nextData != null) {
                    this.nextData.setLength(pixelBuffer.getBytes(this.nextData.getPtr(), this.nextData.getCapacity()));
                    this.nextDataTimeStamp = System.nanoTime();
                    if (this.nextDataFormat == null) {
                        this.nextDataFormat = videoFrameFormat;
                    }
                }
                return;
            }
            if (this.data != null) {
                this.data.free();
                this.data = null;
            }
            this.data = this.byteBufferPool.getBuffer(pixelBuffer.getByteCount());
            if (this.data != null) {
                this.data.setLength(pixelBuffer.getBytes(this.data.getPtr(), this.data.getCapacity()));
                this.dataTimeStamp = System.nanoTime();
                if (this.dataFormat == null) {
                    this.dataFormat = videoFrameFormat;
                }
            }
            if (this.nextData != null) {
                this.nextData.free();
                this.nextData = null;
            }
            if (this.automaticallyDropsLateVideoFrames) {
                transferData = this.data != null;
            } else {
                transferData = false;
                this.dataSyncRoot.notifyAll();
            }
        }
        if (transferData && (transferHandler = this.transferHandler) != null) {
            transferHandler.transferData((PushBufferStream)this);
        }
    }

    public void close() {
        super.close();
        this.captureOutput.setDelegate(null);
        this.byteBufferPool.drain();
    }

    protected Format doGetFormat() {
        Format format;
        if (this.format == null) {
            format = this.getCaptureOutputFormat();
            if (format == null) {
                format = super.doGetFormat();
            } else {
                VideoFormat videoFormat = (VideoFormat)format;
                if (videoFormat.getSize() != null) {
                    this.format = format;
                } else {
                    Dimension defaultSize = NeomediaServiceUtils.getMediaServiceImpl().getDeviceConfiguration().getVideoSize();
                    format = videoFormat.intersects((Format)new VideoFormat(null, new Dimension(defaultSize.width, defaultSize.height), -1, null, -1.0f));
                }
            }
        } else {
            format = this.format;
        }
        return format;
    }

    private Format getCaptureOutputFormat() {
        NSDictionary pixelBufferAttributes = this.captureOutput.pixelBufferAttributes();
        if (pixelBufferAttributes != null) {
            int pixelFormatType = pixelBufferAttributes.intForKey(CVPixelBufferAttributeKey.kCVPixelBufferPixelFormatTypeKey);
            int width = pixelBufferAttributes.intForKey(CVPixelBufferAttributeKey.kCVPixelBufferWidthKey);
            int height = pixelBufferAttributes.intForKey(CVPixelBufferAttributeKey.kCVPixelBufferHeightKey);
            switch (pixelFormatType) {
                case 32: {
                    if (this.captureOutputFormat instanceof AVFrameFormat) {
                        return new AVFrameFormat((Dimension)(width == 0 && height == 0 ? null : new Dimension(width, height)), -1.0f, 27, 32);
                    }
                    return new RGBFormat((Dimension)(width == 0 && height == 0 ? null : new Dimension(width, height)), -1, Format.byteArray, -1.0f, 32, 2, 3, 4);
                }
                case 2033463856: {
                    if (width == 0 && height == 0) {
                        if (this.captureOutputFormat instanceof AVFrameFormat) {
                            return new AVFrameFormat(0, 2033463856);
                        }
                        return new YUVFormat(2);
                    }
                    if (this.captureOutputFormat instanceof AVFrameFormat) {
                        return new AVFrameFormat(new Dimension(width, height), -1.0f, 0, 2033463856);
                    }
                    int strideY = width;
                    int strideUV = strideY / 2;
                    int offsetY = 0;
                    int offsetU = strideY * height;
                    int offsetV = offsetU + strideUV * height / 2;
                    return new YUVFormat(new Dimension(width, height), -1, Format.byteArray, -1.0f, 2, strideY, strideUV, offsetY, offsetU, offsetV);
                }
            }
        }
        return null;
    }

    public float getFrameRate() {
        return (float)(1.0 / this.captureOutput.minimumVideoFrameInterval());
    }

    private Format getVideoFrameFormat(CVPixelBuffer videoFrame) {
        Format format = this.getFormat();
        Dimension size = ((VideoFormat)format).getSize();
        if (size == null || size.width == 0 && size.height == 0) {
            format = format.intersects((Format)new VideoFormat(null, new Dimension(videoFrame.getWidth(), videoFrame.getHeight()), -1, null, -1.0f));
        }
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Buffer buffer) throws IOException {
        Object object = this.dataSyncRoot;
        synchronized (object) {
            Format format;
            if (this.data == null) {
                buffer.setLength(0);
                return;
            }
            if (this.dataFormat != null) {
                buffer.setFormat(this.dataFormat);
            }
            if ((format = buffer.getFormat()) == null && (format = this.getFormat()) != null) {
                buffer.setFormat(format);
            }
            if (format instanceof AVFrameFormat) {
                if (AVFrame.read(buffer, format, this.data) < 0) {
                    this.data.free();
                }
                this.data = null;
            } else {
                byte[] bytes;
                Object o = buffer.getData();
                int length = this.data.getLength();
                if (o instanceof byte[]) {
                    bytes = (byte[])o;
                    if (bytes.length < length) {
                        bytes = null;
                    }
                } else {
                    bytes = null;
                }
                if (bytes == null) {
                    bytes = new byte[length];
                    buffer.setData((Object)bytes);
                }
                CVPixelBuffer.memcpy(bytes, 0, length, this.data.getPtr());
                this.data.free();
                this.data = null;
                buffer.setLength(length);
                buffer.setOffset(0);
            }
            buffer.setFlags(32896);
            buffer.setTimeStamp(this.dataTimeStamp);
            if (!this.automaticallyDropsLateVideoFrames) {
                this.dataSyncRoot.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInTransferDataThread() {
        boolean transferData = false;
        while (Thread.currentThread().equals(this.transferDataThread)) {
            if (transferData) {
                BufferTransferHandler transferHandler = this.transferHandler;
                if (transferHandler != null) {
                    transferHandler.transferData((PushBufferStream)this);
                }
                Object object = this.dataSyncRoot;
                synchronized (object) {
                    if (this.data != null) {
                        this.data.free();
                    }
                    this.data = this.nextData;
                    this.dataTimeStamp = this.nextDataTimeStamp;
                    if (this.dataFormat == null) {
                        this.dataFormat = this.nextDataFormat;
                    }
                    this.nextData = null;
                }
            }
            Object object = this.dataSyncRoot;
            synchronized (object) {
                if (this.data == null) {
                    this.data = this.nextData;
                    this.dataTimeStamp = this.nextDataTimeStamp;
                    if (this.dataFormat == null) {
                        this.dataFormat = this.nextDataFormat;
                    }
                    this.nextData = null;
                }
                if (this.data == null) {
                    boolean interrupted = false;
                    try {
                        this.dataSyncRoot.wait();
                    }
                    catch (InterruptedException iex) {
                        interrupted = true;
                    }
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    transferData = this.data != null;
                } else {
                    transferData = true;
                }
            }
        }
    }

    private void setCaptureOutputFormat(Format format) {
        String encoding;
        int height;
        int width;
        VideoFormat videoFormat = (VideoFormat)format;
        Dimension size = videoFormat.getSize();
        if (size == null) {
            Dimension defaultSize = NeomediaServiceUtils.getMediaServiceImpl().getDeviceConfiguration().getVideoSize();
            width = defaultSize.width;
            height = defaultSize.height;
        } else {
            width = size.width;
            height = size.height;
        }
        NSMutableDictionary pixelBufferAttributes = null;
        if (width > 0 && height > 0) {
            if (pixelBufferAttributes == null) {
                pixelBufferAttributes = new NSMutableDictionary();
            }
            pixelBufferAttributes.setIntForKey(width, CVPixelBufferAttributeKey.kCVPixelBufferWidthKey);
            pixelBufferAttributes.setIntForKey(height, CVPixelBufferAttributeKey.kCVPixelBufferHeightKey);
        }
        if (format instanceof AVFrameFormat) {
            switch (((AVFrameFormat)format).getPixFmt()) {
                case 27: {
                    encoding = "rgb";
                    break;
                }
                case 0: {
                    encoding = "yuv";
                    break;
                }
                default: {
                    encoding = null;
                    break;
                }
            }
        } else {
            encoding = format.isSameEncoding("rgb") ? "rgb" : (format.isSameEncoding("yuv") ? "yuv" : null);
        }
        if ("rgb".equalsIgnoreCase(encoding)) {
            if (pixelBufferAttributes == null) {
                pixelBufferAttributes = new NSMutableDictionary();
            }
            pixelBufferAttributes.setIntForKey(32, CVPixelBufferAttributeKey.kCVPixelBufferPixelFormatTypeKey);
        } else if ("yuv".equalsIgnoreCase(encoding)) {
            if (pixelBufferAttributes == null) {
                pixelBufferAttributes = new NSMutableDictionary();
            }
            pixelBufferAttributes.setIntForKey(2033463856, CVPixelBufferAttributeKey.kCVPixelBufferPixelFormatTypeKey);
        } else {
            throw new IllegalArgumentException("format");
        }
        if (pixelBufferAttributes != null) {
            this.captureOutput.setPixelBufferAttributes(pixelBufferAttributes);
            this.captureOutputFormat = videoFormat;
        }
    }

    public float setFrameRate(float frameRate) {
        this.captureOutput.setMinimumVideoFrameInterval(1.0 / (double)frameRate);
        return this.getFrameRate();
    }

    public void start() throws IOException {
        super.start();
        if (!this.automaticallyDropsLateVideoFrames) {
            this.transferDataThread = new Thread(this.getClass().getSimpleName()){

                public void run() {
                    QuickTimeStream.this.runInTransferDataThread();
                }
            };
            this.transferDataThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        try {
            this.transferDataThread = null;
            Object object = this.dataSyncRoot;
            synchronized (object) {
                if (this.data != null) {
                    this.data.free();
                    this.data = null;
                }
                this.dataFormat = null;
                if (this.nextData != null) {
                    this.nextData.free();
                    this.nextData = null;
                }
                this.nextDataFormat = null;
                if (!this.automaticallyDropsLateVideoFrames) {
                    this.dataSyncRoot.notifyAll();
                }
            }
        }
        finally {
            super.stop();
            this.byteBufferPool.drain();
        }
    }
}

