/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.portaudio;

import java.io.IOException;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.control.FormatControl;
import javax.media.protocol.PullBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPullBufferCaptureDevice;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPullBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.portaudio.PortAudioStream;
import org.jitsi.util.Logger;

public class DataSource
extends AbstractPullBufferCaptureDevice {
    private static final Logger logger = Logger.getLogger(DataSource.class);
    private final boolean audioQualityImprovement;
    private final Format[] supportedFormats;

    public DataSource() {
        this.supportedFormats = null;
        this.audioQualityImprovement = true;
    }

    public DataSource(MediaLocator locator) {
        this(locator, null, true);
    }

    public DataSource(MediaLocator locator, Format[] supportedFormats, boolean audioQualityImprovement) {
        super(locator);
        this.supportedFormats = supportedFormats == null ? null : (Format[])supportedFormats.clone();
        this.audioQualityImprovement = audioQualityImprovement;
    }

    protected AbstractPullBufferStream createStream(int streamIndex, FormatControl formatControl) {
        return new PortAudioStream(this, formatControl, this.audioQualityImprovement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConnect() throws IOException {
        super.doConnect();
        String deviceID = this.getDeviceID();
        Object object = this.getStreamSyncRoot();
        synchronized (object) {
            for (PullBufferStream stream : this.getStreams()) {
                ((PortAudioStream)stream).setDeviceID(deviceID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDisconnect() {
        try {
            Object object = this.getStreamSyncRoot();
            synchronized (object) {
                AbstractBufferStream[] streams = this.streams();
                if (streams != null) {
                    for (AbstractBufferStream stream : streams) {
                        try {
                            ((PortAudioStream)stream).setDeviceID(null);
                        }
                        catch (IOException ioex) {
                            logger.error("Failed to close " + stream.getClass().getSimpleName(), ioex);
                        }
                    }
                }
            }
            Object var10_9 = null;
            super.doDisconnect();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            super.doDisconnect();
            throw throwable;
        }
    }

    public String getDeviceID() {
        MediaLocator locator = this.getLocator();
        if (locator == null) {
            throw new IllegalStateException("locator");
        }
        return DataSource.getDeviceID(locator);
    }

    public static String getDeviceID(MediaLocator locator) {
        if ("portaudio".equalsIgnoreCase(locator.getProtocol())) {
            return locator.getRemainder().replace("#", "");
        }
        throw new IllegalArgumentException("locator.protocol");
    }

    protected Format[] getSupportedFormats(int streamIndex) {
        return this.supportedFormats == null ? super.getSupportedFormats(streamIndex) : this.supportedFormats;
    }
}

