/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.Renderer;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.MediaServiceImpl;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.util.Logger;
import org.jitsi.util.OSUtils;
import org.jitsi.util.event.PropertyChangeNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeviceSystem
extends PropertyChangeNotifier {
    private static List<DeviceSystem> deviceSystems = new LinkedList<DeviceSystem>();
    public static final int FEATURE_REINITIALIZE = 1;
    public static final String LOCATOR_PROTOCOL_CIVIL = "civil";
    public static final String LOCATOR_PROTOCOL_DIRECTSHOW = "directshow";
    public static final String LOCATOR_PROTOCOL_IMGSTREAMING = "imgstreaming";
    public static final String LOCATOR_PROTOCOL_MEDIARECORDER = "mediarecorder";
    public static final String LOCATOR_PROTOCOL_QUICKTIME = "quicktime";
    public static final String LOCATOR_PROTOCOL_VIDEO4LINUX2 = "video4linux2";
    private static final Logger logger = Logger.getLogger(DeviceSystem.class);
    private static List<CaptureDeviceInfo> preInitializeDevices;
    public static final String PROP_DEVICES = "devices";
    private final int features;
    private final String locatorProtocol;
    private final MediaType mediaType;

    protected static List<CaptureDeviceInfo> filterDeviceListByLocatorProtocol(List<CaptureDeviceInfo> deviceList, String locatorProtocol) {
        if (deviceList != null && deviceList.size() > 0) {
            Iterator<CaptureDeviceInfo> deviceListIter = deviceList.iterator();
            while (deviceListIter.hasNext()) {
                MediaLocator locator = deviceListIter.next().getLocator();
                if (locator != null && locatorProtocol.equalsIgnoreCase(locator.getProtocol())) continue;
                deviceListIter.remove();
            }
        }
        return deviceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeviceSystem[] getDeviceSystems(MediaType mediaType) {
        ArrayList<DeviceSystem> ret;
        List<DeviceSystem> list = deviceSystems;
        synchronized (list) {
            ret = new ArrayList<DeviceSystem>(deviceSystems.size());
            for (DeviceSystem deviceSystem : deviceSystems) {
                if (!deviceSystem.getMediaType().equals((Object)mediaType)) continue;
                ret.add(deviceSystem);
            }
        }
        return ret.toArray(new DeviceSystem[ret.size()]);
    }

    public static void initializeDeviceSystems() {
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        if (!(cfg != null && cfg.getBoolean("net.java.sip.communicator.service.media.DISABLE_AUDIO_SUPPORT", false) || Boolean.getBoolean("net.java.sip.communicator.service.media.DISABLE_AUDIO_SUPPORT"))) {
            if (logger.isInfoEnabled()) {
                logger.info("Initializing audio devices");
            }
            DeviceSystem.initializeDeviceSystems(MediaType.AUDIO);
        }
        if (cfg == null || !cfg.getBoolean("net.java.sip.communicator.service.media.DISABLE_VIDEO_SUPPORT", false)) {
            if (logger.isInfoEnabled()) {
                logger.info("Initializing video devices");
            }
            DeviceSystem.initializeDeviceSystems(MediaType.VIDEO);
        }
    }

    public static void initializeDeviceSystems(MediaType mediaType) {
        String[] classNames;
        switch (mediaType) {
            case AUDIO: {
                classNames = new String[]{OSUtils.IS_ANDROID ? ".AudioRecordSystem" : null, OSUtils.IS_ANDROID ? ".OpenSLESSystem" : null, OSUtils.IS_LINUX ? ".PulseAudioSystem" : null, OSUtils.IS_ANDROID ? null : ".PortAudioSystem", ".NoneAudioSystem"};
                break;
            }
            case VIDEO: {
                classNames = new String[]{OSUtils.IS_ANDROID ? ".MediaRecorderSystem" : null, OSUtils.IS_LINUX ? ".Video4Linux2System" : null, OSUtils.IS_MAC ? ".QuickTimeSystem" : null, OSUtils.IS_WINDOWS ? ".DirectShowSystem" : null, ".ImgStreamingSystem"};
                break;
            }
            default: {
                throw new IllegalArgumentException("mediaType");
            }
        }
        DeviceSystem.initializeDeviceSystems(classNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeDeviceSystems(String[] classNames) {
        List<DeviceSystem> list = deviceSystems;
        synchronized (list) {
            String packageName = null;
            for (String className : classNames) {
                boolean reinitialize;
                if (className == null) continue;
                if (className.startsWith(".")) {
                    if (packageName == null) {
                        packageName = DeviceSystem.class.getPackage().getName();
                    }
                    className = packageName + className;
                }
                DeviceSystem deviceSystem = null;
                for (DeviceSystem aDeviceSystem : deviceSystems) {
                    if (!aDeviceSystem.getClass().getName().equals(className)) continue;
                    deviceSystem = aDeviceSystem;
                    break;
                }
                if (deviceSystem == null) {
                    Object o;
                    block16: {
                        reinitialize = false;
                        o = null;
                        try {
                            o = Class.forName(className).newInstance();
                        }
                        catch (Throwable t) {
                            if (t instanceof ThreadDeath) {
                                throw (ThreadDeath)t;
                            }
                            if (!logger.isDebugEnabled()) break block16;
                            logger.debug("Failed to initialize " + className, t);
                        }
                    }
                    if (o instanceof DeviceSystem && !deviceSystems.contains(deviceSystem = (DeviceSystem)o)) {
                        deviceSystems.add(deviceSystem);
                    }
                } else {
                    reinitialize = true;
                }
                if (!reinitialize || (deviceSystem.getFeatures() & 1) == 0) continue;
                try {
                    deviceSystem.initialize();
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Failed to reinitialize " + className, t);
                }
            }
        }
    }

    protected DeviceSystem(MediaType mediaType, String locatorProtocol) throws Exception {
        this(mediaType, locatorProtocol, 0);
    }

    protected DeviceSystem(MediaType mediaType, String locatorProtocol, int features) throws Exception {
        if (mediaType == null) {
            throw new NullPointerException("mediaType");
        }
        if (locatorProtocol == null) {
            throw new NullPointerException("locatorProtocol");
        }
        this.mediaType = mediaType;
        this.locatorProtocol = locatorProtocol;
        this.features = features;
        this.initialize();
    }

    public Renderer createRenderer(boolean playback) {
        String className = this.getRendererClassName();
        if (className != null) {
            try {
                return (Renderer)Class.forName(className).newInstance();
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                logger.warn("Failed to initialize a new " + className + " instance", t);
            }
        }
        return null;
    }

    protected abstract void doInitialize() throws Exception;

    public final int getFeatures() {
        return this.features;
    }

    public Format getFormat() {
        AudioFormat format = null;
        switch (this.getMediaType()) {
            case AUDIO: {
                format = new AudioFormat(null);
                break;
            }
            case VIDEO: {
                format = new VideoFormat(null);
                break;
            }
            default: {
                format = null;
            }
        }
        return format;
    }

    public final String getLocatorProtocol() {
        return this.locatorProtocol;
    }

    public final MediaType getMediaType() {
        return this.mediaType;
    }

    protected String getRendererClassName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void initialize() throws Exception {
        this.preInitialize();
        try {
            this.doInitialize();
            Object var2_1 = null;
            this.postInitialize();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.postInitialize();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postInitialize() {
        try {
            Format format = this.getFormat();
            if (format != null) {
                int postInitializeDeviceCount;
                Vector cdis = CaptureDeviceManager.getDeviceList((Format)format);
                ArrayList postInitializeDevices = new ArrayList(cdis);
                if (preInitializeDevices != null) {
                    Iterator<CaptureDeviceInfo> preIter = preInitializeDevices.iterator();
                    while (preIter.hasNext()) {
                        if (!postInitializeDevices.remove(preIter.next())) continue;
                        preIter.remove();
                    }
                }
                int preInitializeDeviceCount = preInitializeDevices == null ? 0 : preInitializeDevices.size();
                int n = postInitializeDeviceCount = postInitializeDevices == null ? 0 : postInitializeDevices.size();
                if (preInitializeDeviceCount != 0 || postInitializeDeviceCount != 0) {
                    this.firePropertyChange(PROP_DEVICES, preInitializeDevices, postInitializeDevices);
                }
            }
            Object var7_7 = null;
            preInitializeDevices = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            preInitializeDevices = null;
            throw throwable;
        }
    }

    protected void preInitialize() {
        block6: {
            Format format = this.getFormat();
            if (format != null) {
                Vector cdis = CaptureDeviceManager.getDeviceList((Format)format);
                preInitializeDevices = new ArrayList<CaptureDeviceInfo>(cdis);
                if (cdis != null && cdis.size() > 0) {
                    boolean commit = false;
                    for (CaptureDeviceInfo cdi : DeviceSystem.filterDeviceListByLocatorProtocol(cdis, this.getLocatorProtocol())) {
                        CaptureDeviceManager.removeDevice((CaptureDeviceInfo)cdi);
                        commit = true;
                    }
                    if (commit && !MediaServiceImpl.isJmfRegistryDisableLoad()) {
                        try {
                            CaptureDeviceManager.commit();
                        }
                        catch (IOException ioe) {
                            if (!logger.isDebugEnabled()) break block6;
                            logger.debug("Failed to commit CaptureDeviceManager", ioe);
                        }
                    }
                }
            }
        }
    }

    public String toString() {
        return this.getLocatorProtocol();
    }
}

