/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.media.Buffer;
import javax.media.Player;
import javax.media.Processor;
import javax.media.Renderer;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.ReceiveStream;
import org.jitsi.impl.neomedia.audiolevel.AudioLevelEventDispatcher;
import org.jitsi.impl.neomedia.audiolevel.AudioLevelMap;
import org.jitsi.impl.neomedia.conference.AudioMixer;
import org.jitsi.impl.neomedia.conference.AudioMixingPushBufferDataSource;
import org.jitsi.impl.neomedia.conference.DataSourceFilter;
import org.jitsi.impl.neomedia.device.AbstractMediaDevice;
import org.jitsi.impl.neomedia.device.AudioMediaDeviceImpl;
import org.jitsi.impl.neomedia.device.AudioMediaDeviceSession;
import org.jitsi.impl.neomedia.device.MediaDeviceSession;
import org.jitsi.impl.neomedia.device.ReceiveStreamPushBufferDataSource;
import org.jitsi.impl.neomedia.protocol.PushBufferDataSourceDelegate;
import org.jitsi.impl.neomedia.protocol.TranscodingDataSource;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.QualityPreset;
import org.jitsi.service.neomedia.RTPExtension;
import org.jitsi.service.neomedia.codec.EncodingConfiguration;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.device.MediaDeviceWrapper;
import org.jitsi.service.neomedia.event.SimpleAudioLevelListener;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioMixerMediaDevice
extends AbstractMediaDevice
implements MediaDeviceWrapper {
    private static final Logger logger = Logger.getLogger(AudioMixerMediaDevice.class);
    private AudioMixer audioMixer;
    private final AudioMediaDeviceImpl device;
    private AudioMixerMediaDeviceSession deviceSession;
    private final SimpleAudioLevelListener localUserAudioLevelDelegate = new SimpleAudioLevelListener(){

        public void audioLevelChanged(int level) {
            AudioMixerMediaDevice.this.lastMeasuredLocalUserAudioLevel = level;
            AudioMixerMediaDevice.this.fireLocalUserAudioLevelChanged(level);
        }
    };
    private final AudioLevelEventDispatcher localUserAudioLevelDispatcher = new AudioLevelEventDispatcher("Local User Audio Level Dispatcher (Mixer Edition)");
    private List<SimpleAudioLevelListenerWrapper> localUserAudioLevelListeners = new ArrayList<SimpleAudioLevelListenerWrapper>();
    private final Object localUserAudioLevelListenersSyncRoot = new Object();
    private final AudioLevelMap audioLevelCache = new AudioLevelMap();
    private int lastMeasuredLocalUserAudioLevel = 0;
    private List<RTPExtension> rtpExtensions = null;
    private final Map<ReceiveStream, AudioLevelEventDispatcher> streamAudioLevelListeners = new HashMap<ReceiveStream, AudioLevelEventDispatcher>();

    public AudioMixerMediaDevice(AudioMediaDeviceImpl device) {
        if (!device.getDirection().allowsSending()) {
            throw new IllegalArgumentException("device must be able to capture");
        }
        this.device = device;
    }

    @Override
    public void connect(DataSource captureDevice) throws IOException {
        DataSource effectiveCaptureDevice = captureDevice;
        if (captureDevice instanceof PushBufferDataSourceDelegate) {
            captureDevice = ((PushBufferDataSourceDelegate)((Object)captureDevice)).getDataSource();
        }
        if (captureDevice instanceof AudioMixingPushBufferDataSource) {
            effectiveCaptureDevice.connect();
        } else {
            this.device.connect(effectiveCaptureDevice);
        }
    }

    public AudioMixingPushBufferDataSource createOutputDataSource() {
        return this.getAudioMixer().createOutputDataSource();
    }

    @Override
    protected Processor createPlayer(DataSource dataSource) throws Exception {
        return this.device.createPlayer(dataSource);
    }

    @Override
    protected Renderer createRenderer() {
        return this.device.createRenderer();
    }

    @Override
    public synchronized MediaDeviceSession createSession() {
        if (this.deviceSession == null) {
            this.deviceSession = new AudioMixerMediaDeviceSession();
        }
        return new MediaStreamMediaDeviceSession(this.deviceSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLocalUserAudioLevelChanged(int level) {
        List<SimpleAudioLevelListenerWrapper> localUserAudioLevelListeners;
        Object object = this.localUserAudioLevelListenersSyncRoot;
        synchronized (object) {
            localUserAudioLevelListeners = this.localUserAudioLevelListeners;
        }
        int localUserAudioLevelListenerCount = localUserAudioLevelListeners.size();
        for (int i = 0; i < localUserAudioLevelListenerCount; ++i) {
            localUserAudioLevelListeners.get((int)i).listener.audioLevelChanged(level);
        }
    }

    private synchronized AudioMixer getAudioMixer() {
        if (this.audioMixer == null) {
            this.audioMixer = new AudioMixer(this.device.createCaptureDevice()){

                protected void connect(DataSource dataSource, DataSource inputDataSource) throws IOException {
                    if (inputDataSource == this.captureDevice) {
                        AudioMixerMediaDevice.this.connect(dataSource);
                    } else {
                        super.connect(dataSource, inputDataSource);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void read(PushBufferStream stream, Buffer buffer, DataSource dataSource) throws IOException {
                    super.read(stream, buffer, dataSource);
                    if (dataSource == this.captureDevice) {
                        Object object = AudioMixerMediaDevice.this.localUserAudioLevelListenersSyncRoot;
                        synchronized (object) {
                            if (AudioMixerMediaDevice.this.localUserAudioLevelListeners.isEmpty()) {
                                return;
                            }
                        }
                        AudioMixerMediaDevice.this.localUserAudioLevelDispatcher.addData(buffer);
                    } else if (dataSource instanceof ReceiveStreamPushBufferDataSource) {
                        AudioLevelEventDispatcher streamEventDispatcher;
                        ReceiveStream receiveStream = ((ReceiveStreamPushBufferDataSource)dataSource).getReceiveStream();
                        Map map = AudioMixerMediaDevice.this.streamAudioLevelListeners;
                        synchronized (map) {
                            streamEventDispatcher = (AudioLevelEventDispatcher)AudioMixerMediaDevice.this.streamAudioLevelListeners.get(receiveStream);
                        }
                        if (streamEventDispatcher != null && !buffer.isDiscard() && buffer.getLength() > 0 && buffer.getData() != null) {
                            streamEventDispatcher.addData(buffer);
                        }
                    }
                }
            };
        }
        return this.audioMixer;
    }

    @Override
    public MediaDirection getDirection() {
        return this.device.getDirection();
    }

    @Override
    public MediaFormat getFormat() {
        return this.device.getFormat();
    }

    @Override
    public MediaType getMediaType() {
        return this.device.getMediaType();
    }

    @Override
    public List<RTPExtension> getSupportedExtensions() {
        if (this.rtpExtensions == null) {
            URI csrcAudioLevelURN;
            block4: {
                this.rtpExtensions = new ArrayList<RTPExtension>(1);
                try {
                    csrcAudioLevelURN = new URI("urn:ietf:params:rtp-hdrext:csrc-audio-level");
                }
                catch (URISyntaxException e) {
                    csrcAudioLevelURN = null;
                    if (!logger.isInfoEnabled()) break block4;
                    logger.info("Aha! Someone messed with the source!", e);
                }
            }
            if (csrcAudioLevelURN != null) {
                this.rtpExtensions.add(new RTPExtension(csrcAudioLevelURN, MediaDirection.SENDRECV));
            }
        }
        return this.rtpExtensions;
    }

    @Override
    public List<MediaFormat> getSupportedFormats(QualityPreset sendPreset, QualityPreset receivePreset) {
        return this.device.getSupportedFormats();
    }

    @Override
    public List<MediaFormat> getSupportedFormats(QualityPreset sendPreset, QualityPreset receivePreset, EncodingConfiguration encodingConfiguration) {
        return this.device.getSupportedFormats(encodingConfiguration);
    }

    @Override
    public MediaDevice getWrappedDevice() {
        return this.device;
    }

    void removeInputDataSources(DataSourceFilter dataSourceFilter) {
        AudioMixer audioMixer = this.audioMixer;
        if (audioMixer != null) {
            audioMixer.removeInputDataSources(dataSourceFilter);
        }
    }

    public TranscodingDataSource getTranscodingDataSource(DataSource inputDataSource) {
        return this.getAudioMixer().getTranscodingDataSource(inputDataSource);
    }

    private static class SimpleAudioLevelListenerWrapper {
        public final SimpleAudioLevelListener listener;
        int referenceCount;

        public SimpleAudioLevelListenerWrapper(SimpleAudioLevelListener l) {
            this.listener = l;
            this.referenceCount = 1;
        }

        public boolean equals(Object obj) {
            return obj instanceof SimpleAudioLevelListenerWrapper && ((SimpleAudioLevelListenerWrapper)obj).listener == this.listener;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }

    private static class MediaStreamMediaDeviceSession
    extends AudioMediaDeviceSession
    implements PropertyChangeListener {
        private final AudioMixerMediaDeviceSession audioMixerMediaDeviceSession;
        private SimpleAudioLevelListener localUserAudioLevelListener = null;
        private SimpleAudioLevelListener streamAudioLevelListener = null;
        private final Object streamAudioLevelListenerLock = new Object();

        public MediaStreamMediaDeviceSession(AudioMixerMediaDeviceSession audioMixerMediaDeviceSession) {
            super(audioMixerMediaDeviceSession.getDevice());
            this.audioMixerMediaDeviceSession = audioMixerMediaDeviceSession;
            this.audioMixerMediaDeviceSession.addMediaStreamMediaDeviceSession(this);
            this.audioMixerMediaDeviceSession.addPropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                super.close();
                Object var2_1 = null;
                this.audioMixerMediaDeviceSession.removeMediaStreamMediaDeviceSession(this);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.audioMixerMediaDeviceSession.removeMediaStreamMediaDeviceSession(this);
                throw throwable;
            }
        }

        protected Player createPlayer(DataSource dataSource) {
            return null;
        }

        public long[] getRemoteSSRCList() {
            return this.audioMixerMediaDeviceSession.getRemoteSSRCList();
        }

        protected void playbackDataSourceAdded(DataSource playbackDataSource) {
            super.playbackDataSourceAdded(playbackDataSource);
            Object captureDevice = this.getCaptureDevice();
            if (captureDevice instanceof PushBufferDataSourceDelegate) {
                captureDevice = ((PushBufferDataSourceDelegate)((Object)captureDevice)).getDataSource();
            }
            if (captureDevice instanceof AudioMixingPushBufferDataSource) {
                ((AudioMixingPushBufferDataSource)captureDevice).addInputDataSource(playbackDataSource);
            }
            this.audioMixerMediaDeviceSession.addPlaybackDataSource(playbackDataSource);
        }

        protected void playbackDataSourceRemoved(DataSource playbackDataSource) {
            super.playbackDataSourceRemoved(playbackDataSource);
            this.audioMixerMediaDeviceSession.removePlaybackDataSource(playbackDataSource);
        }

        protected void playbackDataSourceUpdated(DataSource playbackDataSource) {
            super.playbackDataSourceUpdated(playbackDataSource);
            Object captureDevice = this.getCaptureDevice();
            if (captureDevice instanceof PushBufferDataSourceDelegate) {
                captureDevice = ((PushBufferDataSourceDelegate)((Object)captureDevice)).getDataSource();
            }
            if (captureDevice instanceof AudioMixingPushBufferDataSource) {
                ((AudioMixingPushBufferDataSource)captureDevice).updateInputDataSource(playbackDataSource);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("SSRC_LIST".equals(evt.getPropertyName())) {
                this.firePropertyChange("SSRC_LIST", evt.getOldValue(), evt.getNewValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void receiveStreamAdded(ReceiveStream receiveStream) {
            super.receiveStreamAdded(receiveStream);
            Object object = this.streamAudioLevelListenerLock;
            synchronized (object) {
                if (this.streamAudioLevelListener != null) {
                    this.audioMixerMediaDeviceSession.setStreamAudioLevelListener(receiveStream, this.streamAudioLevelListener);
                }
            }
            this.audioMixerMediaDeviceSession.addReceiveStream(receiveStream);
        }

        protected void receiveStreamRemoved(ReceiveStream receiveStream) {
            super.receiveStreamRemoved(receiveStream);
            this.audioMixerMediaDeviceSession.removeReceiveStream(receiveStream);
        }

        protected void registerLocalUserAudioLevelEffect(Processor processor) {
        }

        public void setLocalUserAudioLevelListener(SimpleAudioLevelListener l) {
            if (this.localUserAudioLevelListener != null) {
                this.audioMixerMediaDeviceSession.removeLocalUserAudioLevelListener(this.localUserAudioLevelListener);
                this.localUserAudioLevelListener = null;
            }
            if (l != null) {
                this.localUserAudioLevelListener = l;
                if (!this.isMute()) {
                    this.audioMixerMediaDeviceSession.addLocalUserAudioLevelListener(l);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStreamAudioLevelListener(SimpleAudioLevelListener listener) {
            Object object = this.streamAudioLevelListenerLock;
            synchronized (object) {
                this.streamAudioLevelListener = listener;
                for (ReceiveStream receiveStream : this.getReceiveStreams()) {
                    this.audioMixerMediaDeviceSession.setStreamAudioLevelListener(receiveStream, this.streamAudioLevelListener);
                }
            }
        }

        public int getLastMeasuredAudioLevel(long csrc) {
            return ((AudioMixerMediaDevice)this.getDevice()).audioLevelCache.getLevel(csrc);
        }

        public int getLastMeasuredLocalUserAudioLevel() {
            return ((AudioMixerMediaDevice)this.getDevice()).lastMeasuredLocalUserAudioLevel;
        }

        public void setMute(boolean mute) {
            boolean oldValue = this.isMute();
            super.setMute(mute);
            boolean newValue = this.isMute();
            if (oldValue != newValue) {
                if (newValue) {
                    this.audioMixerMediaDeviceSession.removeLocalUserAudioLevelListener(this.localUserAudioLevelListener);
                } else {
                    this.audioMixerMediaDeviceSession.addLocalUserAudioLevelListener(this.localUserAudioLevelListener);
                }
            }
        }
    }

    private class AudioMixerMediaDeviceSession
    extends MediaDeviceSession {
        private final List<MediaStreamMediaDeviceSession> mediaStreamMediaDeviceSessions;

        public AudioMixerMediaDeviceSession() {
            super(AudioMixerMediaDevice.this);
            this.mediaStreamMediaDeviceSessions = new LinkedList<MediaStreamMediaDeviceSession>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLocalUserAudioLevelListener(SimpleAudioLevelListener l) {
            if (l == null) {
                return;
            }
            Object object = AudioMixerMediaDevice.this.localUserAudioLevelListenersSyncRoot;
            synchronized (object) {
                if (AudioMixerMediaDevice.this.localUserAudioLevelListeners.isEmpty()) {
                    AudioMixerMediaDevice.this.localUserAudioLevelDispatcher.setAudioLevelListener(AudioMixerMediaDevice.this.localUserAudioLevelDelegate);
                }
                SimpleAudioLevelListenerWrapper wrapper = new SimpleAudioLevelListenerWrapper(l);
                int index = AudioMixerMediaDevice.this.localUserAudioLevelListeners.indexOf(wrapper);
                if (index != -1) {
                    wrapper = (SimpleAudioLevelListenerWrapper)AudioMixerMediaDevice.this.localUserAudioLevelListeners.get(index);
                    ++wrapper.referenceCount;
                } else {
                    AudioMixerMediaDevice.this.localUserAudioLevelListeners = new ArrayList(AudioMixerMediaDevice.this.localUserAudioLevelListeners);
                    AudioMixerMediaDevice.this.localUserAudioLevelListeners.add(wrapper);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addMediaStreamMediaDeviceSession(MediaStreamMediaDeviceSession mediaStreamMediaDeviceSession) {
            if (mediaStreamMediaDeviceSession == null) {
                throw new NullPointerException("mediaStreamMediaDeviceSession");
            }
            List<MediaStreamMediaDeviceSession> list = this.mediaStreamMediaDeviceSessions;
            synchronized (list) {
                if (!this.mediaStreamMediaDeviceSessions.contains(mediaStreamMediaDeviceSession)) {
                    this.mediaStreamMediaDeviceSessions.add(mediaStreamMediaDeviceSession);
                }
            }
        }

        public void addPlaybackDataSource(DataSource playbackDataSource) {
            super.addPlaybackDataSource((DataSource)((AudioMixingPushBufferDataSource)this.getCaptureDevice()));
        }

        public void addReceiveStream(ReceiveStream receiveStream) {
            this.addSSRC(receiveStream.getSSRC());
        }

        protected DataSource createCaptureDevice() {
            return AudioMixerMediaDevice.this.getAudioMixer().getLocalOutputDataSource();
        }

        protected Player createPlayer(DataSource dataSource) {
            return super.createPlayer(dataSource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStreamAudioLevelListener(ReceiveStream stream, SimpleAudioLevelListener listener) {
            Map map = AudioMixerMediaDevice.this.streamAudioLevelListeners;
            synchronized (map) {
                AudioLevelEventDispatcher dispatcher = (AudioLevelEventDispatcher)AudioMixerMediaDevice.this.streamAudioLevelListeners.get(stream);
                if (listener == null) {
                    if (dispatcher != null) {
                        try {
                            dispatcher.setAudioLevelListener(null);
                            dispatcher.setAudioLevelCache(null, -1L);
                            Object var6_5 = null;
                            AudioMixerMediaDevice.this.streamAudioLevelListeners.remove(dispatcher);
                        }
                        catch (Throwable throwable) {
                            Object var6_6 = null;
                            AudioMixerMediaDevice.this.streamAudioLevelListeners.remove(dispatcher);
                            throw throwable;
                        }
                        {
                        }
                    }
                } else {
                    if (dispatcher == null) {
                        dispatcher = new AudioLevelEventDispatcher("Stream Audio Level Dispatcher (Mixer Edition)");
                        dispatcher.setAudioLevelCache(AudioMixerMediaDevice.this.audioLevelCache, stream.getSSRC());
                        AudioMixerMediaDevice.this.streamAudioLevelListeners.put(stream, dispatcher);
                    }
                    dispatcher.setAudioLevelListener(listener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLocalUserAudioLevelListener(SimpleAudioLevelListener l) {
            Object object = AudioMixerMediaDevice.this.localUserAudioLevelListenersSyncRoot;
            synchronized (object) {
                int index = AudioMixerMediaDevice.this.localUserAudioLevelListeners.indexOf(new SimpleAudioLevelListenerWrapper(l));
                if (index != -1) {
                    SimpleAudioLevelListenerWrapper wrapper = (SimpleAudioLevelListenerWrapper)AudioMixerMediaDevice.this.localUserAudioLevelListeners.get(index);
                    if (wrapper.referenceCount > 1) {
                        --wrapper.referenceCount;
                    } else {
                        AudioMixerMediaDevice.this.localUserAudioLevelListeners = new ArrayList(AudioMixerMediaDevice.this.localUserAudioLevelListeners);
                        AudioMixerMediaDevice.this.localUserAudioLevelListeners.remove(wrapper);
                    }
                }
                if (AudioMixerMediaDevice.this.localUserAudioLevelListeners.isEmpty()) {
                    AudioMixerMediaDevice.this.localUserAudioLevelDispatcher.setAudioLevelListener(null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeMediaStreamMediaDeviceSession(MediaStreamMediaDeviceSession mediaStreamMediaDeviceSession) {
            if (mediaStreamMediaDeviceSession != null) {
                List<MediaStreamMediaDeviceSession> list = this.mediaStreamMediaDeviceSessions;
                synchronized (list) {
                    if (this.mediaStreamMediaDeviceSessions.remove(mediaStreamMediaDeviceSession) && this.mediaStreamMediaDeviceSessions.isEmpty()) {
                        this.close();
                    }
                }
            }
        }

        public void removePlaybackDataSource(final DataSource playbackDataSource) {
            AudioMixerMediaDevice.this.removeInputDataSources(new DataSourceFilter(){

                public boolean accept(DataSource dataSource) {
                    return dataSource.equals(playbackDataSource);
                }
            });
        }

        public void removeReceiveStream(ReceiveStream receiveStream) {
            this.removeSSRC(receiveStream.getSSRC());
            AudioMixerMediaDevice.this.audioLevelCache.removeLevel(receiveStream.getSSRC());
        }
    }
}

